/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.config;

import java.util.*;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ConfigItem implements Cloneable {
	public final String configName;
	protected Vector<ConfigItem> children = new Vector<ConfigItem>();
	
	public ConfigItem(String configName) {
		this.configName = configName;
	}

	public void addChild(ConfigItem config) {
		children.addElement(config);
	}

	public ConfigItem getChild(int index) {
		return children.elementAt(index);
	}
	
	public int getChildCount() {
		return children.size();
	}

	public ConfigItem cloneTree() {
		ConfigItem config = this.cloneThis();
		
		for(int i=0; i<children.size(); i++) {
			config.addChild(children.elementAt(i).cloneThis());
		}

		return config;
	}
	
	public void validateTree() throws ConfigException {
		validateThis();
		
		for(int i=0; i<children.size(); i++) {
			children.elementAt(i).validateThis();
		}
	}

	public void loadConfigTree(Element elem) {
		loadConfig(elem);
		
		for(int i=0; i<children.size(); i++) {
			ConfigItem childConfig = children.elementAt(i);
			
			if(elem != null) {
				NodeList childElements = elem.getElementsByTagName(childConfig.configName);

				if(childElements.getLength() == 0) childConfig.loadConfigTree(null);
				else childConfig.loadConfigTree((Element)childElements.item(0));
			} else {
				childConfig.loadConfigTree(null);
			}
		}
	}
	
	public void saveConfigTree(Element elem) {
		saveConfig(elem);

		for(int i=0; i<children.size(); i++) {
			ConfigItem childConfig = children.elementAt(i);

			NodeList childElements = elem.getElementsByTagName(childConfig.configName);

			Element childElem;
			
			if(childElements.getLength() == 0) {
				childElem = elem.getOwnerDocument().createElement(childConfig.configName);
				elem.appendChild(childElem);
			} else {
				childElem = (Element)childElements.item(0);
			}

			childConfig.saveConfigTree(childElem);
		}
	}

	protected ConfigItem getChildByName(String childName) {
		for(int i=0; i<children.size(); i++) {
			ConfigItem child = children.elementAt(i);
			if(child.configName.equals(childName)) return child;
		}
		
		return null;
	}

	public void validateThis() throws ConfigException {}
	public void loadConfig(Element elem) {}
	public void saveConfig(Element elem) {}
	public String getDispPath() { return null; }
	public ConfigItemView getView() { return null; }

	public ConfigItem cloneThis() { 
		try {
			ConfigItem obj = (ConfigItem)this.clone();
			obj.children = new Vector<ConfigItem>();
			return obj;
		} catch(CloneNotSupportedException e) {
			throw new RuntimeException(e);
		}
	}
}
