/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.config;

import java.awt.*;
import javax.swing.*;
import org.w3c.dom.*;

@SuppressWarnings("serial")
public abstract class ThreadListConfig extends ConfigItem {
	public boolean showImage = true;
	public boolean showDispId = true;
	public boolean showNid = false;
	public boolean showCountry = true;
	public boolean showTitle = true;
	public boolean showArticleNum = true;
	public boolean showPoster = true;
	public boolean showDate;
	public boolean showViewNum = true;
	public boolean showTotalPages;
	private boolean defaultShowDate;
	private boolean defaultShowTotalPages;
	
	
	public ThreadListConfig(String configName, boolean showDate, boolean defaultShowtotalPages) {
		super(configName);
		this.showDate = this.defaultShowDate = showDate;
		this.showTotalPages = this.defaultShowTotalPages = defaultShowtotalPages;
		loadConfig(null);
	}

	@Override public void loadConfig(Element elem) {
		showImage = Config.getBooleanConfig(elem, "ShowImage", true);
		showDispId = Config.getBooleanConfig(elem, "ShowDispID", true);
		showNid = Config.getBooleanConfig(elem, "ShowNID", false);
		showCountry = Config.getBooleanConfig(elem, "ShowCountry", true);
		showTitle = Config.getBooleanConfig(elem, "ShowTitle", true);
		showArticleNum = Config.getBooleanConfig(elem, "ShowArticleNum", true);
		showPoster = Config.getBooleanConfig(elem, "ShowPoster", true);
		showDate = Config.getBooleanConfig(elem, "ShowDate", defaultShowDate);
		showViewNum = Config.getBooleanConfig(elem, "ShowViewNum", true);
		showTotalPages = Config.getBooleanConfig(elem, "ShowTotalPages", defaultShowTotalPages);
	}

	@Override public void saveConfig(Element elem) {
		Config.setBooleanConfig(elem, "ShowImage", showImage);
		Config.setBooleanConfig(elem, "ShowDispID", showDispId);
		Config.setBooleanConfig(elem, "ShowNID", showNid);
		Config.setBooleanConfig(elem, "ShowCountry", showCountry);
		Config.setBooleanConfig(elem, "ShowTitle", showTitle);
		Config.setBooleanConfig(elem, "ShowArticleNum", showArticleNum);
		Config.setBooleanConfig(elem, "ShowPoster", showPoster);
		Config.setBooleanConfig(elem, "ShowDate", showDate);
		Config.setBooleanConfig(elem, "ShowViewNum", showViewNum);
		Config.setBooleanConfig(elem, "ShowTotalPages", showTotalPages);
	}

	@Override public String getDispPath() {
		return "XbhXg";
	}

	protected static class BoardConfigView extends ConfigItemView {
		JCheckBox showImageCheck = new JCheckBox("k摜");
		JCheckBox showDispIdCheck = new JCheckBox("ID");
		JCheckBox showNidCheck = new JCheckBox("nid");
		JCheckBox showCountryCheck = new JCheckBox("");
		JCheckBox showTitleCheck = new JCheckBox("^Cg");
		JCheckBox showArticleNumCheck = new JCheckBox("X");
		JCheckBox showPosterCheck = new JCheckBox("e");
		JCheckBox showDateCheck = new JCheckBox("e");
		JCheckBox showViewNumCheck = new JCheckBox("{");
		JCheckBox showTotalPagesCheck = new JCheckBox("y[W");

		private ThreadListConfig boardConfig;

		public BoardConfigView(String configName) {
			addLine(configName);
			addLine(
				"  ", showImageCheck, "\t",
				"  ", showDispIdCheck, "\n",
				"  ", showNidCheck, "\t",
				"  ", showCountryCheck, "\n",
				"  ", showTitleCheck, "\t", 
				"  ", showArticleNumCheck, "\n", 
				"  ", showPosterCheck, "\t", 
				"  ", showDateCheck, "\n", 
				"  ", showViewNumCheck, "\n",
				"  ", showTotalPagesCheck);
		}

		public void setConfig(ConfigItem config) {
			boardConfig = (ThreadListConfig)config;
			
			showImageCheck.setSelected(boardConfig.showImage);
			showDispIdCheck.setSelected(boardConfig.showDispId);
			showNidCheck.setSelected(boardConfig.showNid);
			showCountryCheck.setSelected(boardConfig.showCountry);
			showTitleCheck.setSelected(boardConfig.showTitle);
			showArticleNumCheck.setSelected(boardConfig.showArticleNum);
			showPosterCheck.setSelected(boardConfig.showPoster);
			showDateCheck.setSelected(boardConfig.showDate);
			showViewNumCheck.setSelected(boardConfig.showViewNum);
			showTotalPagesCheck.setSelected(boardConfig.showTotalPages);
		}

		public void applyConfig() throws ConfigException {
			boardConfig.showImage = showImageCheck.isSelected();
			boardConfig.showDispId = showDispIdCheck.isSelected();
			boardConfig.showNid = showNidCheck.isSelected();
			boardConfig.showCountry = showCountryCheck.isSelected();
			boardConfig.showTitle = showTitleCheck.isSelected();
			boardConfig.showArticleNum = showArticleNumCheck.isSelected();
			boardConfig.showPoster = showPosterCheck.isSelected();
			boardConfig.showDate = showDateCheck.isSelected();
			boardConfig.showViewNum = showViewNumCheck.isSelected();
			boardConfig.showTotalPages = showTotalPagesCheck.isSelected();
		}
	}
}
