/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.content;


import java.util.*;
import java.awt.event.*;
import javax.swing.*;
import com.aibonware.viewnaver.*;

@SuppressWarnings("serial")
public class TabContainerView extends JTabbedPane {
	private HashMap<Class, TabContentViewFactory> factories = new HashMap<Class, TabContentViewFactory>();
	private HashMap<TabContentCategory, TabContentView> views = new HashMap<TabContentCategory, TabContentView>();
	private TabContainer container = null;

	public TabContainerView() {}

	@Override protected void processMouseEvent (MouseEvent event) {
		try {
			super.processMouseEvent(event);
		} catch(ArrayIndexOutOfBoundsException e) {
			// fix JTabbedPane's bug
		}
	}

	@Override protected void processMouseMotionEvent (MouseEvent event) {
		try {
			super.processMouseMotionEvent(event);
		} catch(ArrayIndexOutOfBoundsException e) {
			// fix JTabbedPane's bug
		}
	}
	
	public void addFactory(Class clazz, TabContentViewFactory factory) {
		factories.put(clazz, factory);
	}

	private TabContainerListener containerListener = new TabContainerListener() {
		public void added(TabContent content, int pos) {
			TabContentCategory category = content.getCategory();
			TabContentView view = views.get(category);

			if(view == null) {
				TabContentViewFactory factory = factories.get(content.getClass());
				view = factory.create(category);
				insertTab(content.getContentTitle(), null, view, null, pos);
//				addTab(content.getContentTitle(), view);
			} else {
				setTitleAt(indexOfComponent(view), content.getContentTitle());
			}

			view.setClientContent(content);
			views.put(category, view);
		}

		public void removed(TabContent content) {
			TabContentCategory category = content.getCategory();
			
			TabContentView view = views.get(category);
			if(view != null) {
				views.remove(category);
				remove(view);
			}
		}

		public void replaced(TabContent oldContent, TabContent newContent) {
			TabContentCategory oldCategory = oldContent.getCategory();
			TabContentCategory newCategory = newContent.getCategory();

			TabContentView oldView = views.get(oldCategory);

			if(oldView == null) {
				TabContentViewFactory factory = factories.get(newContent.getClass());
				TabContentView newView = factory.create(newContent.getCategory());
				newView.setClientContent(newContent);
				views.put(newCategory, newView);
//			} else if(oldCategory.equals(newCategory)) {
			} else {
				oldView.setClientContent(newContent);
/*			} else {
				views.remove(oldCategory);
				remove(oldView);
				
				TabContentViewFactory factory = factories.get(newContent.getClass());
				TabContentView newView = factory.create(newContent.getCategory());
				newView.setClientContent(newContent);

				views.put(newCategory, newView);
				addTab(newContent.getContentTitle(), newView);
*/			}
		}
	};

	public void setClientContainer(TabContainer newContainer) {
		if(container != null) container.removeListener(containerListener);

		this.removeAll();

		container = newContainer;

		if(container != null) {
			container.addListener(containerListener);
		}

		for(int i=0; i<container.getContentCount(); i++) {
			TabContent content = container.getContent(i);
			TabContentViewFactory factory = factories.get(content.getClass());
			TabContentView view = factory.create(content.getCategory());
			view.setClientContent(content);

			this.addTab(content.getContentTitle(), view);
		}
	}

	public void activate(TabContentCategory category) {
		TabContentView view = views.get(category);
		if(view != null) this.setSelectedComponent(view);
	}

	public void update(TabContentCategory category) {
		TabContentView view = views.get(category);
		
		if(view == null) {
			view = registerEmptyView(category);
			category.createInitialContent(container, TabContainerView.this, view);
		} else {
			TabContent content = container.getContentByCategory(category);
			if(content != null) {
				content.replaceUpdatedContent(container, TabContainerView.this, view);
			} else {
				ViewNaver.println("̃^u݂܂B");
			}
		}
	}

	public TabContentView registerEmptyView(TabContentCategory category) {
		if(views.get(category) != null) return null;
		
		TabContentViewFactory factory = factories.get(category.getContentClass());
		TabContentView view = factory.create(category);
		view.isEmptyView = true;

		views.put(category, view);

		int pos = container.getInsertPosition(category.getContentClass());

		insertTab(category.getCategoryName(), null, view, null, pos);
//		addTab(category.getCategoryName(), view);
		setSelectedComponent(view);

		return view;
	}

	public void revertEmptyView(TabContentCategory category) {
		TabContentView view = views.get(category);
		
		if(view != null && view.isEmptyView) {
			views.remove(category);
			remove(view);
		}
	}
	
	public void update(TabContent newContent) {
		TabContentCategory newCategory = newContent.getCategory();
		TabContent oldContent = container.getContentByCategory(newCategory);

		if(oldContent == null) {
			container.addContent(newContent);
			activate(newCategory);
		} else {
			container.replace(oldContent, newContent);
			activate(newCategory);
		}
	}

	public boolean isActiveContentCategory(TabContentCategory category) {
		TabContentView view = views.get(category);
		return (this.getSelectedComponent() == view);
	}
}
