/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.content.message;

import java.util.*;
import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.content.*;
import com.aibonware.viewnaver.model.*;
import com.aibonware.viewnaver.parser.*;
import com.aibonware.viewnaver.task.*;

public class DenyListContent implements TabContent {
	public final Vector<DenyEntry> denyList;
	
	public DenyListContent(Vector<DenyEntry> denyList) {
		this.denyList = denyList;
	}

	protected static class DenyListContentCategory implements TabContentCategory {
		public DenyListContentCategory() {}

		@Override public boolean equals(Object o) {
			if(!(o instanceof DenyListContentCategory)) return false;
			return true;
		}

		public void createInitialContent(final TabContainer container, final TabContainerView containerView, TabContentView initialView) {
			TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getDenyListFlow();
			
			taskFlow.addStatusReceiver(((DenyListContentView)initialView).createUpdateTaskStatusReceiver(taskFlow));
			
			taskFlow.execute(new WorkerTask() {
				 Vector<DenyEntry> denyList = null;

				 public void exec() {
					try {
						ViewNaver.println("MۃXgǂݍݒ...");
						DenyListParser parser;
						
						parser = new DenyListParser("http://bbs.enjoykorea.jp/memo/m_reject_list.php");
						denyList = parser.parse();

						ViewNaver.println("MۃXgǂݍݏIB");
					} catch(Exception e) {
						ViewNaver.err(e);
					}

					taskFlow.execute(new GUITask() {
						public void exec() {
							if(denyList == null) {
								containerView.revertEmptyView(DenyListContentCategory.this);
								return;
							}

							final DenyListContent content = new DenyListContent(denyList);

							container.addContent(content);
//							containerView.activate(content.getCategory());
						}
					});
				}
			});
		}
		
		public String getCategoryName() {
			return "ۃXg";
		}

		@Override public int hashCode() {
			return DenyListContentCategory.class.hashCode();
		}

		public Class getContentClass() {
			return DenyListContent.class;
		}
	};

	public String getContentTitle() {
		return "ۃXg";
	}

	public static TabContentCategory getConstantCategory() {
		return new DenyListContentCategory();
	}
	
	public TabContentCategory getCategory() {
		return new DenyListContentCategory();
	}

	public void replaceUpdatedContent(final TabContainer container, final TabContainerView containerView, TabContentView contentView) {
		TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getDenyListFlow();

		taskFlow.addStatusReceiver(((DenyListContentView)contentView).createUpdateTaskStatusReceiver(taskFlow));

		taskFlow.execute(new WorkerTask() {
			 Vector<DenyEntry> denyList = null;

			 public void exec() {
				try {
					ViewNaver.println("MۃXgǂݍݒ...");
					DenyListParser parser;
					
					parser = new DenyListParser("http://bbs.enjoykorea.jp/memo/m_reject_list.php");
					denyList = parser.parse();

					ViewNaver.println("MۃXgǂݍݏIB");
				} catch(Exception e) {
					ViewNaver.err(e);
				}

				taskFlow.execute(new GUITask() {
					public void exec() {
						TabContent newContent = new DenyListContent(denyList);

						container.replace(DenyListContent.this, newContent);
						containerView.activate(newContent.getCategory());
					}
				});
			}
		});
	}
}
