/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.window;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import com.aibonware.viewnaver.ViewNaver;

@SuppressWarnings("serial")
public class IDJitenWindow extends JDialog {
	private void init(String explain) {
		setDefaultCloseOperation(DISPOSE_ON_CLOSE);

		JTextArea text = new JTextArea(explain);
		text.setLineWrap(true);

		add(new JScrollPane(
				text, 
				JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED, 
				JScrollPane.HORIZONTAL_SCROLLBAR_NEVER));
		
		setSize(600, 400);

		addWindowFocusListener(new WindowAdapter() {
			@Override public void windowLostFocus(WindowEvent e) {
				dispose();
			}
		});
		
		ViewNaver.instance.childWindowActivator.addChildWindow(this);
	}
	
	public static IDJitenWindow createIDJitenWindow(Window parentWindow, String personName, String explain) {
		if(parentWindow instanceof JDialog) return new IDJitenWindow((JDialog)parentWindow, personName, explain);
		else return new IDJitenWindow((JFrame)parentWindow, personName, explain);
	}
	
	public IDJitenWindow(JDialog parentFrame, String personName, String explain) {
		super(parentFrame, "IDT - " + personName);
		init(explain);
	}

	public IDJitenWindow(JFrame parentFrame, String personName, String explain) {
		super(parentFrame, "IDT - " + personName);
		init(explain);
	}

}
