/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver;

import java.util.*;

import com.aibonware.viewnaver.net.*;
import com.aibonware.viewnaver.model.*;
import com.aibonware.viewnaver.parser.*;
import com.aibonware.viewnaver.storage.*;

public class Cache {
//	private HashMap<ThreadIdentifier, CompositeThread> compositeThreads = new HashMap<ThreadIdentifier, CompositeThread>();
	private HashMap<String, SortedMap<Integer, CompositeThread>> compositeThreadsPerBoard = new HashMap<String, SortedMap<Integer, CompositeThread>>();
	private HashMap<String, Vector<Board>> threadHeadersPerBoard = new HashMap<String, Vector<Board>>();
	private HashMap<String, SortedMap<Integer, NThread>> threadHeaders = new HashMap<String, SortedMap<Integer, NThread>>();

	private Comparator<Integer> reverseIntegerComparator = new Comparator<Integer>() {
		public int compare(Integer src, Integer dest) {
			return dest - src;
		}
	};

	public Cache() {
		super();
	}

	/**
	 * 
	 * @param boardName
	 * @param nid
	 * @param update falsew肵ꍇ...LbVɂꍇ̓LbV̓eԋpB
     *                LbVɖOɂꍇ̓OǂݍŕԋpB
     *                ǂɂꍇ̓[gǂݍŕԋpB
     *                truew肵ꍇ...Ƀ[gǂݍŕԋpB
	 * @return
	 */
	public CompositeThread getCompositeThread(String boardName, int nid, boolean forceRemote) {
		try {
			if(!forceRemote) {
				SortedMap<Integer, CompositeThread> compositeThreads = compositeThreadsPerBoard.get(boardName);
				
				if(compositeThreads == null) {
					compositeThreads = new TreeMap<Integer, CompositeThread>(reverseIntegerComparator);

					compositeThreadsPerBoard.put(boardName, compositeThreads);
				}

				CompositeThread compositeThread = compositeThreads.get(nid);

				if(compositeThread != null) return compositeThread;

				try {
					if(ViewNaver.instance.threadStorage.existsThread(boardName, nid)) {
						return ViewNaver.instance.threadStorage.readThread(boardName, nid);
					}
				} catch(StorageException e) {
					ViewNaver.err(e);
				}
			}

			ViewNaver.println("Xbh " + nid + "̓ǍJn...");
			
			CompositeThread compositeThread = ViewNaver.instance.web.queryWebThreadContents(
					boardName, nid, null);

			ViewNaver.println("Xbh " + nid + "̓ǍI.");

			
			return compositeThread;

		} catch(NetException e) {
			ViewNaver.err(e);
			return null;
		} catch(ParsingException e) {
			ViewNaver.err(e);
			ViewNaver.println(LoginSession.getAlertString(e.parsingText));
			return null;
		}
	}

	public void putCompositeThread(CompositeThread compositeThread) {
		SortedMap<Integer, CompositeThread> compositeThreads = compositeThreadsPerBoard.get(compositeThread.boardName);
		
		if(compositeThreads == null) {
			compositeThreads = new TreeMap<Integer, CompositeThread>(reverseIntegerComparator);

			compositeThreadsPerBoard.put(compositeThread.boardName, compositeThreads);
		}

		compositeThreads.put(compositeThread.thread.nid, compositeThread);

		int i=0;
		int maxThreadNum = ViewNaver.instance.config.capacityConfig.maxCompositeThreadCache;
		int limitNid = -1;

		if(compositeThreads.size() * 1.1 > maxThreadNum) {
			for(int nid: compositeThreads.keySet()) {
				if(i++ > maxThreadNum) {
					limitNid = nid;
					break;
				}
			}
		}

		if(limitNid != -1) {
			Set<Integer> nids = compositeThreads.keySet();

			for(Iterator<Integer> iter = nids.iterator(); iter.hasNext();) {
				int nid = iter.next();
				if(nid < limitNid) iter.remove();
			}
		}
	}

	private int findPageIndex(Vector<Board> pages, int pageNo) {
		for(int i=0; i<pages.size(); i++) {
			Board page = pages.elementAt(i);
			if(page.pageNo == pageNo) return i;
		}

		return -1;
	}

	public Board getBoard(String boardName, int pageNo, boolean update) {
		try {
			if(pageNo < 1) pageNo = 1;

			Vector<Board> pages = threadHeadersPerBoard.get(boardName);

			if(pages == null) {
				pages = new Vector<Board>();
				threadHeadersPerBoard.put(boardName, pages);
			}

			int pageIndex = findPageIndex(pages, pageNo);

			if(!update && pageIndex != -1) {
				return pages.elementAt(pageIndex);
			}

			ViewNaver.println(boardName + " page=" + pageNo + "̓ǍJn..");

			BoardTitle boardTitle = ViewNaver.instance.boardTitles.getBoardTitle(boardName);

			if(boardTitle == null) {
				boardTitle = new BoardTitle(boardName, boardName, BoardType.Text);
			}

			BoardParser parser = new BoardParser(ViewNaver.instance.web.getBoardPageUrl(boardName, pageNo));
			Board newBoard = parser.parse(boardTitle.boardName, boardTitle.dispName, boardTitle.boardType, pageNo);

			ViewNaver.println(boardName + " page=" + pageNo + "̓Ǎ.");

			if(pageIndex != -1) {
				pages.setSize(pageIndex);
			}

			if(pages.size() < ViewNaver.instance.config.capacityConfig.maxBoardPageCache) {
				pages.add(newBoard);
			}
			
			SortedMap<Integer, NThread> curThreads = threadHeaders.get(boardName);
			
			if(curThreads == null) {
				curThreads = new TreeMap<Integer, NThread>(reverseIntegerComparator);
				threadHeaders.put(boardName, curThreads);
			}

			for(NThread newThread: newBoard) {
				NThread oldThread = curThreads.get(newThread.nid);

				if(oldThread != null) {
					newThread.oldArticleNum = oldThread.articleNum;
				}

				try {
					curThreads.put(newThread.nid, newThread);
				} catch(Exception e) {
					System.out.println();
				}
			}

			int i=0;
			int maxThreadNum = ViewNaver.instance.config.capacityConfig.maxBoardPageCache * 35;
			int limitNid = -1;

			if(curThreads.size() > maxThreadNum) {
				for(int nid: curThreads.keySet()) {
					if(i++ > maxThreadNum) {
						limitNid = nid;
						break;
					}
				}
			}

			if(limitNid != -1) {
				Set<Integer> nids = curThreads.keySet();

				for(Iterator<Integer> iter = nids.iterator(); iter.hasNext();) {
					int nid = iter.next();
					if(nid < limitNid) iter.remove();
				}
			}

/*			
			try {
				if(limitNid != -1) {
					curThreads.keySet().removeAll(curThreads.subMap(limitNid-1, -1).keySet());
				}
			} catch(Exception e) {
				e.printStackTrace();
			}
*/			
			return newBoard;
			
		} catch(NetException e) {
			ViewNaver.err(e);
			return null;
		} catch(ParsingException e) {
			ViewNaver.err(e);
			return null;
		}
	}
	
/*	
	public Board getBoard(String boardName, int pageNo, boolean update) {
		try {
			if(pageNo < 1) pageNo = 1;

			ViewNaver.println(boardName + " page=" + pageNo + "̓ǍJn..");

			BoardTitle boardTitle = ViewNaver.instance.boardTitles.getBoardTitle(boardName);
			if(boardTitle == null) {
				boardTitle = new BoardTitle(boardName, boardName, BoardType.Text);
			}

			BoardParser parser = new BoardParser(ViewNaver.instance.web.getBoardPageUrl(boardName, pageNo));
			Board board = parser.parse(boardTitle.boardName, boardTitle.dispName, boardTitle.boardType, pageNo);

			ViewNaver.println(boardName + " page=" + pageNo + "̓Ǎ.");

			for(int i=0; i<board.getThreadCount(); i++) {
				NThread thread = board.getTitle(i);
				ThreadIdentifier id = new ThreadIdentifier(boardName, thread.nid);
				NThread oldThread = threadHeaders.get(id);

				if(oldThread != null) {
					thread.oldArticleNum = oldThread.articleNum;
				}

				threadHeaders.put(id, thread);
			}
			
			return board;
		} catch(NetException e) {
			ViewNaver.err(e);
			return null;
		} catch(ParsingException e) {
			ViewNaver.err(e);
			return null;
		}
	}
*/
}
