/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver;

import java.io.*;
import java.util.*;
import javax.swing.*;

public class Launcher {
	public Launcher() {}

	public static void main(String args[]) throws Exception {
		if(args.length < 1 || !args[0].equals("main")) {
			new Launcher().start();
		} else {
			Class viewNaverClass = Class.forName("com.aibonware.viewnaver.ViewNaver");
			Runnable app = (Runnable)viewNaverClass.newInstance();
			app.run();
		}
	}

	public void start() {
		boolean isWindows = System.getProperty("os.name").toLowerCase().contains("windows");
		
		String version = System.getProperty("java.version");
		StringTokenizer verTokens = new StringTokenizer(version, ".");
		
		/* String major = */ verTokens.nextToken();
		String minor = verTokens.nextToken();
		
		if(Integer.parseInt(minor) < 5) {
			JOptionPane.showMessageDialog(null, "ÂJava^CłB");
			return;
		}
		
		// Javãx[XfBNg߂
		String home = System.getProperty("java.home");
		String binDir;

		// java.exedll̂fBNg߂
		if(home.endsWith(File.separator)) binDir = home + "bin";
		else binDir = home + File.separator + "bin";

		// NfBNg߂
		String userDir = System.getProperty("user.dir");

		// CuEvOC̃fBNg߂
		String libDir;
		String pluginsDir;

		if(userDir.endsWith("File.separator")) {
			libDir = userDir + "lib";
			pluginsDir = userDir + "plugins";
		} else {
			libDir = userDir + File.separator + "lib";
			pluginsDir = userDir + File.separator + "plugins";
		}

		
		// NXpX߂
		String classes = "viewnvr.jar";

		File[] files =new File(libDir).listFiles();

		if(files != null) {
			for(int i=0; i<files.length; i++) {
				if(!files[i].isFile()) continue;
				String fileName = files[i].getName();
				
				if(fileName.endsWith(".jar") || fileName.endsWith(".zip")) {
					classes = classes + File.pathSeparatorChar + "lib" + File.separator + fileName;
				}
			}
		}

		files = new File(pluginsDir).listFiles();

		if(files != null) {
			for(int i=0; i<files.length; i++) {
				if(!files[i].isFile()) continue;
				String fileName = files[i].getName();
	
				if(fileName.endsWith(".jar") || fileName.endsWith(".zip")) {
					classes = classes + File.pathSeparatorChar + "plugins" + File.separator + fileName;
				}
			}
		}

		// R}h߂
		String javaExe;
		
		if(isWindows) {
			javaExe = "javaw.exe";
		} else {
			javaExe = "java";
		}

		String cmd = binDir + File.separator + javaExe;

		if(cmd.contains(" ")) {
			cmd = "\"" + cmd + "\"";
		}
		
//		String cmd =  "\"C:\\Program Files\\Java\\jre1.5.0_05\\bin\\javaw.exe\"";
		
		// R}hC߂
//		String cmdline = "-cp " + classes + " com.aibonware.viewnaver.ViewNaver main";
//		String cmdline = "-classpath . com.aibonware.viewnaver.ViewNaver main";
		String cmdline[] = {cmd, "-cp", classes, "com.aibonware.viewnaver.Launcher", "main"};

		ProcessBuilder builder = new ProcessBuilder(cmdline);
//		ProcessBuilder builder = new ProcessBuilder(binDir + "\\java.ex", "-version");

		// PATHϐJAVA_HOME\binǉ
		String pathKey = "Path";
		String path = builder.environment().get(pathKey);

		if(path == null) {
			pathKey = "PATH";
			path = builder.environment().get(pathKey);
		}
		
		if(path == null) path = "";
		
		if(path.endsWith(File.pathSeparator)) path = path + binDir;
		else path = path + File.pathSeparator + binDir;

		// PATHϐ(UNIX̏ꍇLD_LIBRARY_PATH)libzǉ
		if(isWindows) {
			path = path + File.pathSeparator + libDir;
		} else {
			String ldPath = builder.environment().get("LD_LIBRARY_PATH");
			if(ldPath == null) ldPath = "";
	
			if(ldPath.endsWith(File.pathSeparator)) ldPath = ldPath + libDir;
			else ldPath = ldPath + File.pathSeparator + libDir;

			builder.environment().put("LD_LIBRARY_PATH", ldPath);
			System.out.println("ldpath:" + ldPath);
		}

		builder.environment().put(pathKey, path);
		
		// NfBNgݒ
		builder.directory(new File(userDir));
		
		System.out.println("command lines: ");
		for(String cmditem: cmdline) System.out.println(cmditem);
		System.out.println("userDir: " + userDir);
		System.out.println("path:" + path);

		// N
		try {
			System.out.println("now exit this process and launch again, wait a minute... ");
			builder.start();
			System.exit(-1);
		} catch(Exception e) {
			JOptionPane.showMessageDialog(null, "Ns");
			return;
		}
	}
}
