/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.browser.win32;

public class URLActions {
	public final URLAction[] children;
	
	public URLActions() {
		children = createDefaultActions();
	}

	private URLAction[] createDefaultActions() {
		URLAction[] actions = new URLAction[] {
			new URLAction(
				URLAction.URLACTION_ACTIVEX_MIN, URLAction.URLACTION_ACTIVEX_MAX,
				"ANeBuXEvOC",
				URLPolicy.ALLOW, URLPolicy.DISALLOW),
	
			new URLAction(
				URLAction.URLACTION_CHANNEL_SOFTDIST_PERMISSIONS, 
				"\tgEFAXV`l",
				URLPolicy.CHANNEL_SOFTDIST_PROHIBIT, URLPolicy.CHANNEL_SOFTDIST_PRECACHE),
	
			new URLAction(
				URLAction.URLACTION_COOKIES,
				"iICookie",
				URLPolicy.DISALLOW, URLPolicy.ALLOW),
	
			new URLAction(
				URLAction.URLACTION_COOKIES_SESSION,
				"ZbVCookie",
				URLPolicy.DISALLOW, URLPolicy.ALLOW),
	
			new URLAction(
				URLAction.URLACTION_CREDENTIALS_USE,
				"lbgł̔F؏̎gp",
				URLPolicy.CREDENTIALS_MUST_PROMPT_USER, URLPolicy.CREDENTIALS_SILENT_LOGON_OK),
	
			new URLAction(
				URLAction.URLACTION_DOWNLOAD_SIGNED_ACTIVEX,
				"tANeBuXRg[̃_E[h",
				URLPolicy.DISALLOW, URLPolicy.ALLOW),
	
			new URLAction(
				URLAction.URLACTION_DOWNLOAD_UNSIGNED_ACTIVEX,
				"ANeBuXRg[̃_E[h",
				URLPolicy.DISALLOW, URLPolicy.ALLOW),
	
			new URLAction(
				URLAction.URLACTION_HTML_FONT_DOWNLOAD,
				"tHg̃_E[h",
				URLPolicy.DISALLOW, URLPolicy.ALLOW),
	
			new URLAction(
				URLAction.URLACTION_HTML_SUBFRAME_NAVIGATE,
				"hC܂t[",
				URLPolicy.DISALLOW, URLPolicy.ALLOW),
	
			new URLAction(
				URLAction.URLACTION_HTML_SUBMIT_FORMS,
				"tH[",
				URLPolicy.DISALLOW, URLPolicy.ALLOW),
	
			new URLAction(
				URLAction.URLACTION_HTML_USERDATA_SAVE,
				"[Uf[^̉iۊ",
				URLPolicy.DISALLOW, URLPolicy.ALLOW),

			// XNvgJava̎gpAXNvgɂy[XgAXNvg̎sAXNvg(?)SȃANeBuXRg[̎sAhCԂɂ܂f[^̃ANZX
			new URLAction(
				URLAction.URLACTION_SCRIPT_MIN, URLAction.URLACTION_SCRIPT_MAX,
				"XNvg",
				URLPolicy.DISALLOW, URLPolicy.ALLOW),
	
			new URLAction(
				URLAction.URLACTION_SHELL_FILE_DOWNLOAD,
				"t@C̃_E[h",
				URLPolicy.DISALLOW, URLPolicy.ALLOW),
	
			new URLAction(
				URLAction.URLACTION_SHELL_INSTALL_DTITEMS,
				"fXNgbvڂ̃CXg[",
				URLPolicy.DISALLOW, URLPolicy.ALLOW),
	
			new URLAction(
				URLAction.URLACTION_SHELL_MOVE_OR_COPY,
				"Rs[Eړ",
				URLPolicy.DISALLOW, URLPolicy.ALLOW),
	
			new URLAction(
				URLAction.URLACTION_SHELL_VERB,
				"AvP[V̋N",
				URLPolicy.DISALLOW, URLPolicy.ALLOW),

			new URLAction(
				0, -1,
				"̑",
				URLPolicy.DISALLOW, URLPolicy.ALLOW),
		};
		
		return actions;
	}

	public int[] createRawDump() {
		int[] nat = new int[children.length*3];
		
		int pos = 0;
		
		for(URLAction action: children) {
			nat[pos++] = action.minAction;
			nat[pos++] = action.maxAction;
			nat[pos++] = action.currentPolicy;
		}
	
		return nat;
	}

	public URLAction findAction(int minAction, int maxAction, int policy) {
		for(int i=0; i<children.length; i++) {
			URLAction a = children[i];
			
			if(a.minAction == minAction && a.maxAction == maxAction && a.containPolicy(policy)) {
				return a;
			}
		}
	
		return null;
	}
}
