/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.content;

import java.util.*;

public class TabContainer {
	private Vector<TabContent> children = new Vector<TabContent>();
	private Vector<TabContainerListener> listeners = new Vector<TabContainerListener>();
	public TabContentOrder comparator;
	
	public TabContainer(TabContentOrder comparator) {
		this.comparator = comparator;
	}

	public int getInsertPosition(Class<? extends TabContent> dest) {
		for(int i=0; i<children.size(); i++) {
			TabContent src = children.elementAt(i);
			
			int comp = comparator.compare(src.getClass(), dest);
			if(comp > 0) return i;
		}

		return children.size();
	}
	
	public void addContent(TabContent content) {
		int pos = getInsertPosition(content.getClass());
		children.insertElementAt(content, pos);

		for(int i=0; i<listeners.size(); i++) {
			listeners.elementAt(i).added(content, pos);
		}
	}

	public void removeContent(TabContent content) {
		children.removeElement(content);

		for(int i=0; i<listeners.size(); i++) {
			listeners.elementAt(i).removed(content);
		}
	}

	public void replace(TabContent oldContent, TabContent newContent) {
		children.set(children.indexOf(oldContent), newContent);

		for(int i=0; i<listeners.size(); i++) {
			listeners.elementAt(i).replaced(oldContent, newContent);
		}
	}
	
	public int getContentCount() {
		return children.size();
	}

	public int getContentIndex(TabContentCategory category) {
		for(int i=0; i<children.size(); i++) {
			if(children.elementAt(i).getCategory().equals(category)) return i;
		}
		
		return -1;
	}
	
	public TabContent getContent(int index) {
		return children.elementAt(index);
	}

	public void addListener(TabContainerListener listener) {
		listeners.addElement(listener);
	}

	public void removeListener(TabContainerListener listener) {
		listeners.removeElement(listener);
	}
	
	public TabContent getContentByCategory(TabContentCategory category) {
		for(int i=0; i<children.size(); i++) {
			TabContent child = children.elementAt(i);
			if(category.equals(child.getCategory())) return child;
		}
		
		return null;
	}
}
