/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.server.movie;

import java.util.*;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.decorator.*;
import com.aibonware.viewnaver.server.*;
import com.aibonware.viewnaver.server.conv.ConverterFilter;
import com.aibonware.viewnaver.server.image.ImageConverterFilter;

public class MovieConverterFilter implements ConverterFilter {
	private char marker;

	public MovieConverterFilter() {
		marker = ViewNaver.instance.getPUA(ImageConverterFilter.class);
	}

	public ConverterFilter newInstance() {
		return new MovieConverterFilter();
	}

	Vector<String> movieUrls = new Vector<String>();

	public String preprocess(String contents) {
		return EmbeddedMovieDecorator.walkMovie(contents, new EmbeddedMovieDecorator.MovieWalker() {
			public String walk(String contents, int prefixStart, int suffixStart, int prefixLength, int suffixLength) {
				String movieDesc = contents.substring(prefixStart + prefixLength, suffixStart); 
				
				int urlStart = movieDesc.indexOf(" src=");
				while(movieDesc.charAt(urlStart+" src=".length()) == ' ') urlStart++;
				int urlEnd = movieDesc.indexOf(" ", urlStart+" src=".length());

				String movieUrl = movieDesc.substring(urlStart + " src=".length(), urlEnd);

				movieUrl = dequote(movieUrl);
				
				movieUrls.addElement(movieUrl);

				return String.valueOf(marker);
			}
		});
	}

	private String dequote(String s) {
		s = s.trim();
		while(s.charAt(0) == '\"' || s.charAt(0) == '\'') s = s.substring(1);
		while(s.charAt(s.length()-1) == '\"' || s.charAt(s.length()-1) == '\'') s = s.substring(0, s.length()-1);
		return s;
	}
	
	public String postprocess(UserSession user, String contents) {
		for(String movieUrl: movieUrls) {
			int pos = contents.indexOf(marker);

			Movie movie = user.movieCache.putMovieUrl(user, movieUrl);
			
			contents = 
				contents.substring(0, pos)
				+ "<a href=\"" + MovieServlet.createUrl(user, movie.no) + "\">" + movie.getCaption() + "</a>"
				+ contents.substring(pos+1);
		}

		return contents;
	}
}
