/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.server.movie;

import java.io.*;
import java.util.*;
import java.security.*;
import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.parser.*;
import com.aibonware.viewnaver.server.*;

public class MovieWorker extends Thread {
	public static final int STATUS_INIT = 0;
	public static final int STATUS_DOWNLOAD = 1;
	public static final int STATUS_ENCODE = 2;
	public static final int STATUS_FINISH = 3;
	public static final int STATUS_IMCOMPLETE = 4;
		
	private volatile int status;
	private UserSession user;
	private Movie movie;
	public volatile int processedBytes = 0;
	
	public MovieWorker(UserSession user, Movie movie) {
		this.movie = movie;
		this.user = user;
		status = STATUS_INIT;
	}

	public int getStatus() {
		return status;
	}

	@Override public void run() {
		try {
			String url;
			
			// youtubȅꍇ́A悪uĂURL߂
			if(isYoutubeUrl(movie.srcUrl)) {
				url = getRealYoutubeMovieUrl(movie.srcUrl);
			} else {
				url = movie.srcUrl;
			}

			String cacheFileName = getCacheFileName(movie.srcUrl, "mcs");

			// rȂƂ܂Bvolatile
			
			// LbVt@C܂݂ȂȂ쐬
			if(!new File(cacheFileName).exists()) {
				status = STATUS_DOWNLOAD;

				BufferedInputStream in = new BufferedInputStream(ViewNaver.instance.server.outerSession.openStream(url, true));
				BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(cacheFileName));

				byte buf[] = new byte[1000];
				
				processedBytes = 0;
				
				for(;;) {
					int len = in.read(buf);
					if(len == -1) break;
					out.write(buf, 0, len);
					processedBytes += len;
				}

				in.close();
				out.close();
			}

			// LbVt@CɁAt@CăGR[h
			status = STATUS_ENCODE;

			String reencFileName = getCacheFileName(url, "mcd");

			String cmdline = getReencodeCommand(cacheFileName, reencFileName);

			Process process = Runtime.getRuntime().exec(cmdline);
			final BufferedInputStream stderr = new BufferedInputStream(process.getErrorStream());

			StringWriter sout = new StringWriter();
			final PrintWriter procout = new PrintWriter(sout);
			
			Thread errHandler = new Thread() {
				@Override public void run() {
					try {
						BufferedReader errreader = new BufferedReader(new InputStreamReader(stderr));
						String line;

						while((line = errreader.readLine()) != null) {
							procout.println(line);
						}

						stderr.close();
					} catch(Exception e) {
						e.printStackTrace(procout);
					}
				}
			};

			errHandler.start();

			process.waitFor();
			errHandler.join();

			int exitCode = process.exitValue();

			procout.println("exit code: " + exitCode);

			if(exitCode != 0) {
				status = STATUS_IMCOMPLETE;
				return;
			}

			// ǂݍ݌ʂɓǂݍ݁AăGR[hʃt@C폜
			BufferedInputStream in = new BufferedInputStream(new FileInputStream(reencFileName));
			ByteArrayOutputStream out = new ByteArrayOutputStream();
			
			byte buf[] = new byte[1000];
			
			for(;;) {
				int len = in.read(buf);
				if(len == -1) break;
				out.write(buf, 0, len);
			}

			in.close();
			out.close();

			movie.contents = out.toByteArray();
			movie.msg = sout.toString();
			
			new File(reencFileName).delete();

			// 
			status = STATUS_FINISH;
			
			user.addOnceMessage("<a href=\"" + MovieServlet.createUrl(user, movie.no) + "\">" + movie.getCaption() + "</a><br>");
			
		} catch(Exception e) {
			status = STATUS_IMCOMPLETE;
			StringWriter sout = new StringWriter();
			PrintWriter pout = new PrintWriter(sout);
			e.printStackTrace(pout);
			movie.msg = ViewNaver.strToHtml(sout.toString());
			user.addOnceMessage("<a href=\"" + MovieServlet.createUrl(user, movie.no) + "\">" + movie.getCaption() + "</a><br>");
		}
	}
	
	private String getReencodeCommand(String src, String dest) {
		StringBuffer buf = new StringBuffer();
		Formatter formatter = new Formatter(buf);
		formatter.format(ViewNaver.instance.server.movieShrinkerCommandLine, src, dest);
		return buf.toString();
	}
	
	private String getCacheFileName(String url, String ex) throws Exception {
		ViewNaver.makeSureDir("temp");

		MessageDigest md = MessageDigest.getInstance("MD5");

		md.update(url.getBytes());
		byte[] bytes = md.digest();

		StringBuffer buf = new StringBuffer();
		Formatter formatter = new Formatter(buf);

		for(int i=0; i<bytes.length; i++) {
			formatter.format("%02x", bytes[i]);
		}
		
		return "temp" + File.separator + buf.toString() + "." + ex;
	}

	private boolean isYoutubeUrl(String url) {
		return url.toLowerCase().startsWith("http://www.youtube.com/v/");
	}
	
	private String getRealYoutubeMovieUrl(String orgUrl) throws Exception {
		String movieid = orgUrl.substring("http://www.youtube.com/v/".length());
		String url = "http://www.youtube.com/watch?v=" + movieid;
		
		BufferedReader reader = ViewNaver.instance.server.outerSession.open(url, true);
		
		ParsingContext ct = new ParsingContext(reader);
		
		String dest = ct.cut("new SWFObject(\"/player2.swf?hl=en&video_id=", "\",");
		return "http://www.youtube.com/get_video?video_id=" + dest;
	}
	
	public void cancel() {
		throw new RuntimeException("not implement");
	}

}
