/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.server.servlet;

import java.io.*;
import java.text.*;

import Acme.Serve.servlet.*;
import Acme.Serve.servlet.http.*;
import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.model.*;
import com.aibonware.viewnaver.net.*;
import com.aibonware.viewnaver.server.MiniServer;
import com.aibonware.viewnaver.server.UserSession;

public class ConfirmDelServlet extends BaseServlet {
	private static SimpleDateFormat df = new SimpleDateFormat("MM/dd HH:mm");

	public ConfirmDelServlet() {}

	@Override public String getName() {
		return "qdel";
	}

	public static String createUrl(UserSession user, String boardName, int nid, int start) {
		return "qdel?sid=" + user.sid + "&b=" + boardName + "&nid=" + nid + "&s=" + start;
	}
	private static SimpleDateFormat tf = new SimpleDateFormat("HH:mm");

	@Override public void dispContents(MiniServer server, UserSession user, HttpServletRequest request, HttpServletResponse response, ServletOutputStream out) throws Exception {
		String boardName = request.getParameter("b");
		String sNid = request.getParameter("nid");
		String sStart = request.getParameter("s");

		int nid = Integer.parseInt(sNid);
		int start = Integer.parseInt(sStart);

		String userName = ViewNaver.instance.naverSession.getUserName();
		Country country = ViewNaver.instance.naverSession.getCountry();

		CompositeThread composite = user.getCachedThread(user, server.conv, boardName, nid, start);
		
		int targetThreads = 0;
		
		if(composite.thread.poster.equals(userName) && composite.thread.country.equals(country)) {
			targetThreads++;
			
			out.println("<form action=\"delthread\" method=\"get\">");
			out.println("<input type=\"hidden\" name=\"sid\" value=\"" + user.sid + "\">");
			out.println("<input type=\"hidden\" name=\"b\" value=\"" + boardName + "\">");
			out.println("<input type=\"hidden\" name=\"t\" value=\"" + nid + "\">");
			out.println("<input type=\"submit\" value=\"ڍ폜\">");
			out.println("</form>");
			out.println("<hr>");
		}

		StringWriter optionsWriter = new StringWriter();
		PrintWriter optionsOut = new PrintWriter(optionsWriter);
		
		int targetArticles = 0;
		boolean first = true;
		
		for(int i=start; i<composite.articleList.getArticleCount(); i++) {
			if(i >= start + server.articlesPerPage) break;
			
			Article art = composite.articleList.getArticle(i);
			
			if(art.author.equals(userName) && art.country.equals(country)) {
				targetArticles++;
				optionsOut.print("<input type=\"radio\" name=\"a\" value=\"" + art.articleId + "\"" + (first ?" checked" : "") + ">");
				optionsOut.println((i+1) + "." + tf.format(art.postDate) + " " + art.content + "<br>");
				first = false;
			}
		}

		optionsOut.close();

		if(targetArticles > 0) {
			out.println("<form action=\"delart\" method=\"get\">");
			out.println("<input type=\"hidden\" name=\"sid\" value=\"" + user.sid + "\">");
			out.println("<input type=\"hidden\" name=\"b\" value=\"" + boardName + "\">");
			out.println("<input type=\"hidden\" name=\"t\" value=\"" + nid + "\">");
			out.println("<input type=\"hidden\" name=\"s\" value=\"" + start + "\">");
			
			out.println(optionsWriter.toString());

			out.println("<input type=\"submit\" value=\"ڽ폜\">");
			out.println("</form>");
		} 
	
		if(targetThreads + targetArticles == 0) {
			out.println("error target not found");
		}
	}
}
