/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.view;

import java.util.*;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.event.*;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.browser.*;

@SuppressWarnings("serial")
public class ThreadContentsEditorView extends Container {
	public EditableBrowser browser;
	public JTextArea htmlSourceView;
	public JTextField threadTitleText;
	public JTabbedPane tab;

	private void buildBrowserPanel(JTabbedPane tab) {
		browser =ViewNaver.instance.getBrowserFactory().createEditableBrowser();
		
		if(browser == null) return;
		
		browser.beginDocWriting();
		browser.writeDocHtml(
				"<html><head>"
				+ "<meta http-equiv=\"Content-Type\" content=\"text/html\">"
				//+"<style type=\"text/css\">BODY, TH, TD { font-family: 'MS UI Gothic'; }</style>"
				+ "</head><body></body></html>");
		browser.endDocWriting();
		
		JPanel browserPanel = new JPanel(new BorderLayout());
		browserPanel.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.LOWERED));

		JPanel browserAndToolPanel = new JPanel(new BorderLayout());

		JToolBar toolbar = new JToolBar();
		toolbar.setFloatable(false);
		
		JButton toggleBoldButton = new JButton("B");
		JButton toggleItalicButton = new JButton("I");
		JButton toggleUnderlineButton = new JButton("U");
		JButton insertHRButton = new JButton("HR");
		final JComboBox fontNameCombo = new JComboBox(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
		final JComboBox fontSizeCombo = new JComboBox(new String[] {"-2", "-1", "+0", "+1", "+2", "+3", "+4", "+5"});
		JButton colorButton = new JButton("Color");
		
		fontNameCombo.setEditable(true);
		fontSizeCombo.setEditable(true);

		fontNameCombo.setSelectedItem("");
		fontSizeCombo.setSelectedItem("");
		
//		fontNameCombo.setMaximumSize(new Dimension(100, 50));
//		fontSizeCombo.setMaximumSize(new Dimension(20, 50));

		toggleBoldButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				browser.toggleBold();
			}
		});
		
		toggleItalicButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				browser.toggleItalic();
			}
		});
		
		toggleUnderlineButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				browser.toggleUnderLine();
			}
		});
		
		insertHRButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				browser.insertHR();
			}
		});
		
		fontNameCombo.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				browser.setFontName((String)fontNameCombo.getSelectedItem());
			}
		});
		
		fontSizeCombo.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				browser.setFontSize((String)fontSizeCombo.getSelectedItem());
			}
		});
		
		colorButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				Color color = JColorChooser.showDialog(
						ThreadContentsEditorView.this,
						"Color Chooser",
						Color.black);
				
				if(color == null) return;
				String colorText = new Formatter().format(
						"#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue()).toString();

				browser.setColor(colorText);
			}
		});

		toolbar.add(toggleBoldButton);
		toolbar.add(toggleItalicButton);
		toolbar.add(toggleUnderlineButton);
		toolbar.add(insertHRButton);
		toolbar.addSeparator();
		toolbar.add(fontNameCombo);
		toolbar.addSeparator();
		toolbar.add(new JLabel("Size:"));
		toolbar.add(fontSizeCombo);
		toolbar.addSeparator();
		toolbar.add(colorButton);

		browserPanel.add(browser.getComponent(), BorderLayout.CENTER);

		browserAndToolPanel.add(toolbar, BorderLayout.NORTH);
		browserAndToolPanel.add(browserPanel, BorderLayout.CENTER);

		tab.add("ҏW", browserAndToolPanel);
	}
	
	public ThreadContentsEditorView() {
		setLayout(new BorderLayout());

		htmlSourceView = new JTextArea();
		htmlSourceView.setLineWrap(true);

		tab = new JTabbedPane();

		threadTitleText = new JTextField();

		buildBrowserPanel(tab);
		tab.add("HTML", new JScrollPane(htmlSourceView));

		tab.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent e) {
				if(browser != null) {
					if(tab.getSelectedIndex() == 1) {
						htmlSourceView.setText(browser.getBodyHtml());
					} else {
						browser.setBodyHtml(htmlSourceView.getText());
					}
				}
			}
		});

		Box threadTitleBox = new Box(BoxLayout.LINE_AXIS) {
			{
				setAlignmentX(JComponent.LEFT_ALIGNMENT);
				add(new JLabel("Title: "));
				add(threadTitleText);
			}
		};

		add(threadTitleBox, BorderLayout.NORTH);
		add(tab, BorderLayout.CENTER);
		setVisible(true);
	}

	@Override public void addNotify() {
		super.addNotify();
		
		if(browser == null) return;
		
		browser.setEditable(true);
		
		if(delayHtml != null) {
			browser.setBodyHtml(delayHtml);
		}
	}

	@Override public void setVisible(boolean visible) {
		super.setVisible(visible);
	}
	
	public String getThreadTitle() {
		return threadTitleText.getText();
	}

	public String getHtmlContent() {
		if(browser == null) return htmlSourceView.getText();
		
		if(tab.getSelectedIndex() == 0) {
			return browser.getBodyHtml();
		} else {
			return htmlSourceView.getText();
		}
	}

	private String delayHtml = null;

	public void setHtmlContents(String html) {
		htmlSourceView.setText(html);
		delayHtml = html;
	}
}
