unit MiscUtils;

// MiscUtils 1.0.0
// Delphi 3/4/5/6/7 and Kylix Implementation
// June 2004
//
//
// LICENSE
//
// The contents of this file are subject to the Mozilla Public License Version
// 1.1 (the "License"); you may not use this file except in compliance with
// the License. You may obtain a copy of the License at
// "http://www.mozilla.org/MPL/"
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
// the specific language governing rights and limitations under the License.
//
// The Original Code is "MiscUtils.pas".
//
// The Initial Developer of the Original Code is Dieter Khler (Heidelberg,
// Germany, "http://www.philo.de/"). Portions created by the Initial Developer
// are Copyright (C) 2003 Dieter Khler. All Rights Reserved.
//
// Alternatively, the contents of this file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"), in which case the
// provisions of the GPL are applicable instead of those above. If you wish to
// allow use of your version of this file only under the terms of the GPL, and
// not to allow others to use your version of this file under the terms of the
// MPL, indicate your decision by deleting the provisions above and replace them
// with the notice and other provisions required by the GPL. If you do not delete
// the provisions above, a recipient may use your version of this file under the
// terms of any one of the MPL or the GPL.

// HISTORY
// 2003-08-08 1.0.0

{$INCLUDE cDefines.inc}

interface

uses
  Windows, SysUtils;

type
  TUtilsNoRefCount = class(TObject, IUnknown)
  protected
    function QueryInterface(const IID: TGUID; out Obj): HResult; stdcall;
    function _AddRef: Integer; stdcall;
    function _Release: Integer; stdcall;
  end;

{ Helper functions }

type
  TVersionDetail = (
    vdAll,
    vdVersion,
    vdMajorVersion,
    vdMinorVersion,
    vdRelease,
    vdBuild
  ); 

{$IFDEF OS_MSWIN}
function GetFileVersionStr(const FileName: string;
  const VersionDetail: TVersionDetail = vdAll): string; {$IFDEF DELPHI6_UP}platform;{$ENDIF}
{$ENDIF}

implementation

{ Helper functions }

function GetFileVersionStr(const FileName: string;
  const VersionDetail: TVersionDetail = vdAll): string;
var
  Dummy: DWORD;
  InfoBufferSize: DWORD;
  FixedFileInfo: PVSFixedFileInfo;
  VersionBuffer: Pointer;
  VersionSize: DWORD;
begin
  Result := '';
  InfoBufferSize := GetFileVersionInfoSize(PChar(FileName), Dummy);
  if InfoBufferSize <> 0 then
  begin
    GetMem(VersionBuffer, InfoBufferSize);
    try
      if GetFileVersionInfo(PChar(FileName), Dummy, InfoBufferSize,
        VersionBuffer) then
        if VerQueryValue(VersionBuffer, '\', Pointer(FixedFileInfo), VersionSize) then
        begin
          case VersionDetail of
            vdAll:
              Result := Format('%d.%d.%d.%d',
                [ FixedFileInfo.dwFileVersionMS shr 16 and $0000FFFF,
                  FixedFileInfo.dwFileVersionMS and $0000FFFF,
                  FixedFileInfo.dwFileVersionLS shr 16 and $0000FFFF,
                  FixedFileInfo.dwFileVersionLS and $0000FFFF ]);
            vdVersion:
              Result := Format('%d.%d',
                [ FixedFileInfo.dwFileVersionMS shr 16 and $0000FFFF,
                  FixedFileInfo.dwFileVersionMS and $0000FFFF ]);
            vdMajorVersion:
              Result := Format('%d',
                [ FixedFileInfo.dwFileVersionMS shr 16 and $0000FFFF ]);
            vdMinorVersion:
              Result := Format('%d',
                [ FixedFileInfo.dwFileVersionMS and $0000FFFF ]);
            vdRelease:
              Result := Format('%d',
                [ FixedFileInfo.dwFileVersionLS shr 16 and $0000FFFF ]);
            vdBuild:
              Result := Format('%d',
                [ FixedFileInfo.dwFileVersionLS and $0000FFFF ]);
          end;
        end;
    finally
      FreeMem(VersionBuffer);
    end;
  end;
end;

{ TUtilsNoRefCount }

function TUtilsNoRefCount._AddRef: Integer;
begin
  Result := -1
end;

function TUtilsNoRefCount._Release: Integer;
begin
  Result := -1
end;

function TUtilsNoRefCount.QueryInterface(const IID: TGUID;
  out Obj): HResult;
begin
  if GetInterface(IID, Obj) then
    Result := 0
  else
    Result := E_NoInterface;
end;

end.

 