{*******************************************************}
{                     PHP4Delphi                        }
{               PHP - Delphi interface                  }
{                                                       }
{ Author:                                               }
{ Serhiy Perevoznyk                                     }
{ serge_perevoznyk@hotmail.com                          }
{ http://users.chello.be/ws36637                        }
{*******************************************************}
{$I PHP.INC}

{ $Id: DelphiFunctions.pas,v 1.1 2005/01/26 09:22:50 urmade Exp $ }

unit DelphiFunctions;

interface
uses
  Windows, SysUtils, Classes, ZendTypes, ZendAPI, PHPTypes, PHPAPI, Dialogs, ShellAPI, typinfo,
  Forms, stdctrls;

var
  DelphiTable : array [0..12] of zend_function_entry;


 object_functions    : array[0..2] of zend_function_entry;
 author_functions    : array[0..2] of zend_function_entry;

 DelphiObject : pzend_class_entry;
 ce           : pzend_class_entry;

 {$IFDEF PHP5}
 DelphiObjectHandlers : zend_object_handlers;
 {$ENDIF}

procedure InitDelphiFunctions;

procedure RegisterInternalClasses(p : pointer);


const
  SimpleProps = [tkInteger, tkChar, tkEnumeration, tkFloat,
    tkString,  tkWChar, tkLString, tkWString,  tkVariant];

implementation


//proto string delphi_get_system_directory(void)
procedure delphi_get_system_directory(ht : integer; return_value : pzval; this_ptr : pzval;
      return_value_used : integer; TSRMLS_DC : pointer); cdecl;

var
  Dir: array[0..MAX_PATH] of Char;
  p : pchar;
begin
  GetSystemDirectory(Dir, MAX_PATH);
  p := dir;
  ZVAL_STRING(return_value, p, true);
end;

//proto string delphi_str_date(void)
procedure delphi_str_date(ht : integer; return_value : pzval; this_ptr : pzval;
      return_value_used : integer; TSRMLS_DC : pointer); cdecl;
begin
  ZVAL_STRING(return_value, PChar(DateToStr(Date)), true);
end;

//proto float delphi_date(void)
procedure delphi_date(ht : integer; return_value : pzval; this_ptr : pzval;
      return_value_used : integer; TSRMLS_DC : pointer); cdecl;
begin
  ZVAL_DOUBLE(return_value, Date);
end;

//proto string delphi_extract_file_dir(string source)
procedure delphi_extract_file_dir(ht : integer; return_value : pzval; this_ptr : pzval;
      return_value_used : integer; TSRMLS_DC : pointer); cdecl;
var
  Param : pzval_array;
  P : PChar;
begin
  if ( not (zend_get_parameters_ex(1, Param) = SUCCESS )) then
  begin
    zend_wrong_param_count(TSRMLS_DC);
    Exit;
  end;
  convert_to_string(param[0]^);
  p := PChar(ExtractFileDir(param[0]^.value.str.val));
  ZVAL_STRING(return_value, p, true);
  dispose_pzval_array(Param);
end;

//proto string delphi_extract_file_drive(string source)
procedure delphi_extract_file_drive(ht : integer; return_value : pzval; this_ptr : pzval;
      return_value_used : integer; TSRMLS_DC : pointer); cdecl;
var
  Param : pzval_array;
  P : PChar;
begin
  if ( not (zend_get_parameters_ex(1, Param) = SUCCESS )) then
  begin
    zend_wrong_param_count(TSRMLS_DC);
    Exit;
  end;
  convert_to_string(param[0]^);
  p := PChar(ExtractFileDrive(param[0]^.value.str.val));
  ZVAL_STRING(return_value, p, true);
  dispose_pzval_array(Param);
end;

//proto string delphi_extract_file_name(string source)
procedure delphi_extract_file_name(ht : integer; return_value : pzval; this_ptr : pzval;
      return_value_used : integer; TSRMLS_DC : pointer); cdecl;
var
  Param : pzval_array;
  P : PChar;
begin
  if ( not (zend_get_parameters_ex(1, Param) = SUCCESS )) then
  begin
    zend_wrong_param_count(TSRMLS_DC);
    Exit;
  end;
  convert_to_string(param[0]^);
  p := PChar(ExtractFileName(param[0]^.value.str.val));
  ZVAL_STRING(return_value, p, true);
  dispose_pzval_array(Param);
end;

//proto string delphi_extract_file_ext(string source)
procedure delphi_extract_file_ext(ht : integer; return_value : pzval; this_ptr : pzval;
      return_value_used : integer; TSRMLS_DC : pointer); cdecl;
var
  Param : pzval_array;
  P : PChar;
begin
  if ( not (zend_get_parameters_ex(1, Param) = SUCCESS )) then
  begin
    zend_wrong_param_count(TSRMLS_DC);
    Exit;
  end;
  convert_to_string(param[0]^);
  p := PChar(ExtractFileExt(param[0]^.value.str.val));
  ZVAL_STRING(return_value, p, true);
  dispose_pzval_array(Param);
end;

//proto void delphi_show_message(string message)
procedure delphi_show_message(ht : integer; return_value : pzval; this_ptr : pzval;
      return_value_used : integer; TSRMLS_DC : pointer); cdecl;
var
  Param : pzval_array;
  P : PChar;
begin
  if ( not (zend_get_parameters_ex(1, Param) = SUCCESS )) then
  begin
    zend_wrong_param_count(TSRMLS_DC);
    Exit;
  end;
  convert_to_string(param[0]^);
  p := param[0]^.value.str.val;
  ShowMessage(P);
  dispose_pzval_array(Param);
end;

//proto string delphi_input_box(string caption, string prompt, string default)
procedure delphi_input_box(ht : integer; return_value : pzval; this_ptr : pzval;
      return_value_used : integer; TSRMLS_DC : pointer); cdecl;
var
  Param : pzval_array;
  Caption, Prompt, Default : string;
  P : PChar;
begin
  if ( not (zend_get_parameters_ex(3, Param) = SUCCESS )) then
  begin
    zend_wrong_param_count(TSRMLS_DC);
    Exit;
  end;

  convert_to_string(param[0]^);
  convert_to_string(param[1]^);
  convert_to_string(param[2]^);
  Caption := param[0]^.value.str.val;
  Prompt := param[1]^.value.str.val;
  Default := param[2]^.value.str.val;
  p := PChar(InputBox(Caption, Prompt, Default));
  ZVAL_STRING(return_value, PChar(p), true);
  dispose_pzval_array(Param);
end;

//proto void delphi_send_message(void)
procedure delphi_send_email(ht : integer; return_value : pzval; this_ptr : pzval;
      return_value_used : integer; TSRMLS_DC : pointer); cdecl;
begin
  ShellExecute(0, 'open', 'mailto:serge_perevoznyk@hotmail.com', nil, nil, SW_SHOWNORMAL);
end;

//proto void delphi_visit_homepage(void)
procedure delphi_visit_homepage(ht : integer; return_value : pzval; this_ptr : pzval;
      return_value_used : integer; TSRMLS_DC : pointer); cdecl;
begin
  ShellExecute(0, 'open', 'http://users.chello.be/ws36637', nil, nil, SW_SHOW);
end;


//Delphi objects support


procedure delphi_object_classname(ht : integer; return_value : pzval; this_ptr : pzval;
      return_value_used : integer; TSRMLS_DC : pointer); cdecl;
var
 OBJ : TObject;
 data: ^ppzval;
 P : string;
begin
 new(data);
 {$IFDEF PHP5}
 zend_hash_find(this_ptr^.value.obj.handlers.get_properties(this_ptr, TSRMLS_DC), 'instance', strlen('instance') + 1, data);
 {$ELSE}
 zend_hash_find(this_ptr^.value.obj.properties, 'instance', strlen('instance') + 1, data);
 {$ENDIF}

 Obj := TObject(data^^^.value.lval);
 P := Obj.ClassName;
 ZVAL_STRING(return_value, PChar(p), true);
 freemem(data);
end;


procedure delphi_object_classnameis(ht : integer; return_value : pzval; this_ptr : pzval;
      return_value_used : integer; TSRMLS_DC : pointer); cdecl;
var
 OBJ : TObject;
 data: ^ppzval;
 P : PChar;
 Param : pzval_array;
begin

  if ( not (zend_get_parameters_ex(1, Param) = SUCCESS )) then
  begin
    zend_wrong_param_count(TSRMLS_DC);
    Exit;
  end;

 convert_to_string(param[0]^);
 p := param[0]^.value.str.val;
 new(data);

 {$IFDEF PHP5}
 zend_hash_find(this_ptr^.value.obj.handlers.get_properties(this_ptr, TSRMLS_DC), 'instance', strlen('instance') + 1, data);
 {$ELSE}
 zend_hash_find(this_ptr^.value.obj.properties, 'instance', strlen('instance') + 1, data);
 {$ENDIF}

 Obj := TObject(data^^^.value.lval);
 ZVAL_BOOL(return_value,Obj.ClassNameIs(p));
 freemem(data);
end;



{$IFDEF PHP4}
function delphi_set_property_handler(property_reference : Pzend_property_reference; value : pzval) : integer; cdecl;
var
 this_ptr : pzval;
 OBJ : TObject;
 data: ^ppzval;
 element : pzend_list_element;
 prop  : pzend_overloaded_element;
 p : pointer;
 propname : string;
 pt : TTypeKind;
begin
  element :=  property_reference^.elements_list^.head;
  p := @element^.data;
  prop := pzend_overloaded_element(p);
  propname := prop^.element.value.str.val;

  this_ptr := property_reference^._object;
  new(data);
  zend_hash_find(this_ptr^.value.obj.properties, 'instance', strlen('instance') + 1, data);
  Obj := TObject(data^^^.value.lval);
  freemem(data);

  pt := PropType(Obj, propname);
  if ( pt in SimpleProps) then
   SetPropValue(OBJ, propname, zval2variant(value^))
     else
       if pt = tkClass then
         begin
           Obj := GetObjectProp(Obj, propname);
            while element <> nil do
             begin
               element := element^.prev;
               p := @element^.data;
               prop := pzend_overloaded_element(p);
               propname := prop^.element.value.str.val;
               pt := PropType(Obj, propname);
               if ( pt in SimpleProps) then
                begin
                  SetPropValue(OBJ, propname, zval2variant(value^));
                  break;
                end
                 else
                   if pt = tkClass then
                    Obj := GetObjectProp(Obj, propname);
             end;
         end;

  Result := SUCCESS;
end;



procedure delphi_get_property_handler(val : pzval; property_reference : PZend_property_reference); cdecl;
var
 this_ptr : pzval;
 OBJ : TObject;
 data: ^ppzval;
 element : pzend_list_element;
 prop  : pzend_overloaded_element;
 p : pointer;
 propname : string;
 pt : TTypeKind;
begin
  element :=  property_reference^.elements_list^.head;
  p := @element^.data;
  prop := pzend_overloaded_element(p);
  propname := prop^.element.value.str.val;
  this_ptr := property_reference^._object;
  new(data);
  zend_hash_find(this_ptr^.value.obj.properties, 'instance', strlen('instance') + 1, data);
  Obj := TObject(data^^^.value.lval);
  freemem(data);
  pt := PropType(Obj, propname);
  if ( pt in SimpleProps) then
   variant2zval(GetPropValue(OBJ, propname), val)
     else
       if pt = tkClass then
         begin
           Obj := GetObjectProp(Obj, propname);
            while element <> nil do
             begin
               element := element^.prev;
               p := @element^.data;
               prop := pzend_overloaded_element(p);
               propname := prop^.element.value.str.val;
               pt := PropType(Obj, propname);
               if ( pt in SimpleProps) then
                begin
                  variant2zval(GetPropValue(OBJ, propname), val);
                  break;
                end
                 else
                   if pt = tkClass then
                    Obj := GetObjectProp(Obj, propname);
             end;
         end;
end;



procedure _delphi_get_property_wrapper; assembler;
asm
  push        ebp
  mov         ebp,esp
  sub         esp,50h
  push        ebx
  push        esi
  push        edi
  lea         edi,[ebp-50h]
  mov         ecx,14h
  mov         eax,0CCCCCCCCh
  rep         stosd
  mov         eax,dword ptr [ebp+0Ch]
  push        eax
  lea         ecx,[ebp-10h]
  push        ecx
  call        delphi_get_property_handler
  add         esp,8
  mov         edx,dword ptr [ebp+8]
  mov         eax,dword ptr [ebp-10h]
  mov         dword ptr [edx],eax
  mov         ecx,dword ptr [ebp-0Ch]
  mov         dword ptr [edx+4],ecx
  mov         eax,dword ptr [ebp-8]
  mov         dword ptr [edx+8],eax
  mov         ecx,dword ptr [ebp-4]
  mov         dword ptr [edx+0Ch],ecx
  mov         eax,dword ptr [ebp+8]

  pop         edi
  pop         esi
  pop         ebx
  add         esp,50h
  cmp         ebp,esp
  mov         esp,ebp
  pop         ebp
  ret
end;


procedure delphi_call_function(ht : integer; return_value : pzval; this_ptr : pzval;
      return_value_used : integer; TSRMLS_DC : pointer; property_reference : Pzend_property_reference ); cdecl;
var
 OBJ : TObject;
 data: ^ppzval;
 element : pzend_list_element;
 prop  : pzend_overloaded_element;
 p : pointer;
 MethodName : string;
 Params : pzval_array;
 M, D : integer;
begin
  element :=  property_reference^.elements_list^.head;
  p := @element^.data;
  prop := pzend_overloaded_element(p);
  MethodName := prop^.element.value.str.val;
  this_ptr := property_reference^._object;
  new(data);
  zend_hash_find(this_ptr^.value.obj.properties, 'instance', strlen('instance') + 1, data);
  Obj := TObject(data^^^.value.lval);
  freemem(data);
  if ( Obj.InheritsFrom(TCustomEdit) ) then
   begin
     if SameText(MethodName, 'Clear') then
      TCustomEdit(Obj).Clear;
     if SameText(MethodName, 'ClearSelection') then
      TCustomEdit(Obj).ClearSelection;
     if SameText(MethodName, 'CopyToClipboard') then
      TCustomEdit(Obj).CopyToClipboard;
     if SameText(MethodName, 'ControlCount') then
      ZVAL_LONG(return_value, TCustomEdit(Obj).ControlCount);
     if SameText(MethodName, 'ScaleBy') then
        begin
          if ht > 0 then
           begin
             if ( not (zend_get_parameters_ex(ht, Params) = SUCCESS )) then
               begin
                 zend_wrong_param_count(TSRMLS_DC);
                 Exit;
               end;
            end;
          M := Params[0]^.value.lval;
          D := Params[1]^.value.lval;
          TCustomEdit(Obj).ScaleBy(M, D);
          dispose_pzval_array(Params);
        end;
   end;
end;
{$ENDIF}



{$IFDEF PHP5}

// Read object property value  (getter)
function delphi_get_property_handler(_object : pzval; member : pzval; _type : integer; TSRMLS_DC : pointer) : pzval; cdecl;
var
 retval : pzval;
 OBJ : TObject;
 data: ^ppzval;
 propname : string;
 pt : TTypeKind;
 object_properties : PHashTable;
 _property : PChar;
begin
  retval := emalloc(sizeof(zval));
  FillChar(retval^, sizeof(zval), 0);
  propname := member^.value.str.val;
  new(data);
    try
     object_properties := Z_OBJPROP(_object^);
     if zend_hash_find(object_properties, 'instance', strlen('instance') + 1, data) = SUCCESS then
     Obj := TObject(data^^^.value.lval)
       else
         Obj := nil;
     finally
      freemem(data);
    end;

  if Assigned(Obj) then
   begin
     pt := PropType(Obj, propname);
     if ( pt in SimpleProps) then
     variant2zval(GetPropValue(OBJ, propname), retval)
      else
       if pt = tkClass then
         begin
           Obj := GetObjectProp(Obj, propname);
            retval._type := IS_OBJECT;
           object_init(retval, DelphiObject, TSRMLS_DC);
            _property := 'instance';
           add_property_long_ex(retval, _property, strlen(_property) + 1, Integer(Obj), TSRMLS_DC);
           retval.value.obj.handlers := @DelphiObjectHandlers;
          end;
       end;

  Result := retval;
end;

// Write object property value (setter)
procedure delphi_set_property_handler(_object : pzval; member : pzval; value : pzval; TSRMLS_DC : pointer); cdecl;
var
 OBJ : TObject;
 data: ^ppzval;
 propname : string;
 pt : TTypeKind;
 object_properties : PHashTable;
begin
  propname := member^.value.str.val;
  new(data);
    try
     object_properties := Z_OBJPROP(_object^);
     if zend_hash_find(object_properties, 'instance', strlen('instance') + 1, data) = SUCCESS then
     Obj := TObject(data^^^.value.lval)
       else
         Obj := nil;
     finally
      freemem(data);
    end;

  if Assigned(Obj) then
   begin
     pt := PropType(Obj, propname);
     if ( pt in SimpleProps) then
       SetPropValue(OBJ, propname, zval2variant(value^))
   end;
end;

function delphi_call_method(method : pchar; ht : integer; return_value : pzval; this_ptr : pzval;
      return_value_used : integer; TSRMLS_DC : pointer) : integer; cdecl;
var
 OBJ : TObject;
 data: ^ppzval;
 Params : pzval_array;
 M, D : integer;
begin
 new(data);
 if zend_hash_find(this_ptr^.value.obj.handlers.get_properties(this_ptr, TSRMLS_DC), 'instance', strlen('instance') + 1, data) = SUCCESS then
  Obj := TObject(data^^^.value.lval)
   else
     Obj := nil;
  freemem(data);
  if Obj <> nil then
   begin
     if ( Obj.InheritsFrom(TCustomEdit) ) then
     begin
       if SameText(Method, 'Clear') then
        TCustomEdit(Obj).Clear;
       if SameText(Method, 'ClearSelection') then
        TCustomEdit(Obj).ClearSelection;
       if SameText(Method, 'CopyToClipboard') then
        TCustomEdit(Obj).CopyToClipboard;
       if SameText(Method, 'ControlCount') then
        ZVAL_LONG(return_value, TCustomEdit(Obj).ControlCount);
       if SameText(Method, 'ScaleBy') then
        begin
          if ht > 0 then
           begin
             if ( not (zend_get_parameters_ex(ht, Params) = SUCCESS )) then
               begin
                 zend_wrong_param_count(TSRMLS_DC);
                 Result := FAILURE;
                 Exit;
               end;
            end;
          M := Params[0]^.value.lval;
          D := Params[1]^.value.lval;
          TCustomEdit(Obj).ScaleBy(M, D);
          dispose_pzval_array(Params);
        end;
     end;
   end;
  result := SUCCESS;
end;

function delphi_get_method(_object : pzval; method_name : pchar; method_len : integer; TSRMLS_DC : pointer) : PzendFunction; cdecl;
var
 fnc : pZendFunction;
begin
  fnc := emalloc(sizeof(TZendFunction));
  FillChar(fnc^, sizeOf(TZendFunction), 0);
  fnc^.internal_function._type := ZEND_OVERLOADED_FUNCTION;
  fnc^.internal_function.function_name := estrndup(method_name, method_len);
  fnc^.internal_function.handler := @delphi_call_method;
  result := fnc;
end;


{$ENDIF}

procedure delphi_get_author(ht : integer; return_value : pzval; this_ptr : pzval;
      return_value_used : integer; TSRMLS_DC : pointer); cdecl;
var
 properties : array[0..3] of pchar;
begin
  properties[0] := 'name';
  properties[1] := 'last';
  properties[2] := 'height';
  properties[3] := 'email';
  {$IFDEF PHP4}
  _object_init_ex(return_value, ce,  nil, 0, TSRMLS_DC );
  {$ELSE}
  object_init(return_value, ce,  TSRMLS_DC );
  {$ENDIF}
  add_property_string_ex(return_value, properties[0], strlen(properties[0]) + 1, 'Serhiy', 1);
  add_property_string_ex(return_value, properties[1], strlen(properties[1]) + 1, 'Perevoznyk', 1);

  {$IFDEF PHP5}
  add_property_long_ex(return_value, properties[2], strlen(properties[2]) + 1, 185, TSRMLS_DC);
  {$ELSE}
  add_property_long_ex(return_value, properties[2], strlen(properties[2]) + 1, 185);
  {$ENDIF}

  add_property_string_ex(return_value, properties[3], strlen(properties[3]) + 1, 'serge_perevoznyk@hotmail.com', 1);
end;





procedure register_delphi_object(ht : integer; return_value : pzval; this_ptr : pzval;
      return_value_used : integer; TSRMLS_DC : pointer); cdecl;
var
 _property : pchar;
 Param : pzval_array;
 Obj : TObject;
begin

  if ( not (zend_get_parameters_ex(1, Param) = SUCCESS )) then
  begin
    zend_wrong_param_count(TSRMLS_DC);
    Exit;
  end;


  Obj := TObject(Param[0]^.value.lval);
  _property := 'instance';

  return_value._type := IS_OBJECT;
  {$IFDEF PHP4}
  _object_init_ex(return_value, DelphiObject, nil, 0, TSRMLS_DC );
  {$ELSE}
   object_init(return_value, DelphiObject, TSRMLS_DC);
  {$ENDIF}

  {$IFDEF PHP5}
  add_property_long_ex(return_value, _property, strlen(_property) + 1, Integer(Obj), TSRMLS_DC);
  {$ELSE}
  add_property_long_ex(return_value, _property, strlen(_property) + 1, Integer(Obj));
  {$ENDIF}

  {$IFDEF PHP5}
   return_value.value.obj.handlers := @DelphiObjectHandlers;
  {$ENDIF}

  dispose_pzval_array(Param);

end;


procedure register_delphi_component(ht : integer; return_value : pzval; this_ptr : pzval;
      return_value_used : integer; TSRMLS_DC : pointer); cdecl;
var
 _property : pchar;
 Param : pzval_array;
 Obj : TObject;
 ObjName : string;
 php : TComponent;
 gl : psapi_globals_struct;
 p : pointer;
 Form : TCustomForm;
begin
  if ( not (zend_get_parameters_ex(1, Param) = SUCCESS )) then
  begin
    zend_wrong_param_count(TSRMLS_DC);
    Exit;
  end;
  ObjName  := Param[0]^.value.str.val;

  p := ts_resource_ex(0, nil);
  gl := GetSAPIGlobals(p);
  php := TComponent(gl^.server_context);
  if not Assigned(php) then
   begin
    ZVAL_NULL(return_value);
    exit;
   end;

  Form := TCustomForm(php.Owner);
  if not Assigned(Form) then
   begin
    ZVAL_NULL(return_value);
    exit;
   end;

  if SameText(Form.Name, ObjName) then
   Obj := Form
     else
      OBJ := Form.FindComponent(ObjName);
  if not Assigned(Obj) then
   begin
    ZVAL_NULL(return_value);
    exit;
   end;

  _property := 'instance';
  {$IFDEF PHP4}
  _object_init_ex(return_value, DelphiObject, nil, 0,  TSRMLS_DC );
  {$ELSE}
  object_init(return_value, DelphiObject,  TSRMLS_DC);
  {$ENDIF}

  {$IFDEF PHP5}
  add_property_long_ex(return_value, _property, strlen(_property) + 1, Integer(Obj), TSRMLS_DC);
  {$ELSE}
  add_property_long_ex(return_value, _property, strlen(_property) + 1, Integer(Obj));
  {$ENDIF}

  {$IFDEF PHP5}
  return_value.value.obj.handlers := @DelphiObjectHandlers;
  {$ENDIF}

  dispose_pzval_array(Param);

end;



procedure InitDelphiFunctions;
begin
  PHP_FUNCTION(DelphiTable[0], 'delphi_date', @delphi_date);
  PHP_FUNCTION(DelphiTable[1], 'delphi_extract_file_dir', @delphi_extract_file_dir);
  PHP_FUNCTION(DelphiTable[2], 'delphi_extract_file_drive', @delphi_extract_file_drive);
  PHP_FUNCTION(DelphiTable[3], 'delphi_extract_file_name', @delphi_extract_file_name);

  DelphiTable[4].fname := 'delphi_extract_file_ext';
  DelphiTable[4].handler := @delphi_extract_file_ext;
  {$IFDEF PHP4}
  DelphiTable[4].func_arg_types := nil;
  {$ELSE}
  DelphiTable[4].arg_info := nil;
  {$ENDIF}

  DelphiTable[5].fname := 'delphi_show_message';
  DelphiTable[5].handler := @delphi_show_message;
  {$IFDEF PHP4}
  DelphiTable[5].func_arg_types := nil;
  {$ELSE}
  DelphiTable[5].arg_info := nil;
  {$ENDIF}

  DelphiTable[6].fname :=  'register_delphi_object';
  delphitable[6].handler := @register_delphi_object;
  {$IFDEF PHP4}
  DelphiTable[6].func_arg_types := nil;
  {$ELSE}
  DelphiTable[6].arg_info := nil;
  {$ENDIF}

  DelphiTable[7].fname := 'delphi_get_author';
  DelphiTable[7].handler := @delphi_get_author;
  {$IFDEF PHP4}
  DelphiTable[7].func_arg_types := nil;
  {$ELSE}
  DelphiTable[7].arg_info := nil;
  {$ENDIF}

  DelphiTable[8].fname := 'delphi_str_date';
  DelphiTable[8].handler := @delphi_str_date;
  {$IFDEF PHP4}
  DelphiTable[8].func_arg_types := nil;
  {$ELSE}
  DelphiTable[8].arg_info := nil;
  {$ENDIF}


  PHP_FUNCTION(DelphiTable[9], 'delphi_get_system_directory', @delphi_get_system_directory);


  PHP_FUNCTION(DelphiTable[10], 'delphi_input_box', @delphi_input_box);
  PHP_FUNCTION(DelphiTable[11], 'register_delphi_component', @register_delphi_component);
  DelphiTable[12].fname := nil;
  DelphiTable[12].handler := nil;
end;



procedure RegisterInternalClasses(p : pointer);
var
 author_class_entry   : Tzend_class_entry;
 delphi_object_entry  : TZend_class_entry;

begin
  object_functions[0].fname := 'delphi_classname';
  object_functions[0].handler := @delphi_object_classname;
  object_functions[1].fname := 'delphi_classnameis';
  object_functions[1].handler := @delphi_object_classnameis;
  INIT_CLASS_ENTRY(delphi_object_entry, 'delphi_class' , @object_functions);
  {$IFDEF PHP4}
  Delphi_Object_Entry.handle_property_get :=  @_delphi_get_property_wrapper;
  Delphi_Object_Entry.handle_property_set := @delphi_set_property_handler;
  Delphi_Object_Entry.handle_function_call :=  @delphi_call_function;
  {$ELSE}
  Move(zend_get_std_object_handlers()^, DelphiObjectHandlers, sizeof(zend_object_handlers));
  DelphiObjectHandlers.read_property := @delphi_get_property_handler;
  DelphiObjecthandlers.write_property := @delphi_set_property_handler;
  DelphiObjectHandlers.call_method := @delphi_call_method;
  DelphiObjectHandlers.get_method := @delphi_get_method;
  {$ENDIF}
  DelphiObject := zend_register_internal_class(@delphi_object_entry, p);

  author_functions[0].fname := 'send_email';
  author_functions[0].handler := @delphi_send_email;
  author_functions[1].fname := 'visit_homepage';
  author_functions[1].handler := @delphi_visit_homepage;
  INIT_CLASS_ENTRY(author_class_entry, 'php4delphi_author', @author_functions);
  ce := zend_register_internal_class(@author_class_entry, p);

end;

end.
