unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, HTTPApp;

type
  TWebModule1 = class(TWebModule)
    procedure WebModule1WebActionItem1Action(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure WebModule1WebActionItem2Action(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure WebModule1WebActionItem3Action(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  WebModule1: TWebModule1;

implementation

uses
  ISAPIHTTP, ISAPI2;

{$R *.DFM}

procedure TWebModule1.WebModule1WebActionItem1Action(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
begin
  Response.Content := '<html><body><H1>Test ISAPI application</H1></body></html>';
end;

procedure TWebModule1.WebModule1WebActionItem2Action(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
var
 SessionData : string;
begin
  SessionData := Request.GetFieldByName('HTTP_IDSESSION');
  SessionData := StringReplace(Sessiondata,#13#10,'',[rfReplaceAll]);
  if SessionData = '' then
   SessionData := '0'
   else
     SessionData :=  IntToStr(StrToIntDef(SessionData,0) + 1);
  TISAPIRequest(Request).ECB.ServerSupportFunction(TISAPIRequest(Request).ECB.ConnID,
  HSE_REQ_END_RESERVED + 20, PChar(SessionData), nil, nil);
  with Response.Cookies.Add do
  begin
    Name := 'LastPassword';
    { Set the LastPassword cookie to the current authorization }
    { Or, if no authorization was supplied this time, carry over }
    { the authorization from the LastPassword cookie of the request }
    Value := 'password';
    Expires := Now + 10000; { this cookie expires in one day }
  end;

  with Response.Cookies.Add do
  begin
    Name := 'Another';
    { Set the LastPassword cookie to the current authorization }
    { Or, if no authorization was supplied this time, carry over }
    { the authorization from the LastPassword cookie of the request }
    Value := 'yep';
    Expires := Now + 10000; { this cookie expires in one day }
  end;

  Response.Content := '<html><body><H1>Test ISAPI application. Test action was called <br>' +
  'url: ' + Request.URL + '<br>' +
  'method: ' + Request.Method + '<br>' +
  'protocol version: ' + Request.ProtocolVersion + '<br>' +
  'query: ' + Request.Query + '<br>' +
  'pathinfo: ' + Request.PathInfo + '<br>' +
  'path translated: '+  Request.PathTranslated + '<br>' +
  'cookies: '  + Request.CookieFields.Text + '<br>' +
  'query fields: ' + Request.QueryFields.Text + '<br>' +
  'content fields: '+   Request.ContentFields.Text + '<br>' +
  'remote host: ' + Request.RemoteHost + '<br>'+
  'scriptName: ' + request.ScriptName +  '<br>' +
  'language: ' + Request.GetFieldByName('HTTP_ACCEPT_LANGUAGE')  + '<br>' +
  'referer: ' + Request.GetFieldByName('REFERER') +'<br>' +
  'session: ' + SessionData+
  '</H1></body></html>';
end;

procedure TWebModule1.WebModule1WebActionItem3Action(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
var
 S : TStringStream;
begin
  S := TStringStream.Create('<html><body><H1>Test stream </H1></body></html>');
  S.Position := 0;
  Response.SendResponse;
  Response.SendStream(S);
end;

end.
