unit Main;

interface

uses
  Graphics, Controls, Forms, Dialogs, ActnList, StdCtrls, Buttons, ComCtrls, ExtCtrls,
  windows, messages, SysUtils, Classes, IdComponent, IdTCPServer, IdHTTPServer, IdGlobal, IdBaseComponent, IdThreadMgr, IdThreadMgrDefault, SyncObjs, IdThreadMgrPool, IdIntercept,
  idISAPIRunner, IdCustomHTTPServer;


type
  TfmHTTPServerMain = class(TForm)
  HTTPServer: TIdHTTPServer;
  alGeneral: TActionList;
  acActivate: TAction;
  edPort: TEdit;
  cbActive: TCheckBox;
  StatusBar1: TStatusBar;
  edRoot: TEdit;
  LabelRoot: TLabel;
  cbEnableLog: TCheckBox;
  Label1: TLabel;
  Panel1: TPanel;
  lbLog: TListBox;
  lbSessionList: TListBox;
  Splitter1: TSplitter;
    ISAPIRunner: TidISAPIRunner;
  procedure acActivateExecute(Sender: TObject);
  procedure edPortChange(Sender: TObject);
  procedure edPortKeyPress(Sender: TObject; var Key: Char);
  procedure edPortExit(Sender: TObject);
  procedure HTTPServerCommandGet(AThread: TIdPeerThread;
  RequestInfo: TIdHTTPRequestInfo; ResponseInfo: TIdHTTPResponseInfo);
  procedure FormCreate(Sender: TObject);
  procedure FormDestroy(Sender: TObject);
  procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  procedure HTTPServerConnect(AThread: TIdPeerThread);
  procedure HTTPServerDisconnect(AThread: TIdPeerThread);
  procedure HTTPServerExecute(AThread: TIdPeerThread);
  procedure HTTPServerCommandOther(Thread: TIdPeerThread;
  const asCommand, asData, asVersion: String);
  procedure HTTPServerStatus(ASender: TObject; const AStatus: TIdStatus;
  const AStatusText: String);
  private
  UILock: TCriticalSection;
  procedure DisplayMessage(const Msg: String);
  function GetMIMEType(sFile: TFileName): String;
  { Private declarations }
  public
  { Public declarations }
  EnableLog: boolean;
  MIMEMap: TIdMIMETable;
  end;

var
  fmHTTPServerMain: TfmHTTPServerMain;

implementation

{$WARNINGS OFF}
uses  filectrl, IdStack;

{$R *.DFM}

procedure TfmHTTPServerMain.acActivateExecute(Sender: TObject);
begin
  acActivate.Checked := not acActivate.Checked;
  if acActivate.Checked then
   Caption := 'active'
    else
     caption := 'inactive';
     
  lbSessionList.Items.Clear;
  if not HTTPServer.Active then
  begin
  HTTPServer.Bindings.Clear;
  HTTPServer.DefaultPort := StrToIntDef(edPort.text, 80);
  HTTPServer.Bindings.Add;
  end;

  if not DirectoryExists(edRoot.text) then
  begin
  DisplayMessage(Format('Web root folder (%s) not found.',[edRoot.text]));
  acActivate.Checked := False;
  end
  else
  begin
  if acActivate.Checked then
  begin
  try
  EnableLog := cbEnableLog.Checked;

  HTTPServer.Active := true;
  DisplayMessage(format('Listening for HTTP connections on %s:%d.',[HTTPServer.Bindings[0].IP, HTTPServer.Bindings[0].Port]));
  except
  on e: exception do
  begin
  acActivate.Checked := False;
  DisplayMessage(format('Exception %s in Activate. Error is:"%s".', [e.ClassName, e.Message]));
  end;
  end;
  end
  else
  begin
  HTTPServer.Active := false;
  DisplayMessage('Stop listening.');
  end;
  end;
  edPort.Enabled := not acActivate.Checked;
  edRoot.Enabled := not acActivate.Checked;
  cbEnableLog.Enabled := not acActivate.Checked;
end;

procedure TfmHTTPServerMain.edPortChange(Sender: TObject);
var
  FinalLength, i: Integer;
  FinalText: String;
begin
  // Filter routine. Remove every char that is not a numeric (must do that for cut'n paste)
  Setlength(FinalText, length(edPort.Text));
  FinalLength := 0;
  for i := 1 to length(edPort.Text) do
  begin
  if edPort.text[i] in [ '0'..'9' ] then
  begin
  inc(FinalLength);
  FinalText[FinalLength] := edPort.text[i];
  end;
  end;
  SetLength(FinalText, FinalLength);
  edPort.text := FinalText;
end;

procedure TfmHTTPServerMain.edPortKeyPress(Sender: TObject; var Key: Char);
begin
  if not (key in [ '0'..'9', #8 ]) then
  Key := #0;
end;

procedure TfmHTTPServerMain.edPortExit(Sender: TObject);
begin
  if length(trim(edPort.text)) = 0 then
  edPort.text := '80';
end;


procedure TfmHTTPServerMain.DisplayMessage(const Msg: String);
begin
  if EnableLog then
  begin
  UILock.Acquire;
  try
  lbLog.ItemIndex := lbLog.Items.Add(Msg);
  finally
  UILock.Release;
  end;
  end;
end;

const
  sauthenticationrealm = 'Indy http server demo';

procedure TfmHTTPServerMain.HTTPServerCommandGet(AThread: TIdPeerThread;
  RequestInfo: TIdHTTPRequestInfo; ResponseInfo: TIdHTTPResponseInfo);

  procedure AuthFailed;
  begin
  ResponseInfo.ContentText := '<html><head><title>Error</title></head><body><h1>Authentication failed</h1>'#13 +
  'Check the demo source code to discover the password:<br><ul><li>Search for <b>AuthUsername</b> in <b>Main.pas</b>!</ul></body></html>';
  ResponseInfo.AuthRealm := sauthenticationrealm;
  end;

  procedure AccessDenied;
  begin
  ResponseInfo.ContentText := '<html><head><title>Error</title></head><body><h1>Access denied</h1>'#13 +
  'You do not have sufficient priviligies to access this document.</body></html>';
  ResponseInfo.ResponseNo := 403;
  end;

var
  LocalDoc: string;
  ByteSent: Cardinal;
  ResultFile: TFileStream;
  Action : string;
begin
  // Log the request
  DisplayMessage(Format( 'Command %s %s received from %s:%d',
  [RequestInfo.Command, RequestInfo.Document, AThread.Connection.Socket.Binding.PeerIP,AThread.Connection.Socket.Binding.PeerPort]));

  LocalDoc := '';

  if Pos('.php',LowerCase(RequestInfo.Document)) <> 0 then
     LocalDoc := 'php4isapi.dll';

  if Pos('.dll',LowerCase(RequestInfo.Document)) <> 0 then
    begin
       LocalDoc := LowerCase(RequestInfo.Document);
       Action := Copy(LocalDoc,Pos('.dll',LocalDoc)+4,Length(LocalDoc));
       LocalDoc := Copy(LocalDoc,1,Pos('.dll',LocalDoc)+3);
    end;

   if LocalDoc <> '' then
    begin
      LocalDoc := ExpandFilename(IncludeTrailingBackSlash(edRoot.text) + LocalDoc);
      if FileExists(LocalDoc) then
        begin
          ISAPIRunner.Execute(LocalDoc, AThread,RequestInfo,ResponseInfo, edRoot.Text, false, Action);
        end
         else
            begin
               ResponseInfo.ContentText := '<H1><center>Script not found</center></H1>';
               ResponseInfo.ResponseNo := 404; // Not found
            end;
   end
    else
       begin
         // Interprete the command to it's final path (avoid sending files in parent folders)
         LocalDoc := ExpandFilename(edRoot.text + RequestInfo.Document);
        // Default document (index.html) for folder
        if not FileExists(LocalDoc) and DirectoryExists(LocalDoc) and FileExists(ExpandFileName(LocalDoc + '/index.html')) then
         begin
          LocalDoc := ExpandFileName(LocalDoc + '/index.html');
         end;

        if FileExists(LocalDoc) then // File exists
          begin
            if AnsiSameText(Copy(LocalDoc, 1, Length(edRoot.text)), edRoot.Text) then // File down in dir structure
              begin
                if AnsiSameText(RequestInfo.Command, 'HEAD') then
                  begin
                   // HEAD request, don't send the document but still send back it's size
                   ResultFile := TFileStream.create(LocalDoc, fmOpenRead  or fmShareDenyWrite);
                   try
                    ResponseInfo.ResponseNo := 200;
                    ResponseInfo.ContentType := GetMIMEType(LocalDoc);
                    ResponseInfo.ContentLength := ResultFile.Size;
                   finally
                    ResultFile.Free; // We must free this file since it won't be done by the web server component
                   end;
                 end
                   else
                     begin
                       // Normal document request
                       // Send the document back
                       ByteSent := HTTPServer.ServeFile(AThread, ResponseInfo, LocalDoc);
                       DisplayMessage(Format('Serving file %s (%d bytes / %d bytes sent) to %s:%d',
                              [LocalDoc, ByteSent, FileSizeByName(LocalDoc),
                              AThread.Connection.Socket.Binding.PeerIP,
                              AThread.Connection.Socket.Binding.PeerPort]));
                     end;
              end
                else
                  AccessDenied;
          end
            else
               begin
                  ResponseInfo.ResponseNo := 404; // Not found
                  ResponseInfo.ContentText := '<html><head><title>Error</title></head><body><h1>' + ResponseInfo.ResponseText + '</h1></body></html>';
               end;
  end;
end;

procedure TfmHTTPServerMain.FormCreate(Sender: TObject);
begin
  UILock := TCriticalSection.Create;
  MIMEMap := TIdMIMETable.Create(true);
  edRoot.text := ExtractFilePath(Application.exename) + 'Web';
  if HTTPServer.active then  caption := 'active' else caption := 'inactive';
end;

procedure TfmHTTPServerMain.FormDestroy(Sender: TObject);
begin
  HTTPServer.Active := false;
  MIMEMap.Free;
  UILock.Free;
end;

function TfmHTTPServerMain.GetMIMEType(sFile: TFileName): String;
begin
  result := MIMEMap.GetFileMIMEType(sFile);
end;

procedure TfmHTTPServerMain.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  // desactivate the server
  if cbActive.Checked then
  acActivate.execute;
end;

procedure TfmHTTPServerMain.HTTPServerConnect(AThread: TIdPeerThread);
begin
DisplayMessage('User logged in');
end;

procedure TfmHTTPServerMain.HTTPServerDisconnect(AThread: TIdPeerThread);
begin
DisplayMessage('User logged out');
end;

procedure TfmHTTPServerMain.HTTPServerExecute(AThread: TIdPeerThread);
begin
DisplayMessage('Execute');
end;

procedure TfmHTTPServerMain.HTTPServerCommandOther(Thread: TIdPeerThread;
  const asCommand, asData, asVersion: String);
begin
DisplayMessage('Command other: ' + asCommand);
end;

procedure TfmHTTPServerMain.HTTPServerStatus(ASender: TObject;
  const AStatus: TIdStatus; const AStatusText: String);
begin
DisplayMessage('Status: ' + aStatusText);
end;

end.
