{-------------------------------------------------------------------------------
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in compliance
with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
the specific language governing rights and limitations under the License.

The Original Code is: SynHighlighterJScript.pas, released 2000-04-14.
The Original Code is based on the mwJScript.pas file from the
mwEdit component suite by Martin Waldenburg and other developers, the Initial
Author of this file is Tony de Buys.
Unicode translation by Mal Hrz.
All Rights Reserved.

Contributors to the SynEdit and mwEdit projects are listed in the
Contributors.txt file.

Alternatively, the contents of this file may be used under the terms of the
GNU General Public License Version 2 or later (the "GPL"), in which case
the provisions of the GPL are applicable instead of those above.
If you wish to allow use of your version of this file only under the terms
of the GPL and not to allow others to use your version of this file
under the MPL, indicate your decision by deleting the provisions above and
replace them with the notice and other provisions required by the GPL.
If you do not delete the provisions above, a recipient may use your version
of this file under either the MPL or the GPL.

$Id: SynHighlighterJScript.pas,v 1.1 2005/01/28 07:46:09 urmade Exp $

You may retrieve the latest version of this file at the SynEdit home page,
located at http://SynEdit.SourceForge.net

Known Issues:
-------------------------------------------------------------------------------}
{
@abstract(Provides a JavaScript/JScript highlighter for SynEdit)
@author(Tony De Buys [tony@lad.co.za], converted to SynEdit by David Muir <david@loanhead45.freeserve.co.uk>)
@created(December 1999, converted to SynEdit April 14, 2000)
@lastmod(2000-06-23)
The SynHighlighterJScript unit provides SynEdit with a JScript/JavaScript (.js) highlighter.
The highlighter formats JavaScript source code highlighting keywords, strings, numbers and characters.
}

{$IFNDEF QSYNHIGHLIGHTERJSCRIPT}
unit SynHighlighterJScript;
{$ENDIF}

{$I SynEdit.inc}

interface

uses
{$IFDEF SYN_CLX}
  QGraphics,
  QSynEditTypes,
  QSynEditHighlighter,
{$ELSE}
  Graphics,
  Registry,
  SynEditTypes,
  SynEditHighlighter,
{$ENDIF}
  SysUtils, Classes;

type
  TtkTokenKind = (tkComment, tkIdentifier, tkKey, tkNull, tkNumber, tkSpace,
    tkString, tkSymbol, tkUnknown, tkNonReservedKey, tkEvent);

  TRangeState = (rsUnknown, rsANSI);

  PIdentFuncTableFunc = ^TIdentFuncTableFunc;
  TIdentFuncTableFunc = function (Index: Integer): TtkTokenKind of object;

type
  TSynJScriptSyn = class(TSynCustomHighLighter)
  private
    fRange: TRangeState;
    FTokenID: TtkTokenKind;
    fIdentFuncTable: array[0..4252] of TIdentFuncTableFunc;
    fCommentAttri: TSynHighlighterAttributes;
    fIdentifierAttri: TSynHighlighterAttributes;
    fKeyAttri: TSynHighlighterAttributes;
    fNonReservedKeyAttri: TSynHighlighterAttributes;
    fEventAttri: TSynHighlighterAttributes;
    fNumberAttri: TSynHighlighterAttributes;
    fSpaceAttri: TSynHighlighterAttributes;
    fStringAttri: TSynHighlighterAttributes;
    fSymbolAttri: TSynHighlighterAttributes;
    function AltFunc(Index: Integer): TtkTokenKind;
    function FuncAbs(Index: Integer): TtkTokenKind;
    function FuncAbstract(Index: Integer): TtkTokenKind;
    function FuncAcos(Index: Integer): TtkTokenKind;
    function FuncAction(Index: Integer): TtkTokenKind;
    function FuncAlert(Index: Integer): TtkTokenKind;
    function FuncAlign(Index: Integer): TtkTokenKind;
    function FuncAlinkcolor(Index: Integer): TtkTokenKind;
    function FuncAll(Index: Integer): TtkTokenKind;
    function FuncAnchor(Index: Integer): TtkTokenKind;
    function FuncAnchors(Index: Integer): TtkTokenKind;
    function FuncAppcodename(Index: Integer): TtkTokenKind;
    function FuncApplet(Index: Integer): TtkTokenKind;
    function FuncApplets(Index: Integer): TtkTokenKind;
    function FuncAppname(Index: Integer): TtkTokenKind;
    function FuncAppversion(Index: Integer): TtkTokenKind;
    function FuncArea(Index: Integer): TtkTokenKind;
    function FuncArguments(Index: Integer): TtkTokenKind;
    function FuncArray(Index: Integer): TtkTokenKind;
    function FuncAsin(Index: Integer): TtkTokenKind;
    function FuncAtan(Index: Integer): TtkTokenKind;
    function FuncAtan2(Index: Integer): TtkTokenKind;
    function FuncBack(Index: Integer): TtkTokenKind;
    function FuncBackground(Index: Integer): TtkTokenKind;
    function FuncBgcolor(Index: Integer): TtkTokenKind;
    function FuncBig(Index: Integer): TtkTokenKind;
    function FuncBlink(Index: Integer): TtkTokenKind;
    function FuncBlur(Index: Integer): TtkTokenKind;
    function FuncBody(Index: Integer): TtkTokenKind;
    function FuncBold(Index: Integer): TtkTokenKind;
    function FuncBoolean(Index: Integer): TtkTokenKind;
    function FuncBorder(Index: Integer): TtkTokenKind;
    function FuncBottom(Index: Integer): TtkTokenKind;
    function FuncBreak(Index: Integer): TtkTokenKind;
    function FuncButton(Index: Integer): TtkTokenKind;
    function FuncByte(Index: Integer): TtkTokenKind;
    function FuncCall(Index: Integer): TtkTokenKind;
    function FuncCallee(Index: Integer): TtkTokenKind;
    function FuncCaller(Index: Integer): TtkTokenKind;
    function FuncCaptureevents(Index: Integer): TtkTokenKind;
    function FuncCase(Index: Integer): TtkTokenKind;
    function FuncCatch(Index: Integer): TtkTokenKind;
    function FuncCeil(Index: Integer): TtkTokenKind;
    function FuncChar(Index: Integer): TtkTokenKind;
    function FuncCharat(Index: Integer): TtkTokenKind;
    function FuncCharcodeat(Index: Integer): TtkTokenKind;
    function FuncCheckbox(Index: Integer): TtkTokenKind;
    function FuncChecked(Index: Integer): TtkTokenKind;
    function FuncClass(Index: Integer): TtkTokenKind;
    function FuncClear(Index: Integer): TtkTokenKind;
    function FuncClearinterval(Index: Integer): TtkTokenKind;
    function FuncCleartimeout(Index: Integer): TtkTokenKind;
    function FuncClick(Index: Integer): TtkTokenKind;
    function FuncClose(Index: Integer): TtkTokenKind;
    function FuncClosed(Index: Integer): TtkTokenKind;
    function FuncColor(Index: Integer): TtkTokenKind;
    function FuncComplete(Index: Integer): TtkTokenKind;
    function FuncConcat(Index: Integer): TtkTokenKind;
    function FuncConfirm(Index: Integer): TtkTokenKind;
    function FuncConst(Index: Integer): TtkTokenKind;
    function FuncConstructor(Index: Integer): TtkTokenKind;
    function FuncContinue(Index: Integer): TtkTokenKind;
    function FuncCookie(Index: Integer): TtkTokenKind;
    function FuncCos(Index: Integer): TtkTokenKind;
    function FuncCurrent(Index: Integer): TtkTokenKind;
    function FuncDate(Index: Integer): TtkTokenKind;
    function FuncDebugger(Index: Integer): TtkTokenKind;
    function FuncDefault(Index: Integer): TtkTokenKind;
    function FuncDefaultchecked(Index: Integer): TtkTokenKind;
    function FuncDefaultselected(Index: Integer): TtkTokenKind;
    function FuncDefaultstatus(Index: Integer): TtkTokenKind;
    function FuncDefaultvalue(Index: Integer): TtkTokenKind;
    function FuncDelete(Index: Integer): TtkTokenKind;
    function FuncDescription(Index: Integer): TtkTokenKind;
    function FuncDisplay(Index: Integer): TtkTokenKind;
    function FuncDo(Index: Integer): TtkTokenKind;
    function FuncDocument(Index: Integer): TtkTokenKind;
    function FuncDomain(Index: Integer): TtkTokenKind;
    function FuncDouble(Index: Integer): TtkTokenKind;
    function FuncE(Index: Integer): TtkTokenKind;
    function FuncElements(Index: Integer): TtkTokenKind;
    function FuncElse(Index: Integer): TtkTokenKind;
    function FuncEmbed(Index: Integer): TtkTokenKind;
    function FuncEmbeds(Index: Integer): TtkTokenKind;
    function FuncEnabledplugin(Index: Integer): TtkTokenKind;
    function FuncEncoding(Index: Integer): TtkTokenKind;
    function FuncEnum(Index: Integer): TtkTokenKind;
    function FuncEscape(Index: Integer): TtkTokenKind;
    function FuncEval(Index: Integer): TtkTokenKind;
    function FuncEvent(Index: Integer): TtkTokenKind;
    function FuncExp(Index: Integer): TtkTokenKind;
    function FuncExport(Index: Integer): TtkTokenKind;
    function FuncExtends(Index: Integer): TtkTokenKind;
    function FuncFalse(Index: Integer): TtkTokenKind;
    function FuncFgcolor(Index: Integer): TtkTokenKind;
    function FuncFilename(Index: Integer): TtkTokenKind;
    function FuncFileupload(Index: Integer): TtkTokenKind;
    function FuncFinal(Index: Integer): TtkTokenKind;
    function FuncFinally(Index: Integer): TtkTokenKind;
    function FuncFind(Index: Integer): TtkTokenKind;
    function FuncFixed(Index: Integer): TtkTokenKind;
    function FuncFloat(Index: Integer): TtkTokenKind;
    function FuncFloor(Index: Integer): TtkTokenKind;
    function FuncFocus(Index: Integer): TtkTokenKind;
    function FuncFontcolor(Index: Integer): TtkTokenKind;
    function FuncFontsize(Index: Integer): TtkTokenKind;
    function FuncFor(Index: Integer): TtkTokenKind;
    function FuncForm(Index: Integer): TtkTokenKind;
    function FuncForms(Index: Integer): TtkTokenKind;
    function FuncForward(Index: Integer): TtkTokenKind;
    function FuncFrame(Index: Integer): TtkTokenKind;
    function FuncFrames(Index: Integer): TtkTokenKind;
    function FuncFromcharcode(Index: Integer): TtkTokenKind;
    function FuncFunction(Index: Integer): TtkTokenKind;
    function FuncGetdate(Index: Integer): TtkTokenKind;
    function FuncGetday(Index: Integer): TtkTokenKind;
    function FuncGetelementbyid(Index: Integer): TtkTokenKind;
    function FuncGetfullyear(Index: Integer): TtkTokenKind;
    function FuncGethours(Index: Integer): TtkTokenKind;
    function FuncGetmilliseconds(Index: Integer): TtkTokenKind;
    function FuncGetminutes(Index: Integer): TtkTokenKind;
    function FuncGetmonth(Index: Integer): TtkTokenKind;
    function FuncGetseconds(Index: Integer): TtkTokenKind;
    function FuncGettime(Index: Integer): TtkTokenKind;
    function FuncGettimezoneoffset(Index: Integer): TtkTokenKind;
    function FuncGetutcdate(Index: Integer): TtkTokenKind;
    function FuncGetutcday(Index: Integer): TtkTokenKind;
    function FuncGetutcfullyear(Index: Integer): TtkTokenKind;
    function FuncGetutchours(Index: Integer): TtkTokenKind;
    function FuncGetutcmilliseconds(Index: Integer): TtkTokenKind;
    function FuncGetutcminutes(Index: Integer): TtkTokenKind;
    function FuncGetutcmonth(Index: Integer): TtkTokenKind;
    function FuncGetutcseconds(Index: Integer): TtkTokenKind;
    function FuncGetyear(Index: Integer): TtkTokenKind;
    function FuncGlobal(Index: Integer): TtkTokenKind;
    function FuncGo(Index: Integer): TtkTokenKind;
    function FuncGoto(Index: Integer): TtkTokenKind;
    function FuncHandleevent(Index: Integer): TtkTokenKind;
    function FuncHash(Index: Integer): TtkTokenKind;
    function FuncHeight(Index: Integer): TtkTokenKind;
    function FuncHidden(Index: Integer): TtkTokenKind;
    function FuncHistory(Index: Integer): TtkTokenKind;
    function FuncHome(Index: Integer): TtkTokenKind;
    function FuncHost(Index: Integer): TtkTokenKind;
    function FuncHostname(Index: Integer): TtkTokenKind;
    function FuncHref(Index: Integer): TtkTokenKind;
    function FuncHspace(Index: Integer): TtkTokenKind;
    function FuncIf(Index: Integer): TtkTokenKind;
    function FuncImage(Index: Integer): TtkTokenKind;
    function FuncImages(Index: Integer): TtkTokenKind;
    function FuncImplements(Index: Integer): TtkTokenKind;
    function FuncImport(Index: Integer): TtkTokenKind;
    function FuncIn(Index: Integer): TtkTokenKind;
    function FuncIndex(Index: Integer): TtkTokenKind;
    function FuncIndexof(Index: Integer): TtkTokenKind;
    function FuncInfinity(Index: Integer): TtkTokenKind;
    function FuncInnerheight(Index: Integer): TtkTokenKind;
    function FuncInnerwidth(Index: Integer): TtkTokenKind;
    function FuncInput(Index: Integer): TtkTokenKind;
    function FuncInstanceof(Index: Integer): TtkTokenKind;
    function FuncInt(Index: Integer): TtkTokenKind;
    function FuncInterface(Index: Integer): TtkTokenKind;
    function FuncIsfinite(Index: Integer): TtkTokenKind;
    function FuncIsnan(Index: Integer): TtkTokenKind;
    function FuncItalics(Index: Integer): TtkTokenKind;
    function FuncJava(Index: Integer): TtkTokenKind;
    function FuncJavaenabled(Index: Integer): TtkTokenKind;
    function FuncJoin(Index: Integer): TtkTokenKind;
    function FuncLastindexof(Index: Integer): TtkTokenKind;
    function FuncLastmodified(Index: Integer): TtkTokenKind;
    function FuncLayer(Index: Integer): TtkTokenKind;
    function FuncLayers(Index: Integer): TtkTokenKind;
    function FuncLeft(Index: Integer): TtkTokenKind;
    function FuncLength(Index: Integer): TtkTokenKind;
    function FuncLink(Index: Integer): TtkTokenKind;
    function FuncLinkcolor(Index: Integer): TtkTokenKind;
    function FuncLinks(Index: Integer): TtkTokenKind;
    function FuncLn10(Index: Integer): TtkTokenKind;
    function FuncLn2(Index: Integer): TtkTokenKind;
    function FuncLocation(Index: Integer): TtkTokenKind;
    function FuncLocationbar(Index: Integer): TtkTokenKind;
    function FuncLog(Index: Integer): TtkTokenKind;
    function FuncLog10e(Index: Integer): TtkTokenKind;
    function FuncLog2e(Index: Integer): TtkTokenKind;
    function FuncLogon(Index: Integer): TtkTokenKind;
    function FuncLong(Index: Integer): TtkTokenKind;
    function FuncLowsrc(Index: Integer): TtkTokenKind;
    function FuncMatch(Index: Integer): TtkTokenKind;
    function FuncMath(Index: Integer): TtkTokenKind;
    function FuncMax(Index: Integer): TtkTokenKind;
    function FuncMax_value(Index: Integer): TtkTokenKind;
    function FuncMenubar(Index: Integer): TtkTokenKind;
    function FuncMethod(Index: Integer): TtkTokenKind;
    function FuncMimetype(Index: Integer): TtkTokenKind;
    function FuncMimetypes(Index: Integer): TtkTokenKind;
    function FuncMin(Index: Integer): TtkTokenKind;
    function FuncMin_value(Index: Integer): TtkTokenKind;
    function FuncMoveby(Index: Integer): TtkTokenKind;
    function FuncMoveto(Index: Integer): TtkTokenKind;
    function FuncName(Index: Integer): TtkTokenKind;
    function FuncNan(Index: Integer): TtkTokenKind;
    function FuncNative(Index: Integer): TtkTokenKind;
    function FuncNavigator(Index: Integer): TtkTokenKind;
    function FuncNegative_infinity(Index: Integer): TtkTokenKind;
    function FuncNetscape(Index: Integer): TtkTokenKind;
    function FuncNew(Index: Integer): TtkTokenKind;
    function FuncNext(Index: Integer): TtkTokenKind;
    function FuncNull(Index: Integer): TtkTokenKind;
    function FuncNumber(Index: Integer): TtkTokenKind;
    function FuncObject(Index: Integer): TtkTokenKind;
    function FuncOnabort(Index: Integer): TtkTokenKind;
    function FuncOnblur(Index: Integer): TtkTokenKind;
    function FuncOnchange(Index: Integer): TtkTokenKind;
    function FuncOnclick(Index: Integer): TtkTokenKind;
    function FuncOndblclick(Index: Integer): TtkTokenKind;
    function FuncOnerror(Index: Integer): TtkTokenKind;
    function FuncOnfocus(Index: Integer): TtkTokenKind;
    function FuncOnkeydown(Index: Integer): TtkTokenKind;
    function FuncOnkeypress(Index: Integer): TtkTokenKind;
    function FuncOnkeyup(Index: Integer): TtkTokenKind;
    function FuncOnload(Index: Integer): TtkTokenKind;
    function FuncOnmousedown(Index: Integer): TtkTokenKind;
    function FuncOnmousemove(Index: Integer): TtkTokenKind;
    function FuncOnmouseout(Index: Integer): TtkTokenKind;
    function FuncOnmouseover(Index: Integer): TtkTokenKind;
    function FuncOnmouseup(Index: Integer): TtkTokenKind;
    function FuncOnreset(Index: Integer): TtkTokenKind;
    function FuncOnselect(Index: Integer): TtkTokenKind;
    function FuncOnsubmit(Index: Integer): TtkTokenKind;
    function FuncOnunload(Index: Integer): TtkTokenKind;
    function FuncOpen(Index: Integer): TtkTokenKind;
    function FuncOpener(Index: Integer): TtkTokenKind;
    function FuncOption(Index: Integer): TtkTokenKind;
    function FuncOptions(Index: Integer): TtkTokenKind;
    function FuncOuterheight(Index: Integer): TtkTokenKind;
    function FuncOuterwidth(Index: Integer): TtkTokenKind;
    function FuncPackage(Index: Integer): TtkTokenKind;
    function FuncPackages(Index: Integer): TtkTokenKind;
    function FuncPagex(Index: Integer): TtkTokenKind;
    function FuncPagexoffset(Index: Integer): TtkTokenKind;
    function FuncPagey(Index: Integer): TtkTokenKind;
    function FuncPageyoffset(Index: Integer): TtkTokenKind;
    function FuncParent(Index: Integer): TtkTokenKind;
    function FuncParse(Index: Integer): TtkTokenKind;
    function FuncParsefloat(Index: Integer): TtkTokenKind;
    function FuncParseint(Index: Integer): TtkTokenKind;
    function FuncPassword(Index: Integer): TtkTokenKind;
    function FuncPathname(Index: Integer): TtkTokenKind;
    function FuncPersonalbar(Index: Integer): TtkTokenKind;
    function FuncPi(Index: Integer): TtkTokenKind;
    function FuncPlatform(Index: Integer): TtkTokenKind;
    function FuncPlugin(Index: Integer): TtkTokenKind;
    function FuncPlugins(Index: Integer): TtkTokenKind;
    function FuncPort(Index: Integer): TtkTokenKind;
    function FuncPositive_infinity(Index: Integer): TtkTokenKind;
    function FuncPow(Index: Integer): TtkTokenKind;
    function FuncPrevious(Index: Integer): TtkTokenKind;
    function FuncPrint(Index: Integer): TtkTokenKind;
    function FuncPrivate(Index: Integer): TtkTokenKind;
    function FuncPrompt(Index: Integer): TtkTokenKind;
    function FuncProtected(Index: Integer): TtkTokenKind;
    function FuncProtocol(Index: Integer): TtkTokenKind;
    function FuncPrototype(Index: Integer): TtkTokenKind;
    function FuncPublic(Index: Integer): TtkTokenKind;
    function FuncRadio(Index: Integer): TtkTokenKind;
    function FuncRandom(Index: Integer): TtkTokenKind;
    function FuncReferrer(Index: Integer): TtkTokenKind;
    function FuncRefresh(Index: Integer): TtkTokenKind;
    function FuncRegexp(Index: Integer): TtkTokenKind;
    function FuncReleaseevents(Index: Integer): TtkTokenKind;
    function FuncReload(Index: Integer): TtkTokenKind;
    function FuncReplace(Index: Integer): TtkTokenKind;
    function FuncReset(Index: Integer): TtkTokenKind;
    function FuncResizeby(Index: Integer): TtkTokenKind;
    function FuncResizeto(Index: Integer): TtkTokenKind;
    function FuncReturn(Index: Integer): TtkTokenKind;
    function FuncReverse(Index: Integer): TtkTokenKind;
    function FuncRight(Index: Integer): TtkTokenKind;
    function FuncRound(Index: Integer): TtkTokenKind;
    function FuncRouteevent(Index: Integer): TtkTokenKind;
    function FuncScreen(Index: Integer): TtkTokenKind;
    function FuncScroll(Index: Integer): TtkTokenKind;
    function FuncScrollbars(Index: Integer): TtkTokenKind;
    function FuncScrollby(Index: Integer): TtkTokenKind;
    function FuncScrollto(Index: Integer): TtkTokenKind;
    function FuncSearch(Index: Integer): TtkTokenKind;
    function FuncSelect(Index: Integer): TtkTokenKind;
    function FuncSelected(Index: Integer): TtkTokenKind;
    function FuncSelectedindex(Index: Integer): TtkTokenKind;
    function FuncSelf(Index: Integer): TtkTokenKind;
    function FuncSetdate(Index: Integer): TtkTokenKind;
    function FuncSetfullyear(Index: Integer): TtkTokenKind;
    function FuncSethours(Index: Integer): TtkTokenKind;
    function FuncSetinterval(Index: Integer): TtkTokenKind;
    function FuncSetmilliseconds(Index: Integer): TtkTokenKind;
    function FuncSetminutes(Index: Integer): TtkTokenKind;
    function FuncSetmonth(Index: Integer): TtkTokenKind;
    function FuncSetseconds(Index: Integer): TtkTokenKind;
    function FuncSettime(Index: Integer): TtkTokenKind;
    function FuncSettimeout(Index: Integer): TtkTokenKind;
    function FuncSetutcdate(Index: Integer): TtkTokenKind;
    function FuncSetutcfullyear(Index: Integer): TtkTokenKind;
    function FuncSetutchours(Index: Integer): TtkTokenKind;
    function FuncSetutcmilliseconds(Index: Integer): TtkTokenKind;
    function FuncSetutcminutes(Index: Integer): TtkTokenKind;
    function FuncSetutcmonth(Index: Integer): TtkTokenKind;
    function FuncSetutcseconds(Index: Integer): TtkTokenKind;
    function FuncSetyear(Index: Integer): TtkTokenKind;
    function FuncShort(Index: Integer): TtkTokenKind;
    function FuncSin(Index: Integer): TtkTokenKind;
    function FuncSlice(Index: Integer): TtkTokenKind;
    function FuncSmall(Index: Integer): TtkTokenKind;
    function FuncSort(Index: Integer): TtkTokenKind;
    function FuncSplit(Index: Integer): TtkTokenKind;
    function FuncSqrt(Index: Integer): TtkTokenKind;
    function FuncSqrt1_2(Index: Integer): TtkTokenKind;
    function FuncSqrt2(Index: Integer): TtkTokenKind;
    function FuncSrc(Index: Integer): TtkTokenKind;
    function FuncStart(Index: Integer): TtkTokenKind;
    function FuncStatic(Index: Integer): TtkTokenKind;
    function FuncStatus(Index: Integer): TtkTokenKind;
    function FuncStatusbar(Index: Integer): TtkTokenKind;
    function FuncStop(Index: Integer): TtkTokenKind;
    function FuncStrike(Index: Integer): TtkTokenKind;
    function FuncString(Index: Integer): TtkTokenKind;
    function FuncStyle(Index: Integer): TtkTokenKind;
    function FuncSub(Index: Integer): TtkTokenKind;
    function FuncSubmit(Index: Integer): TtkTokenKind;
    function FuncSubstr(Index: Integer): TtkTokenKind;
    function FuncSubstring(Index: Integer): TtkTokenKind;
    function FuncSuffixes(Index: Integer): TtkTokenKind;
    function FuncSup(Index: Integer): TtkTokenKind;
    function FuncSuper(Index: Integer): TtkTokenKind;
    function FuncSwitch(Index: Integer): TtkTokenKind;
    function FuncSynchronized(Index: Integer): TtkTokenKind;
    function FuncTags(Index: Integer): TtkTokenKind;
    function FuncTaint(Index: Integer): TtkTokenKind;
    function FuncTaintenabled(Index: Integer): TtkTokenKind;
    function FuncTan(Index: Integer): TtkTokenKind;
    function FuncTarget(Index: Integer): TtkTokenKind;
    function FuncText(Index: Integer): TtkTokenKind;
    function FuncTextarea(Index: Integer): TtkTokenKind;
    function FuncThis(Index: Integer): TtkTokenKind;
    function FuncThrow(Index: Integer): TtkTokenKind;
    function FuncThrows(Index: Integer): TtkTokenKind;
    function FuncTitle(Index: Integer): TtkTokenKind;
    function FuncTogmtstring(Index: Integer): TtkTokenKind;
    function FuncTolocalestring(Index: Integer): TtkTokenKind;
    function FuncTolowercase(Index: Integer): TtkTokenKind;
    function FuncToolbar(Index: Integer): TtkTokenKind;
    function FuncTop(Index: Integer): TtkTokenKind;
    function FuncTosource(Index: Integer): TtkTokenKind;
    function FuncTostring(Index: Integer): TtkTokenKind;
    function FuncTouppercase(Index: Integer): TtkTokenKind;
    function FuncToutcstring(Index: Integer): TtkTokenKind;
    function FuncTransient(Index: Integer): TtkTokenKind;
    function FuncTrue(Index: Integer): TtkTokenKind;
    function FuncTry(Index: Integer): TtkTokenKind;
    function FuncType(Index: Integer): TtkTokenKind;
    function FuncTypeof(Index: Integer): TtkTokenKind;
    function FuncUndefined(Index: Integer): TtkTokenKind;
    function FuncUnescape(Index: Integer): TtkTokenKind;
    function FuncUntaint(Index: Integer): TtkTokenKind;
    function FuncUnwatch(Index: Integer): TtkTokenKind;
    function FuncUrl(Index: Integer): TtkTokenKind;
    function FuncUseragent(Index: Integer): TtkTokenKind;
    function FuncUtc(Index: Integer): TtkTokenKind;
    function FuncValue(Index: Integer): TtkTokenKind;
    function FuncValueof(Index: Integer): TtkTokenKind;
    function FuncVar(Index: Integer): TtkTokenKind;
    function FuncVisibility(Index: Integer): TtkTokenKind;
    function FuncVlinkcolor(Index: Integer): TtkTokenKind;
    function FuncVoid(Index: Integer): TtkTokenKind;
    function FuncVspace(Index: Integer): TtkTokenKind;
    function FuncWatch(Index: Integer): TtkTokenKind;
    function FuncWhile(Index: Integer): TtkTokenKind;
    function FuncWidth(Index: Integer): TtkTokenKind;
    function FuncWindow(Index: Integer): TtkTokenKind;
    function FuncWith(Index: Integer): TtkTokenKind;
    function FuncWrite(Index: Integer): TtkTokenKind;
    function FuncWriteln(Index: Integer): TtkTokenKind;
    function FuncZindex(Index: Integer): TtkTokenKind;
    function HashKey(Str: PWideChar): Cardinal;
    function IdentKind(MayBe: PWideChar): TtkTokenKind;
    procedure InitIdent;
    procedure AndSymbolProc;
    procedure CommentProc;
    procedure CRProc;
    procedure IdentProc;
    procedure LFProc;
    procedure MinusProc;
    procedure ModSymbolProc;
    procedure NullProc;
    procedure NumberProc;
    procedure OrSymbolProc;
    procedure PlusProc;
    procedure PointProc;
    procedure SlashProc;
    procedure SpaceProc;
    procedure StarProc;
    procedure StringProc;
    procedure SymbolProc;
    procedure UnknownProc;
  protected
    function GetSampleSource: WideString; override;
    function IsFilterStored: Boolean; override;
  public
    class function GetLanguageName: string; override;
    class function GetFriendlyLanguageName: WideString; override;
  public
    constructor Create(AOwner: TComponent); override;
    function GetDefaultAttribute(Index: integer): TSynHighlighterAttributes;
      override;
    function GetEol: Boolean; override;
    function GetRange: Pointer; override;
    function GetTokenID: TtkTokenKind;
    function GetTokenAttribute: TSynHighlighterAttributes; override;
    function GetTokenKind: integer; override;
    procedure Next; override;
    procedure SetRange(Value: Pointer); override;
    procedure ResetRange; override;
  published
    property CommentAttri: TSynHighlighterAttributes read fCommentAttri
      write fCommentAttri;
    property IdentifierAttri: TSynHighlighterAttributes read fIdentifierAttri
      write fIdentifierAttri;
    property KeyAttri: TSynHighlighterAttributes read fKeyAttri write fKeyAttri;
    property NonReservedKeyAttri: TSynHighlighterAttributes read fNonReservedKeyAttri write fNonReservedKeyAttri;
    property EventAttri: TSynHighlighterAttributes read fEventAttri write fEventAttri;
    property NumberAttri: TSynHighlighterAttributes read fNumberAttri
      write fNumberAttri;
    property SpaceAttri: TSynHighlighterAttributes read fSpaceAttri
      write fSpaceAttri;
    property StringAttri: TSynHighlighterAttributes read fStringAttri
      write fStringAttri;
    property SymbolAttri: TSynHighlighterAttributes read fSymbolAttri
      write fSymbolAttri;
  end;

implementation

uses
{$IFDEF SYN_CLX}
  QSynEditStrConst;
{$ELSE}
  SynEditStrConst;
{$ENDIF}

const
  KeyWords: array[0..380] of WideString = (
    'abs', 'abstract', 'acos', 'action', 'alert', 'align', 'alinkColor', 'All', 
    'Anchor', 'anchors', 'appCodeName', 'Applet', 'applets', 'appName', 
    'appVersion', 'Area', 'Arguments', 'Array', 'asin', 'atan', 'atan2', 'back', 
    'background', 'bgColor', 'big', 'blink', 'blur', 'body', 'bold', 'Boolean', 
    'border', 'bottom', 'break', 'Button', 'byte', 'call', 'callee', 'caller', 
    'captureEvents', 'case', 'catch', 'ceil', 'char', 'charAt', 'charCodeAt',
    'Checkbox', 'checked', 'class', 'clear', 'clearInterval', 'clearTimeout', 
    'click', 'close', 'closed', 'color', 'complete', 'concat', 'confirm', 
    'const', 'constructor', 'continue', 'cookie', 'cos', 'current', 'Date', 
    'debugger', 'default', 'defaultChecked', 'defaultSelected', 'defaultStatus', 
    'defaultValue', 'delete', 'description', 'display', 'do', 'document', 
    'domain', 'double', 'E', 'elements', 'else', 'Embed', 'embeds', 
    'enabledPlugin', 'encoding', 'enum', 'escape', 'eval', 'event', 'exp', 
    'export', 'extends', 'false', 'fgColor', 'filename', 'FileUpload', 'final', 
    'finally', 'find', 'fixed', 'float', 'floor', 'focus', 'fontcolor', 
    'fontsize', 'for', 'Form', 'forms', 'forward', 'Frame', 'frames', 
    'fromCharCode', 'Function', 'getDate', 'getDay', 'getElementById', 
    'getFullYear', 'getHours', 'getMilliseconds', 'getMinutes', 'getMonth', 
    'getSeconds', 'getTime', 'getTimezoneOffset', 'getUTCDate', 'getUTCDay', 
    'getUTCFullYear', 'getUTCHours', 'getUTCMilliseconds', 'getUTCMinutes', 
    'getUTCMonth', 'getUTCSeconds', 'getYear', 'Global', 'go', 'goto', 
    'handleEvent', 'hash', 'height', 'Hidden', 'History', 'home', 'host', 
    'hostname', 'href', 'hspace', 'if', 'Image', 'images', 'implements', 
    'import', 'in', 'index', 'indexOf', 'Infinity', 'innerHeight', 'innerWidth', 
    'input', 'instanceof', 'int', 'interface', 'isFinite', 'isNaN', 'italics', 
    'java', 'javaEnabled', 'join', 'lastIndexOf', 'lastModified', 'Layer', 
    'layers', 'left', 'length', 'Link', 'linkColor', 'links', 'LN10', 'LN2', 
    'Location', 'locationbar', 'log', 'LOG10E', 'LOG2E', 'logon', 'long', 
    'lowsrc', 'match', 'Math', 'max', 'MAX_VALUE', 'menubar', 'method', 
    'MimeType', 'mimeTypes', 'min', 'MIN_VALUE', 'moveBy', 'moveTo', 'name', 
    'NaN', 'native', 'Navigator', 'NEGATIVE_INFINITY', 'netscape', 'new', 
    'next', 'Null', 'Number', 'Object', 'onAbort', 'onBlur', 'onChange', 
    'onClick', 'onDblClick', 'onError', 'onFocus', 'onKeyDown', 'onKeyPress', 
    'onKeyUp', 'onLoad', 'onMouseDown', 'onMouseMove', 'onMouseOut', 
    'onMouseOver', 'onMouseUp', 'onReset', 'onSelect', 'onSubmit', 'onUnload', 
    'open', 'opener', 'Option', 'options', 'outerHeight', 'outerWidth', 
    'package', 'Packages', 'pageX', 'pageXOffset', 'pageY', 'pageYOffset', 
    'parent', 'parse', 'parseFloat', 'parseInt', 'Password', 'pathname', 
    'personalbar', 'PI', 'platform', 'Plugin', 'plugins', 'port', 
    'POSITIVE_INFINITY', 'pow', 'previous', 'print', 'private', 'prompt', 
    'protected', 'protocol', 'prototype', 'public', 'Radio', 'random', 
    'referrer', 'refresh', 'RegExp', 'releaseEvents', 'reload', 'replace', 
    'reset', 'resizeBy', 'resizeTo', 'return', 'reverse', 'right', 'round', 
    'routeEvent', 'screen', 'scroll', 'scrollbars', 'scrollBy', 'scrollTo', 
    'search', 'Select', 'selected', 'selectedIndex', 'self', 'setDate', 
    'setFullYear', 'setHours', 'setInterval', 'setMilliseconds', 'setMinutes', 
    'setMonth', 'setSeconds', 'setTime', 'setTimeout', 'setUTCDate', 
    'setUTCFullYear', 'setUTCHours', 'setUTCMilliseconds', 'setUTCMinutes', 
    'setUTCMonth', 'setUTCSeconds', 'setYear', 'short', 'sin', 'slice', 'small', 
    'sort', 'split', 'sqrt', 'SQRT1_2', 'SQRT2', 'src', 'start', 'static', 
    'status', 'statusbar', 'stop', 'strike', 'String', 'style', 'sub', 'Submit', 
    'substr', 'substring', 'suffixes', 'sup', 'super', 'switch', 'synchronized', 
    'tags', 'taint', 'taintEnabled', 'tan', 'target', 'Text', 'Textarea', 
    'this', 'throw', 'throws', 'title', 'toGMTString', 'toLocaleString', 
    'toLowerCase', 'toolbar', 'top', 'toSource', 'toString', 'toUpperCase', 
    'toUTCString', 'transient', 'true', 'try', 'type', 'typeof', 'Undefined', 
    'unescape', 'untaint', 'unwatch', 'URL', 'userAgent', 'UTC', 'value', 
    'valueOf', 'var', 'visibility', 'vlinkColor', 'void', 'vspace', 'watch', 
    'while', 'width', 'Window', 'with', 'write', 'writeln', 'zIndex' 
  );

  KeyIndices: array[0..4252] of Integer = (
    105, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 271, 89, 309, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 258, -1, -1, -1, -1, 
    -1, 264, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, 191, -1, -1, 177, 72, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, 
    74, -1, -1, -1, -1, 148, -1, -1, -1, -1, -1, 253, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, 211, -1, -1, -1, -1, -1, 135, 341, -1, -1, -1, -1, 301, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 185, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 41, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, 112, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, 246, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 49, 339, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, 110, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, 281, -1, -1, -1, -1, -1, 9, -1, 131, 233, -1, -1, -1, 14, 
    255, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, 12, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, 243, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, 206, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, 331, -1, -1, -1, -1, -1, -1, -1, -1, -1, 93, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 325, 57, -1, -1, 
    376, -1, 189, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    35, -1, -1, -1, -1, -1, -1, 284, -1, -1, 372, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, 168, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, 36, -1, -1, -1, -1, 181, -1, -1, -1, -1, -1, 26, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 180, -1, -1, 
    -1, -1, -1, 142, -1, -1, -1, 165, -1, -1, 269, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, 132, -1, -1, -1, -1, -1, -1, -1, -1, -1, 333, -1, 
    -1, -1, -1, -1, -1, 375, -1, 22, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, 94, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 313, -1, -1, -1, -1, 
    -1, -1, -1, 38, 296, -1, -1, -1, -1, -1, -1, -1, 358, -1, -1, -1, -1, -1, 
    -1, 39, -1, 171, -1, -1, -1, -1, -1, -1, -1, 104, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 151, -1, -1, -1, -1, 
    -1, -1, -1, -1, 21, -1, -1, -1, 300, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, 308, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, 302, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    144, -1, -1, -1, -1, -1, 355, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, 90, -1, -1, -1, 2, -1, -1, -1, -1, -1, -1, -1, -1, 42, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 166, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 370, -1, -1, -1, -1, 368, -1, 
    -1, -1, -1, -1, 18, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 360, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, 199, -1, -1, -1, -1, -1, -1, 221, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 266, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, 205, -1, -1, -1, -1, -1, -1, -1, 299, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 314, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 96, 316, 
    -1, 43, -1, -1, -1, -1, -1, -1, 16, -1, -1, -1, -1, -1, -1, 256, -1, -1, -1, 
    -1, -1, -1, -1, -1, 128, -1, -1, -1, -1, -1, -1, -1, -1, 98, -1, -1, -1, -1, 
    -1, 354, 328, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 95, -1, 
    -1, -1, -1, -1, 51, -1, -1, 247, -1, -1, -1, -1, -1, -1, 356, -1, -1, -1, 
    -1, 251, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 157, -1, 289, -1, -1, -1, -1, 
    -1, -1, -1, 176, -1, -1, -1, 336, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    347, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 343, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 13, -1, -1, -1, -1, -1, 
    -1, -1, -1, 150, -1, -1, -1, -1, -1, -1, 245, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, 346, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, 46, -1, -1, -1, -1, -1, -1, -1, 250, -1, -1, -1, -1, -1, 
    334, -1, -1, -1, 59, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, 33, -1, -1, -1, -1, -1, -1, 278, -1, -1, -1, 80, -1, -1, 
    -1, -1, -1, -1, 143, -1, -1, -1, -1, 373, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, 340, -1, -1, 351, -1, -1, 293, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, 364, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, 76, -1, -1, -1, -1, -1, -1, -1, 209, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 78, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, 167, -1, -1, -1, -1, 152, 127, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, 141, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, 342, -1, -1, -1, -1, -1, 61, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, 324, -1, -1, -1, 224, -1, -1, -1, -1, 194, -1, -1, -1, 
    -1, -1, -1, 366, 85, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 257, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, 140, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, 367, -1, -1, -1, -1, -1, -1, -1, -1, -1, 28, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, 290, 195, -1, 371, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, 116, -1, -1, 362, 149, 88, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, 159, -1, -1, 297, -1, -1, 161, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, 65, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 345, -1, -1, 312, -1, -1, -1, -1, 
    -1, -1, 25, -1, -1, 229, -1, 295, -1, 212, -1, -1, -1, -1, -1, 126, -1, -1, 
    -1, -1, -1, -1, -1, -1, 117, -1, -1, -1, -1, 71, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, 119, -1, -1, -1, -1, -1, -1, -1, -1, 315, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, 86, -1, -1, -1, -1, -1, -1, -1, -1, 82, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    77, -1, -1, 111, -1, -1, -1, -1, -1, -1, -1, -1, -1, 169, -1, -1, -1, 216, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 357, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, 352, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, 84, -1, -1, -1, -1, -1, -1, -1, -1, 154, -1, 
    -1, -1, -1, -1, -1, 223, -1, -1, -1, 11, -1, 261, -1, -1, -1, -1, -1, 75, 
    -1, -1, -1, -1, -1, 68, -1, -1, -1, -1, -1, -1, 280, -1, 1, -1, -1, -1, 359, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, 286, -1, -1, -1, 283, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, 238, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, 107, -1, -1, -1, -1, -1, -1, -1, 137, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, 182, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, 17, 236, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, 275, -1, -1, 267, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, 186, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, 273, -1, -1, -1, -1, -1, -1, 29, -1, 30, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, 101, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, 114, -1, -1, -1, 187, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, 173, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    109, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 145, -1, 319, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 66, -1, -1, -1, 222, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, 23, 58, -1, -1, -1, -1, 303, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, 268, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 118, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    136, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, 91, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, 310, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, 0, -1, 231, -1, -1, -1, -1, -1, -1, -1, -1, -1, 121, -1, -1, 
    -1, -1, -1, -1, 282, -1, 274, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, 87, -1, -1, 54, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, 374, -1, -1, -1, -1, -1, -1, -1, 320, -1, -1, -1, -1, -1, -1, 
    -1, -1, 304, -1, -1, 27, 317, -1, -1, -1, -1, 235, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 242, -1, -1, -1, -1, 
    -1, -1, -1, -1, 202, 249, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, 113, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 252, 
    -1, -1, -1, -1, -1, -1, 153, -1, -1, 241, -1, -1, -1, -1, -1, -1, 272, -1, 
    44, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 179, -1, -1, -1, -1, -1, -1, -1, 
    -1, 226, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 69, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, 298, -1, -1, -1, -1, -1, 31, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, 200, -1, -1, -1, -1, 174, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, 50, 232, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 190, -1, 210, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, 108, -1, -1, -1, -1, -1, -1, -1, -1, 365, -1, 172, 
    -1, 20, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, 56, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, 146, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 378, 6, 
    -1, -1, -1, -1, -1, -1, 234, -1, -1, 100, -1, 170, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, 79, 292, -1, -1, -1, -1, 55, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 254, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, 305, -1, -1, -1, -1, -1, -1, -1, -1, -1, 337, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 380, 240, 244, -1, -1, -1, 
    348, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 83, 
    -1, -1, -1, -1, -1, -1, -1, -1, 285, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, 227, -1, -1, -1, -1, -1, -1, 198, -1, -1, -1, -1, -1, 
    -1, -1, -1, 276, 259, -1, -1, -1, -1, 175, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, 123, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, 379, -1, -1, 332, -1, -1, 122, -1, -1, -1, -1, -1, 
    19, -1, -1, 178, -1, -1, -1, -1, -1, -1, -1, 201, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 208, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 163, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    279, -1, -1, -1, -1, -1, -1, -1, -1, -1, 350, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, 207, -1, -1, -1, -1, -1, -1, 183, -1, -1, -1, 102, 
    -1, -1, -1, -1, -1, -1, -1, 15, -1, 106, -1, -1, -1, -1, -1, 217, 133, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 263, 97, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 138, -1, -1, -1, -1, -1, 
    349, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 125, -1, 326, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, 230, -1, -1, 64, -1, -1, 4, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, 260, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 73, 
    -1, -1, 32, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, 288, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, 353, -1, -1, -1, -1, -1, 53, -1, 335, -1, -1, -1, -1, -1, 
    270, -1, 306, -1, -1, 237, -1, 164, -1, -1, -1, 327, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, 184, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    219, -1, -1, -1, -1, 156, -1, -1, 160, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    63, -1, -1, -1, -1, -1, 287, -1, 248, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 318, -1, -1, -1, -1, -1, 155, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, 147, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 225, -1, 228, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, 192, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    291, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 188, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, 265, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    197, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 369, -1, 239, -1, -1, -1, -1, 
    48, -1, 311, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, 321, -1, -1, 7, -1, -1, -1, -1, -1, -1, 60, -1, -1, -1, 
    70, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 220, -1, -1, 262, -1, -1, -1, 
    -1, 322, -1, 130, -1, -1, -1, 203, -1, -1, -1, -1, -1, -1, -1, 361, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    67, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, 215, -1, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 338, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 214, -1, -1, 129, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, 47, -1, -1, -1, -1, -1, -1, -1, -1, 34, 24, -1, -1, -1, -1, 
    -1, -1, -1, -1, 193, -1, -1, -1, -1, -1, -1, -1, 363, -1, -1, -1, -1, -1, 
    -1, -1, 81, -1, -1, -1, -1, -1, -1, -1, 37, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, 134, -1, -1, -1, -1, -1, -1, -1, 52, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, 323, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 124, -1, -1, -1, -1, -1, 92, -1, 
    -1, -1, -1, -1, 139, -1, -1, -1, -1, -1, -1, -1, 45, -1, -1, -1, -1, -1, 
    218, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 120, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 99, -1, 
    -1, -1, 307, -1, -1, -1, -1, -1, 213, -1, 196, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 103, -1, -1, -1, 
    329, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 40, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, 330, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    162, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, 115, -1, 377, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 344, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 204, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, 277, 158, -1, -1, -1, -1, 294, -1, -1, -1, -1, -1, -1, -1, 
    -1 
  );

{$Q-}
function TSynJScriptSyn.HashKey(Str: PWideChar): Cardinal;
begin
  Result := 0;
  while IsIdentChar(Str^) do
  begin
    Result := Result * 727 + Ord(Str^) * 267;
    inc(Str);
  end;
  Result := Result mod 4253;
  fStringLen := Str - fToIdent;
end;
{$Q+}

function TSynJScriptSyn.IdentKind(MayBe: PWideChar): TtkTokenKind;
var
  Key: Cardinal;
begin
  fToIdent := MayBe;
  Key := HashKey(MayBe);
  if Key <= High(fIdentFuncTable) then
    Result := fIdentFuncTable[Key](KeyIndices[Key])
  else
    Result := tkIdentifier;
end;

procedure TSynJScriptSyn.InitIdent;
var
  i: Integer;
begin
  for i := Low(fIdentFuncTable) to High(fIdentFuncTable) do
    if KeyIndices[i] = -1 then
      fIdentFuncTable[i] := AltFunc;

  fIdentFuncTable[2376] := FuncAbs;
  fIdentFuncTable[1918] := FuncAbstract;
  fIdentFuncTable[814] := FuncAcos;
  fIdentFuncTable[596] := FuncAction;
  fIdentFuncTable[3336] := FuncAlert;
  fIdentFuncTable[3847] := FuncAlign;
  fIdentFuncTable[2799] := FuncAlinkcolor;
  fIdentFuncTable[3738] := FuncAll;
  fIdentFuncTable[3561] := FuncAnchor;
  fIdentFuncTable[272] := FuncAnchors;
  fIdentFuncTable[67] := FuncAppcodename;
  fIdentFuncTable[1895] := FuncApplet;
  fIdentFuncTable[304] := FuncApplets;
  fIdentFuncTable[1190] := FuncAppname;
  fIdentFuncTable[279] := FuncAppversion;
  fIdentFuncTable[3216] := FuncArea;
  fIdentFuncTable[1038] := FuncArguments;
  fIdentFuncTable[2036] := FuncArray;
  fIdentFuncTable[865] := FuncAsin;
  fIdentFuncTable[3041] := FuncAtan;
  fIdentFuncTable[2744] := FuncAtan2;
  fIdentFuncTable[677] := FuncBack;
  fIdentFuncTable[568] := FuncBackground;
  fIdentFuncTable[2244] := FuncBgcolor;
  fIdentFuncTable[3931] := FuncBig;
  fIdentFuncTable[1720] := FuncBlink;
  fIdentFuncTable[504] := FuncBlur;
  fIdentFuncTable[2451] := FuncBody;
  fIdentFuncTable[1624] := FuncBold;
  fIdentFuncTable[2121] := FuncBoolean;
  fIdentFuncTable[2123] := FuncBorder;
  fIdentFuncTable[2607] := FuncBottom;
  fIdentFuncTable[3361] := FuncBreak;
  fIdentFuncTable[1275] := FuncButton;
  fIdentFuncTable[3930] := FuncByte;
  fIdentFuncTable[450] := FuncCall;
  fIdentFuncTable[493] := FuncCallee;
  fIdentFuncTable[3964] := FuncCaller;
  fIdentFuncTable[621] := FuncCaptureevents;
  fIdentFuncTable[637] := FuncCase;
  fIdentFuncTable[4156] := FuncCatch;
  fIdentFuncTable[145] := FuncCeil;
  fIdentFuncTable[823] := FuncChar;
  fIdentFuncTable[1031] := FuncCharat;
  fIdentFuncTable[2537] := FuncCharcodeat;
  fIdentFuncTable[4061] := FuncCheckbox;
  fIdentFuncTable[1237] := FuncChecked;
  fIdentFuncTable[3921] := FuncClass;
  fIdentFuncTable[3711] := FuncClear;
  fIdentFuncTable[196] := FuncClearinterval;
  fIdentFuncTable[2634] := FuncCleartimeout;
  fIdentFuncTable[1090] := FuncClick;
  fIdentFuncTable[4001] := FuncClose;
  fIdentFuncTable[3426] := FuncClosed;
  fIdentFuncTable[2421] := FuncColor;
  fIdentFuncTable[2827] := FuncComplete;
  fIdentFuncTable[2771] := FuncConcat;
  fIdentFuncTable[429] := FuncConfirm;
  fIdentFuncTable[2245] := FuncConst;
  fIdentFuncTable[1255] := FuncConstructor;
  fIdentFuncTable[3745] := FuncContinue;
  fIdentFuncTable[1468] := FuncCookie;
  fIdentFuncTable[664] := FuncCos;
  fIdentFuncTable[3488] := FuncCurrent;
  fIdentFuncTable[3333] := FuncDate;
  fIdentFuncTable[1687] := FuncDebugger;
  fIdentFuncTable[2212] := FuncDefault;
  fIdentFuncTable[3823] := FuncDefaultchecked;
  fIdentFuncTable[1909] := FuncDefaultselected;
  fIdentFuncTable[2588] := FuncDefaultstatus;
  fIdentFuncTable[3749] := FuncDefaultvalue;
  fIdentFuncTable[1747] := FuncDelete;
  fIdentFuncTable[61] := FuncDescription;
  fIdentFuncTable[3358] := FuncDisplay;
  fIdentFuncTable[74] := FuncDo;
  fIdentFuncTable[1903] := FuncDocument;
  fIdentFuncTable[1384] := FuncDomain;
  fIdentFuncTable[1811] := FuncDouble;
  fIdentFuncTable[1411] := FuncE;
  fIdentFuncTable[2821] := FuncElements;
  fIdentFuncTable[1286] := FuncElse;
  fIdentFuncTable[3956] := FuncEmbed;
  fIdentFuncTable[1786] := FuncEmbeds;
  fIdentFuncTable[2929] := FuncEnabledplugin;
  fIdentFuncTable[1875] := FuncEncoding;
  fIdentFuncTable[1517] := FuncEnum;
  fIdentFuncTable[1777] := FuncEscape;
  fIdentFuncTable[2418] := FuncEval;
  fIdentFuncTable[1654] := FuncEvent;
  fIdentFuncTable[14] := FuncExp;
  fIdentFuncTable[810] := FuncExport;
  fIdentFuncTable[2324] := FuncExtends;
  fIdentFuncTable[4047] := FuncFalse;
  fIdentFuncTable[371] := FuncFgcolor;
  fIdentFuncTable[583] := FuncFilename;
  fIdentFuncTable[1084] := FuncFileupload;
  fIdentFuncTable[1028] := FuncFinal;
  fIdentFuncTable[3242] := FuncFinally;
  fIdentFuncTable[1063] := FuncFind;
  fIdentFuncTable[4102] := FuncFixed;
  fIdentFuncTable[2809] := FuncFloat;
  fIdentFuncTable[2134] := FuncFloor;
  fIdentFuncTable[3208] := FuncFocus;
  fIdentFuncTable[4137] := FuncFontcolor;
  fIdentFuncTable[647] := FuncFontsize;
  fIdentFuncTable[0] := FuncFor;
  fIdentFuncTable[3218] := FuncForm;
  fIdentFuncTable[2004] := FuncForms;
  fIdentFuncTable[2731] := FuncForward;
  fIdentFuncTable[2184] := FuncFrame;
  fIdentFuncTable[251] := FuncFrames;
  fIdentFuncTable[1814] := FuncFromcharcode;
  fIdentFuncTable[156] := FuncFunction;
  fIdentFuncTable[2502] := FuncGetdate;
  fIdentFuncTable[2154] := FuncGetday;
  fIdentFuncTable[4199] := FuncGetelementbyid;
  fIdentFuncTable[1649] := FuncGetfullyear;
  fIdentFuncTable[1742] := FuncGethours;
  fIdentFuncTable[2274] := FuncGetmilliseconds;
  fIdentFuncTable[1757] := FuncGetminutes;
  fIdentFuncTable[4083] := FuncGetmonth;
  fIdentFuncTable[2388] := FuncGetseconds;
  fIdentFuncTable[3035] := FuncGettime;
  fIdentFuncTable[2990] := FuncGettimezoneoffset;
  fIdentFuncTable[4041] := FuncGetutcdate;
  fIdentFuncTable[3314] := FuncGetutcday;
  fIdentFuncTable[1733] := FuncGetutcfullyear;
  fIdentFuncTable[1429] := FuncGetutchours;
  fIdentFuncTable[1054] := FuncGetutcmilliseconds;
  fIdentFuncTable[3896] := FuncGetutcminutes;
  fIdentFuncTable[3770] := FuncGetutcmonth;
  fIdentFuncTable[274] := FuncGetutcseconds;
  fIdentFuncTable[549] := FuncGetyear;
  fIdentFuncTable[3225] := FuncGlobal;
  fIdentFuncTable[3993] := FuncGo;
  fIdentFuncTable[101] := FuncGoto;
  fIdentFuncTable[2296] := FuncHandleevent;
  fIdentFuncTable[2012] := FuncHash;
  fIdentFuncTable[3278] := FuncHeight;
  fIdentFuncTable[4053] := FuncHidden;
  fIdentFuncTable[1596] := FuncHistory;
  fIdentFuncTable[1444] := FuncHome;
  fIdentFuncTable[528] := FuncHost;
  fIdentFuncTable[1293] := FuncHostname;
  fIdentFuncTable[787] := FuncHref;
  fIdentFuncTable[2197] := FuncHspace;
  fIdentFuncTable[2785] := FuncIf;
  fIdentFuncTable[3583] := FuncImage;
  fIdentFuncTable[79] := FuncImages;
  fIdentFuncTable[1653] := FuncImplements;
  fIdentFuncTable[1199] := FuncImport;
  fIdentFuncTable[668] := FuncIn;
  fIdentFuncTable[1428] := FuncIndex;
  fIdentFuncTable[2525] := FuncIndexof;
  fIdentFuncTable[1884] := FuncInfinity;
  fIdentFuncTable[3522] := FuncInnerheight;
  fIdentFuncTable[3475] := FuncInnerwidth;
  fIdentFuncTable[1134] := FuncInput;
  fIdentFuncTable[4239] := FuncInstanceof;
  fIdentFuncTable[1666] := FuncInt;
  fIdentFuncTable[3478] := FuncInterface;
  fIdentFuncTable[1672] := FuncIsfinite;
  fIdentFuncTable[4178] := FuncIsnan;
  fIdentFuncTable[3113] := FuncItalics;
  fIdentFuncTable[3441] := FuncJava;
  fIdentFuncTable[532] := FuncJavaenabled;
  fIdentFuncTable[836] := FuncJoin;
  fIdentFuncTable[1423] := FuncLastindexof;
  fIdentFuncTable[470] := FuncLastmodified;
  fIdentFuncTable[1824] := FuncLayer;
  fIdentFuncTable[2811] := FuncLayers;
  fIdentFuncTable[639] := FuncLeft;
  fIdentFuncTable[2742] := FuncLength;
  fIdentFuncTable[2170] := FuncLink;
  fIdentFuncTable[2624] := FuncLinkcolor;
  fIdentFuncTable[2976] := FuncLinks;
  fIdentFuncTable[1144] := FuncLn10;
  fIdentFuncTable[60] := FuncLn2;
  fIdentFuncTable[3044] := FuncLocation;
  fIdentFuncTable[2567] := FuncLocationbar;
  fIdentFuncTable[522] := FuncLog;
  fIdentFuncTable[498] := FuncLog10e;
  fIdentFuncTable[2022] := FuncLog2e;
  fIdentFuncTable[3204] := FuncLogon;
  fIdentFuncTable[3460] := FuncLong;
  fIdentFuncTable[126] := FuncLowsrc;
  fIdentFuncTable[2073] := FuncMatch;
  fIdentFuncTable[2158] := FuncMath;
  fIdentFuncTable[3652] := FuncMax;
  fIdentFuncTable[434] := FuncMax_value;
  fIdentFuncTable[2701] := FuncMenubar;
  fIdentFuncTable[57] := FuncMethod;
  fIdentFuncTable[3607] := FuncMimetype;
  fIdentFuncTable[3940] := FuncMimetypes;
  fIdentFuncTable[1509] := FuncMin;
  fIdentFuncTable[1636] := FuncMin_value;
  fIdentFuncTable[4114] := FuncMoveby;
  fIdentFuncTable[3693] := FuncMoveto;
  fIdentFuncTable[2961] := FuncName;
  fIdentFuncTable[903] := FuncNan;
  fIdentFuncTable[2619] := FuncNative;
  fIdentFuncTable[3052] := FuncNavigator;
  fIdentFuncTable[2487] := FuncNegative_infinity;
  fIdentFuncTable[3774] := FuncNetscape;
  fIdentFuncTable[4225] := FuncNew;
  fIdentFuncTable[959] := FuncNext;
  fIdentFuncTable[341] := FuncNull;
  fIdentFuncTable[3197] := FuncNumber;
  fIdentFuncTable[3077] := FuncObject;
  fIdentFuncTable[1392] := FuncOnabort;
  fIdentFuncTable[2703] := FuncOnblur;
  fIdentFuncTable[95] := FuncOnchange;
  fIdentFuncTable[1727] := FuncOnclick;
  fIdentFuncTable[4112] := FuncOndblclick;
  fIdentFuncTable[3893] := FuncOnerror;
  fIdentFuncTable[3845] := FuncOnfocus;
  fIdentFuncTable[1828] := FuncOnkeydown;
  fIdentFuncTable[3224] := FuncOnkeypress;
  fIdentFuncTable[4067] := FuncOnkeyup;
  fIdentFuncTable[3470] := FuncOnload;
  fIdentFuncTable[3760] := FuncOnmousedown;
  fIdentFuncTable[910] := FuncOnmousemove;
  fIdentFuncTable[2216] := FuncOnmouseout;
  fIdentFuncTable[1891] := FuncOnmouseover;
  fIdentFuncTable[1504] := FuncOnmouseup;
  fIdentFuncTable[3595] := FuncOnreset;
  fIdentFuncTable[2576] := FuncOnselect;
  fIdentFuncTable[2954] := FuncOnsubmit;
  fIdentFuncTable[3597] := FuncOnunload;
  fIdentFuncTable[1723] := FuncOpen;
  fIdentFuncTable[3330] := FuncOpener;
  fIdentFuncTable[2378] := FuncOption;
  fIdentFuncTable[2635] := FuncOptions;
  fIdentFuncTable[275] := FuncOuterheight;
  fIdentFuncTable[2806] := FuncOuterwidth;
  fIdentFuncTable[2457] := FuncPackage;
  fIdentFuncTable[2037] := FuncPackages;
  fIdentFuncTable[3439] := FuncPagex;
  fIdentFuncTable[1984] := FuncPagexoffset;
  fIdentFuncTable[3706] := FuncPagey;
  fIdentFuncTable[2906] := FuncPageyoffset;
  fIdentFuncTable[2528] := FuncParent;
  fIdentFuncTable[2478] := FuncParse;
  fIdentFuncTable[321] := FuncParsefloat;
  fIdentFuncTable[2907] := FuncParseint;
  fIdentFuncTable[1206] := FuncPassword;
  fIdentFuncTable[168] := FuncPathname;
  fIdentFuncTable[1093] := FuncPersonalbar;
  fIdentFuncTable[3496] := FuncPi;
  fIdentFuncTable[2488] := FuncPlatform;
  fIdentFuncTable[1245] := FuncPlugin;
  fIdentFuncTable[1105] := FuncPlugins;
  fIdentFuncTable[2518] := FuncPort;
  fIdentFuncTable[85] := FuncPositive_infinity;
  fIdentFuncTable[2847] := FuncPow;
  fIdentFuncTable[280] := FuncPrevious;
  fIdentFuncTable[1045] := FuncPrint;
  fIdentFuncTable[1586] := FuncPrivate;
  fIdentFuncTable[32] := FuncPrompt;
  fIdentFuncTable[2971] := FuncProtected;
  fIdentFuncTable[3346] := FuncProtocol;
  fIdentFuncTable[1897] := FuncPrototype;
  fIdentFuncTable[3763] := FuncPublic;
  fIdentFuncTable[3241] := FuncRadio;
  fIdentFuncTable[38] := FuncRandom;
  fIdentFuncTable[3675] := FuncReferrer;
  fIdentFuncTable[946] := FuncRefresh;
  fIdentFuncTable[2063] := FuncRegexp;
  fIdentFuncTable[2262] := FuncReleaseevents;
  fIdentFuncTable[535] := FuncReload;
  fIdentFuncTable[3434] := FuncReplace;
  fIdentFuncTable[13] := FuncReset;
  fIdentFuncTable[2535] := FuncResizeby;
  fIdentFuncTable[2114] := FuncResizeto;
  fIdentFuncTable[2397] := FuncReturn;
  fIdentFuncTable[2060] := FuncReverse;
  fIdentFuncTable[2970] := FuncRight;
  fIdentFuncTable[4238] := FuncRound;
  fIdentFuncTable[1282] := FuncRouteevent;
  fIdentFuncTable[3135] := FuncScreen;
  fIdentFuncTable[1916] := FuncScroll;
  fIdentFuncTable[266] := FuncScrollbars;
  fIdentFuncTable[2395] := FuncScrollby;
  fIdentFuncTable[1974] := FuncScrollto;
  fIdentFuncTable[457] := FuncSearch;
  fIdentFuncTable[2938] := FuncSelect;
  fIdentFuncTable[1970] := FuncSelected;
  fIdentFuncTable[3494] := FuncSelectedindex;
  fIdentFuncTable[3384] := FuncSelf;
  fIdentFuncTable[1136] := FuncSetdate;
  fIdentFuncTable[1635] := FuncSetfullyear;
  fIdentFuncTable[3637] := FuncSethours;
  fIdentFuncTable[2822] := FuncSetinterval;
  fIdentFuncTable[1357] := FuncSetmilliseconds;
  fIdentFuncTable[4244] := FuncSetminutes;
  fIdentFuncTable[1725] := FuncSetmonth;
  fIdentFuncTable[622] := FuncSetseconds;
  fIdentFuncTable[1669] := FuncSettime;
  fIdentFuncTable[2601] := FuncSettimeout;
  fIdentFuncTable[967] := FuncSetutcdate;
  fIdentFuncTable[681] := FuncSetutcfullyear;
  fIdentFuncTable[107] := FuncSetutchours;
  fIdentFuncTable[770] := FuncSetutcmilliseconds;
  fIdentFuncTable[2250] := FuncSetutcminutes;
  fIdentFuncTable[2448] := FuncSetutcmonth;
  fIdentFuncTable[2881] := FuncSetutcseconds;
  fIdentFuncTable[3436] := FuncSetyear;
  fIdentFuncTable[4106] := FuncShort;
  fIdentFuncTable[715] := FuncSin;
  fIdentFuncTable[15] := FuncSlice;
  fIdentFuncTable[2339] := FuncSmall;
  fIdentFuncTable[3713] := FuncSort;
  fIdentFuncTable[1713] := FuncSplit;
  fIdentFuncTable[613] := FuncSqrt;
  fIdentFuncTable[1004] := FuncSqrt1_2;
  fIdentFuncTable[1766] := FuncSqrt2;
  fIdentFuncTable[1029] := FuncSrc;
  fIdentFuncTable[2452] := FuncStart;
  fIdentFuncTable[3516] := FuncStatic;
  fIdentFuncTable[2199] := FuncStatus;
  fIdentFuncTable[2439] := FuncStatusbar;
  fIdentFuncTable[3735] := FuncStop;
  fIdentFuncTable[3768] := FuncStrike;
  fIdentFuncTable[4012] := FuncString;
  fIdentFuncTable[1500] := FuncStyle;
  fIdentFuncTable[428] := FuncSub;
  fIdentFuncTable[3316] := FuncSubmit;
  fIdentFuncTable[3445] := FuncSubstr;
  fIdentFuncTable[1070] := FuncSubstring;
  fIdentFuncTable[4141] := FuncSuffixes;
  fIdentFuncTable[4166] := FuncSup;
  fIdentFuncTable[361] := FuncSuper;
  fIdentFuncTable[3032] := FuncSwitch;
  fIdentFuncTable[559] := FuncSynchronized;
  fIdentFuncTable[1251] := FuncTags;
  fIdentFuncTable[3428] := FuncTaint;
  fIdentFuncTable[1148] := FuncTaintenabled;
  fIdentFuncTable[2891] := FuncTan;
  fIdentFuncTable[3860] := FuncTarget;
  fIdentFuncTable[197] := FuncText;
  fIdentFuncTable[1351] := FuncTextarea;
  fIdentFuncTable[102] := FuncThis;
  fIdentFuncTable[1462] := FuncThrow;
  fIdentFuncTable[1176] := FuncThrows;
  fIdentFuncTable[4212] := FuncTitle;
  fIdentFuncTable[1710] := FuncTogmtstring;
  fIdentFuncTable[1220] := FuncTolocalestring;
  fIdentFuncTable[1159] := FuncTolowercase;
  fIdentFuncTable[2911] := FuncToolbar;
  fIdentFuncTable[3284] := FuncTop;
  fIdentFuncTable[3145] := FuncTosource;
  fIdentFuncTable[1354] := FuncTostring;
  fIdentFuncTable[1852] := FuncTouppercase;
  fIdentFuncTable[3420] := FuncToutcstring;
  fIdentFuncTable[1069] := FuncTransient;
  fIdentFuncTable[793] := FuncTrue;
  fIdentFuncTable[1100] := FuncTry;
  fIdentFuncTable[1841] := FuncType;
  fIdentFuncTable[630] := FuncTypeof;
  fIdentFuncTable[1922] := FuncUndefined;
  fIdentFuncTable[890] := FuncUnescape;
  fIdentFuncTable[3782] := FuncUntaint;
  fIdentFuncTable[1652] := FuncUnwatch;
  fIdentFuncTable[3948] := FuncUrl;
  fIdentFuncTable[1367] := FuncUseragent;
  fIdentFuncTable[2740] := FuncUtc;
  fIdentFuncTable[1516] := FuncValue;
  fIdentFuncTable[1614] := FuncValueof;
  fIdentFuncTable[859] := FuncVar;
  fIdentFuncTable[3704] := FuncVisibility;
  fIdentFuncTable[854] := FuncVlinkcolor;
  fIdentFuncTable[1638] := FuncVoid;
  fIdentFuncTable[460] := FuncVspace;
  fIdentFuncTable[1298] := FuncWatch;
  fIdentFuncTable[2431] := FuncWhile;
  fIdentFuncTable[566] := FuncWidth;
  fIdentFuncTable[432] := FuncWindow;
  fIdentFuncTable[4201] := FuncWith;
  fIdentFuncTable[2798] := FuncWrite;
  fIdentFuncTable[3029] := FuncWriteln;
  fIdentFuncTable[2905] := FuncZindex;
end;

function TSynJScriptSyn.AltFunc(Index: Integer): TtkTokenKind;
begin
  Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncAbs(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncAbstract(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncAcos(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncAction(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncAlert(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncAlign(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncAlinkcolor(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncAll(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncAnchor(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncAnchors(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncAppcodename(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncApplet(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncApplets(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncAppname(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncAppversion(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncArea(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncArguments(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncArray(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncAsin(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncAtan(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncAtan2(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncBack(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncBackground(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncBgcolor(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncBig(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncBlink(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncBlur(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncBody(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncBold(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncBoolean(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncBorder(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncBottom(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncBreak(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncButton(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncByte(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncCall(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncCallee(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncCaller(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncCaptureevents(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncCase(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncCatch(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncCeil(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncChar(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncCharat(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncCharcodeat(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncCheckbox(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncChecked(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncClass(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncClear(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncClearinterval(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncCleartimeout(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncClick(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncClose(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncClosed(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncColor(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncComplete(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncConcat(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncConfirm(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncConst(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncConstructor(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncContinue(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncCookie(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncCos(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncCurrent(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncDate(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncDebugger(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncDefault(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncDefaultchecked(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncDefaultselected(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncDefaultstatus(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncDefaultvalue(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncDelete(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncDescription(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncDisplay(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncDo(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncDocument(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncDomain(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncDouble(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncE(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncElements(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncElse(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncEmbed(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncEmbeds(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncEnabledplugin(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncEncoding(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncEnum(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncEscape(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncEval(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncEvent(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncExp(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncExport(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncExtends(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncFalse(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncFgcolor(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncFilename(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncFileupload(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncFinal(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncFinally(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncFind(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncFixed(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncFloat(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncFloor(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncFocus(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncFontcolor(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncFontsize(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncFor(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncForm(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncForms(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncForward(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncFrame(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncFrames(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncFromcharcode(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncFunction(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncGetdate(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncGetday(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncGetelementbyid(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncGetfullyear(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncGethours(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncGetmilliseconds(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncGetminutes(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncGetmonth(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncGetseconds(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncGettime(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncGettimezoneoffset(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncGetutcdate(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncGetutcday(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncGetutcfullyear(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncGetutchours(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncGetutcmilliseconds(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncGetutcminutes(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncGetutcmonth(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncGetutcseconds(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncGetyear(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncGlobal(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncGo(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncGoto(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncHandleevent(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncHash(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncHeight(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncHidden(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncHistory(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncHome(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncHost(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncHostname(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncHref(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncHspace(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncIf(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncImage(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncImages(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncImplements(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncImport(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncIn(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncIndex(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncIndexof(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncInfinity(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncInnerheight(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncInnerwidth(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncInput(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncInstanceof(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncInt(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncInterface(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncIsfinite(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncIsnan(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncItalics(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncJava(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncJavaenabled(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncJoin(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncLastindexof(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncLastmodified(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncLayer(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncLayers(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncLeft(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncLength(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncLink(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncLinkcolor(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncLinks(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncLn10(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncLn2(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncLocation(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncLocationbar(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncLog(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncLog10e(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncLog2e(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncLogon(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncLong(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncLowsrc(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncMatch(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncMath(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncMax(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncMax_value(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncMenubar(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncMethod(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncMimetype(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncMimetypes(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncMin(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncMin_value(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncMoveby(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncMoveto(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncName(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncNan(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncNative(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncNavigator(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncNegative_infinity(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncNetscape(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncNew(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncNext(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncNull(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncNumber(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncObject(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncOnabort(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkEvent
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncOnblur(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkEvent
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncOnchange(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkEvent
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncOnclick(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkEvent
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncOndblclick(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkEvent
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncOnerror(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkEvent
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncOnfocus(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkEvent
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncOnkeydown(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkEvent
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncOnkeypress(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkEvent
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncOnkeyup(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkEvent
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncOnload(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkEvent
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncOnmousedown(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkEvent
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncOnmousemove(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkEvent
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncOnmouseout(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkEvent
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncOnmouseover(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkEvent
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncOnmouseup(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkEvent
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncOnreset(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkEvent
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncOnselect(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkEvent
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncOnsubmit(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkEvent
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncOnunload(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkEvent
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncOpen(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncOpener(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncOption(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncOptions(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncOuterheight(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncOuterwidth(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncPackage(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncPackages(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncPagex(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncPagexoffset(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncPagey(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncPageyoffset(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncParent(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncParse(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncParsefloat(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncParseint(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncPassword(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncPathname(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncPersonalbar(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncPi(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncPlatform(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncPlugin(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncPlugins(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncPort(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncPositive_infinity(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncPow(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncPrevious(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncPrint(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncPrivate(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncPrompt(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncProtected(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncProtocol(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncPrototype(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncPublic(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncRadio(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncRandom(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncReferrer(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncRefresh(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncRegexp(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncReleaseevents(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncReload(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncReplace(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncReset(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncResizeby(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncResizeto(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncReturn(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncReverse(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncRight(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncRound(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncRouteevent(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncScreen(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncScroll(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncScrollbars(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncScrollby(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncScrollto(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSearch(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSelect(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSelected(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSelectedindex(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSelf(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSetdate(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSetfullyear(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSethours(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSetinterval(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSetmilliseconds(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSetminutes(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSetmonth(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSetseconds(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSettime(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSettimeout(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSetutcdate(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSetutcfullyear(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSetutchours(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSetutcmilliseconds(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSetutcminutes(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSetutcmonth(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSetutcseconds(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSetyear(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncShort(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSin(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSlice(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSmall(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSort(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSplit(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSqrt(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSqrt1_2(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSqrt2(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSrc(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncStart(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncStatic(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncStatus(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncStatusbar(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncStop(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncStrike(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncString(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncStyle(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSub(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSubmit(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSubstr(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSubstring(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSuffixes(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSup(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSuper(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSwitch(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncSynchronized(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncTags(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncTaint(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncTaintenabled(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncTan(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncTarget(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncText(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncTextarea(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncThis(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncThrow(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncThrows(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncTitle(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncTogmtstring(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncTolocalestring(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncTolowercase(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncToolbar(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncTop(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncTosource(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncTostring(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncTouppercase(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncToutcstring(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncTransient(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncTrue(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncTry(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncType(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncTypeof(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncUndefined(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncUnescape(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncUntaint(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncUnwatch(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncUrl(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncUseragent(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncUtc(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncValue(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncValueof(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncVar(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncVisibility(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncVlinkcolor(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncVoid(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncVspace(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncWatch(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncWhile(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncWidth(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncWindow(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncWith(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncWrite(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncWriteln(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

function TSynJScriptSyn.FuncZindex(Index: Integer): TtkTokenKind;
begin
  if IsCurrentToken(KeyWords[Index]) then
    Result := tkNonReservedKey
  else
    Result := tkIdentifier;
end;

constructor TSynJScriptSyn.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);

  fCaseSensitive := True;

  fCommentAttri := TSynHighlighterAttributes.Create(SYNS_AttrComment, SYNS_FriendlyAttrComment);
  fCommentAttri.Style := [fsItalic];
  AddAttribute(fCommentAttri);
  fIdentifierAttri := TSynHighlighterAttributes.Create(SYNS_AttrIdentifier, SYNS_FriendlyAttrIdentifier);
  AddAttribute(fIdentifierAttri);
  fKeyAttri := TSynHighlighterAttributes.Create(SYNS_AttrReservedWord, SYNS_FriendlyAttrReservedWord);
  fKeyAttri.Style := [fsBold];
  AddAttribute(fKeyAttri);
  fNonReservedKeyAttri := TSynHighlighterAttributes.Create(SYNS_AttrNonReservedKeyword, SYNS_FriendlyAttrNonReservedKeyword);
  AddAttribute(fNonReservedKeyAttri);
  fEventAttri := TSynHighlighterAttributes.Create(SYNS_AttrEvent, SYNS_FriendlyAttrEvent);
  AddAttribute(fEventAttri);
  fNumberAttri := TSynHighlighterAttributes.Create(SYNS_AttrNumber, SYNS_FriendlyAttrNumber);
  AddAttribute(fNumberAttri);
  fSpaceAttri := TSynHighlighterAttributes.Create(SYNS_AttrSpace, SYNS_FriendlyAttrSpace);
  AddAttribute(fSpaceAttri);
  fStringAttri := TSynHighlighterAttributes.Create(SYNS_AttrString, SYNS_FriendlyAttrString);
  AddAttribute(fStringAttri);
  fSymbolAttri := TSynHighlighterAttributes.Create(SYNS_AttrSymbol, SYNS_FriendlyAttrSymbol);
  AddAttribute(fSymbolAttri);
  SetAttributesOnChange(DefHighlightChange);
  InitIdent;
  fDefaultFilter := SYNS_FilterJScript;
  fRange := rsUnknown;
end;

procedure TSynJScriptSyn.AndSymbolProc;
begin
  fTokenID := tkSymbol;
  inc(Run);
  if fLine[Run] in [WideChar('='), WideChar('&')] then inc(Run);
end;

procedure TSynJScriptSyn.CommentProc;
begin
  if fLine[Run] = #0 then
    fTokenID := tkNull
  else begin
    fTokenID := tkComment;
    repeat
      if (fLine[Run] = '*') and (fLine[Run + 1] = '/') then begin
        fRange := rsUnKnown;
        inc(Run, 2);
        break;
      end;
      inc(Run);
    until IsLineEnd(fLine[Run]);
  end;
end;

procedure TSynJScriptSyn.CRProc;
begin
  fTokenID := tkSpace;
  inc(Run);
  if fLine[Run] = #10 then inc(Run);
end;

procedure TSynJScriptSyn.IdentProc;
begin
  fTokenID := IdentKind((fLine + Run));
  inc(Run, fStringLen);
  while IsIdentChar(fLine[Run]) do inc(Run);
end;

procedure TSynJScriptSyn.LFProc;
begin
  fTokenID := tkSpace;
  inc(Run);
end;

procedure TSynJScriptSyn.MinusProc;
begin
  fTokenID := tkSymbol;
  inc(Run);
  if fLine[Run] in [WideChar('='), WideChar('-'), WideChar('>')] then inc(Run);
end;

procedure TSynJScriptSyn.ModSymbolProc;
begin
  fTokenID := tkSymbol;
  inc(Run);
  if fLine[Run] = '=' then inc(Run);
end;

procedure TSynJScriptSyn.NullProc;
begin
  fTokenID := tkNull;
end;

procedure TSynJScriptSyn.NumberProc;

  function IsNumberChar: Boolean;
  begin
    case fLine[Run] of
      '0'..'9', '.', 'a'..'f', 'A'..'F', 'x', 'X':
        Result := True;
      else
        Result := False;
    end;
  end;

  function IsHexChar(Run: Integer): Boolean;
  begin
    case fLine[Run] of
      '0'..'9', 'a'..'f', 'A'..'F':
        Result := True;
      else
        Result := False;
    end;
  end;

var
  idx1: Integer; // token[1]
  isHex: Boolean;
begin
  fTokenID := tkNumber;
  isHex := False;
  idx1 := Run;
  Inc(Run);
  while IsNumberChar do
  begin
    case FLine[Run] of
      '.':
        if FLine[Succ(Run)] = '.' then
          Break;
      'a'..'f', 'A'..'F':
        if not isHex then
          Break;
      'x', 'X':
        begin
          if (FLine[idx1] <> '0') or (Run > Succ(idx1)) then
            Break;
          if not IsHexChar(Succ(Run)) then
            Break;
          isHex := True;
        end;
    end;
    Inc(Run);
  end;
end;

procedure TSynJScriptSyn.OrSymbolProc;
begin
  fTokenID := tkSymbol;
  inc(Run);
  if fLine[Run] in [WideChar('='), WideChar('|')] then inc(Run);
end;

procedure TSynJScriptSyn.PlusProc;
begin
  fTokenID := tkSymbol;
  inc(Run);
  if fLine[Run] in [WideChar('='), WideChar('+')] then inc(Run);
end;

procedure TSynJScriptSyn.PointProc;
begin
  fTokenID := tkSymbol;
  inc(Run);
  if (fLine[Run] = '.') and (fLine[Run + 1] = '.') then inc(Run, 2);
end;

procedure TSynJScriptSyn.SlashProc;
begin
  Inc(Run);
  case fLine[Run] of
    '/': begin
           fTokenID := tkComment;
           repeat
             Inc(Run);
           until IsLineEnd(fLine[Run]);
         end;
    '*': begin
           fTokenID := tkComment;
           fRange := rsAnsi;
           repeat
             Inc(Run);
             if (fLine[Run] = '*') and (fLine[Run + 1] = '/') then begin
               fRange := rsUnKnown;
               Inc(Run, 2);
               break;
             end;
           until IsLineEnd(fLine[Run]);
         end;
    '=': begin
           Inc(Run);
           fTokenID := tkSymbol;
         end;
    else
      fTokenID := tkSymbol;
  end;
end;

procedure TSynJScriptSyn.SpaceProc;
begin
  inc(Run);
  fTokenID := tkSpace;
  while (FLine[Run] <= #32) and not IsLineEnd(FLine[Run]) do inc(Run);
end;

procedure TSynJScriptSyn.StarProc;
begin
  fTokenID := tkSymbol;
  inc(Run);
  if fLine[Run] = '=' then inc(Run);
end;

procedure TSynJScriptSyn.StringProc;
var
  l_strChar: WideString;
begin
  fTokenID := tkString;
  l_strChar := FLine[Run];   // We could have '"' or #39
  if (FLine[Run + 1] = l_strChar) and (FLine[Run + 2] = l_strChar) then inc(Run, 2);
  repeat
    case FLine[Run] of
      #0, #10, #13: break;
    end;
    inc(Run);
  until (FLine[Run] = l_strChar) and (FLine[Pred(Run)] <> '\');
  if FLine[Run] <> #0 then
    Inc(Run);
end;

procedure TSynJScriptSyn.SymbolProc;
begin
  inc(Run);
  fTokenId := tkSymbol;
end;

procedure TSynJScriptSyn.UnknownProc;
begin
  inc(Run);
  fTokenID := tkUnknown;
end;

procedure TSynJScriptSyn.Next;
begin
  fTokenPos := Run;
  if fRange = rsANSI then
    CommentProc
  else
    case fLine[Run] of
      '&': AndSymbolProc;
      #13: CRProc;
      'A'..'Z', 'a'..'z', '_': IdentProc;
      #10: LFProc;
      '-': MinusProc;
      '%': ModSymbolProc;
      #0: NullProc;
      '0'..'9': NumberProc;
      '|': OrSymbolProc;
      '+': PlusProc;
      '.': PointProc;
      '/': SlashProc;
      #1..#9, #11, #12, #14..#32: SpaceProc;
      '*': StarProc;
      '"', #39: StringProc;
      '~', '{', '}', ',', '(', ')', '[', ']', '<', '>', ':', '?', ';', '!', '=':
        SymbolProc;
      else UnknownProc;
    end;
end;

function TSynJScriptSyn.GetDefaultAttribute(Index: integer): TSynHighlighterAttributes;
begin
  case Index of
    SYN_ATTR_COMMENT: Result := fCommentAttri;
    SYN_ATTR_IDENTIFIER: Result := fIdentifierAttri;
    SYN_ATTR_KEYWORD: Result := fKeyAttri;
    SYN_ATTR_STRING: Result := fStringAttri;
    SYN_ATTR_WHITESPACE: Result := fSpaceAttri;
    SYN_ATTR_SYMBOL: Result := fSymbolAttri;
  else
    Result := nil;
  end;
end;

function TSynJScriptSyn.GetEol: Boolean;
begin
  Result := fTokenID = tkNull;
end;

function TSynJScriptSyn.GetRange: Pointer;
begin
  Result := Pointer(fRange);
end;

function TSynJScriptSyn.GetTokenID: TtkTokenKind;
begin
  Result := fTokenId;
end;

function TSynJScriptSyn.GetTokenAttribute: TSynHighlighterAttributes;
begin
  case GetTokenID of
    tkComment: Result := fCommentAttri;
    tkIdentifier: Result := fIdentifierAttri;
    tkKey: Result := fKeyAttri;
    tkNonReservedKey: Result := fNonReservedKeyAttri;
    tkEvent: Result := fEventAttri;
    tkNumber: Result := fNumberAttri;
    tkSpace: Result := fSpaceAttri;
    tkString: Result := fStringAttri;
    tkSymbol: Result := fSymbolAttri;
    tkUnknown: Result := fIdentifierAttri;
    else Result := nil;
  end;
end;

function TSynJScriptSyn.GetTokenKind: integer;
begin
  Result := Ord(fTokenId);
end;

procedure TSynJScriptSyn.ResetRange;
begin
  fRange := rsUnknown;
end;

procedure TSynJScriptSyn.SetRange(Value: Pointer);
begin
  fRange := TRangeState(Value);
end;

function TSynJScriptSyn.IsFilterStored: Boolean;
begin
  Result := fDefaultFilter <> SYNS_FilterJScript;
end;

class function TSynJScriptSyn.GetLanguageName: string;
begin
  Result := SYNS_LangJScript;
end;

function TSynJScriptSyn.GetSampleSource: WideString;
begin
  Result := '// Syntax highlighting'#13#10+
            'function printNumber()'#13#10+
            '{'#13#10+
            '  var number = 1234;'#13#10+
            '  var x;'#13#10+
            '  document.write("The number is " + number);'#13#10+
            '  for (var i = 0; i <= number; i++)'#13#10+
            '  {'#13#10+
            '    x++;'#13#10+
            '    x--;'#13#10+
            '    x += 1.0;'#13#10+
            '  }'#13#10+
            '  i += @; // illegal character'#13#10+
            '}'#13#10+
            'body.onLoad = printNumber;';
end;

class function TSynJScriptSyn.GetFriendlyLanguageName: WideString;
begin
  Result := SYNS_FriendlyLangJScript;
end;

initialization
{$IFNDEF SYN_CPPB_1}
  RegisterPlaceableHighlighter(TSynJScriptSyn);
{$ENDIF}
end.
