{-------------------------------------------------------------------------------
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in compliance
with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
the specific language governing rights and limitations under the License.

The Original Code is: SynHighlighterSQL.pas, released 2000-04-21.
The Original Code is based on the wmSQLSyn.pas and wmSybaseSyn.pas files from
the mwEdit component suite by Martin Waldenburg and other developers, the
Initial Author of these files is Willo van der Merwe. Initial Author of
SynHighlighterSQL.pas is Michael Hieke.
Portions created by Willo van der Merwe are Copyright 1999 Willo van der Merwe.
Portions created by Michael Hieke are Copyright 2000 Michael Hieke.
Unicode translation by Mal Hrz.
All Rights Reserved.

Contributors to the SynEdit and mwEdit projects are listed in the
Contributors.txt file.

Alternatively, the contents of this file may be used under the terms of the
GNU General Public License Version 2 or later (the "GPL"), in which case
the provisions of the GPL are applicable instead of those above.
If you wish to allow use of your version of this file only under the terms
of the GPL and not to allow others to use your version of this file
under the MPL, indicate your decision by deleting the provisions above and
replace them with the notice and other provisions required by the GPL.
If you do not delete the provisions above, a recipient may use your version
of this file under either the MPL or the GPL.

$Id: SynHighlighterSQL.pas,v 1.1 2005/01/28 07:46:10 urmade Exp $

You may retrieve the latest version of this file at the SynEdit home page,
located at http://SynEdit.SourceForge.net

Known Issues:
-------------------------------------------------------------------------------}
{
@abstract(SQL highlighter for SynEdit with support for different dialects.)
@author(Michael Hieke)
@created(2000-04-21)
@lastmod(2000-11-16)
The SynHighlighterSQL implements a highlighter for SQL for the SynEdit projects.
Different SQL dialects can be selected via the Dialect property.
}

{$IFNDEF QSYNHIGHLIGHTERSQL}
unit SynHighlighterSQL;
{$ENDIF}

{$I SynEdit.inc}

interface

uses
{$IFDEF SYN_CLX}
  Types,
  QGraphics,
  QSynEditTypes,
  QSynEditHighlighter,
  QSynHighlighterHashEntries,
  QSynUnicode,
{$ELSE}
  Graphics,
  Registry,
  SynEditTypes,
  SynEditHighlighter,
  SynHighlighterHashEntries,
  SynUnicode, {$IFDEF USE_JCL_UNICODE_SUPPORT} JclUnicode, {$ENDIF}
{$ENDIF}
  SysUtils,
  Classes;

type
  TtkTokenKind = (tkComment, tkDatatype, tkDefaultPackage, tkException,
    tkFunction, tkIdentifier, tkKey, tkNull, tkNumber, tkSpace, tkPLSQL,
    tkSQLPlus, tkString, tkSymbol, tkTableName, tkUnknown, tkVariable,
    tkConditionalComment, tkDelimitedIdentifier);

  TRangeState = (rsUnknown, rsComment, rsString, rsConditionalComment);

  TSQLDialect = (sqlStandard, sqlInterbase6, sqlMSSQL7, sqlMySQL, sqlOracle,
    sqlSybase, sqlIngres, sqlMSSQL2K);

type
  TSynSQLSyn = class(TSynCustomHighlighter)
  private
    fRange: TRangeState;
    fTokenID: TtkTokenKind;
    fKeywords: TSynHashEntryList;
    fTableNames: TWideStrings;
    fDialect: TSQLDialect;
    fCommentAttri: TSynHighlighterAttributes;
    fConditionalCommentAttri: TSynHighlighterAttributes;
    fDataTypeAttri: TSynHighlighterAttributes;
    fDefaultPackageAttri: TSynHighlighterAttributes;
    fDelimitedIdentifierAttri: TSynHighlighterAttributes;
    fExceptionAttri: TSynHighlighterAttributes;
    fFunctionAttri: TSynHighlighterAttributes;
    fIdentifierAttri: TSynHighlighterAttributes;
    fKeyAttri: TSynHighlighterAttributes;
    fNumberAttri: TSynHighlighterAttributes;
    fPLSQLAttri: TSynHighlighterAttributes;
    fSpaceAttri: TSynHighlighterAttributes;
    fSQLPlusAttri: TSynHighlighterAttributes;
    fStringAttri: TSynHighlighterAttributes;
    fSymbolAttri: TSynHighlighterAttributes;
    fTableNameAttri: TSynHighlighterAttributes;
    fVariableAttri: TSynHighlighterAttributes;
    function HashKey(Str: PWideChar): Integer;
    function IdentKind(MayBe: PWideChar): TtkTokenKind;
    procedure DoAddKeyword(AKeyword: WideString; AKind: integer);
    procedure SetDialect(Value: TSQLDialect);
    procedure SetTableNames(const Value: TWideStrings);
    procedure TableNamesChanged(Sender: TObject);
    procedure InitializeKeywordLists;
    procedure PutTableNamesInKeywordList;
    procedure AndSymbolProc;
    procedure AsciiCharProc;
    procedure CRProc;
    procedure EqualProc;
    procedure GreaterProc;
    procedure IdentProc;
    procedure LFProc;
    procedure LowerProc;
    procedure MinusProc;
    procedure HashProc;
    procedure NullProc;
    procedure NumberProc;
    procedure OrSymbolProc;
    procedure PlusProc;
    procedure SlashProc;
    procedure SpaceProc;
    procedure QuoteProc;
    procedure BacktickProc;
    procedure BracketProc;
    procedure SymbolProc;
    procedure SymbolAssignProc;
    procedure VariableProc;
    procedure UnknownProc;
    procedure AnsiCProc;
  protected
    function GetSampleSource: WideString; override;
    function IsFilterStored: Boolean; override;
  public
    class function GetLanguageName: string; override;
    class function GetFriendlyLanguageName: WideString; override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Assign(Source: TPersistent); override;
    function GetDefaultAttribute(Index: Integer): TSynHighlighterAttributes;
      override;
    function GetEol: Boolean; override;
    function GetRange: Pointer; override;
    function GetTokenAttribute: TSynHighlighterAttributes; override;
    function GetTokenID: TtkTokenKind;
    function GetTokenKind: Integer; override;
    function IsIdentChar(AChar: WideChar): Boolean; override;
    function IsKeyword(const AKeyword: WideString): Boolean; override;
    procedure Next; override;
    procedure ResetRange; override;
    procedure SetRange(Value: Pointer); override;
  published
    property CommentAttri: TSynHighlighterAttributes read fCommentAttri
      write fCommentAttri;
    property ConditionalCommentAttri: TSynHighlighterAttributes
      read fConditionalCommentAttri write fConditionalCommentAttri;
    property DataTypeAttri: TSynHighlighterAttributes read fDataTypeAttri
      write fDataTypeAttri;
    property DefaultPackageAttri: TSynHighlighterAttributes
      read fDefaultPackageAttri write fDefaultPackageAttri;
    property DelimitedIdentifierAttri: TSynHighlighterAttributes
      read fDelimitedIdentifierAttri write fDelimitedIdentifierAttri;
    property ExceptionAttri: TSynHighlighterAttributes read fExceptionAttri
      write fExceptionAttri;
    property FunctionAttri: TSynHighlighterAttributes read fFunctionAttri
      write fFunctionAttri;
    property IdentifierAttri: TSynHighlighterAttributes read fIdentifierAttri
      write fIdentifierAttri;
    property KeyAttri: TSynHighlighterAttributes read fKeyAttri write fKeyAttri;
    property NumberAttri: TSynHighlighterAttributes read fNumberAttri
      write fNumberAttri;
    property PLSQLAttri: TSynHighlighterAttributes read fPLSQLAttri
      write fPLSQLAttri;
    property SpaceAttri: TSynHighlighterAttributes read fSpaceAttri
      write fSpaceAttri;
    property SQLPlusAttri: TSynHighlighterAttributes read fSQLPlusAttri
      write fSQLPlusAttri;
    property StringAttri: TSynHighlighterAttributes read fStringAttri
      write fStringAttri;
    property SymbolAttri: TSynHighlighterAttributes read fSymbolAttri
      write fSymbolAttri;
    property TableNameAttri: TSynHighlighterAttributes read fTableNameAttri
      write fTableNameAttri;
    property TableNames: TWideStrings read fTableNames write SetTableNames;
    property VariableAttri: TSynHighlighterAttributes read fVariableAttri
      write fVariableAttri;
    property SQLDialect: TSQLDialect read fDialect write SetDialect
      default sqlStandard;
  end;

implementation

uses
{$IFDEF SYN_CLX}
  QSynEditStrConst;
{$ELSE}
  SynEditStrConst;
{$ENDIF}

const
//---"Standard" (ANSI SQL keywords (Version 1, 2 and 3) (www.sql.org)-----------
  StandardKW: WideString =
    'absolute,action,active,actor,add,after,alias,all,allocate,alter,' +
    'and,any,are,as,asc,ascending,assertion,async,at,attributes,auto,' +
    'base_name,before,begin,between,bit,bit_length,boolean,both,breadth,by,' +
    'cache,call,cascade,cascaded,case,cast,catalog,char_length,' +
    'character_length,check,coalesce,collate,collation,column,commit,' +
    'committed,completion,computed,conditional,connect,connection,constraint,' +
    'constraints,containing,convert,corresponding,count,create,cross,current,' +
    'current_date,current_path,current_time,current_timestamp,current_user,' +
    'cursor,cycle,data,database,date,day,deallocate,debug,declare,default,' +
    'deferrable,deferred,delete,depth,desc,descending,describe,descriptor,' +
    'destroy,diagnostics,dictionary,disconnect,distinct,do,domain,' +
    'drop,each,element,else,elseif,end,end-exec,entry_point,equals,escape,' +
    'except,exception,execute,exists,exit,external,extract,factor,false,' +
    'filter,first,for,foreign,from,full,function,general,generator,get,' +
    'global,grant,group,having,hold,hour,identity,if,ignore,immediate,in,' +
    'inactive,index,initially,inner,input,insensitive,insert,instead,' +
    'intersect,interval,into,is,isolation,join,key,last,leading,leave,left,' +
    'less,level,like,limit,list,local,loop,lower,match,merge,minute,modify,' +
    'month,names,national,natural,nchar,new,new_table,next,no,none,not,null,' +
    'nullif,object,octet_length,of,off,old,old_table,on,only,operation,' +
    'operator,operators,or,order,others,outer,output,overlaps,pad,' +
    'parameter,parameters,partial,password,path,pendant,plan,position,' +
    'postfix,prefix,preorder,prepare,preserve,primary,prior,private,' +
    'privileges,procedure,protected,read,recursive,ref,referencing,relative,' +
    'replace,resignal,restrict,retain,return,returns,revoke,right,role,' +
    'rollback,routine,row,rows,savepoint,schema,scroll,search,second,select,' +
    'sensitive,sequence,session,session_user,set,shadow,shared,signal,' +
    'similar,size,snapshot,some,space,sqlexception,sqlstate,sqlwarning,start,' +
    'state,structure,substring,suspend,symbol,system_user,table,temporary,' +
    'term,test,then,there,time,timestamp,timezone_hour,timezone_minute,to,' +
    'trailing,transaction,translate,translation,trigger,trim,true,tuple,type,' +
    'uncommitted,under,union,unique,unknown,update,upper,usage,user,using,' +
    'value,varchar,variable,varying,view,virtual,visible,wait,when,where,' +
    'while,with,without,work,write,year,zone';

//---Sybase keywords------------------------------------------------------------
  SybaseKW: WideString =
    'absolute,action,add,after,alias,all,allocate,alter,and,any,are,' +
    'arith_overflow,as,asc,assertion,async,at,authorization,avg,before,begin,' +
    'between,bit,bit_length,boolean,both,breadth,break,browse,bulk,by,call,' +
    'cascade,cascaded,case,cast,catalog,char,char_convert,char_length,' +
    'character,character_length,check,checkpoint,close,clustered,coalesce,' +
    'collate,collation,column,commit,completion,compute,confirm,' +
    'connect,connection,constraint,constraints,continue,controlrow,convert,' +
    'corresponding,count,create,cross,current,current_date,current_time,' +
    'current_timestamp,current_user,cursor,cycle,data,database,date,day,dbcc,' +
    'deallocate,dec,decimal,declare,default,deferrable,deferred,delete,depth,' +
    'desc,describe,descriptor,diagnostics,dictionary,dis,disconnect,distinct,' +
    'domain,double,drop,dummy,dump,each,else,elseif,en,end,endtran,equals,' +
    'errlvl,errordata,errorexit,escape,except,exception,exclusive,exec,' +
    'execute,exists,exit,exp_row_size,external,extract,false,fetch,' +
    'fillfactor,first,float,for,foreign,found,from,full,general,get,global,' +
    'go,goto,grant,group,having,holdlock,hour,identity,identity_gap,' +
    'identity_insert,identity_start,if,ignore,immediate,in,index,indicator,' +
    'initially,inner,input,insensitive,insert,install,int,integer,intersect,' +
    'interval,into,is,isolation,jar,join,key,kill,language,last,leading,' +
    'leave,left,less,level,like,limit,lineno,load,local,lock,loop,lower,' +
    'match,max,max_rows_per_page,min,minute,mirror,mirrorexit,modify,module,' +
    'month,names,national,natural,nchar,new,next,no,noholdlock,nonclustered,' +
    'none,not,null,nullif,numeric,numeric_truncation,object,' +
    'octet_length,of,off,offsets,oid,old,on,once,online,only,open,operation,' +
    'operators,option,or,order,others,outer,output,over,overlaps,pad,' +
    'parameters,partial,partition,pendant,perm,permanent,plan,position,' +
    'precision,preorder,prepare,preserve,primary,print,prior,private,' +
    'privileges,proc,procedure,processexit,protected,proxy_table,public,' +
    'quiesce,raiserror,read,readpast,readtext,real,reconfigure,recursive,' +
    'ref,reference,referencing,relative,remove,reorg,replace,replication,' +
    'reservepagegap,resignal,restrict,return,returns,revoke,right,role,' +
    'rollback,routine,row,rowcount,rows,rule,save,savepoint,schema,scroll,' +
    'search,second,section,select,sensitive,sequence,session_user,set,' +
    'setuser,shared,shutdown,signal,similar,size,smallint,some,space,sql,' +
    'sqlcode,sqlerror,sqlexception,sqlstate,statistics,stripe,structure,' +
    'substring,sum,syb_identity,syb_restree,system_user,table,temp,temporary,' +
    'test,textsize,then,there,time,timestamp,timezone_hour,timezone_minute,' +
    'to,trailing,tran,transaction,translate,translation,trigger,trim,true,' +
    'truncate,tsequal,type,under,union,unique,unknown,unpartition,update,' +
    'upper,usage,use,user,user_option,using,value,values,varchar,variable,' +
    'varying,view,virtual,visible,wait,waitfor,when,whenever,where,while,' +
    'with,without,work,write,writetext,year,zone';

//---Oracle---------------------------------------------------------------------
  // Oracle SQL keywords
  OracleKW: WideString =
    'access,accessed,account,activate,active_instance_count,add,admin,advise,' +
    'agent,all,allocate,alter,analyze,ancillary,and,any,aq_tm_processes,' +
    'archive_lag_target,archivelog,as,asc,associate,attributes,audit,' +
    'audit_file_dest,audit_sys_operations,audit_trail,authenticated,authid,' +
    'autoallocate,autoextend,automatic,background_core_dump,' +
    'background_dump_dest,backup,backup_tape_io_slaves,become,before,' +
    'behalf,between,binding,bitmap,bitmap_merge_area_size,blank_trimming,' +
    'block,blocksize,buffer_pool,buffer_pool_keep,buffer_pool_recycle,by,' +
    'cache,cancel,cascade,cast,category,chained,change,character,check,' +
    'checkpoint,child,chunk,circuits,class,clone,cluster,cluster_database,' +
    'cluster_database_instances,cluster_interconnects,coalesce,cobol,' +
    'column,columns,comment,commit_point_strength,compatible,compile,' +
    'complete,composite_limit,compress,compute,connect,' +
    'connect_time,consider,constraint,constraints,contents,context,continue,' +
    'control,control_file_record_keep_time,control_files,controlfile,' +
    'core_dump_dest,cost,cpu_count,cpu_per_call,cpu_per_session,create,' +
    'create_bitmap_area_size,create_stored_outlines,current,current_user,' +
    'cursor_sharing,cursor_space_for_time,cycle,dangling,datafile,' +
    'db_block_buffers,db_block_checking,db_block_checksum,db_block_size,' +
    'db_cache_advice,db_cache_size,db_create_file_dest,db_domain,' +
    'db_file_multiblock_read_count,db_file_name_convert,db_files,' +
    'db_keep_cache_size,db_name,db_recycle_cache_size,db_writer_processes,' +
    'dblink_encrypt_login,dbwr_io_slaves,deallocate,debug,default,deferred,' +
    'definer,delete,demand,determines,dg_broker_start,dictionary,dimension,' +
    'directory,disable,disassociate,disk_asynch_io,dismount,dispatchers,' +
    'distinct,distributed,distributed_lock_timeout,dml,dml_locks,document,' +
    'drop,drs_start,else,enable,enqueue_resources,escape,estimate,event,' +
    'events,except,exceptions,exchange,excluding,exclusive,exists,expire,' +
    'explain,extent,externally,failed_login_attempts,fal_client,fal_server,' +
    'fast,fast_start_io_target,fast_start_mttr_target,' +
    'fast_start_parallel_rollback,file,file_mapping,filesystemio_options,' +
    'fixed_date,flush,for,force,foreign,fortran,freelist,freelists,fresh,' +
    'from,from_tz,functions,gc_files_to_locks,generated,global,' +
    'global_context_pool_size,global_name,global_names,globally,go,grant,' +
    'group,groups,hash,hash_area_size,hash_join_enabled,hashkeys,having,heap,' +
    'hi_shared_memory_address,hierarchy,hs_autoregister,identified,idle_time,' +
    'ifile,immediate,in,including,increment,index,indextype,indextypes,' +
    'infile,initial,initialized,initially,initrans,insert,instance,' +
    'instance_groups,instance_name,instance_number,int,intersect,into,' +
    'invalidate,is,isolation,java,java_max_sessionspace_size,java_pool_size,' +
    'java_soft_sessionspace_limit,job_queue_processes,join,keep,key,kill,' +
    'large_pool_size,layerlists,level,library,license_max_sessions,' +
    'license_max_users,license_sessions_warning,like,limit,link,list,lob,' +
    'local,local_listener,locator,lock,lock_name_space,lock_sga,' +
    'log_archive_dest,log_archive_duplex_dest,log_archive_format,' +
    'log_archive_max_processes,log_archive_min_succeed_dest,' +
    'log_archive_start,log_archive_trace,log_buffer,log_checkpoint_interval,' +
    'log_checkpoint_timeout,log_checkpoints_to_alert,log_file_name_convert,' +
    'log_parallelism,logfile,logging,logical_reads_per_call,' +
    'logical_reads_per_session,logmnr_max_persistent_sessions,manage,managed,' +
    'manual,map,master,matched,materialized,max_commit_propagation_delay,' +
    'max_dispatchers,max_dump_file_size,max_enabled_roles,' +
    'max_rollback_segments,max_shared_servers,maxdatafiles,maxextents,' +
    'maxinstances,maxlogfiles,maxloghistory,maxlogmembers,maxsize,maxtrans,' +
    'maxvalue,member,merge,minextents,minimize,minimum,minus,minvalue,mode,' +
    'modify,module,monitoring,mount,move,movement,multiset,named,national,' +
    'nested,never,next,nls_calendar,nls_comp,nls_currency,nls_date_format,' +
    'nls_date_language,nls_dual_currency,nls_iso_currency,nls_language,' +
    'nls_length_semantics,nls_nchar_conv_excp,nls_numeric_characters,' +
    'nls_territory,nls_timestamp_format,nls_timestamp_tz_format,no,' +
    'noarchivelog,noaudit,nocache,nocompress,nocopy,nocycle,noforce,' +
    'nologging,nomaxvalue,nominimize,nominvalue,nomonitoring,none,' +
    'noorder,norely,noresetlogs,noreverse,normal,norowdependencies,nosort,' +
    'not,nothing,novalidate,nowait,null,o7_dictionary_accessibility,' +
    'object_cache_max_size_percent,object_cache_optimal_size,of,offline,oid,' +
    'olap_page_pool_size,on,online,only,open_cursors,open_links,' +
    'open_links_per_instance,operator,optimal,optimizer_dynamic_sampling,' +
    'optimizer_features_enable,optimizer_index_caching,' +
    'optimizer_index_cost_adj,optimizer_max_permutations,optimizer_mode,' +
    'option,or,oracle_trace_collection_name,oracle_trace_collection_path,' +
    'oracle_trace_collection_size,oracle_trace_enable,' +
    'oracle_trace_facility_name,oracle_trace_facility_path,order,' +
    'os_authent_prefix,os_roles,outline,overflow,own,packages,parallel,' +
    'parallel_adaptive_multi_user,parallel_automatic_tuning,' +
    'parallel_execution_message_size,parallel_instance_group,' +
    'parallel_max_servers,parallel_min_percent,parallel_min_servers,' +
    'parallel_threads_per_cpu,parameters,partition_view_enabled,partitions,' +
    'password,password_grace_time,password_life_time,password_lock_time,' +
    'password_reuse_max,password_reuse_time,password_verify_function,' +
    'pctfree,pctincrease,pctthreshold,pctused,pctversion,percent,permanent,' +
    'pga_aggregate_target,pipelined,plan,pli,plsql_compiler_flags,' +
    'plsql_native_c_compiler,plsql_native_library_dir,' +
    'plsql_native_library_subdir_count,plsql_native_linker,' +
    'plsql_native_make_file_name,plsql_native_make_utility,' +
    'plsql_v2_compatibility,post_transaction,pre_page_sga,prebuild,precision,' +
    'primary,prior,private_sga,privileges,processes,profile,public,query,' +
    'query_rewrite_enabled,query_rewrite_integrity,quiesce,quota,' +
    'rdbms_server_dn,read,read_only_open_delayed,rebuild,records_per_block,' +
    'recover,recoverable,recovery,recovery_parallelism,recycle,reduced,' +
    'references,refresh,register,rely,remote_archive_enable,' +
    'remote_dependencies_mode,remote_listener,remote_login_passwordfile,' +
    'remote_os_authent,remote_os_roles,rename,' +
    'replication_dependency_tracking,reset,resetlogs,resize,resolve,resolver,' +
    'resource,resource_limit,resource_manager_plan,restrict,restricted,' +
    'resumable,resume,reuse,revoke,rewrite,rnds,rnps,role,roles,' +
    'rollback_segments,row,row_locking,rowdependencies,rowlabel,rownum,' +
    'rows,sample,scn,scope,section,segment,select,selectivity,sequence,' +
    'serial_reuse,service_names,session,session_cached_cursors,' +
    'session_max_open_files,sessions,sessions_per_user,sga_max_size,' +
    'shadow_core_dump,share,shared,shared_memory_address,shared_pool,' +
    'shared_pool_reserved_size,shared_pool_size,shared_server_sessions,' +
    'shared_servers,shrink,size,snapshot,some,sort,sort_area_retained_size,' +
    'sort_area_size,source,specification,specified,spfile,split,sql_trace,' +
    'sql92_security,standby,standby_archive_dest,standby_file_management,' +
    'star_transformation_enabled,start,start_date,static,statistics,' +
    'statistics_level,stop,storage,structure,subpartition,subpartitions,' +
    'successful,suspend,switch,synonym,system,table,tablespace,' +
    'tape_asynch_io,tempfile,temporary,the,then,thread,through,time,' +
    'timed_os_statistics,timed_statistics,timeout,to,trace_enabled,' +
    'tracefile_identifier,tracing,transaction,transaction_auditing,' +
    'transactions,transactions_per_rollback_segment,trigger,truncate,trust,' +
    'types,unarchived,under,undo,undo_management,undo_retention,' +
    'undo_suppress_errors,undo_tablespace,uniform,union,unique,unlimited,' +
    'unlock,unquiesce,unrecoverable,until,unusable,unused,update,usage,' +
    'use_indirect_data_buffers,user_dump_dest,validate,validation,values,' +
    'vargraphic,varray,view,where,with,without,wnds,wnps,' +
    'workarea_size_policy';

  // PLSQL keywords
  OraclePLSQLKW: WideString =
    'abort,accept,after,array,arraylen,assert,assign,at,authorization,' +
    'autonomous_transaction,base_table,begin,body,bulk,bulk_rowcount,call,' +
    'calling,case,char_base,charsetform,charsetid,close,clusters,colauth,' +
    'collect,commit,connection,constant,cookie,cookie_table,crash,currval,' +
    'cursor,data_base,database,dba,debugoff,debugon,declare,definition,' +
    'delay,delta,dequeue_options_t,deterministic,digits,dispose,do,each,' +
    'elsif,end,enqueue_options_t,entry,exception,exception_init,exit,' +
    'external,false,fetch,fixed,forall,form,found,function,generic,goto,if,' +
    'indexes,indicator,instead,interface,isopen,language,lcr$_ddl_record,' +
    'lcr$_row_list,lcr$_row_record,lcr$_row_unit,limited,loop,maxlen,' +
    'message_properties_t,mgw_basic_msg_t,mgw_mqseries_properties,' +
    'mgw_name_type_array_t,mgw_name_value_t,mgw_properties,mgw_property,' +
    'mgw_raw_value_t,mgw_text_value_t,name,new,nextval,notfound,' +
    'number_base,old,open,out,package,parallel_enable,partition,pascal,' +
    'pragma,private,procedure,raise,range,re$attribute_value,' +
    're$attribute_value_list,re$column_value,re$column_value_list,' +
    're$name_array,re$nv_array,re$nv_list,re$nv_node,re$rule_hit,' +
    're$rule_hit_list,re$table_alias,re$table_alias_list,' +
    're$table_value,re$table_value_list,re$variable_type,' +
    're$variable_type_list,re$variable_value,re$variable_value_list,record,' +
    'ref,referencing,release,remr,req,resp,restrict_references,return,' +
    'reverse,rollback,rowcount,rowtype,runtime_info,savepoint,schema,' +
    'self,separate,serially_reusable,space,sql,sqlerror,statement,struct,' +
    'subtype,tabauth,tables,task,tdo,terminate,true,type,use,varying,views,' +
    'when,while,work,write,xor';

  // Oracle data types
  OracleTypes: WideString =
    'anydata,anydataset,anytype,bfile,binary_integer,blob,boolean,char,clob,' +
    'date,day,dburitype,dec,decimal,double,float,httpuritype,integer,long,' +
    'mlslabel,month,natural,naturaln,nchar,nclob,number,numeric,' +
    'nvarchar2,pls_integer,positive,positiven,raw,real,rowid,second,smallint,' +
    'timestamp,uritype,urowid,varchar,varchar2,xdburitype,xmldata,xmltype,' +
    'year,zone';

  // Oracle built in exceptions
  OracleExceptions: WideString =
    'access_into_null,collection_is_null,cursor_already_open,' +
    'dup_val_on_index,invalid_cursor,invalid_number,login_denied,' +
    'no_data_found,not_logged_on,others,program_error,rowtype_mismatch,' +
    'storage_error,subscript_beyond_count,subscript_outside_limit,' +
    'sys_invalid_rowid,timeout_on_resource,too_many_rows,value_error,' +
    'zero_divide';

  // Oracle built in functions
  OracleFunctions: WideString =
    'abs,acos,add_months,aggregate,analytic,ascii,asciistr,asin,atan,atan2,' +
    'average,avg,base64_decode,base64_encode,begin_request,bfilename,' +
    'bin_to_num,bit_and,bit_complement,bit_or,bit_xor,bitand,' +
    'cast_from_binary_integer,cast_from_number,cast_to_binary_integer,' +
    'cast_to_number,cast_to_raw,cast_to_varchar2,ceil,chartorowid,chr,' +
    'column_present,compare,compare_templates,compose,concat,conversion,' +
    'convert,convert_anydata_to_lcr_ddl,convert_anydata_to_lcr_row,' +
    'copies,copy_template,corr,cos,cosh,count,covar_pop,covar_samp,' +
    'create_object_from_existing,create_pipe,create_refresh_template,' +
    'create_template_object,create_template_parm,create_user_authorization,' +
    'create_user_parm_value,crlf,cube,cume_dist,current_date,' +
    'current_instance,current_timestamp,data_block_address_block,' +
    'data_block_address_file,dbtimezone,decode,decompose,delete_breakpoint,' +
    'delete_oer_breakpoint,dense_rank,depth,deref,disable_breakpoint,' +
    'disabled,display,drop_all,drop_element,drop_file,dump,' +
    'empty_blob,empty_clob,enable_breakpoint,equals_path,estimate_cpu_units,' +
    'exclude_push,execute_and_fetch,execute_non_query,existsnode,exp,extend,' +
    'extract,extractvalue,fcopy,fetch_row,fetch_rows,fgetpos,fileexists,' +
    'fileisopen,first,first_value,floor,flush_data,fopen,fopen_nchar,' +
    'format_call_stack,format_error_stack,fremove,frename,from_remote,fseek,' +
    'get_arg_form,get_arg_type,get_cookie_count,get_cookies,' +
    'get_detailed_sqlcode,get_detailed_sqlerrm,get_error_message,' +
    'get_hash_value,get_header_count,get_indexes,get_information,' +
    'get_object_null_vector_arg,get_parameter_value,' +
    'get_persistent_conn_count,get_raw,get_response,get_runtime_info,' +
    'get_runtime_parm_id,get_session_timeout,get_system_change_number,' +
    'get_tag,get_time,get_timeout,get_timeout_behavior,get_value,' +
    'getchunksize,getlength,glb,greatest,greatest_lb,group_id,grouping,' +
    'grouping_id,hextoraw,i_am_a_refresh,initcap,initialize,' +
    'instantiate_offline,instantiate_online,instr,instrb,' +
    'internal_version_check,is_cluster_database,is_locator,is_open,' +
    'is_role_enabled,is_session_alive,is_trigger_fire_once,istemporary,lag,' +
    'last,last_day,last_error_position,last_row_count,last_row_id,' +
    'last_sql__code,last_value,lead,least,least_lb,length,lengthb,linear,ln,' +
    'local_transaction_id,localtimestamp,log,lower,lpad,ltrim,lub,' +
    'make_data_block_address,make_ref,map_all,map_element,map_file,' +
    'map_object,max,min,mine_value,miscellaneous,mod,months_between,nchr,' +
    'new_time,next_day,next_item_type,nls_charset_decl_len,nls_charset_id,' +
    'nls_charset_name,nls_initcap,nls_lower,nls_sort,nls_upper,nlssort,ntile,' +
    'nullif,numtodsinterval,numtoyminterval,nvarray_find_name,' +
    'nvarray_find_name_type,nvarray_get,nvarray_get_boolean,nvarray_get_byte,' +
    'nvarray_get_date,nvarray_get_double,nvarray_get_float,' +
    'nvarray_get_integer,nvarray_get_long,nvarray_get_raw,nvarray_get_short,' +
    'nvarray_get_text,nvl,nvl2,object,open_cursor,over,overlay,path,' +
    'pause_profiler,percent_rank,percentile_cont,percentile_disc,pmarker,' +
    'port_string,power,purge,push,put_raw,quoted_printable_decode,' +
    'quoted_printable_encode,random,rank,ratio_to_report,ration_to_report,' +
    'rawtohex,rawtonhex,receive_message,reference,reftohex,regr_avgx,' +
    'regr_avgy,regr_count,regr_intercept,regr_r2,regr_slope,regr_sxx,' +
    'regr_sxy,regr_syy,regression,remove_pipe,replace,replication_is_on,' +
    'request,request_pieces,restore,resume_profiler,returning,rollup,round,' +
    'row_number,rowid_block_number,rowid_create,rowid_object,' +
    'rowid_relative_fno,rowid_row_number,rowid_to_absolute_fno,' +
    'rowid_to_extended,rowid_to_restricted,rowid_type,rowid_verify,' +
    'rowidtochar,rowidtonchar,rpad,rtrim,send_message,sessiontimezone,' +
    'set_breakpoint,set_oer_breakpoint,set_timeout,set_value,sign,sin,sinh,' +
    'soundex,space_error_info,sqlcode,sqlerrm,sqrt,start_profiler,stddev,' +
    'stddev_pop,stddev_samp,stddevp,stddevs,step_id,stop_profiler,substr,' +
    'substrb,sum,synchronize,sys_connect_by_path,sys_context,sys_dburigen,' +
    'sys_extract_utc,sys_guid,sys_typeid,sys_xmlagg,sys_xmlgen,sysdate,' +
    'systimestamp,tan,tanh,to_char,to_clob,to_date,to_dsinterval,to_label,' +
    'to_lob,to_multi_byte,to_nchar,to_nclob,to_number,to_single_byte,' +
    'to_timestamp,to_timestamp_tz,to_yminterval,translate,transliterate,' +
    'treat,trim,trunc,tz_offset,uid,under_path,unescape,unique_session_id,' +
    'unique_session_name,unistr,updatexml,upper,user,userenv,using,uudecode,' +
    'uuencode,value,var_pop,var_samp,variance,varp,vars,vsize,width_bucket,' +
    'xmlagg,xmlcolattval,xmlconcat,xmlelement,xmlforest,xmlsequence,' +
    'xmltransform,xrange';

  OracleDefaultPackages: WideString =
    'dbms_alert,dbms_application_info,dbms_apply_adm,dbms_aq,' +
    'dbms_aq_exp_history_tables,dbms_aq_exp_index_tables,' +
    'dbms_aq_exp_queue_tables,dbms_aq_exp_queues,' +
    'dbms_aq_exp_subscriber_tables,dbms_aq_exp_timemgr_tables,' +
    'dbms_aq_exp_zecurity,dbms_aq_imp_internal,dbms_aq_imp_zecurity,' +
    'dbms_aq_import_internal,dbms_aq_sys_exp_actions,' +
    'dbms_aq_sys_exp_internal,dbms_aq_sys_imp_internal,dbms_aqadm,' +
    'dbms_aqadm_sys,dbms_aqadm_syscalls,dbms_aqelm,dbms_aqin,' +
    'dbms_aqjms,dbms_backup_restore,dbms_capture_adm,dbms_ddl,' +
    'dbms_debug,dbms_defer,dbms_defer_import_internal,dbms_defer_query,' +
    'dbms_defer_sys,dbms_describe,dbms_distributed_trust_admin,' +
    'dbms_export_extension,dbms_fga,dbms_flashback,dbms_hs_passthrough,' +
    'dbms_ijob,dbms_internal_trigger,dbms_iot,dbms_irefresh,dbms_isnapshot,' +
    'dbms_java_test,dbms_job,dbms_ldap,dbms_libcache,dbms_lob,dbms_lock,' +
    'dbms_logmnr,dbms_logmnr_cdc_publish,dbms_logmnr_cdc_subscribe,' +
    'dbms_logmnr_d,dbms_logstdby,dbms_metadata,dbms_mgwadm,' +
    'dbms_mgwmsg,dbms_mview,dbms_obfuscation_toolkit,dbms_odci,' +
    'dbms_offline_og,dbms_offline_snapshot,dbms_olap,' +
    'dbms_oracle_trace_agent,dbms_oracle_trace_user,dbms_outln,' +
    'dbms_outln_edit,dbms_output,dbms_pclxutil,dbms_pickler,dbms_pipe,' +
    'dbms_pitr,dbms_plugts,dbms_profiler,dbms_propagation_adm,' +
    'dbms_prvtaqim,dbms_prvtaqip,dbms_prvtaqis,dbms_prvtrmie,dbms_psp,' +
    'dbms_pswmg_import,dbms_random,dbms_rcvman,dbms_rectifier_diff,' +
    'dbms_redefinition,dbms_refresh,dbms_refresh_exp_lwm,' +
    'dbms_refresh_exp_sites,dbms_repair,dbms_repcat,dbms_repcat_admin,' +
    'dbms_repcat_auth,dbms_repcat_instantiate,dbms_repcat_rgt,dbms_reputil,' +
    'dbms_resource_manager,dbms_resource_manager_privs,dbms_resumable,' +
    'dbms_rls,dbms_rmgr_group_export,dbms_rmgr_pact_export,' +
    'dbms_rmgr_plan_export,dbms_rmin,dbms_rowid,dbms_rule,dbms_rule_adm,' +
    'dbms_rule_eximp,dbms_session,dbms_shared_pool,dbms_snap_internal,' +
    'dbms_snap_repapi,dbms_snapshot,dbms_snapshot_utl,dbms_space,' +
    'dbms_space_admin,dbms_sql,dbms_standard,dbms_stats,dbms_storage_map,' +
    'dbms_streams,dbms_streams_adm,dbms_sumadv,dbms_summary,' +
    'dbms_sumref_child,dbms_sumref_parent,dbms_sumref_util,' +
    'dbms_sumref_util2,dbms_sumvdm,dbms_sys_error,dbms_sys_sql,' +
    'dbms_system,dbms_trace,dbms_transaction,dbms_transform,dbms_tts,' +
    'dbms_types,dbms_utility,dbms_wm,dbms_xdb,dbms_xdb_version,dbms_xdbt,' +
    'dbms_xmldom,dbms_xmlgen,dbms_xmlparser,dbms_xmlquery,' +
    'dbms_xmlsave,dbms_xplan,dbms_xslprocessor,dbms_zhelp,dbms_zhelp_ir,' +
    'dbmszexp_syspkggrnt,debug_extproc,diana,diutil,odciconst,outln_pkg,' +
    'pbreak,pbrph,pbsde,pbutl,pidl,plitblm,sdo_cs,sdo_geom,sdo_lrs,' +
    'sdo_migrate,sdo_tune,sdo_util,standard,sys_stub_for_purity_analysis,' +
    'utl_coll,utl_encode,utl_file,utl_file_dir,utl_http,utl_inaddr,utl_pg,' +
    'utl_raw,utl_ref,utl_smtp,utl_tcp,utl_url';

  OracleSQLPlusCommands: WideString =
    'app,appinfo,aq$_agent,aq$_agent_list_t,aq$_descriptor,aq$_post_info,' +
    'aq$_post_info_list,aq$_recipient_list_t,aq$_reg_info,aq$_reg_info_list,' +
    'aq$_subscriber_list_t,archive,arraysize,attribute,autocommit,autop,' +
    'autoprint,autorecovery,autot,autotrace,blo,blockterminator,bre,break,' +
    'bti,btitle,buffer,cl,clear,closecursor,cmds,cmdsep,col,colsep,com,comp,' +
    'compat,compatibility,con,conn,copy,copyc,copycommit,copytypecheck,def,' +
    'define,desc,descr,descri,describ,describe,disc,disco,discon,disconn,' +
    'disconne,disconnec,disconnect,ea,echo,editf,editfile,emb,' +
    'embedded,esc,exec,execute,failure,feed,feedback,flagger,flu,full,get,' +
    'hea,heading,heads,headsep,help,ho,host,input,intermed,intermediate,inv,' +
    'invisible,lin,linesize,lo,lobof,loboffset,logon,logsource,longc,' +
    'longchunksize,markup,maxdata,mix,mixed,native,newp,newpage,num,' +
    'numf,numformat,numwidth,off,oserror,pages,pagesize,passw,pau,pause,' +
    'pprint,pri,print,prompt,recsep,recsepchar,repf,repfooter,reph,repheader,' +
    'run,save,scan,serveroutput,set,shift,shiftinout,sho,show,shutdown,' +
    'silent,spool,sqlbl,sqlblanklines,sqlc,sqlcase,sqlco,sqlcontinue,sqln,' +
    'sqlnumber,sqlp,sqlpre,sqlprefix,sqlprompt,sqlt,sqlterminator,sta,' +
    'startup,statement_id,store,success,suf,suffix,tab,term,termout,ti,timi,' +
    'timing,trimout,trims,trimspool,tti,ttitle,und,undef,undefine,' +
    'underline,up,var,variable,ver,verify,version,vis,visible,whenever,wr,' +
    'wra,wrap,wrapped';

  OracleCommentKW: WideString =
    'rem,rema,remar,remark';

//---MS-SQL 7-------------------------------------------------------------------
  // keywords
  MSSQL7KW: WideString =
    'absolute,add,all,alter,any,as,asc,authorization,avg,backup,begin,' +
    'between,break,browse,bulk,by,cascade,check,checkpoint,close,clustered,' +
    'column,commit,committed,compute,confirm,constraint,contains,' +
    'containstable,continue,controlrow,count,create,cross,current,' +
    'current_date,current_time,cursor,database,dbcc,deallocate,declare,' +
    'default,delete,deny,desc,disk,distinct,distributed,double,drop,dummy,' +
    'dump,else,end,errlvl,errorexit,escape,except,exec,execute,exists,exit,' +
    'fetch,file,fillfactor,first,floppy,for,foreign,freetext,freetexttable,' +
    'from,full,global,goto,grant,group,having,holdlock,identity,identitycol,' +
    'identity_insert,if,in,index,inner,insert,intersect,into,is,isolation,' +
    'join,key,kill,last,left,level,like,lineno,load,max,min,mirrorexit,' +
    'national,next,nocheck,nonclustered,not,null,of,off,offsets,on,once,' +
    'only,open,opendatasource,openquery,openrowset,option,or,order,outer,' +
    'over,percent,perm,permanent,pipe,plan,precision,prepare,primary,print,' +
    'prior,privileges,proc,procedure,processexit,public,raiserror,read,' +
    'readtext,reconfigure,references,relative,repeatable,replication,restore,' +
    'restrict,return,revoke,right,rollback,rowcount,rowguidcol,rule,save,' +
    'schema,select,serializable,set,setuser,shutdown,some,statistics,sum,' +
    'table,tape,temp,temporary,textsize,then,to,top,tran,transaction,trigger,' +
    'truncate,tsequal,uncommitted,union,unique,update,updatetext,use,user,' +
    'values,varying,view,waitfor,when,where,while,with,work,writetext';

  // functions
  MSSQL7Functions: WideString =
    '@@connections,@@cpu_busy,@@cursor_rows,@@datefirst,@@dbts,@@error,' +
    '@@fetch_status,@@identity,@@idle,@@io_busy,@@langid,@@language,' +
    '@@lock_timeout,@@max_connections,@@max_precision,@@nestlevel,@@options,' +
    '@@packet_errors,@@pack_received,@@pack_sent,@@procid,@@remserver,' +
    '@@rowcount,@@servername,@@servicename,@@spid,@@textsize,@@timeticks,' +
    '@@total_errors,@@total_read,@@total_write,@@trancount,@@version,abs,' +
    'acos,and,app_name,ascii,asin,atan,atn2,case,cast,ceiling,charindex,' +
    'coalesce,columnproperty,col_length,col_name,convert,cos,cot,' +
    'current_timestamp,current_user,cursor_status,databaseproperty,' +
    'datalength,dateadd,datediff,datename,datepart,day,db_id,db_name,' +
    'degrees,difference,exp,filegroupproperty,filegroup_id,filegroup_name,' +
    'fileproperty,file_id,file_name,floor,formatmessage,' +
    'fulltextcatalogproperty,fulltextserviceproperty,getansinull,getdate,' +
    'host_id,host_name,ident_incr,ident_seed,indexproperty,index_col,' +
    'isdate,isnull,isnumeric,is_member,is_srvrolemember,len,log,log10,lower,' +
    'ltrim,month,newid,nullif,objectproperty,object_id,object_name,parsename,' +
    'patindex,permissions,pi,power,quotename,radians,rand,replace,replicate,' +
    'reverse,round,rtrim,session_user,sign,sin,soundex,space,sqrt,square,' +
    'stats_date,str,stuff,substring,suser_id,suser_name,suser_sid,' +
    'suser_sname,system_user,tan,textptr,textvalid,typeproperty,unicode,' +
    'upper,user_id,user_name,year';

  // types
  MSSQL7Types: WideString =
    'binary,bit,char,datetime,decimal,float,image,int,money,nchar,ntext,' +
    'numeric,nvarchar,real,smalldatetime,smallint,smallmoney,sysname,text,' +
    'timestamp,tinyint,uniqueidentifier,varbinary,varchar';

//---MS-SQL2K-------------------------------------------------------------------
  // keywords
  MSSQL2000KW: WideString =
    'add,all,alter,and,any,as,asc,authorization,backup,' +
    'begin,between,break,browse,bulk,by,cascade,case,' +
    'check,checkpoint,close,clustered,collate,' +
    'column,commit,compute,constraint,contains,containstable,' +
    'continue,create,cross,current,cursor,database,' +
    'dbcc,deallocate,declare,default,delete,deny,desc,disk,' +
    'distinct,distributed,double,drop,dummy,dump,else,end,' +
    'errlvl,escape,except,exec,execute,exists,exit,fetch,file,' +
    'fillfactor,for,foreign,formsof,freetext,freetexttable,from,full,' +
    'function,goto,grant,group,having,holdlock,identity,' +
    'identitycol,identity_insert,if,in,inflectional,index,inner,insert,' +
    'intersect,into,is,isabout,join,key,kill,left,like,lineno,load,' +
    'national,nocheck,nonclustered,not,null,nullif,of,off,' +
    'offsets,on,open,opendatasource,openquery,openrowset,openxml,' +
    'option,or,order,outer,over,percent,plan,precision,' +
    'primary,print,proc,procedure,public,raiserror,read,' +
    'readtext,reconfigure,references,replication,restore,' +
    'restrict,return,revoke,right,rollback,rowcount,rowguidcol,' +
    'rule,save,schema,select,session_user,set,setuser,shutdown,' +
    'some,statistics,table,textsize,then,to,top,tran,transaction,' +
    'trigger,truncate,tsequal,union,unique,update,updatetext,' +
    'use,user,values,varying,view,waitfor,weight,when,where,while,' +
    'with,writetext';

  // functions
  MSSQL2000Functions: WideString =
    '@@connections,@@cpu_busy,@@cursor_rows,@@datefirst,@@dbts,@@error,' +
    '@@fetch_status,@@identity,@@idle,@@io_busy,@@langid,@@language,' +
    '@@lock_timeout,@@max_connections,@@max_precision,@@nestlevel,@@options,' +
    '@@packet_errors,@@pack_received,@@pack_sent,@@procid,@@remserver,' +
    '@@rowcount,@@servername,@@servicename,@@spid,@@textsize,@@timeticks,' +
    '@@total_errors,@@total_read,@@total_write,@@trancount,@@version,' +
    'abs,acos,app_name,ascii,asin,atan,atn2,avg,binary_checksum,cast,' +
    'ceiling,charindex,checksum,checksum_agg,coalesce,collationproperty,' +
    'columnproperty,col_length,col_name,convert,cos,cot,count,' +
    'count_big,current_date,current_time,current_timestamp,' +
    'current_user,cursor_status,databaseproperty,databasepropertyex,' +
    'datalength,dateadd,datediff,datename,datepart,day,db_id,db_name,degrees,' +
    'difference,exp,filegroupproperty,filegroup_id,filegroup_name,' +
    'fileproperty,file_id,file_name,floor,fn_helpcollations,' +
    'fn_listextendedproperty,fn_servershareddrives,fn_trace_geteventinfo,' +
    'fn_trace_getfilterinfo,fn_trace_getinfo,fn_trace_gettable,' +
    'fn_virtualfilestats,formatmessage,fulltextcatalogproperty,' +
    'fulltextserviceproperty,getansinull,getdate,getutcdate,grouping,' +
    'has_dbaccess,host_id,host_name,ident_current,ident_incr,ident_seed,' +
    'indexkey_property,indexproperty,index_col,isdate,isnull,isnumeric,' +
    'is_member,is_srvrolemember,len,log,log10,lower,ltrim,max,min,month,' +
    'newid,objectproperty,object_id,object_name,parsename,patindex,' +
    'permissions,pi,power,quotename,radians,rand,replace,replicate,reverse,' +
    'round,rowcount_big,rtrim,scope_identity,serverproperty,sessionproperty,' +
    'sign,sin,soundex,space,sql_variant_property,sqrt,square,' +
    'stats_date,stdev,stdevp,str,stuff,substring,sum,suser_sid,suser_sname,' +
    'system_user,tan,textptr,textvalid,typeproperty,unicode,upper,' +
    'user_id,user_name,var,varp,year';

  // types
  MSSQL2000Types: WideString =
    'bigint,binary,bit,char,character,datetime,' +
    'dec,decimal,float,image,int,' +
    'integer,money,nchar,ntext,numeric,nvarchar,real,' +
    'rowversion,smalldatetime,smallint,smallmoney,' +
    'sql_variant,sysname,text,timestamp,tinyint,uniqueidentifier,' +
    'varbinary,varchar';

//---Interbase 6----------------------------------------------------------------
  // functions
  Interbase6Functions: WideString = 'avg,cast,count,gen_id,max,min,sum,upper';

  // keywords
  Interbase6KW: WideString = 'active,add,after,all,alter,and,any,as,asc,' +
    'ascending,at,auto,autoddl,based,basename,base_name,before,begin,between,' +
    'blobedit,buffer,by,cache,character_length,char_length,check,' +
    'check_point_len,check_point_length,collate,collation,column,commit,' +
    'commited,compiletime,computed,close,conditional,connect,constraint,' +
    'containing,continue,create,current,current_date,current_time,' +
    'current_timestamp,cursor,database,day,db_key,debug,dec,declare,default,' +
    'delete,desc,descending,describe,descriptor,disconnect,distinct,do,' +
    'domain,drop,echo,edit,else,end,entry_point,escape,event,exception,' +
    'execute,exists,exit,extern,external,extract,fetch,file,filter,for,' +
    'foreign,found,from,full,function,gdscode,generator,global,goto,grant,' +
    'group,group_commit_wait,group_commit_wait_time,having,help,hour,if,' +
    'immediate,in,inactive,index,indicator,init,inner,input,input_type,' +
    'insert,int,into,is,isolation,isql,join,key,lc_messages,lc_type,left,' +
    'length,lev,level,like,logfile,log_buffer_size,log_buf_size,long,manual,' +
    'maximum,maximum_segment,max_segment,merge,message,minimum,minute,' +
    'module_name,month,names,national,natural,nchar,no,noauto,not,null,' +
    'num_log_buffs,num_log_buffers,octet_length,of,on,only,open,option,or,' +
    'order,outer,output,output_type,overflow,page,pagelength,pages,page_size,' +
    'parameter,password,plan,position,post_event,precision,prepare,procedure,' +
    'protected,primary,privileges,public,quit,raw_partitions,read,real,' +
    'record_version,references,release,reserv,reserving,retain,return,' +
    'returning_values,returns,revoke,right,rollback,runtime,schema,second,' +
    'segment,select,set,shadow,shared,shell,show,singular,size,snapshot,some,' +
    'sort,sql,sqlcode,sqlerror,sqlwarning,stability,starting,starts,' +
    'statement,static,statistics,sub_type,suspend,table,terminator,then,to,' +
    'transaction,translate,translation,trigger,trim,type,uncommitted,union,' +
    'unique,update,user,using,value,values,variable,varying,version,view,' +
    'wait,weekday,when,whenever,where,while,with,work,write,year,yearday';

  // types
  Interbase6Types: WideString =
    'blob,char,character,date,decimal,double,float,integer,' +
    'numeric,smallint,time,timestamp,varchar';

//---MySQL----------------------------------------------------------------------
  // keywords
  MySqlKW: WideString = 'action,after,against,aggregate,all,alter,analyze,and,as,' +
    'asc,auto_increment,avg_row_length,backup,begin,benchmark,between,binary,' +
    'bit,bool,both,by,cascade,change,character,check,checksum,column,columns,' +
    'comment,commit,constraint,create,cross,data,databases,dec,default,' +
    'delayed,delay_key_write,delete,desc,describe,distinct,distinctrow,drop,' +
    'else,enclosed,end,escape,escaped,exists,explain,fields,file,first,' +
    'float4,float8,flush,for,foreign,from,full,fulltext,function,global,grant,' +
    'grants,group,having,heap,high_priority,hosts,identified,ignore,' +
    'index,infile,inner,int1,int2,int3,int4,int8,into,is,isam,join,key,' +
    'keys,kill,leading,like,limit,lines,load,local,lock,logs,long,' +
    'low_priority,match,max_rows,middleint,min_rows,modify,myisam,' +
    'natural,no,not,null,optimize,option,optionally,on,open,or,order,outer,' +
    'outfile,pack_keys,partial,precision,primary,privileges,procedure,' +
    'process,processlist,read,references,regexp,reload,rename,repair,' +
    'restrict,restore,returns,revoke,rlike,rollback,row,rows,select,show,' +
    'shutdown,soname,sql_big_result,sql_big_selects,sql_big_tables,' +
    'sql_log_off,sql_log_update,sql_low_priority_updates,sql_select_limit,' +
    'sql_small_result,sql_warnings,starting,status,straight_join,table,' +
    'tables,temporary,terminated,then,to,trailing,transaction,type,unique,' +
    'unlock,unsigned,update,usage,use,using,values,varbinary,varchar,' +
    'variables,varying,where,with,write,zerofill';

  // types
  MySqlTypes: WideString =
    'tinyint,smallint,mediumint,int,integer,bigint,float,' +
    'double,real,decimal,numeric,date,datetime,timestamp,time,year,char,' +
    'national,tinyblob,tinytext,text,blob,mediumblob,mediumtext,longblob,' +
    'longtext,enum,set,string';

  // functions
  MySqlFunctions: WideString =
    'abs,acos,ascii,add,adddate,asin,atan,atan2,avg,' +
    'bin,bit_and,bit_count,bit_or,case,character_length,ceiling,' +
    'connection_id,char_length,coalesce,concat,conv,cos,cot,count,' +
    'curdate,current_date,current_time,current_timestamp,curtime,database,' +
    'date_add,date_format,date_sub,day,dayname,dayofmonth,dayofweek,' +
    'dayofyear,day_hour,day_minute,day_second,decode,degrees,elt,encode,' +
    'encrypt,exp,export_set,field,find_in_set,floor,format,from_days,' +
    'from_unixtime,get_lock,greatest,hex,hour,hour_minute,hour_second,if,' +
    'ifnull,in,inet_ntoa,inet_aton,insert,insert_id,instr,interval,isnull,' +
    'last_insert_id,lcase,least,left,length,load_file,locate,log,log10,lower,' +
    'lpad,ltrim,make_set,master_pos_wait,max,md5,mid,min,minute,' +
    'minute_second,mod,month,monthname,now,nullif,oct,octet_length,ord,' +
    'password,period_add,period_diff,pi,position,pow,power,quarter,radians,' +
    'rand,release_lock,repeat,replace,reverse,right,round,rpad,rtrim,second,' +
    'sec_to_time,session_user,sign,sin,soundex,space,sqrt,std,stddev,strcmp,' +
    'subdate,substring,substring_index,sum,sysdate,system_user,tan,' +
    'time_format,time_to_sec,to_days,trim,truncate,ucase,unix_timestamp,' +
    'upper,user,version,week,weekday,when,yearweek,year_month';

//---Ingres---------------------------------------------------------------------
  // keywords
  IngresKW: WideString =
    'abort,activate,add,addform,after,aggregate,all,alter,and,append,array,' +
    'as,asc,at,audit_log,authorization,autocommit,avgu,before,begin,between,' +
    'breakdisplay,by,byref,cache,call,callframe,callproc,cascade,check,clear,' +
    'clearrow,close,column,command,comment,commit,connect,constraint,' +
    'continue,copy,countu,cpufactor,create,current,current_user,cursor,data,' +
    'datahandler,date_format,dbevent,ddl_concurrency,deadlock,declare,' +
    'default,deferred,define,delete,deleterow,desc,describe,descriptor,' +
    'destroy,direct,disable,disconnect,display,distinct,distribute,do,down,' +
    'drop,else,elseif,enable,end,enddata,enddisplay,endforms,endif,endloop,' +
    'endretrieve,endselect,endwhile,error,escape,exclude,excluding,exec,' +
    'execute,exists,exit,fetch,field,finalize,for,foreign,formdata,forminit,' +
    'forms,from,full,get,getform,getoper,getrow,global,goto,grant,granted,' +
    'having,help,help_forms,help_frs,helpfile,identified,if,iimessage,' +
    'iiprintf,iiprompt,iistatement,immediate,import,in,include,index,' +
    'indicator,ingres,initialize,inittable,inner,inquire_equel,inquire_forms,' +
    'inquire_frs,inquire_ingres,insert,insertrow,installation,integrity,into,' +
    'io_trace,is,j_freesz1,j_freesz2,j_freesz3,j_freesz4,j_sortbufsz,' +
    'jcpufactor,join,joinop,journaling,key,level,like,link,loadtable,local,' +
    'location,lock_trace,log_trace,logdbevents,logging,maxcost,maxcpu,' +
    'maxpage,menuitem,message,mode,modify,module,money_format,money_prec,' +
    'move,natural,next,nodeadlock,noecho,noio_trace,nojionop,nojournaling,' +
    'nolock_trace,nolog_trace,nologdbevents,nologging,nomaxcost,nomaxcpu,' +
    'nomaxio,nomaxpage,nomaxquery,nomaxrow,nooptimizeonly,noprintdbevents,' +
    'noprintqry,noprintrules,noqep,norules,nosql,nostatistics,not,notrace,' +
    'null,of,on,only,open,optimizeonly,option,or,order,out,param,permit,' +
    'prepare,preserve,primary,print,printdbevents,printqry,printscreen,' +
    'privileges,procedure,prompt,public,put,putform,putoper,putrow,qbufsize,' +
    'qep,qry,qualification,query_size,raise,range,readonly,redisplay,' +
    'references,referencing,register,relocate,remove,rename,repeat,repeated,' +
    'replace,replicate,restrict,result_structure,resume,ret_into,retrieve,' +
    'return,returning,revoke,rollback,rows,rule,run,save,savepoint,schema,' +
    'screen,scroll,scrolldown,scrollup,section,security_alarm,security_audit,' +
    'select,session,set,set_4gl,set_equal,set_forms,set_frs,set_ingres,' +
    'set_sql,short_remark,sleep,some,sort,sortbufsize,sql,statistics,stop,' +
    'submenu,sumu,synonym,system,table,tabledata,tewmporary,then,to,trace,' +
    'transaction,type,union,unique,unloadtable,until,up,update,user,using,' +
    'validate,validrow,values,view,when,whenever,where,while,with,work';

  // types
  IngresTypes: WideString =
    'byte,c,char,character,date,decimal,float,float4,float8,integer,integer1,' +
    'integer2,integer4,long,money,object_key,security_label,short,smallint,' +
    'table_key,text,varchar,varying';

  // functions
  IngresFunctions: WideString =
    '_bintim,_cpu_ms,_date,_dio_cnt,_et_sec,_pfault_cnt,_time,_version,abs,' +
    'any,atan,autocommit_state,avg,biocnt,charextract,collation,concat,' +
    'connect_time_limit,cos,count,create_procedure,create_table,database,' +
    'date_gmt,date_part,date_trunc,db_admin,db_delimited_case,db_name_case,' +
    'dba,dbms_bio,dbms_cpu,dbms_dio,dbmsinfo,dow,exp,flatten_aggregate,' +
    'flatten_none,flatten_optimize,flatten_singleton,group,hex,' +
    'idle_time_limit,ifnull,initial_user,inquire_sql,int1,int2,int4,interval,' +
    'language,left,length,locate,lockmode,log,long_byte,long_varchar,' +
    'lowercase,max,maxconnect,maxidle,maxio,maxquery,maxrow,min,mod,notrim,' +
    'on_error_state,pad,query_io_limit,query_language,query_row_limit,right,' +
    'role,security_audit_log,security_audit_state,security_priv,' +
    'select_syscat,server_class,session_id,session_priority,' +
    'session_priority_limit,session_priv,session_seclabel,session_user,shift,' +
    'sin,size,sqrt,squeeze,sum,system_user,table_statistics,terminal,' +
    'transaction_state,trim,update_rowcnt,update_syscat,uppercase,username,' +
    'varbyte';

function TSynSQLSyn.HashKey(Str: PWideChar): Integer;

  function GetOrd: Integer;
  begin
    case Str^ of
      '_': Result := 1;
      'a'..'z': Result := 2 + Ord(Str^) - Ord('a');
      'A'..'Z': Result := 2 + Ord(Str^) - Ord('A');
      '@':
        if fDialect in [sqlMSSQL7, sqlMSSQL2K] then
          Result := 24
        else
          Result := 0;
      else Result := 0;
    end;
  end;

begin
  Result := 0;
  while IsIdentChar(Str^) do
  begin
{$IFOPT Q-}
    Result := 2 * Result + GetOrd;
{$ELSE}
    Result := (2 * Result + GetOrd) and $FFFFFF;
{$ENDIF}
    inc(Str);
  end;
  Result := Result and $FF; // 255
  fStringLen := Str - fToIdent;
end;

function TSynSQLSyn.IdentKind(MayBe: PWideChar): TtkTokenKind;
var
  Entry: TSynHashEntry;
begin
  fToIdent := MayBe;
  Entry := fKeywords[HashKey(MayBe)];
  while Assigned(Entry) do
  begin
    if Entry.KeywordLen > fStringLen then
      break
    else if Entry.KeywordLen = fStringLen then
      if IsCurrentToken(Entry.Keyword) then
      begin
        Result := TtkTokenKind(Entry.Kind);
        exit;
      end;
    Entry := Entry.Next;
  end;
  Result := tkIdentifier;
end;

constructor TSynSQLSyn.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);

  fCaseSensitive := False;

  fKeywords := TSynHashEntryList.Create;
  fTableNames := TWideStringList.Create;
  TWideStringList(fTableNames).OnChange := TableNamesChanged;
  fCommentAttri := TSynHighlighterAttributes.Create(SYNS_AttrComment, SYNS_FriendlyAttrComment);
  fCommentAttri.Style := [fsItalic];
  AddAttribute(fCommentAttri);
  fConditionalCommentAttri := TSynHighlighterAttributes.Create(SYNS_AttrConditionalComment, SYNS_FriendlyAttrConditionalComment);
  fConditionalCommentAttri.Style := [fsItalic];
  AddAttribute(fConditionalCommentAttri);
  
  fDataTypeAttri := TSynHighlighterAttributes.Create(SYNS_AttrDataType, SYNS_FriendlyAttrDataType);
  fDataTypeAttri.Style := [fsBold];
  AddAttribute(fDataTypeAttri);
  fDefaultPackageAttri :=
    TSynHighlighterAttributes.Create(SYNS_AttrDefaultPackage, SYNS_FriendlyAttrDefaultPackage);
  fDefaultPackageAttri.Style := [fsBold];
  AddAttribute(fDefaultPackageAttri);
  fDelimitedIdentifierAttri := TSynHighlighterAttributes.Create(SYNS_AttrDelimitedIdentifier, SYNS_FriendlyAttrDelimitedIdentifier);
  AddAttribute(fDelimitedIdentifierAttri);  
  fExceptionAttri := TSynHighlighterAttributes.Create(SYNS_AttrException, SYNS_FriendlyAttrException);
  fExceptionAttri.Style := [fsItalic];
  AddAttribute(fExceptionAttri);
  fFunctionAttri := TSynHighlighterAttributes.Create(SYNS_AttrFunction, SYNS_FriendlyAttrFunction);
  fFunctionAttri.Style := [fsBold];
  AddAttribute(fFunctionAttri);
  fIdentifierAttri := TSynHighlighterAttributes.Create(SYNS_AttrIdentifier, SYNS_FriendlyAttrIdentifier);
  AddAttribute(fIdentifierAttri);
  fKeyAttri := TSynHighlighterAttributes.Create(SYNS_AttrReservedWord, SYNS_FriendlyAttrReservedWord);
  fKeyAttri.Style := [fsBold];
  AddAttribute(fKeyAttri);
  fNumberAttri := TSynHighlighterAttributes.Create(SYNS_AttrNumber, SYNS_FriendlyAttrNumber);
  AddAttribute(fNumberAttri);
  fPLSQLAttri := TSynHighlighterAttributes.Create(SYNS_AttrPLSQL, SYNS_FriendlyAttrPLSQL);
  fPLSQLAttri.Style := [fsBold];
  AddAttribute(fPLSQLAttri);
  fSpaceAttri := TSynHighlighterAttributes.Create(SYNS_AttrSpace, SYNS_FriendlyAttrSpace);
  AddAttribute(fSpaceAttri);
  fSQLPlusAttri:=TSynHighlighterAttributes.Create(SYNS_AttrSQLPlus, SYNS_FriendlyAttrSQLPlus);
  fSQLPlusAttri.Style := [fsBold];
  AddAttribute(fSQLPlusAttri);
  fStringAttri := TSynHighlighterAttributes.Create(SYNS_Attrstring, SYNS_FriendlyAttrstring);
  AddAttribute(fStringAttri);
  fSymbolAttri := TSynHighlighterAttributes.Create(SYNS_AttrSymbol, SYNS_FriendlyAttrSymbol);
  AddAttribute(fSymbolAttri);
  fTableNameAttri := TSynHighlighterAttributes.Create(SYNS_AttrTableName, SYNS_FriendlyAttrTableName);
  AddAttribute(fTableNameAttri);
  fVariableAttri := TSynHighlighterAttributes.Create(SYNS_AttrVariable, SYNS_FriendlyAttrVariable);
  AddAttribute(fVariableAttri);
  SetAttributesOnChange(DefHighlightChange);
  fDefaultFilter := SYNS_FilterSQL;
  fRange := rsUnknown;
  fDialect := sqlStandard;
  InitializeKeywordLists;
end;

destructor TSynSQLSyn.Destroy;
begin
  fKeywords.Free;
  fTableNames.Free;
  inherited Destroy;
end;

procedure TSynSQLSyn.Assign(Source: TPersistent);
begin
  inherited Assign(Source);
  if (Source is TSynSQLSyn) then
    SQLDialect := TSynSQLSyn(Source).SQLDialect;
end;

procedure TSynSQLSyn.AndSymbolProc;
begin
  fTokenID := tkSymbol;
  Inc(Run);
  if fLine[Run] in [WideChar('='), WideChar('&')] then Inc(Run);
end;

procedure TSynSQLSyn.AsciiCharProc;
begin
  // Oracle SQL allows strings to go over multiple lines
  if fLine[Run] = #0 then
    NullProc
  else begin
    fTokenID := tkString;
    // else it's end of multiline string
    if SQLDialect <> sqlMySql then
    begin
      if (Run > 0) or (fRange <> rsString) or (fLine[Run] <> #39) then
      begin
        fRange := rsString;
        repeat
          Inc(Run);
        until IsLineEnd(fLine[Run]) or (fLine[Run] = #39);
      end;
      if fLine[Run] = #39 then
      begin
        Inc(Run);
        fRange := rsUnknown;
      end;
    end
    else
    begin
      if (Run > 0) or (fRange <> rsString) or
        ((fLine[Run] <> #39) and (fLine[Run - 1] <> '\')) then
      begin
        fRange := rsString;
        repeat
          if (fLine[Run] <> '\') and (fLine[Run + 1] = #39) then
          begin
            Inc(Run);
            break;
          end;
          Inc(Run);
        until IsLineEnd(fLine[Run]);
      end;
      if (fLine[Run] = #39) and not(fLine[Run-1] = '\') then
      begin
        Inc(Run);
        fRange := rsUnknown;
      end;
    end;
  end;
end;

procedure TSynSQLSyn.CRProc;
begin
  fTokenID := tkSpace;
  Inc(Run);
  if fLine[Run] = #10 then Inc(Run);
end;

procedure TSynSQLSyn.EqualProc;
begin
  fTokenID := tkSymbol;
  Inc(Run);
  if fLine[Run] in [WideChar('='), WideChar('>')] then Inc(Run);
end;

procedure TSynSQLSyn.GreaterProc;
begin
  fTokenID := tkSymbol;
  Inc(Run);
  if fLine[Run] in [WideChar('='), WideChar('>')] then Inc(Run);
end;

procedure TSynSQLSyn.IdentProc;
begin
  fTokenID := IdentKind((fLine + Run));
  inc(Run, fStringLen);
  if fTokenID = tkComment then
  begin
    while not IsLineEnd(fLine[Run]) do
      Inc(Run);
  end
  else
    while IsIdentChar(fLine[Run]) do inc(Run);
end;

procedure TSynSQLSyn.LFProc;
begin
  fTokenID := tkSpace;
  inc(Run);
end;

procedure TSynSQLSyn.LowerProc;
begin
  fTokenID := tkSymbol;
  Inc(Run);
  case fLine[Run] of
    '=': Inc(Run);
    '<': begin
           Inc(Run);
           if fLine[Run] = '=' then Inc(Run);
         end;
  end;
end;

procedure TSynSQLSyn.MinusProc;
begin
  Inc(Run);
  if fLine[Run] = '-' then
  begin
    fTokenID := tkComment;
    repeat
      Inc(Run);
    until IsLineEnd(fLine[Run]);
  end
  else
    fTokenID := tkSymbol;
end;

procedure TSynSQLSyn.HashProc;
begin
  if SQLDialect = sqlMySql then
  begin
    fTokenID := tkComment;
    repeat
      Inc(Run);
    until IsLineEnd(fLine[Run]);
  end
  else
  begin
    Inc(Run);
    fTokenID := tkUnknown;
  end;
end;

procedure TSynSQLSyn.NullProc;
begin
  fTokenID := tkNull;
end;

procedure TSynSQLSyn.NumberProc;

  function IsNumberChar: Boolean;
  begin
    case fLine[Run] of
      '0'..'9', '.', '-':
        Result := True;
      else
        Result := False;
    end;
  end;

begin
  inc(Run);
  fTokenID := tkNumber;
  while IsNumberChar do
  begin
    case FLine[Run] of
      '.':
        if FLine[Run + 1] = '.' then break;
    end;
    inc(Run);
  end;
end;

procedure TSynSQLSyn.OrSymbolProc;
begin
  fTokenID := tkSymbol;
  Inc(Run);
  if fLine[Run] in [WideChar('='), WideChar('|')] then Inc(Run);
end;

procedure TSynSQLSyn.PlusProc;
begin
  fTokenID := tkSymbol;
  Inc(Run);
  if fLine[Run] in [WideChar('='), WideChar('+')] then Inc(Run);
end;

procedure TSynSQLSyn.SlashProc;
begin
  Inc(Run);
  case fLine[Run] of
    '*':
      begin
        if (SQLDialect = sqlMySql) and (fLine[Run + 1] = '!') then
        begin
          fRange := rsConditionalComment;
          fTokenID := tkConditionalComment;
        end
        else
        begin
          fRange := rsComment;
          fTokenID := tkComment;
        end;
        repeat
          Inc(Run);
          if (fLine[Run] = '*') and (fLine[Run + 1] = '/') then begin
            fRange := rsUnknown;
            Inc(Run, 2);
            break;
          end;
        until IsLineEnd(fLine[Run]);
      end;
    '=':
      begin
        Inc(Run);
        fTokenID := tkSymbol;
      end;
    else
      fTokenID := tkSymbol;
  end;
end;

procedure TSynSQLSyn.SpaceProc;
begin
  inc(Run);
  fTokenID := tkSpace;
  while (FLine[Run] <= #32) and not IsLineEnd(FLine[Run]) do inc(Run);
end;

procedure TSynSQLSyn.QuoteProc;
begin
  fTokenID := tkDelimitedIdentifier;
  Inc(Run);
  while not IsLineEnd(fLine[Run]) do
  begin
    if fLine[Run] = #34 then
    begin
      Inc(Run);
      if fLine[Run] <> #34 then
        Break;
    end;
    Inc(Run);
  end;
end;

procedure TSynSQLSyn.BacktickProc;
begin
  if SQLDialect = sqlMySql then
  begin
    fTokenID := tkDelimitedIdentifier;
    Inc(Run);
    while not IsLineEnd(fLine[Run]) do
    begin
      if fLine[Run] = '`' then
      begin
        Inc(Run);
        if fLine[Run] <> '`' then
          Break;
      end;
      Inc(Run);
    end;
  end
  else
  begin
    Inc(Run);
    fTokenID := tkUnknown;
  end;
end;

procedure TSynSQLSyn.BracketProc;
begin
  if SQLDialect in [sqlMSSQL7, sqlMSSQL2K] then
  begin
    fTokenID := tkDelimitedIdentifier;
    Inc(Run);
    while not IsLineEnd(fLine[Run]) do
    begin
      if fLine[Run] = ']' then
      begin
        Inc(Run);
        if fLine[Run] <> ']' then
          Break;
      end;
      Inc(Run);
    end;
  end
  else
  begin
    Inc(Run);
    fTokenID := tkSymbol;
  end;
end;

procedure TSynSQLSyn.SymbolProc;
begin
  Inc(Run);
  fTokenID := tkSymbol;
end;

procedure TSynSQLSyn.SymbolAssignProc;
begin
  fTokenID := tkSymbol;
  Inc(Run);
  if fLine[Run] = '=' then Inc(Run);
end;

procedure TSynSQLSyn.VariableProc;
var
  i: integer;
begin
  // MS SQL Server uses @@ to indicate system functions/variables
  if (SQLDialect in [sqlMSSQL7, sqlMSSQL2K]) and (fLine[Run] = '@') and (fLine[Run + 1] = '@') then
    IdentProc
  else if (SQLDialect in [sqlMySql, sqlOracle]) and (fLine[Run] = '@') then
    SymbolProc
  // Oracle uses the ':' character to indicate bind variables
  // Ingres II also uses the ':' character to indicate variables
  else if not (SQLDialect in [sqlOracle, sqlIngres]) and (fLine[Run] = ':') then
    SymbolProc
  else
  begin
    fTokenID := tkVariable;
    i := Run;
    repeat
      Inc(i);
    until not IsIdentChar(fLine[i]);
    Run := i;
  end;
end;

procedure TSynSQLSyn.UnknownProc;
begin
  Inc(Run);
  fTokenID := tkUnknown;
end;

procedure TSynSQLSyn.AnsiCProc;
begin
  case fLine[Run] of
     #0: NullProc;
    #10: LFProc;
    #13: CRProc;
    else
    begin
      if fRange = rsConditionalComment then
        fTokenID := tkConditionalComment
      else
        fTokenID := tkComment;
      repeat
        if (fLine[Run] = '*') and (fLine[Run + 1] = '/') then
        begin
          fRange := rsUnknown;
          Inc(Run, 2);
          Break;
        end;
        Inc(Run);
      until IsLineEnd(fLine[Run]);
    end;
  end;
end;

function TSynSQLSyn.IsKeyword(const AKeyword: WideString): Boolean;
var
  tk: TtkTokenKind;
begin
  tk := IdentKind(PWideChar(AKeyword));
  Result := tk in [tkDatatype, tkException, tkFunction, tkKey, tkPLSQL,
    tkDefaultPackage];
end;

procedure TSynSQLSyn.Next;
begin
  fTokenPos := Run;
  case fRange of
    rsComment, rsConditionalComment:
      AnsiCProc;
    rsString:
      AsciiCharProc;
  else
    case fLine[Run] of
      #0: NullProc;
      #10: LFProc;
      #13: CRProc;
      #39: AsciiCharProc;
      '=': EqualProc;
      '>': GreaterProc;
      '<': LowerProc;
      '-': MinusProc;
      '#': HashProc;
      '|': OrSymbolProc;
      '+': PlusProc;
      '/': SlashProc;
      '&': AndSymbolProc;
      #34: QuoteProc;
      '`': BacktickProc;
      '[': BracketProc;
      ':', '@': VariableProc;
      'A'..'Z', 'a'..'z', '_': IdentProc;
      '0'..'9': NumberProc;
      #1..#9, #11, #12, #14..#32: SpaceProc;
      '^', '%', '*', '!': SymbolAssignProc;
      '{', '}', '.', ',', ';', '?', '(', ')', ']', '~': SymbolProc;
      else UnknownProc;
    end;
  end;
end;

function TSynSQLSyn.GetDefaultAttribute(Index: integer):
  TSynHighlighterAttributes;
begin
  case Index of
    SYN_ATTR_COMMENT: Result := fCommentAttri;
    SYN_ATTR_IDENTIFIER: Result := fIdentifierAttri;
    SYN_ATTR_KEYWORD: Result := fKeyAttri;
    SYN_ATTR_STRING: Result := fStringAttri;
    SYN_ATTR_WHITESPACE: Result := fSpaceAttri;
    SYN_ATTR_SYMBOL: Result := fSymbolAttri;
  else
    Result := nil;
  end;
end;

function TSynSQLSyn.GetEol: Boolean;
begin
  Result := fTokenID = tkNull;
end;

function TSynSQLSyn.GetRange: Pointer;
begin
  Result := Pointer(fRange);
end;

function TSynSQLSyn.GetTokenID: TtkTokenKind;
begin
  Result := fTokenId;
end;

function TSynSQLSyn.GetTokenAttribute: TSynHighlighterAttributes;
begin
  case GetTokenID of
    tkComment: Result := fCommentAttri;
    tkConditionalComment: Result := fConditionalCommentAttri;
    tkDatatype: Result := fDataTypeAttri;
    tkDefaultPackage: Result := fDefaultPackageAttri;
    tkDelimitedIdentifier: Result := fDelimitedIdentifierAttri;
    tkException: Result := fExceptionAttri;
    tkFunction: Result := fFunctionAttri;
    tkIdentifier: Result := fIdentifierAttri;
    tkKey: Result := fKeyAttri;
    tkNumber: Result := fNumberAttri;
    tkPLSQL: Result := fPLSQLAttri;
    tkSpace: Result := fSpaceAttri;
    tkSQLPlus: Result := fSQLPlusAttri;
    tkString: Result := fStringAttri;
    tkSymbol: Result := fSymbolAttri;
    tkTableName: Result := fTableNameAttri;
    tkVariable: Result := fVariableAttri;
    tkUnknown: Result := fIdentifierAttri;
  else
    Result := nil;
  end;
end;

function TSynSQLSyn.GetTokenKind: integer;
begin
  Result := Ord(fTokenId);
end;

procedure TSynSQLSyn.ResetRange;
begin
  fRange := rsUnknown;
end;

procedure TSynSQLSyn.SetRange(Value: Pointer);
begin
  fRange := TRangeState(Value);
end;

function TSynSQLSyn.IsFilterStored: Boolean;
begin
  Result := fDefaultFilter <> SYNS_FilterSQL;
end;

function TSynSQLSyn.IsIdentChar(AChar: WideChar): Boolean;
begin
  case AChar of
    'a'..'z', 'A'..'Z', '0'..'9', '_':
      Result := True;
    '-':
      Result := fDialect = sqlStandard;
    '#', '$':                          // TODO: check this case, ANSI code wasn't clear here if this is exclusively Oracle
      Result := fDialect = sqlOracle;
    '@':
      Result := fDialect in [sqlMSSQL7, sqlMSSQL2K];
    else
      Result := False;
  end;
end;

class function TSynSQLSyn.GetLanguageName: string;
begin
  Result := SYNS_LangSQL;
end;

procedure TSynSQLSyn.DoAddKeyword(AKeyword: WideString; AKind: integer);
var
  HashValue: Integer;
begin
  HashValue := HashKey(PWideChar(AKeyword));
  fKeywords[HashValue] := TSynHashEntry.Create(AKeyword, AKind);
end;

procedure TSynSQLSyn.SetTableNames(const Value: TWideStrings);
begin
  fTableNames.Assign(Value);
end;

procedure TSynSQLSyn.TableNamesChanged(Sender: TObject);
begin
  InitializeKeywordLists;
end;

procedure TSynSQLSyn.PutTableNamesInKeywordList;
var
  i: Integer;
  Entry: TSynHashEntry;
begin
  for i := 0 to fTableNames.Count - 1 do
  begin
    Entry := fKeywords[HashKey(PWideChar(fTableNames[i]))];
    while Assigned(Entry) do
    begin
      if SynWideUpperCase(Entry.Keyword) = SynWideUpperCase(fTableNames[i]) then
        Break;
      Entry := Entry.Next;
    end;
    if not Assigned(Entry) then
      DoAddKeyword(fTableNames[i], Ord(tkTableName));
  end;
end;

procedure TSynSQLSyn.InitializeKeywordLists;
begin
  fKeywords.Clear;

  case fDialect of
    sqlIngres:
      begin
        EnumerateKeywords(Ord(tkDatatype), IngresTypes, IsIdentChar,
          DoAddKeyword);
        EnumerateKeywords(Ord(tkKey), IngresKW, IsIdentChar, DoAddKeyword);
        EnumerateKeywords(Ord(tkFunction), IngresFunctions, IsIdentChar,
          DoAddKeyword);
      end;
    sqlInterbase6:
      begin
        EnumerateKeywords(Ord(tkDatatype), Interbase6Types, IsIdentChar,
          DoAddKeyword);
        EnumerateKeywords(Ord(tkFunction), Interbase6Functions, IsIdentChar,
          DoAddKeyword);
        EnumerateKeywords(Ord(tkKey), Interbase6KW, IsIdentChar, DoAddKeyword);
      end;
    sqlMSSQL7:
      begin
        EnumerateKeywords(Ord(tkKey), MSSQL7KW, IsIdentChar, DoAddKeyword);
        EnumerateKeywords(Ord(tkDatatype), MSSQL7Types, IsIdentChar,
          DoAddKeyword);
        EnumerateKeywords(Ord(tkFunction), MSSQL7Functions, IsIdentChar,
          DoAddKeyword);
      end;
    sqlMSSQL2K:
      begin
        EnumerateKeywords(ord(tkKey), MSSQL2000KW, IsIdentChar, DoAddKeyword);
        EnumerateKeywords(ord(tkDataType), MSSQL2000Types, IsIdentChar, DoAddKeyword);
        EnumerateKeywords(ord(tkFunction), MSSQL2000Functions, IsIdentChar, DoAddKeyword);
      end;
    sqlMySql:
      begin
        EnumerateKeywords(Ord(tkKey), MySqlKW, IsIdentChar, DoAddKeyword);
        EnumerateKeywords(Ord(tkDatatype), MySqlTypes, IsIdentChar,
          DoAddKeyword);
        EnumerateKeywords(Ord(tkFunction), MySqlFunctions, IsIdentChar,
          DoAddKeyword);
      end;
    sqlOracle:
      begin
        EnumerateKeywords(Ord(tkKey), OracleKW, IsIdentChar, DoAddKeyword);
        EnumerateKeywords(Ord(tkDatatype), OracleTypes, IsIdentChar,
          DoAddKeyword);
        EnumerateKeywords(Ord(tkException), OracleExceptions, IsIdentChar,
          DoAddKeyword);
        EnumerateKeywords(Ord(tkFunction), OracleFunctions, IsIdentChar,
          DoAddKeyword);
        EnumerateKeywords(Ord(tkComment), OracleCommentKW, IsIdentChar,
          DoAddKeyword);
        EnumerateKeywords(Ord(tkDefaultPackage), OracleDefaultPackages,
          IsIdentChar, DoAddKeyword);
        EnumerateKeywords(Ord(tkPLSQL), OraclePLSQLKW, IsIdentChar,
          DoAddKeyword);
        EnumerateKeywords(Ord(tkSQLPlus), OracleSQLPlusCommands, IsIdentChar,
          DoAddKeyword);
      end;
    sqlStandard:
      EnumerateKeywords(Ord(tkKey), StandardKW, IsIdentChar, DoAddKeyword);
    sqlSybase:
      EnumerateKeywords(Ord(tkKey), SybaseKW, IsIdentChar, DoAddKeyword);
  end;
  PutTableNamesInKeywordList;
  DefHighlightChange(Self);
end;

procedure TSynSQLSyn.SetDialect(Value: TSQLDialect);
begin
  if (Value <> fDialect) then
  begin
    fDialect := Value;
    InitializeKeywordLists;
  end;
end;

function TSynSQLSyn.GetSampleSource: WideString;
begin
  Result := '';
  case fDialect of
    sqlStandard:
      Result := '-- ANSI SQL sample source'#13#10 +
        'SELECT *'#13#10 +
        'FROM planets'#13#10 +
        'WHERE diameter < 13000'#13#10 +
        '  AND name <> ''Earth''';
    sqlInterbase6:
      Result := '/* Interbase sample source */'#13#10 +
        'SET TERM !! ;'#13#10 +
        #13#10 +
        'CREATE PROCEDURE HelloWorld(P_MSG VARCHAR(80)) AS'#13#10 +
        'BEGIN'#13#10 +
        '  EXECUTE PROCEDURE WRITELN(:P_MSG);'#13#10 +
        'END !!'#13#10 +
        #13#10 +
        'SET TERM ; !!';
    sqlMySQL:
      Result := '/* MySQL sample source*/'#13#10 +
        'SET @variable = 1;'#13#10 +
        #13#10 +
        'CREATE /*!32302 TEMPORARY */ TABLE t (a INT);'#13#10 +
        #13#10 +
        'CREATE TABLE sample ('#13#10 +
        '        id INT NOT NULL,'#13#10 +
        '        first_name CHAR(30) NOT NULL,'#13#10 +
        '        PRIMARY KEY (id),'#13#10 +
        '        INDEX name (first_name));'#13#10 +
        #13#10 +
        'SELECT DATE_ADD(''1997-12-31 23:59:59'','#13#10 +
        '        INTERVAL 1 SECOND);'#13#10 +
        #13#10 +
        '# End of sample';
    sqlOracle:
      Result := 'PROMPT Oracle sample source'#13#10 +
        'declare'#13#10 +
        '  x varchar2(2000);'#13#10 +
        'begin   -- Show some text here'#13#10 +
        '  select to_char(count(*)) into x'#13#10 +
        '  from tab;'#13#10 +
        #13#10 +
        '  dbms_output.put_line(''Hello World: '' || x);'#13#10 +
        'exception'#13#10 +
        '  when others then'#13#10 +
        '    null;'#13#10 +
        'end;';
    sqlSybase:
      Result := '/* SyBase example source */'#13#10 +
        'declare @Integer        int'#13#10 +
        #13#10 +
        '/* Good for positive numbers only. */'#13#10 +
        'select @Integer = 1000'#13#10 +
        #13#10 +
        'select "Positives Only" ='#13#10 +
        '  right(replicate("0",12) + '#13#10 +
        '    convert(varchar, @Integer),12)'#13#10 +
        #13#10 +
        '/* Good for positive and negative numbers. */'#13#10 +
        'select @Integer = -1000'#13#10 +
        #13#10 +
        'select "Both Signs" ='#13#10 +
        '  substring( "- +", (sign(@Integer) + 2), 1) +'#13#10 +
        '  right(replicate("0",12) + '#13#10 +
        '    convert(varchar, abs(@Integer)),12)'#13#10 +
        #13#10 +
        'select @Integer = 1000'#13#10 +
        #13#10 +
        'select "Both Signs" ='#13#10 +
        '  substring( "- +", (sign(@Integer) + 2), 1) +'#13#10 +
        '  right(replicate("0",12) + '#13#10 +
        '    convert(varchar, abs(@Integer)),12)'#13#10 +
        #13#10 +
        'go';
    sqlIngres:
      Result := '/* Ingres example source */'#13#10 +
        'DELETE'#13#10 +
        'FROM t1'#13#10 +
        'WHERE EXISTS'#13#10 +
        '(SELECT t2.column1, t2.column2'#13#10 +
        'FROM t2'#13#10 +
        'WHERE t1.column1 = t2.column1 and'#13#10 +
        't1.column2 = t2.column2)';
    sqlMSSQL7:
      Result := '/* SQL Server 7 example source */'#13#10 +
        'SET QUOTED_IDENTIFIER ON'#13#10 +
        'GO'#13#10 +
        'SET ANSI_NULLS OFF'#13#10 +
        'GO'#13#10 +
        #13#10 +
        '/* Object:  Stored Procedure dbo.sp_PPQInsertOrder */'#13#10 +
        'CREATE PROCEDURE sp_PPQInsertOrder'#13#10 +
        '  @Name    varchar(25),'#13#10 +
        '  @Address varchar(255),'#13#10 +
        '  @ZipCode varchar(15)'#13#10 +
        'AS'#13#10 +
        '  INSERT INTO PPQOrders(Name, Address, ZipCode, OrderDate)'#13#10 +
        '  VALUES (@Name, @Address, @ZipCode, GetDate())'#13#10 +
        #13#10 +
        '  SELECT SCOPE_IDENTITY()'#13#10 +
        'GO';
    sqlMSSQL2K:
      Result := '/* SQL Server2000 example source */'#13#10 +
        'SET QUOTED_IDENTIFIER ON'#13#10 +
        'GO'#13#10 +
        'SET ANSI_NULLS OFF'#13#10 +
        'GO'#13#10 +
        #13#10 +
        '/* Object:  Stored Procedure dbo.sp_PPQInsertOrder */'#13#10 +
        'CREATE PROCEDURE sp_PPQInsertOrder'#13#10 +
        '  @Name    varchar(25),'#13#10 +
        '  @Address varchar(255),'#13#10 +
        '  @ZipCode varchar(15)'#13#10 +
        'AS'#13#10 +
        '  INSERT INTO PPQOrders(Name, Address, ZipCode, OrderDate)'#13#10 +
        '  VALUES (@Name, @Address, @ZipCode, GetDate())'#13#10 +
        #13#10 +
        '  SELECT SCOPE_IDENTITY()'#13#10 +
        'GO';
  end;
end;

class function TSynSQLSyn.GetFriendlyLanguageName: WideString;
begin
  Result := SYNS_FriendlyLangSQL;
end;

initialization
{$IFNDEF SYN_CPPB_1}
  RegisterPlaceableHighlighter(TSynSQLSyn);
{$ENDIF}
end.
