unit SampleMain;

{ Sample application to use Toolbar2000 and the tb2KEdit customizer dialog }

{
  Steps to using the customizer dialog for your Toolbar2000 application:
   1) Include the tb2kedit unit (and its form) in your app.
   2) Set up your default toolbar at design time with all possibly available buttons
      (the list of available buttons in the customizer is taken from this).
      Note: See additional notes in FormCreate regarding the default set of buttons.
   3) In your toolbar form's Create event, call TB2KInitializeToolbar(),
      passing the Toolbar component name, registry key and/or INI file name,
      and help context ID.
   4) To display the dialog, simply instantiate the form, show it modally,
      then release it.
   5) In your toolbar form's Destroy event, call TB2KShutdownToolbar();
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, ImgList, TB2Item, TB2Dock, TB2Toolbar,
  StdCtrls;

type
  TForm1 = class(TForm)
    PopupMenu1: TPopupMenu;
    Customize1: TMenuItem;
    Cancel1: TMenuItem;
    TBDock1: TTBDock;
    TBToolbar1: TTBToolbar;
    NewBtn: TTBItem;
    OpenBtn: TTBItem;
    SaveBtn: TTBItem;
    ImageList1: TImageList;
    ImageList2: TImageList;
    SmallImages: TRadioButton;
    LargeImages: TRadioButton;
    TBSeparatorItem1: TTBSeparatorItem;
    CutBtn: TTBItem;
    CopyBtn: TTBItem;
    PasteBtn: TTBItem;
    TBSeparatorItem2: TTBSeparatorItem;
    FindBtn: TTBItem;
    PrintBtn: TTBItem;
    procedure Customize1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure SmallImagesClick(Sender: TObject);
    procedure LargeImagesClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses tb2kedit;

const
  TOOLBAR_REG_KEY = '\Software\Software with Brains, Inc.\Sample';
  TOOLBAR_HELP_ID = 0;

{$R *.DFM}

procedure TForm1.Customize1Click(Sender: TObject);
var
  ToolbarEditForm : TToolbarEditForm;
begin
  { Toolbar Edit Form is dynamically created in main app --
    Remember to remove ToolbarEditForm from
    the AutoCreate column in the project options dialog
    when dynamically creating forms.  If you want, you could
    let the application create the form at startup, but it's
    less efficient to keep it hanging around using up resources. }

  ToolbarEditForm := TToolbarEditForm.Create(Application);

  With ToolbarEditForm Do
    begin
      {  Note:  Here you could edit properties of the Toolbar Editor dialog
                such as the form caption, label captions, or button captions.  }
      ShowModal;
      Release;
    end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  { Initialize the toolbar customizer unit:
    Param #1 - The name of the TToolbar component to be customized
    Param #2 - The registry key where the toolbar configuration will be saved
               (this is always under HKEY_CURRENT_USER).  This is not required
               if specifying an INI file.
    Param #3 - The INI file name where the toolbar configuration will be saved.
               This is not required if specifying a registry key.
    Param #4 - The context ID for the help system page to display when the user
                presses F1 while the toolbar customizer dialog is displayed. }

  { Note: When you call TB2KInitializeToolbar at startup, this procedure will
          save the current state of the toolbar at startup as the 'default' state.
          That is, the state of the toolbar buttons (visible or hidden) and the state
          of button captions (toolbar option tboImageAboveCaption) at design time will
          be used as the 'default' state of the toolbar, and the toolbar will be restored
          to this state whenever the Default button is clicked in the customizer dialog. } 
  TB2kInitializeToolbar(TBToolbar1, EmptyStr, ExtractFilePath(Application.EXEName) + 'TB2KEDITOR.INI', TOOLBAR_HELP_ID);
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  { Release all toolbar customizer unit resources -
    call when destroying your main application form. }
  TB2KShutdownToolbar;
end;

procedure TForm1.SmallImagesClick(Sender: TObject);
begin
  { Note: Small vs. Large images is not a property that is saved
          and restored with the toolbar by the customizer.  It is
          simply demonstrated here to show how the customizer
          dialog reacts to and works with each image size.  This option
          is something your app would control and restore. }
  TBToolbar1.Images := ImageList2;
  TBToolbar1.Refresh;
end;

procedure TForm1.LargeImagesClick(Sender: TObject);
begin
  { Note: Small vs. Large images is not a property that is saved
          and restored with the toolbar by the customizer.  It is
          simply demonstrated here to show how the customizer
          dialog reacts to and works with each image size.  This option
          is something your app would control and restore. }
  TBToolbar1.Images := ImageList1;
  TBToolbar1.Refresh;
end;

end.
