unit tb2Kedit;

{ *******************************************************
   Unit:     TB2KEdit
   Purpose:  Toolbar2000 Component Customizer Dialog

   (C)Copyright 2001 Software with Brains, Inc.
   All rights reserved.
   http://www.softwarewithbrains.com
   support@softwarewithbrains.com

   Notices:
   Toolbar2000 component is (C)Copyright Jordan Russell.

   License is granted to use, modify and redistribute
   this unit in your applications as you see fit, as
   long as the copyright notices contained herein remain
   unmodified.  All ownership and copyright for this code
   shall remain with the original author,
   Software with Brains, Inc.
  *******************************************************
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ImgList, ComCtrls, Buttons, StdCtrls, Registry, ExtCtrls, INIFiles,
  TBX;

type
  TToolbarEditForm = class(TForm)
    lstAvailable: TListView;
    lblAvailableList: TLabel;
    lblSelectedList: TLabel;
    btnOK: TButton;
    lstSelected: TListView;
    imgButtons: TImageList;
    btnDefault: TButton;
    Label1: TLabel;
    btnSelect: TButton;
    btnDeselect: TButton;
    Label2: TLabel;
    cboShowCaptions: TComboBox;
    btnMoveUp: TButton;
    btnMoveDn: TButton;
    procedure lstSelectedDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure lstSelectedDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure btnSelectClick(Sender: TObject);
    procedure lstSelectedMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure btnDeselectClick(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure lstAvailableDblClick(Sender: TObject);
    procedure lstSelectedDblClick(Sender: TObject);
    procedure SetAvailableList;
    procedure SetSelectedList;
    procedure btnDefaultClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure lstSelectedEnter(Sender: TObject);
    procedure btnMoveUpClick(Sender: TObject);
    procedure btnMoveDnClick(Sender: TObject);
    procedure lstAvailableEnter(Sender: TObject);
    procedure cboShowCaptionsEnter(Sender: TObject);
    procedure btnSelectEnter(Sender: TObject);
    procedure btnDeselectEnter(Sender: TObject);
    procedure DisableMoveButtons;
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
  public
    { Public declarations }
  published
  end;

var
  ToolbarEditForm: TToolbarEditForm;
  DefaultCommands : TStrings;
  DefaultShowCaptionState : Boolean;

procedure TB2KSaveToolbarButtons(Toolbar : TTBXToolbar);
procedure TB2KSaveToolbarDefaultButtons(Toolbar : TTBXToolbar);
procedure TB2KRestoreToolbarButtons(Toolbar : TTBXToolbar);
procedure TB2KRestoreToolbarDefaultButtons(Toolbar : TTBXToolbar);
procedure TB2KUpdateToolbarDisplay(Toolbar : TTBXToolbar; SelectedCommands : TStrings; ShowCaptions : Boolean);
function  TB2KFindToolbarButton(Toolbar : TTBXToolbar; BtnCaption : String) : Integer;
procedure TB2KInitializeToolbar(Toolbar : TTBXToolbar; RegistryKey, INIFileName : String; HelpContextID : LongInt);
procedure TB2KShutdownToolbar;

implementation

uses frmMain;

const
  { These may be customized to suit your application's needs
    The toolbar button widths are automatic when captions are showing,
    based on the caption widths, but that could be modified as well to
    be static. }
  SMALL_BUTTON_HEIGHT = 22;
  SMALL_BUTTON_WIDTH = 22;
  LARGE_BUTTON_HEIGHT = 44;
  OPT_SHOW_CAPTIONS = 0;
  OPT_NO_CAPTIONS = 1;

var
  ShowCaptions : Boolean;
  SelectedCommands : TStrings;
  tbToolbar : TTBXToolbar;
  sRegistryKey : String;
  sINIFileName : String;
  lHelpContextID : LongInt;

{$R *.DFM}

procedure TToolbarEditForm.DisableMoveButtons;
begin
  btnMoveUp.Enabled := False;
  btnMoveDn.Enabled := False;
end;

procedure TToolbarEditForm.lstSelectedDragDrop(Sender, Source: TObject; X, Y: Integer);
var
  NewListItem : TListItem;
  NewPos : Integer;
begin
  If (Source is TListView) then
    With (Sender as TListView) Do
      begin
        If ((Source as TListView).Selected.Caption <> 'Separator') or (Sender <> lstAvailable) or ((Source as TListView) <> lstSelected) Then
          begin
            If (GetItemAt(X,Y) <> Nil) Then
              NewPos := GetItemAt(X,Y).Index
            Else
              NewPos := Items.Count;

            NewListItem := Items.Insert(NewPos);
            NewListItem.Caption := (Source as TListView).Selected.Caption;
            NewListItem.ImageIndex := (Source as TListView).Selected.ImageIndex;
          end;

        If (((Source as TListView).Selected.Caption <> 'Separator') or (Sender = lstAvailable)) or
           (((Source as TListView).Selected.Caption = 'Separator') and (Sender = lstSelected) and ((Source as TListView) = lstSelected)) Then
        (Source as TListView).Selected.Delete;
      end;
end;

procedure TToolbarEditForm.lstSelectedMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  (Sender as TListView).Selected := (Sender as TListView).GetItemAt(X,Y);
end;

procedure TToolbarEditForm.lstSelectedDragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
  Accept := (Source is TListView);
end;

procedure TToolbarEditForm.btnSelectClick(Sender: TObject);
begin
  If (lstAvailable.Selected <> Nil) Then
    begin
      lstSelectedDragDrop(lstSelected, lstAvailable, $FFFF, $FFFF);
      lstAvailable.SetFocus;
      lstAvailable.Selected := lstAvailable.ItemFocused;
    end;
end;

procedure TToolbarEditForm.btnDeselectClick(Sender: TObject);
begin
  If (lstSelected.Selected <> Nil) Then
    begin
      lstSelectedDragDrop(lstAvailable, lstSelected, $FFFF, $FFFF);
      lstSelected.SetFocus;
      lstSelected.Selected := lstSelected.ItemFocused;
    end;
end;

procedure TToolbarEditForm.btnOKClick(Sender: TObject);
var
  I : Integer;
begin
  SelectedCommands.Clear;
  For I := 0 to lstSelected.Items.Count - 1 Do
    SelectedCommands.Add(lstSelected.Items[I].Caption);

  ShowCaptions := (cboShowCaptions.ItemIndex = OPT_SHOW_CAPTIONS);

  TB2KUpdateToolbarDisplay(tbToolbar, SelectedCommands, ShowCaptions);
  TB2KSaveToolbarButtons(tbToolbar);
  TB2KRestoreToolbarButtons(tbToolbar);

  ModalResult := mrOK;
end;

procedure TToolbarEditForm.btnCancelClick(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

procedure TToolbarEditForm.btnDefaultClick(Sender: TObject);
var
  I : Integer;
  lstItem : TListItem;
  BtnCaption : String;
begin
  lstAvailable.Items.BeginUpdate;
  lstSelected.Items.BeginUpdate;

  lstAvailable.Items.Clear;
  lstSelected.Items.Clear;

  SetAvailableList;

  For I := 0 to DefaultCommands.Count - 1 Do
    begin
      BtnCaption := DefaultCommands[I];
      If BtnCaption = EmptyStr Then BtnCaption := 'Separator';

      lstItem := lstAvailable.FindCaption(0, BtnCaption, False, True, False);

      If (lstItem <> Nil) Then
        begin
          lstAvailable.Selected := lstItem;
          btnSelectClick(btnSelect);
        end;
    end;

  lstAvailable.Items.EndUpdate;
  lstSelected.Items.EndUpdate;

  If (DefaultShowCaptionState) Then
    cboShowCaptions.ItemIndex := OPT_SHOW_CAPTIONS
  Else
    cboShowCaptions.ItemIndex := OPT_NO_CAPTIONS;
end;

procedure TToolbarEditForm.SetSelectedList;
var
  lstItem : TListItem;
  I : Integer;
begin
  lstSelected.Items.BeginUpdate;
  lstAvailable.Items.BeginUpdate;

  lstSelected.SmallImages.Width :=  tbToolbar.Images.Width;
  lstSelected.SmallImages.Height :=  tbToolbar.Images.Height;

  With lstSelected Do
    begin
      Items.Clear;

      { Add the currently displayed (visible) buttons to the selected list. }
      For I := 0 to tbToolbar.Items.Count - 1 Do
        If (tbToolbar.Items[I].Visible) Then
          begin
            lstItem := Nil;

            If (tbToolbar.Items[I] is TTBXItem) Then
              lstItem := lstAvailable.FindCaption(0, (tbToolbar.Items[I] as TTBXItem).Caption, False, True, False);
            If (tbToolbar.Items[I] is TTBXSubmenuItem) Then
              lstItem := lstAvailable.FindCaption(0, (tbToolbar.Items[I] as TTBXSubmenuItem).Caption, False, True, False);
            If (tbToolbar.Items[I] is TTBXVisibilityToggleItem) Then
              lstItem := lstAvailable.FindCaption(0, (tbToolbar.Items[I] as TTBXVisibilityToggleItem).Caption, False, True, False);
            If (tbToolbar.Items[I] is TTBXSeparatorItem) Then
              lstItem := lstAvailable.FindCaption(0, 'Separator', False, True, False);

            If (lstItem <> Nil) Then
              begin
                lstAvailable.Selected := lstItem;
                btnSelectClick(btnSelect);
              end;
          end;
    end;

  lstSelected.Items.EndUpdate;
  lstAvailable.Items.EndUpdate;
end;

procedure TToolbarEditForm.FormCreate(Sender: TObject);
var
  Reg : TRegistry;
  Ini : TIniFile;
begin
  HelpContext := lHelpContextID;

  SelectedCommands := TStringList.Create;
  SelectedCommands.Clear;

  If (sRegistryKey <> EmptyStr) Then
    begin
      Reg := TRegistry.Create;
      With Reg Do
        begin
          Access := KEY_READ or KEY_WRITE;
          RootKey := HKEY_CURRENT_USER;

          If (OpenKey(sRegistryKey, False)) Then
            ShowCaptions := ReadBool('Show Captions');

          Free;
        end;
    end;

  If (sINIFileName <> EmptyStr) Then
    begin
      Ini := TINIFile.Create(sINIFileName);
      With Ini Do
        begin
          ShowCaptions := ReadBool(tbToolbar.Name+'Options', 'Show Captions', False);

          Free;
        end;
    end;
end;

procedure TToolbarEditForm.FormDestroy(Sender: TObject);
begin
  If (SelectedCommands <> Nil) Then SelectedCommands.Free;
  SelectedCommands := Nil;
end;

procedure TToolbarEditForm.lstAvailableDblClick(Sender: TObject);
begin
  btnSelectClick(btnSelect);
end;

procedure TToolbarEditForm.lstSelectedDblClick(Sender: TObject);
begin
  btnDeselectClick(lstSelected);
end;

function TB2KFindToolbarButton(Toolbar : TTBXToolbar; BtnCaption : String) : Integer;
var
  I : Integer;
begin
  Result := -1;

  For I := Toolbar.Items.Count - 1 DownTo 0 Do
    begin
      If ((Toolbar.Items[I] is TTBXSeparatorItem) and (BtnCaption = 'Separator')) Then
        begin
          Result := I;
          break;
        end;
      If (Toolbar.Items[I] is TTBXItem) Then
        begin
          If ((Toolbar.Items[I] as TTBXItem).Caption = BtnCaption) Then
            begin
              Result := I;
              break;
            end;
        end;
      If (Toolbar.Items[I] is TTBXSubmenuItem) Then
        begin
          If ((Toolbar.Items[I] as TTBXSubmenuItem).Caption = BtnCaption) Then
            begin
              Result := I;
              break;
            end;
        end;
      If (Toolbar.Items[I] is TTBXVisibilityToggleItem) Then
        begin
          If ((Toolbar.Items[I] as TTBXVisibilityToggleItem).Caption = BtnCaption) Then
            begin
              Result := I;
              break;
            end;
        end;
    end;
end;

procedure TB2KUpdateToolbarDisplay(Toolbar : TTBXToolbar; SelectedCommands : TStrings; ShowCaptions : Boolean);
var
  I : Integer;
  BtnNum : Integer;
  NewSep : TTBXSeparatorItem;
  MinCaptionWidth : Integer;
begin
  With Toolbar Do
    begin
      BeginUpdate;
      Items.ViewBeginUpdate;

      { Remove all existing separators from the toolbar }
      For I := Toolbar.Items.Count - 1 DownTo 0 Do
        begin
          If (Toolbar.Items[I] is TTBXSeparatorItem) Then
            Toolbar.Items[I].Free;
        end;

      { Start by hiding all existing buttons on the toolbar }
      For I := 0 to Toolbar.Items.Count - 1 Do
        Toolbar.Items[I].Visible := False;

      If (ShowCaptions) Then
        begin
          Height := 60;
          //Options := [tboImageAboveCaption];
        end
      Else
        begin
          Options := [];
        end;

      MinCaptionWidth := 46;

      { Find longest button caption }
      (*
      BtnCanvas := Toolbar.Controls[I].Canvas;
      For I := 0 To SelectedCommands.Count - 1 Do
        If (SelectedCommands[I] <> 'Separator') Then
          begin
            If (BtnCanvas.TextWidth(SelectedCommands[I]) + 4 > MinCaptionWidth) Then
              MinCaptionWidth := BtnCanvas.TextWidth(SelectedCommands[I]) + 4;
          end;
      *)

      For I := 0 To SelectedCommands.Count - 1 Do
        begin
          If (SelectedCommands[I] = 'Separator') Then
            begin
              NewSep := TTBXSeparatorItem.Create(Toolbar);
              NewSep.Name := 'ToolbarSep2K' + IntToStr(I);
              NewSep.ParentComponent := Toolbar;
              NewSep.Blank := False;
              NewSep.Visible := True;
              Toolbar.Items.Insert(I, NewSep);
            end
          Else
            begin
              BtnNum := TB2KFindToolbarButton(Toolbar, SelectedCommands[I]);

              If (BtnNum >= 0) Then
                begin
                  With (Toolbar.Items[BtnNum]) Do
                    begin
                      If (I < Toolbar.Items.Count) Then
                        Toolbar.Items.Move(BtnNum, I)
                      Else
                        Toolbar.Items.Move(BtnNum, I - 1);
                      Visible := True;
                    end;

                  If (Toolbar.Items[BtnNum] is TTBXItem) Then
                    begin
                      With (Toolbar.Items[BtnNum] as TTBXItem) Do
                        begin
                          If (ShowCaptions) Then
                            begin
                              //DisplayMode := nbdmImageAndText;
                              Height := LARGE_BUTTON_HEIGHT;
                              Width := MinCaptionWidth;
                            end
                          Else
                            begin
                             // DisplayMode := nbdmDefault;
                              Height := SMALL_BUTTON_HEIGHT;
                              Width := SMALL_BUTTON_WIDTH;
                            end;
                        end;
                    end;
                  If (Toolbar.Items[BtnNum] is TTBXSubmenuItem) Then
                    begin
                      With (Toolbar.Items[BtnNum] as TTBXSubmenuItem) Do
                        begin
                          If (ShowCaptions) Then
                            begin
                             // DisplayMode := nbdmImageAndText;
                              Height := LARGE_BUTTON_HEIGHT;
                              Width := MinCaptionWidth;
                            end
                          Else
                            begin
                              //DisplayMode := nbdmDefault;
                              Height := SMALL_BUTTON_HEIGHT;
                              Width := SMALL_BUTTON_WIDTH;
                            end;
                        end;
                    end;
                end;
            end;
        end;

      Items.ViewEndUpdate;
      EndUpdate;
    end;
end;

procedure TB2KGetDefaultToolbarButtons(Toolbar : TTBXToolbar; DefaultButtons : TStrings; var DefaultShowCaptions : Boolean);
var
  I : Integer;
begin
  //DefaultShowCaptions := (tboImageAboveCaption in Toolbar.Options);
  DefaultButtons.Clear;

  For I := 0 to Toolbar.Items.Count - 1 Do
    begin
      If (Toolbar.Items[I].Visible) Then DefaultButtons.Add(Toolbar.Items[I].Caption);
    end;
end;

procedure SaveToolbarButtons(Toolbar : TTBXToolbar; SectionName : String);
var
  Reg : TRegistry;
  Ini : TINIFile;
  I : Integer;
  ButtonList : TStringList;
begin
  If (sRegistryKey <> EmptyStr) Then
    begin
      Reg := TRegistry.Create;
      With Reg Do
        begin
          Access := KEY_READ or KEY_WRITE;
          RootKey := HKEY_CURRENT_USER;

          OpenKey(sRegistryKey + SectionName, True);
          WriteBool('Show Captions', ShowCaptions);

          { Delete any existing button keys first }
          OpenKey(sRegistryKey + SectionName + '\Buttons', True);

          ButtonList := TStringList.Create;
          ButtonList.Clear;
          GetValueNames(ButtonList);
          For I := 0 to ButtonList.Count - 1 Do
            DeleteValue(ButtonList[I]);

          { Now add the list of currently displayed (visible) buttons only. }
          For I := 0 to Toolbar.Items.Count - 1 Do
            If (Toolbar.Items[I].Visible) Then
              begin
                If (Toolbar.Items[I] is TTBXItem) Then
                  WriteString('Button'+Format('%.2d', [I]), (Toolbar.Items[I] as TTBXItem).Caption);
                If (Toolbar.Items[I] is TTBXSubmenuItem) Then
                  WriteString('Button'+Format('%.2d', [I]), (Toolbar.Items[I] as TTBXSubmenuItem).Caption);
                If (Toolbar.Items[I] is TTBXVisibilityToggleItem) Then
                  WriteString('Button'+Format('%.2d', [I]), (Toolbar.Items[I] as TTBXVisibilityToggleItem).Caption);
                If (Toolbar.Items[I] is TTBXSeparatorItem) Then
                  WriteString('Button'+Format('%.2d', [I]), 'Separator');
              end;

          Free;
        end;
    end;

  If (sINIFileName <> EmptyStr) Then
    begin
      Ini := TINIFile.Create(sINIFileName);
      With Ini Do
        begin
          WriteBool(Toolbar.Name + SectionName + 'Options', 'Show Captions', ShowCaptions);
          WriteInteger(Toolbar.Name + SectionName + 'Options','DockRow',Toolbar.DockRow);
          WriteInteger(Toolbar.Name + SectionName + 'Options','DockPos',Toolbar.DockPos);
          WriteString(Toolbar.Name + SectionName + 'Options','CurrentDock',Toolbar.CurrentDock.Name);

          { Delete any existing button keys first }
          EraseSection(Toolbar.Name + SectionName + 'Buttons');

          { Now add the list of currently displayed (visible) buttons only. }
          For I := 0 to Toolbar.Items.Count - 1 Do
            If (Toolbar.Items[I].Visible) Then
              begin
                If (Toolbar.Items[I] is TTBXItem) Then
                  WriteString(tbToolbar.Name + SectionName + 'Buttons', 'Button'+Format('%.2d', [I]), (Toolbar.Items[I] as TTBXItem).Caption);
                If (Toolbar.Items[I] is TTBXSubmenuItem) Then
                  WriteString(tbToolbar.Name + SectionName + 'Buttons', 'Button'+Format('%.2d', [I]), (Toolbar.Items[I] as TTBXSubmenuItem).Caption);
                If (Toolbar.Items[I] is TTBXVisibilityToggleItem) Then
                  WriteString(tbToolbar.Name + SectionName + 'Buttons', 'Button'+Format('%.2d', [I]), (Toolbar.Items[I] as TTBXVisibilityToggleItem).Caption);
                If (Toolbar.Items[I] is TTBXSeparatorItem) Then
                  WriteString(tbToolbar.Name + SectionName + 'Buttons', 'Button'+Format('%.2d', [I]), 'Separator');
              end;

          Free;
        end;
    end;

end;

procedure RestoreToolbarButtons(Toolbar : TTBXToolbar; SectionName : String);
var
  Reg : TRegistry;
  Ini : TINIFile;
  I : Integer;
  ButtonList : TStringList;
  BtnCaptions : Boolean;
  FirstTime : Boolean;
  s:string;
begin
  //BtnCaptions := (tboImageAboveCaption in Toolbar.Options);
  ButtonList := TStringList.Create;
  ButtonList.Clear;

  If (sRegistryKey <> EmptyStr) Then
    begin
      Reg := TRegistry.Create;
      With Reg Do
        begin
          Access := KEY_READ or KEY_WRITE;
          RootKey := HKEY_CURRENT_USER;

          FirstTime := True;

          If (OpenKey(sRegistryKey + SectionName, False)) Then
            If (ValueExists('Show Captions')) Then
              begin
                BtnCaptions := ReadBool('Show Captions');
                FirstTime := False;
              end;

          If (OpenKey(sRegistryKey + SectionName + '\Buttons', True)) Then
            begin
              OpenKey(sRegistryKey + SectionName + '\Buttons', True);

              { Get the list of buttons to be included on the toolbar. }
              GetValueNames(ButtonList);

              { If first time loading toolbar, set up default toolbar. }
              If (FirstTime) Then
                begin
                  ShowCaptions := BtnCaptions;
                  TB2KSaveToolbarButtons(Toolbar);
                  TB2KSaveToolbarDefaultButtons(Toolbar);
                  GetValueNames(ButtonList);
                end;

              For I := 0 to ButtonList.Count - 1 Do
                begin
                  { Overwrite the list item with the name of the button from the registry value. }
                  ButtonList[I] := ReadString(ButtonList[I]);
                end;
            end;

          Free;
        end;
    end;

  If (sINIFileName <> EmptyStr) Then
    begin
      ButtonList.Clear;
      Ini := TINIFile.Create(sINIFileName);
      With Ini Do
        begin
          FirstTime := Not SectionExists(Toolbar.Name + SectionName +'Options');

          //BtnCaptions := ReadBool(Toolbar.Name + SectionName +'Options', 'Show Captions', (tboImageAboveCaption in Toolbar.Options));

          { Get the list of buttons to be included on the toolbar. }
          ReadSectionValues(Toolbar.Name + SectionName +'Buttons', ButtonList);

          { If no buttons in the INI file, set up default toolbar. }
          If (FirstTime) Then
            begin
              ShowCaptions := BtnCaptions;
              TB2KSaveToolbarButtons(Toolbar);
              TB2KSaveToolbarDefaultButtons(Toolbar);
              ReadSectionValues(Toolbar.Name + SectionName +'Buttons', ButtonList);
            end;

          For I := 0 to ButtonList.Count - 1 Do
            begin
              { Overwrite the list item with the name of the button from the registry value. }
              ButtonList[I] := ReadString(Toolbar.Name + SectionName +'Buttons', ButtonList.Names[I], EmptyStr);
            end;
          s:=ReadString(Toolbar.Name + SectionName +'Options', 'CurrentDock', Toolbar.DefaultDock.Name);
          for i:=0 to mainfrm.ComponentCount-1 do begin
            if mainfrm.Components[i].Name=s then begin
              Toolbar.CurrentDock:=mainfrm.Components[i] as TTBXDock;
            end;
          end;   
          Toolbar.DockRow := ReadInteger(Toolbar.Name + SectionName +'Options', 'DockRow', 1);
          Toolbar.DockPos := ReadInteger(Toolbar.Name + SectionName +'Options', 'DockPos', 1);
          Free;
        end;
    end;

  TB2KUpdateToolbarDisplay(Toolbar, ButtonList, BtnCaptions);

  If (ButtonList <> Nil) Then ButtonList.Free;
end;

procedure TB2KSaveToolbarButtons(Toolbar : TTBXToolbar);
begin
  tbtoolbar:=Toolbar;
  SaveToolbarButtons(Toolbar, EmptyStr);
end;

procedure TB2KSaveToolbarDefaultButtons(Toolbar : TTBXToolbar);
begin
  tbtoolbar:=Toolbar;
  SaveToolbarButtons(Toolbar, 'Default');
end;

procedure TB2KRestoreToolbarButtons(Toolbar : TTBXToolbar);
begin
  tbtoolbar:=Toolbar;
  RestoreToolbarButtons(Toolbar, EmptyStr);
end;

procedure TB2KRestoreToolbarDefaultButtons(Toolbar : TTBXToolbar);
begin
  tbtoolbar:=Toolbar;
  RestoreToolbarButtons(Toolbar, 'Default');
end;

procedure TToolbarEditForm.SetAvailableList;
var
  I : Integer;
  BtnItem : TListItem;
  TempImage : TBitmap;
  R : TRect;
begin
  lstAvailable.Items.BeginUpdate;

  lstAvailable.SmallImages.Width :=  tbToolbar.Images.Width;
  lstAvailable.SmallImages.Height :=  tbToolbar.Images.Height;
  lstAvailable.Items.Clear;

  TempImage := TBitmap.Create;
  TempImage.Width := tbToolbar.Images.Width;
  TempImage.Height := tbToolbar.Images.Height;
  TempImage.Canvas.CopyMode := cmSrcCopy;

  imgButtons.Width := tbToolbar.Images.Width;
  imgButtons.Height := tbToolbar.Images.Height;
  imgButtons.Clear;

  For I := 0 to tbToolbar.Items.Count - 1 Do
    begin
      If (tbToolbar.Items[I] is TTBXItem) Then
        With (tbToolbar.Items[I] as TTBXItem) Do
          begin
            { Add toolbar image to the image list. }
            TempImage.Assign(Nil);
            tbToolbar.Images.GetBitmap(tbToolbar.Items[I].ImageIndex, TempImage);
            imgButtons.AddMasked(TempImage, TempImage.TransparentColor);

            { Add item to the Available list with its image from the imagelist. }
            BtnItem := lstAvailable.Items.Add;
            BtnItem.Caption := Caption;
            BtnItem.ImageIndex := imgButtons.Count - 1;
          end;
      If (tbToolbar.Items[I] is TTBXSubmenuItem) Then
        With (tbToolbar.Items[I] as TTBXSubmenuItem) Do
          begin
            { Add toolbar image to the image list. }
            TempImage.Assign(Nil);
            tbToolbar.Images.GetBitmap(tbToolbar.Items[I].ImageIndex, TempImage);
            imgButtons.AddMasked(TempImage, TempImage.TransparentColor);

            { Add item to the Available list with its image from the imagelist. }
            BtnItem := lstAvailable.Items.Add;
            BtnItem.Caption := Caption;
            BtnItem.ImageIndex := imgButtons.Count - 1;
          end;
      If (tbToolbar.Items[I] is TTBXVisibilityToggleItem) Then
        With (tbToolbar.Items[I] as TTBXVisibilityToggleItem) Do
          begin
            { Add toolbar image to the image list. }
            TempImage.Assign(Nil);
            tbToolbar.Images.GetBitmap(tbToolbar.Items[I].ImageIndex, TempImage);
            imgButtons.AddMasked(TempImage, TempImage.TransparentColor);

            { Add item to the Available list with its image from the imagelist. }
            BtnItem := lstAvailable.Items.Add;
            BtnItem.Caption := Caption;
            BtnItem.ImageIndex := imgButtons.Count - 1;
          end;
    end;

  {Add the separator to the button list }
  R.Left := 0;
  R.Top := 0;
  R.Right := tbToolbar.Images.Width;
  R.Bottom := tbToolbar.Images.Height;
  TempImage.Canvas.Brush.Color := TempImage.TransparentColor;
  TempImage.Canvas.FillRect(R);
  TempImage.Canvas.Brush.Color := clBlack;
  TempImage.Canvas.MoveTo(Trunc(TempImage.Width / 2), 2);
  TempImage.Canvas.LineTo(Trunc(TempImage.Width / 2), TempImage.Height - 2);

  imgButtons.AddMasked(TempImage, TempImage.TransparentColor);

  BtnItem := lstAvailable.Items.Add;
  BtnItem.ImageIndex := imgButtons.Count - 1;
  BtnItem.Caption := 'Separator';

  lstAvailable.Items.EndUpdate;

  TempImage.Free;
end;

procedure TB2KInitializeToolbar(Toolbar : TTBXToolbar; RegistryKey, INIFileName : String; HelpContextID : LongInt);
var
  SortList : TStringList;
  PosCaption : String;
  I : Integer;
begin
  DefaultCommands := TStringList.Create;

  tbToolbar := Toolbar;
  sRegistryKey := RegistryKey;
  sINIFileName := INIFileName;

  SortList := TStringList.Create;
  SortList.Clear;
  SortList.Sorted := False;

  For I := 0 to tbToolbar.Items.Count - 1 Do
    begin
      If (tbToolbar.Items[I] is TTBXItem) Then
        PosCaption := Format('%.4d%s', [I, (tbToolbar.Items[I] as TTBXItem).Caption]);
      If (tbToolbar.Items[I] is TTBXSeparatorItem) Then
        PosCaption := Format('%.4d%s', [I, 'Separator']);
      If (tbToolbar.Items[I] is TTBXSubmenuItem) Then
        PosCaption := Format('%.4d%s', [I, (tbToolbar.Items[I] as TTBXSubmenuItem).Caption]);
      If (tbToolbar.Items[I] is TTBXVisibilityToggleItem) Then
        PosCaption := Format('%.4d%s', [I, (tbToolbar.Items[I] as TTBXVisibilityToggleItem).Caption]);

      SortList.Add(PosCaption);
    end;

  SortList.Sort;

  For I := 0 to SortList.Count - 1 Do
    SortList[I] := Copy(SortList[I], 5, Length(SortList[I]));

  If (SortList <> Nil) Then SortList.Free;

  TB2KGetDefaultToolbarButtons(tbToolbar, DefaultCommands, DefaultShowCaptionState);
  TB2KRestoreToolbarButtons(tbToolbar);
end;

procedure TB2KShutdownToolbar;
begin
  If (DefaultCommands <> Nil) Then DefaultCommands.Free;
  DefaultCommands := Nil;
end;

procedure TToolbarEditForm.FormActivate(Sender: TObject);
begin
  SetAvailableList;
  SetSelectedList;

  If (ShowCaptions) Then
    cboShowCaptions.ItemIndex := OPT_SHOW_CAPTIONS
  Else
    cboShowCaptions.ItemIndex := OPT_NO_CAPTIONS;

  If (lstSelected.Items.Count > 0) Then lstSelected.ItemIndex := 0;

  lstAvailableEnter(Nil);
  lstAvailable.SetFocus;
  If (lstAvailable.Items.Count > 0) Then lstAvailable.ItemIndex := 0;

end;

procedure TToolbarEditForm.lstSelectedEnter(Sender: TObject);
begin
  btnMoveUp.Enabled := True;
  btnMoveDn.Enabled := True;
end;

procedure TToolbarEditForm.btnMoveUpClick(Sender: TObject);
var
  NewListItem : TListItem;
  NewPos : Integer;
begin
  If (lstSelected.Selected <> Nil) Then
     If (lstSelected.Selected.Index > 0) Then
       begin
         NewPos := lstSelected.Selected.Index - 1;

         NewListItem := lstSelected.Items.Insert(NewPos);
         NewListItem.Caption := lstSelected.Selected.Caption;
         NewListItem.ImageIndex := lstSelected.Selected.ImageIndex;

         lstSelected.Selected.Delete;
         NewListItem.Selected := True;
         NewListItem.Focused := True;
       end;

  lstSelected.SetFocus;
end;

procedure TToolbarEditForm.btnMoveDnClick(Sender: TObject);
var
  NewListItem : TListItem;
  NewPos : Integer;
begin
  If (lstSelected.Selected <> Nil) Then
     If (lstSelected.Selected.Index < (lstSelected.Items.Count - 1)) Then
       begin
         NewPos := lstSelected.Selected.Index + 2;
         //If (NewPos > lstSelected.Items.Count - 1) Then NewPos := lstSelected.Items.Count - 1;

         NewListItem := lstSelected.Items.Insert(NewPos);
         NewListItem.Caption := lstSelected.Selected.Caption;
         NewListItem.ImageIndex := lstSelected.Selected.ImageIndex;

         lstSelected.Selected.Delete;
         NewListItem.Selected := True;
         NewListItem.Focused := True;
       end;

  lstSelected.SetFocus;
end;

procedure TToolbarEditForm.lstAvailableEnter(Sender: TObject);
begin
  DisableMoveButtons;
end;

procedure TToolbarEditForm.cboShowCaptionsEnter(Sender: TObject);
begin
  DisableMoveButtons;
end;

procedure TToolbarEditForm.btnSelectEnter(Sender: TObject);
begin
  DisableMoveButtons;
end;

procedure TToolbarEditForm.btnDeselectEnter(Sender: TObject);
begin
  DisableMoveButtons;
end;

procedure TToolbarEditForm.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key=VK_ESCAPE then begin
    Close; Key:=0;
  end;
end;

end.
