!define VER_FILE "2013"
!define VER_DISPLAY "2.0.13 Installation"
!include "MUI.nsh"
BrandingText "DEV-PHP2"
OutFile "devphp2013d.exe"
Name "Dev-php"
Caption "Dev-PHP ${VER_DISPLAY} Setup"

!define SOURCEDIR "C:\sourcen\dev-php\source\"

;--------------------------------
;Interface Settings

!define MUI_ICON "devphp.ico"
!define MUI_UNICON "devphp.ico"
;!define MUI_COMPONENTSPAGE_NODESC
;!define MUI_SPECIALBITMAP "logo2.bmp"
;!define MUI_WELCOMEFINISHPAGE_INI "devphp_nsis1.ini"
;!define MUI_HEADERIMAGE_RIGHT
!define MUI_HEADERIMAGE
!define MUI_ABORTWARNING
!define MUI_HEADERIMAGE_BITMAP_NOSTRETCH
!define MUI_HEADERIMAGE_BITMAP "logo2.bmp"

!define MUI_INSTFILESPAGE_COLORS "FFFFFF 000000"
!define MUI_BGCOLOR "FFFFFF"
!define MUI_COMPONENTSPAGE_TEXT_DESCRIPTION_INFO "set the mouse over the item to see descriptions"

!define MUI_FINISHPAGE_SHOWREADME "$INSTDIR\news.txt"
!define MUI_FINISHPAGE_SHOWREADME_TEXT "Show news.txt"
!define MUI_FINISHPAGE_SHOWREADME_NOTCHECKED
!define MUI_FINISHPAGE_RUN_NOTCHECKED
!define MUI_FINISHPAGE_TITLE "Installation completed"
!define MUI_FINISHPAGE_TEXT "Gratulation!\n\nyou have installed dev-php2."
!define MUI_FINISHPAGE_BUTTON "Finish"
!define MUI_FINISHPAGE_LINK "Visit the Dev-php website"
!define MUI_FINISHPAGE_LINK_LOCATION "http://devphp.sourceforge.net/"
!define MUI_FINISHPAGE_LINK_COLOR "FFFFFF"
;!define MUI_FINISHPAGE_RUN_TEXT "Run Dev-php"
!define MUI_FINISHPAGE_RUN "$INSTDIR\devphp.exe"
;!define MUI_WELCOMEFINISHPAGE_BITMAP "logo2.bmp"
!define MUI_WELCOMEFINISHPAGE_BITMAP_NOSTRETCH
!define MUI_WELCOMEPAGE_TEXT "Dev-PHP Installation Program"
!define MUI_WELCOMEPAGE_TITLE "Dev-PHP Installation"

ReserveFile "logo2.bmp"
;--------------------------------
;Pages
;!insertmacro MUI_PAGE_WELCOME
!insertmacro MUI_PAGE_LICENSE "${SOURCEDIR}contrib\copying.txt"
!insertmacro MUI_PAGE_COMPONENTS
InstallDir "$PROGRAMFILES\Dev-php2"
!insertmacro MUI_PAGE_DIRECTORY
;!insertmacro MUI_PAGE_STARTMENU page_id variable
Page custom StartMenuGroupSelect "" ": Start Menu Folder"
!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_PAGE_FINISH

;!insertmacro MUI_DEFAULT MUI_WELCOMEFINISHPAGE_INI "devphp_nsis1.ini"
;!insertmacro MUI_UNPAGE_WELCOME
!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES
!insertmacro MUI_UNPAGE_FINISH
;--------------------------------
;Languages

!insertmacro MUI_LANGUAGE "English"

;user prompt
DirText "Please select a path to install this application to:"
;Get install folder from registry if available
InstallDirRegKey HKCU "Software\Dev-php2" ""


;install the files
Section "Dev-php" devphp
  ;Tell the installer where to extract file
	SetDetailsView show
	SetOutPath $INSTDIR
	File "${SOURCEDIR}contrib\news.txt"
	File "${SOURCEDIR}contrib\libeay32.dll"
	File "${SOURCEDIR}contrib\ssleay32.dll"
	File "${SOURCEDIR}DevPHP.exe"
	File "${SOURCEDIR}Translator.exe"
	File "${SOURCEDIR}contrib\SnippetExample.xml"
  IfFileExists "$APPDATA\devphp.ini" noinidat	inidat
  inidat:
	SetOutPath $APPDATA\devphp
	File "${SOURCEDIR}contrib\devphp.ini"
  	SetOutPath $INSTDIR
noinidat:
  IfFileExists "$APPDATA\devphp.prd" noinidat2 inidat2
  inidat2:
	SetOutPath $APPDATA\devphp
	File "${SOURCEDIR}contrib\devphp.prd"
  	SetOutPath $INSTDIR
  noinidat2:
  IfFileExists "$INSTDIR\autotext.xml" noinidat3 inidat3
  inidat3:
	SetOutPath $APPDATA\devphp
	File "${SOURCEDIR}contrib\autotext.xml"
  	SetOutPath $INSTDIR
  noinidat3:
	WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\DevPHP" "DisplayName" "Dev-PHP (remove only)"
	WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\DevPHP" "UninstallString" '"$INSTDIR\uninstall.exe"'
  SetOutPath $INSTDIR\lang
  File "${SOURCEDIR}lang\*.*"
  SetOutPath $INSTDIR\data
  File "${SOURCEDIR}data\*.*"
  WriteUninstaller $INSTDIR\uninstall.exe
  
  # this part is only necessary if you used /checknoshortcuts
  StrCpy $R1 $R0 1
  StrCmp $R1 ">" skip

  SetShellVarContext All
  CreateDirectory $SMPROGRAMS\$R0
  CreateShortCut "$SMPROGRAMS\$R0\Devphp.lnk" $INSTDIR\devphp.exe

  ;CreateDirectory $SMPROGRAMS\$R0
  CreateShortCut "$SMPROGRAMS\$R0\uninstall.lnk" $INSTDIR\uninstall.exe
  SetShellVarContext current

  skip:

SectionEnd

Section "Uninstall"
	SetDetailsView show
  Messagebox MB_YESNO|MB_ICONINFORMATION "Deinstallation of Dev-PHP ?" IDNO Poop
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\DevPHP"
  Delete $INSTDIR\Uninstall.exe
  Delete $INSTDIR\DevPHP.exe
  Delete $INSTDIR\contrib.txt
  Delete $INSTDIR\news.txt
  Delete $INSTDIR\SnippetExample.xml
  Delete $INSTDIR\Translator.exe
  RMDir /r $INSTDIR\lang
  RMDir /r $INSTDIR\data
  RMDir /r $APPDATA\devphp
  RMDir /r $INSTDIR
  SetShellVarContext All
  RMDir /r $SMPROGRAMS\$R0\DEV-PHP2
  SetShellVarContext current
  DeleteRegKey HKCU SOFTWARE\devphpCVS
  Poop:
SectionEnd

LangString DESC_SecDummy ${LANG_ENGLISH} "Dev-php Program"
LangString DESC_SecDummy1 ${LANG_ENGLISH} "english Documentation for php"
LangString DESC_SecDummy2 ${LANG_ENGLISH} "PHP version 5.0.2 installed in the dev-php directory"

!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
;!insertmacro MUI_DESCRIPTION_TEXT ${php502} $(DESC_SecDummy2)
;!insertmacro MUI_DESCRIPTION_TEXT ${documentation} $(DESC_SecDummy1)
!insertmacro MUI_DESCRIPTION_TEXT ${devphp} $(DESC_SecDummy)
!insertmacro MUI_FUNCTION_DESCRIPTION_END

Function .onInit
        # the plugins dir is automatically deleted when the installer exits
        InitPluginsDir
        #optional
        #File /oname=$PLUGINSDIR\splash.wav "C:\myprog\sound.wav"

        File /oname=$PLUGINSDIR\splash.bmp "logo3.bmp"
        advsplash::show 1000 600 400 0x00005B $PLUGINSDIR\splash
        Pop $0

        Delete $PLUGINSDIR\splash.bmp
FunctionEnd

Function StartMenuGroupSelect
	Push $R1

	StartMenu::Select /checknoshortcuts "Don't create a start menu folder" /autoadd /lastused $R0 "DEV-PHP2"
	Pop $R1

	StrCmp $R1 "success" success
	StrCmp $R1 "cancel" done
		; error
		MessageBox MB_OK $R1
		Return
	success:
	Pop $R0

	done:
	Pop $R1
FunctionEnd

