unit InitStuff;
interface
uses SyncObjs;

function getAppFolder():string;
function getPersonalFolder():string;
procedure RegisterExt(prefix:string;exepfad:string);
procedure UnRegisterExt(prefix:string);

var     UILock: TCriticalSection;

implementation

uses Registry,Windows,shellAPI,shlobj,activeX,forms,SysUtils;

function getSpecialFolder(i:integer):string;
var
  Allocator: IMalloc;
  SpecialDir: PItemIdList;
  FBuf: array[0..MAX_PATH] of Char;
begin
  if SHGetMalloc(Allocator) = NOERROR then
  begin
    SHGetSpecialFolderLocation(application.Handle, i, SpecialDir);
    SHGetPathFromIDList(SpecialDir, @FBuf[0]);
    Allocator.Free(SpecialDir);
    result:=(string(FBuf));
  end;
  if result='' then result:=ExtractFilePath(application.ExeName);
end;

function getAppFolder():string;
begin
  result:=getSpecialFolder(CSIDL_APPDATA);
end;

function getPersonalFolder():string;
begin
  result:=getSpecialFolder(CSIDL_PERSONAL);
end;

procedure RegisterExt(prefix:string;exepfad:string);
var
  reg: TRegistry;
  s:string;
begin
  s:=prefix+'file';
  reg := TRegistry.Create;
  try
    reg.RootKey := HKEY_CLASSES_ROOT;
    reg.OpenKey('.' + prefix, True);
    try
      reg.Writestring('', s);
    finally
      reg.CloseKey;
    end;
    reg.CreateKey(s);
    reg.OpenKey(s + '\DefaultIcon', True);
    try
      reg.Writestring('', exepfad + ',0');
    finally
      reg.CloseKey;
    end;
    reg.OpenKey(s + '\shell\open\command', True);
    try
      reg.Writestring('', exepfad + ' "%1"');
    finally
      reg.CloseKey;
    end;
  finally
    reg.Free;
  end;
  SHChangeNotify(SHCNE_ASSOCCHANGED, SHCNF_IDLIST, nil, nil);
end;

procedure UnRegisterExt(prefix:string);
var
  reg: TRegistry;
  s:string;
begin
  s:=prefix+'file';
  reg := TRegistry.Create;
  try
    reg.RootKey := HKEY_CLASSES_ROOT;
    reg.OpenKey('.' + prefix, True);
    try
      reg.Writestring('', '');
    finally
      reg.CloseKey;
    end;
    reg.DeleteKey(s);
  finally
    reg.Free;
  end;
  SHChangeNotify(SHCNE_ASSOCCHANGED, SHCNF_IDLIST, nil, nil);
end;

initialization
  UILock := TCriticalSection.Create;
end.
