unit Unit2;

interface

uses
  SysUtils, Classes, dws2Comp,dws2Exprs,SynEdit;

type
  TScriptEditor = class(TDataModule)
    dws2Unit1: Tdws2Unit;
    function getText():WideString;
  private
    { Private-Deklarationen }
    FScript: TDelphiWebScriptII;
    FSynEdit: TSynEdit;
    procedure SetScript(const Value: TDelphiWebScriptII);
  protected
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
  public
    { Public-Deklarationen }
    property Script: TDelphiWebScriptII read FScript write SetScript;
    property SynEdit:TSynEdit read FSynEdit write FSynEdit;
  end;

procedure Register;

var
  ScriptEditor: TScriptEditor;

implementation

{$R *.dfm}

{ TScriptEditor }

procedure Register;
begin
  RegisterComponents('DWS2', [TScriptEditor]);
end;

function TScriptEditor.getText: WideString;
begin
  result:=SynEdit.Text;
end;

procedure TScriptEditor.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited;
  if (Operation = opRemove) and (AComponent = Script) then
    SetScript(nil)
end;

procedure TScriptEditor.SetScript(const Value: TDelphiWebScriptII);
var
  x: Integer;
begin
  if Assigned(FScript) then
    FScript.RemoveFreeNotification(Self);
  if Assigned(Value) then
    Value.FreeNotification(Self);

  FScript := Value;

  for x := 0 to ComponentCount - 1 do
    if Components[x] is Tdws2Unit then
      Tdws2Unit(Components[x]).Script := Value;
end;

end.
