//
// +----------------------------------------------------------------------+
// | Dev-PHP - Integrated Development Environment                         |
// +----------------------------------------------------------------------+
// | Copyright (C) 2002-2003, http://devphp.sourceforge.net               |
// +----------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify |
// | it under the terms of the GNU General Public License as published by |
// | the Free Software Foundation; either version 2 of the License, or    |
// | (at your option) any later version.                                  |
// | This program is distributed in the hope that it will be useful       |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of       |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         |
// | GNU General Public License for more details.                         |
// +----------------------------------------------------------------------+
// | Author: Leonardo Garca <simbiotik@users.sourceforge.net>            |
// | Author: Urs Mder <ursmaeder@users.sourceforge.net>                  |
// +----------------------------------------------------------------------+
//

unit frmAutoText;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls,frmMain, ExtCtrls, Grids, Mask, Spin,ulang,InitStuff,
  uinifile,version;

type
  TAutoTextFrm = class(TForm)
    Panel12: TPanel;
    Panel1: TPanel;
    Button2: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Button1: TButton;
    Edit1: TEdit;
    Memo1: TMemo;
    Button5: TButton;
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Button1Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    procedure setTitleAndMemo(title, memo: widestring);
    { Public-Deklarationen }
  end;

var
  AutoTextFrm: TAutoTextFrm;

implementation

{$R *.dfm}

procedure TAutoTextFrm.FormShow(Sender: TObject);
begin
  panel1.Caption:=lang(3200);
  caption:=lang(3200);
//  panel2.Caption:=lang(3201);
  label1.Caption:=lang(3202);
  label2.Caption:=lang(3203);
  button1.Caption:=lang(3204);
//  button5.Caption:=lang(3205);
//  button3.Caption:=lang(3206);
//  button4.Caption:=lang(3207);
  button2.Caption:=lang(3208);
end;

procedure TAutoTextFrm.FormCreate(Sender: TObject);
var autofile:string;
begin
  autofile:=getAppFolder() +'\devphp\'+ '\'+autofilename;
end;

procedure TAutoTextFrm.setTitleAndMemo(title,memo:widestring);
begin
  Edit1.Text:=title;
  memo1.Lines.Text:=memo;
end;

procedure TAutoTextFrm.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key=VK_ESCAPE then begin
    Close; Key:=0;
  end;
end;

procedure TAutoTextFrm.Button1Click(Sender: TObject);
begin
  memo1.SelText:=cursorstr;
end;

end.
