//
// +----------------------------------------------------------------------+
// | Dev-PHP - Integrated Development Environment                         |
// +----------------------------------------------------------------------+
// | Copyright (C) 2002-2003, http://devphp.sourceforge.net               |
// +----------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify |
// | it under the terms of the GNU General Public License as published by |
// | the Free Software Foundation; either version 2 of the License, or    |
// | (at your option) any later version.                                  |
// | This program is distributed in the hope that it will be useful       |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of       |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         |
// | GNU General Public License for more details.                         |
// +----------------------------------------------------------------------+
// | Author: Leonardo Garca <simbiotik@users.sourceforge.net>            |
// | Author: Mder Urs       <ursmaeder@users.sourceforge.net>            |
// +----------------------------------------------------------------------+
//
unit frmGTK;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, ComCtrls, uLang,uIniFile,
 // XPMenu,
  uEditor;

type
  TGtkRun = class(TForm)
    Timer1: TTimer;
    Panel1: TPanel;
    progress: TProgressBar;
    procedure Panel2Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Timer1Timer(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
  public
    ArchivoEntrada : string;
    PHP_GTK : string;
    Comandos : string;
  end;

var
  GtkRun: TGtkRun;

implementation

uses frmMain;

{$R *.dfm}

procedure TGtkRun.Panel2Click(Sender: TObject);
begin
  Close;
  MainFrm.GetEditor.SynEdit.SetFocus;
end;

procedure TGtkRun.FormShow(Sender: TObject);
var
  IniPath : string;
  e : TEditor;
begin
  Self.Font.Name := settings.DialogFontText;
  Self.Caption := Lang(1350);
  Panel1.Hint := Lang(1351);
  PHP_GTK := MainFrm.Parser;

  e := MainFrm.GetEditor;
  if not Assigned(e) then Exit;

  with MainFrm do begin
    if e.fFileName <> '' then begin
      ArchivoEntrada := ExtractFilePath(e.fFileName) + '~out.php';
    end else begin
      ArchivoEntrada := ExtractFilePath(Application.ExeName) + '~out.php';
    end;
    e.SynEdit.Lines.SaveToFile(ArchivoEntrada);
  end;
  IniPath := ExtractFilePath(PHP_GTK);
  Delete(IniPath, Length(IniPath), 1);
//  Comandos := '"' + PHP_GTK + '" -c "' + IniPath + '" -f "' + e.fFileName + '"';
  Comandos:= '"' + PHP_GTK + '" "' + e.fFileName + '"';
  Timer1.Enabled := true;
end;

procedure TGtkRun.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  ChDir(ExtractFilePath(Application.ExeName));
  if FileExists(ArchivoEntrada) then
    DeleteFile(ArchivoEntrada);
end;

procedure TGtkRun.Timer1Timer(Sender: TObject);
var
  i : integer;
begin
  i := 0;
  if progress.Position = 0 then begin
    progress.Position := 2;
    ChDir(ExtractFilePath(ArchivoEntrada));
    i := WinExec(PChar(Comandos), SW_HIDE);
  end;
  while i = 0 do begin
    if progress.Position < progress.Max - 2 then begin
      progress.Position := progress.Position + 2;
    end;
  end;
  if i > 0 then begin
    progress.Position := progress.Max;
  end;
  if progress.Position = progress.Max then begin
    Timer1.Enabled := false;
    progress.Visible := false;
    if FileExists(PHP_GTK) then begin
      Panel1.Caption := Lang(1352);
    end else begin
      Panel1.Caption := Lang(1353);
    end;
  end;
  close;
end;

procedure TGtkRun.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key=VK_ESCAPE then begin
    Close; Key:=0;
  end;
end;

end.
