//
// +----------------------------------------------------------------------+
// | Dev-PHP - Integrated Development Environment                         |
// +----------------------------------------------------------------------+
// | Copyright (C) 2002-2003, http://devphp.sourceforge.net               |
// +----------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify |
// | it under the terms of the GNU General Public License as published by |
// | the Free Software Foundation; either version 2 of the License, or    |
// | (at your option) any later version.                                  |
// | This program is distributed in the hope that it will be useful       |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of       |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         |
// | GNU General Public License for more details.                         |
// +----------------------------------------------------------------------+
// | Author: Leonardo Garca <simbiotik@users.sourceforge.net>            |
// +----------------------------------------------------------------------+
//
unit frmOptions;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, ColorGrd, SynEditHighlighter,
  SynHighlighterPHP, SynEdit, jpeg, Buttons, ComCtrls, Spin, uLang, shellAPI,
  ColorPickerButton, devTabs, uEditor,fileCtrl,uIniFile, version, Grids, ValEdit,
  SynHighlighterMulti,InitStuff, VirtualTrees,Inifiles;

type
  TListObj = class(TObject)
  private
    highlighter:TSynCustomHighlighter;
    index:integer;
  end;

  TOptionForm = class(TForm)
    OpenDialog1: TOpenDialog;
    accept: TSpeedButton;
    cancel: TSpeedButton;
    Servers: TdevPages;
    General: TdevPage;
    Sintaxis: TdevPage;
    Parser: TdevPage;
    Extra: TdevPage;
    Panel9: TPanel;
    Panel10: TPanel;
    Panel11: TPanel;
    DialogFont: TComboBox;
    SaveSession: TCheckBox;
    Panel12: TPanel;
    Bevel3: TBevel;
    ColorPickerButton3: TColorPickerButton;
    SpinEdit3: TEdit;
    UpDown3: TUpDown;
    UpDown2: TUpDown;
    SpinEdit2: TEdit;
    SpinEdit1: TEdit;
    UpDown1: TUpDown;
    EditFont: TPanel;
    Opciones: TPanel;
    Borde: TPanel;
    Tamano: TPanel;
    Ancho: TPanel;
    Color: TPanel;
    Braces: TCheckBox;
    Panel17: TPanel;
    Foreground: TLabel;
    ColorPickerButton2: TColorPickerButton;
    Background: TLabel;
    ColorPickerButton1: TColorPickerButton;
    Propiedades: TPanel;
    ElementList: TListBox;
    Bold: TCheckBox;
    Italic: TCheckBox;
    Panel13: TPanel;
    Exechoice: TSpeedButton;
    Edit1: TEdit;
    Interprete: TPanel;
    Panel7: TPanel;
    Panel16: TPanel;
    SelectLanguage: TSpeedButton;
    Archivo: TPanel;
    Idioma: TEdit;
    Actual: TPanel;
    Edit3: TEdit;
    Panel14: TPanel;
    SearchDocs: TSpeedButton;
    Panel15: TPanel;
    DocsPath: TEdit;
    DocsLang: TComboBox;
    Panel4: TPanel;
    Panel5: TPanel;
    Panel6: TPanel;
    Edit2: TEdit;
    UpDown4: TUpDown;
    Panel18: TPanel;
    devPage1: TdevPage;
    GroupBox1: TGroupBox;
    Label2: TLabel;
    Label1: TLabel;
    LocalPort: TEdit;
    LocalPath: TEdit;
    LocalServerPathchoice: TSpeedButton;
    GroupBox3: TGroupBox;
    Label9: TLabel;
    WebServerPath: TEdit;
    ftp: TdevPage;
    GroupBox2: TGroupBox;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label8: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    FTPHost: TEdit;
    FTPPort: TEdit;
    FTPUser: TEdit;
    FTPPassword: TEdit;
    FTPServerPath: TEdit;
    ftppassive: TCheckBox;
    GroupBox4: TGroupBox;
    ListBox1: TListBox;
    TestFTP: TButton;
    Label12: TLabel;
    Edit5: TEdit;
    Label13: TLabel;
    Edit6: TEdit;
    Label14: TLabel;
    Edit7: TEdit;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    FileExt: TdevPage;
    Panel19: TPanel;
    ExtHighlighter: TPanel;
    Edit8: TEdit;
    Edit9: TEdit;
    Edit10: TEdit;
    Edit11: TEdit;
    Edit12: TEdit;
    Edit13: TEdit;
    Edit14: TEdit;
    Panel20: TPanel;
    Edit15: TEdit;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    Label21: TLabel;
    devPage2: TdevPage;
    Panel21: TPanel;
    Panel22: TPanel;
    ValueListEditor1: TValueListEditor;
    Label22: TLabel;
    Label23: TLabel;
    FontDialog1: TFontDialog;
    ShowFont: TPanel;
    Fontchoice: TButton;
    Panel3: TPanel;
    Panel2: TPanel;
    Image1: TImage;
    Panel1: TPanel;
    Image2: TImage;
    Label7: TLabel;
    Label24: TLabel;
    Edit4: TEdit;
    SpeedButton2: TSpeedButton;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    Label25: TLabel;
    Label26: TLabel;
    ColorPickerButton4: TColorPickerButton;
    Install: TButton;
    Label27: TLabel;
    CheckBox4: TCheckBox;
    ComboBox1: TComboBox;
    CheckBox5: TCheckBox;
    devPage4: TdevPage;
    Panel8: TPanel;
    Panel23: TPanel;
    Panel24: TPanel;
    Panel25: TPanel;
    SpeedButton1: TSpeedButton;
    Edit17: TEdit;
    GroupBox5: TGroupBox;
    Label30: TLabel;
    SpeedButton3: TSpeedButton;
    Edit19: TEdit;
    SpinEdit4: TSpinEdit;
    Label29: TLabel;
    Button3: TButton;
    Button4: TButton;
    Label31: TLabel;
    devPage3: TdevPage;
    Label28: TLabel;
    Button1: TButton;
    TreeView1: TTreeView;
    Edit16: TEdit;
    Button2: TButton;
    CheckBox3: TCheckBox;
    ComboBox2: TComboBox;
    Label32: TLabel;
    Label33: TLabel;
    ComboBox3: TComboBox;
    Label34: TLabel;
    Edit18: TEdit;
    Edit20: TEdit;
    Label35: TLabel;
    Edit21: TEdit;
    Label36: TLabel;
    CheckBox6: TCheckBox;
    CheckBox7: TCheckBox;
    Edit22: TEdit;
    SpeedButton4: TSpeedButton;
    Label37: TLabel;
    Label38: TLabel;
    Edit23: TEdit;
    Label39: TLabel;
    Button5: TButton;
    Button6: TButton;
    Label40: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure ElementListClick(Sender: TObject);
    procedure ExechoiceClick(Sender: TObject);
    procedure cancelClick(Sender: TObject);
    procedure acceptClick(Sender: TObject);
    procedure Image1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure SelectLanguageClick(Sender: TObject);
    procedure SpinEdit2Change(Sender: TObject);
    procedure BoldClick(Sender: TObject);
    procedure StyleBold(Attri: TSynHighlighterAttributes);
    procedure StyleItalic(Attri: TSynHighlighterAttributes);
    procedure ItalicClick(Sender: TObject);
    procedure ColorPickerButton1Change(Sender: TObject);
    procedure ColorPickerButton2Change(Sender: TObject);
    procedure ColorPickerButton3Change(Sender: TObject);
    procedure Image2Click(Sender: TObject);
    procedure SearchDocsClick(Sender: TObject);
    procedure DialogFontChange(Sender: TObject);
    procedure LocalServerPathchoiceClick(Sender: TObject);
    procedure TestFTPClick(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure ColorPickerButton2DefaultSelect(Sender: TObject);
    procedure ColorPickerButton3DefaultSelect(Sender: TObject);
    procedure ColorPickerButton1DefaultSelect(Sender: TObject);
    procedure FontchoiceClick(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure ColorPickerButton4DefaultSelect(Sender: TObject);
    procedure InstallClick(Sender: TObject);
    procedure Label27Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button1Click(Sender: TObject);
    procedure TreeView1Change(Sender: TObject; Node: TTreeNode);
    procedure ServersChange(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Label40Click(Sender: TObject);
  private
    function ChangeFTPPath: boolean;
    procedure Translate(Sender: TObject);
  end;

var
  OptionForm: TOptionForm;

implementation

uses frmMain,registry;

{$R *.dfm}
{-----------------------------------------------------------------------------
  Procedure: TOptionForm.FormCreate
  Author:    urmade
  Date:      30-Mai-2005
  Arguments: Sender: TObject
  Result:    None
-----------------------------------------------------------------------------}

procedure TOptionForm.FormCreate(Sender: TObject);
var
  dl      : string;
  ii,i,i2 : integer;
  e       : TEditor;
  h       : TSynMultiSyn;
  l       : TListObj;
begin
  ColorPickerButton3.SelectionColor := gsettings.DemoEditColor;
  ColorPickerButton4.SelectionColor := graphics.StringToColor(gsettings.activeLineColor);
  UpDown1.Position                  := settings.UpDown1Position;
  UpDown2.Position                  := gsettings.UpDown2Position;
  UpDown3.Position                  := gsettings.UpDown3Position;
  UpDown4.Position                  := mainfrm.Panel2.Width;
  Edit1.Text                        := gsettings.PHPExeFile;
  Edit4.Text                        := gsettings.PHPIniFile;
  Idioma.Text                       := gsettings.IdiomaText;
  Braces.Checked                    := settings.BracesChecked;
  SaveSession.Checked               := settings.SaveSessionChecked;
  DialogFont.Text                   := settings.DialogFontText;
  localpath.Text                    := settings.localpathText;
  localPort.Text                    := settings.localPortText;
  Ftppassive.Checked                := settings.FTPPassive;
  FTPHost.Text                      := settings.FTPHostText;
  FTPPort.Text                      := settings.FTPPortText;
  FTPUser.Text                      := settings.FTPUserText;
  FTPPassword.Text                  := settings.FTPPasswordSave;
  FTPServerPath.Text                := settings.FTPServerPathText;
  WebServerPath.Text                := settings.ExternPath;
  combobox1.Text                    := gsettings.Encoding;
  checkbox5.Checked                 := gsettings.BOM;
  EditFont.Font.Name                := gsettings.EditorFontText;
  EditFont.Font.Size                := StrToInt(SpinEdit2.Text);
  DocsPath.Text                     := gsettings.DocsPathText;
  dl                                := gsettings.dl;
  edit5.Text                        := gsettings.DateFmt;
  edit6.Text                        := gsettings.TimeFmt;
  edit7.Text                        := gsettings.DateTimeFmt;
  checkbox1.Checked                 := gsettings.AutoIndent;
  checkbox4.Checked                 := gsettings.TabsToSpaces;
  checkbox2.Checked                 := gsettings.WordWrap;
  if assigned(mainfrm.GetEditor()) then begin
    ShowFont.Font:=mainfrm.getEditor().SynEdit.Font;
    ShowFont.Caption:=mainfrm.getEditor().SynEdit.Font.Name;
  end;

  ii := 0;
  if dl = 'pt_BR' then ii := 1;
  if dl = 'zh' then ii := 2;
  if dl = 'cs' then ii := 3;
  if dl = 'nl' then ii := 4;
  if dl = 'fi' then ii := 5;
  if dl = 'fr' then ii := 6;
  if dl = 'de' then ii := 7;
  if dl = 'hu' then ii := 8;
  if dl = 'it' then ii := 9;
  if dl = 'ja' then ii := 10;
  if dl = 'kr' then ii := 11;
  if dl = 'pl' then ii := 12;
  if dl = 'ro' then ii := 13;
  if dl = 'sk' then ii := 14;
  if dl = 'sl' then ii := 15;
  if dl = 'es' then ii := 16;
  if dl = 'sv' then ii := 17;
  if dl = 'tr' then ii := 18;
  DocsLang.ItemIndex := ii;

  DialogFont.Items.AddStrings(Screen.Fonts);
  Elementlist.Clear;
  e:=mainfrm.GetEditor();
  if assigned(e) then begin
    if assigned(e.synEdit.highlighter) then
      if e.SynEdit.Highlighter is TSynMultiSyn then begin
        h:=TSynMultiSyn(e.SynEdit.Highlighter);
//        showmessage(h.Schemes.Items[0].DisplayName);
        for i:=0 to h.DefaultHighlighter.AttrCount-1 do begin
          l:=TListObj.Create;
          l.highlighter:=h.DefaultHighlighter;
          l.index:=i;
          elementlist.Items.AddObject(h.DefaultHighlighter.LanguageName+' - '+
            h.DefaultHighlighter.Attribute[i].Name,l);
        end;
        for i:=0 to h.Schemes.Count-1 do begin
          for i2:=0 to h.Schemes.Items[i].Highlighter.AttrCount-1 do begin
            l:=TListObj.Create;
            l.highlighter:=h.Schemes[i].Highlighter;
            l.index:=i2;
            elementlist.items.AddObject(h.Schemes.Items[i].DisplayName+' - '+
              h.Schemes.Items[i].Highlighter.Attribute[i2].Name,l);
          end;
        end;
      end else begin
        for i:=0 to e.SynEdit.Highlighter.AttrCount-1 do begin
          l:=TListObj.Create;
          l.highlighter:=e.SynEdit.Highlighter;
          l.index:=i;
          elementlist.Items.AddObject(e.SynEdit.Highlighter.Attribute[i].Name,l);
        end;
      end;
  end;
  edit8.Text:=gsettings.SynPHPSyn1Filter;
  edit11.Text:=gsettings.SynHTMLSyn1Filter;
  edit9.Text:=gsettings.SynCSSSyn1Filter;
  edit10.Text:=gsettings.SynJSSyn1Filter;
  edit12.Text:=gsettings.SynSQLSyn1Filter;
  edit14.Text:=gsettings.SynXMLSyn1Filter;
  edit13.Text:=gsettings.SynMultiSyn1Filter;
  edit15.Text:=gsettings.Assoc;
  edit19.Text:=settings.DefaultDoc;
  spinedit4.Value:=settings.ServerTimeout;

  if settings.InternBrowser='InternetExplorer' then RadioButton2.Checked:=true
  else RadioButton1.Checked:=true;
  label27.Caption:='you have to download and install the Control from:'#13+
                   'http://www.iol.ie/~locka/mozilla/control.htm'#13+
                   'After this click on Install and take the File mozctlx.dll';

  label39.Caption:='Please Attention'#13+
                   'this buttons will change your'#13+
                   'your php.ini-File!'#13+
                   'be carefull'#13+
                   'change only with a backup!';

end;

procedure TOptionForm.ElementListClick(Sender: TObject);
var e:TEditor;
    t:TListObj;
begin
  e:=mainfrm.GetEditor();
  if not assigned(e) then  exit;
  t:= ((sender as TListBox).Items.Objects[Elementlist.ItemIndex])as TListObj;
  ColorPickerButton1.SelectionColor := t.highlighter.Attribute[t.index].Background;
  ColorPickerButton2.SelectionColor := t.highlighter.Attribute[t.index].Foreground;
  Italic.Checked := fsItalic in t.highlighter.Attribute[t.index].Style;
  Bold.Checked := fsBold in t.highlighter.Attribute[t.index].Style;
end;

procedure TOptionForm.ExechoiceClick(Sender: TObject);
begin
  OpenDialog1.Filter := 'Applications|*.exe';
  OpenDialog1.FileName:=replPath(Edit1.Text);
  if OpenDialog1.Execute then begin
    Edit1.Text := OpenDialog1.FileName;
  end;
end;

procedure TOptionForm.cancelClick(Sender: TObject);
begin
  Close;
end;

procedure TOptionForm.acceptClick(Sender: TObject);
var
  dl : string;

  procedure assignToEditors();
  var i:integer;
      e:TEditor;
  begin
    for i:=0 to mainfrm.PageControl.PageCount-1 do begin
      e:=mainfrm.GetEditor(i);
      if assigned(e) then begin
        e.checkbraces:=Braces.Checked;
        e.SynEdit.ActiveLineColor:=ColorPickerButton4.SelectionColor;
        if checkbox1.Checked then
          e.SynEdit.Options:=e.SynEdit.Options+[eoAutoIndent]
        else
          e.SynEdit.Options:=e.SynEdit.Options-[eoAutoIndent];
        if checkbox4.Checked then
          e.SynEdit.Options:=e.SynEdit.Options+[eoTabsToSpaces]
        else
          e.SynEdit.Options:=e.SynEdit.Options-[eoTabsToSpaces];
        e.SynEdit.TabWidth:=UpDown3.Position;
        e.SynEdit.Font.Size:=UpDown2.Position;
      end;
    end;
  end;

begin
  MainFrm.Parser := Edit1.Text;
  gsettings.PHPExeFile:=Edit1.Text;
  gsettings.PHPIniFile:=Edit4.Text;
  gsettings.UpDown4Position:=UpDown4.Position;
  MainFrm.panel2.Width := UpDown4.Position;
  assignToEditors();   /// assign selected to all open editors
  settings.UpDown1Position:=UpDown1.Position;
  gsettings.UpDown2Position:=UpDown2.Position;
  gsettings.UpDown3Position:=UpDown3.Position;
  gsettings.DateFmt:=Edit5.Text;
  gsettings.TimeFmt:=Edit6.Text;
  gsettings.DateTimeFmt:=Edit7.Text;
  gsettings.AutoIndent:=checkbox1.Checked;
  gsettings.TabsToSpaces:=checkbox4.Checked;
  gsettings.WordWrap:=checkbox2.Checked;
  settings.SaveSessionChecked:=SaveSession.Checked;
  settings.DialogFontText:=DialogFont.Text;
  gsettings.Encoding:=combobox1.Text;
  gsettings.BOM:=checkbox5.Checked;
  if DialogFont.Text <> MainFrm.Font.Name then begin
    MainFrm.Repaint;
  end;
  settings.BracesChecked:=Braces.Checked;
  settings.localpathText:=LocalPath.Text;
  settings.localPortText:=LocalPort.Text;
  if (localpath.Text<>'') and (localport.Text<>'') then begin
    mainfrm.IdHTTPServer1.Active:=false;
    mainfrm.IdHTTPServer1.DefaultPort:=StrToIntDef(settings.localPortText, 8080);
    mainfrm.acActivateExecute(nil);
  end;
  settings.FTPPassive:=ftppassive.Checked;
  settings.FTPHostText:=FTPHost.Text;
  settings.FTPPortText:=FTPPort.Text;
  settings.FTPUserText:=FTPUser.Text;
//  settings.FTPPasswordText:=FTPPassword.Text;
  settings.FTPPasswordSave:=FTPPassword.Text;
  settings.FTPServerPathText:=FTPServerPath.Text;
  settings.ExternPath:=WebServerPath.Text;

  gsettings.IdiomaText:=Idioma.text;

  gsettings.DocsPathText:=DocsPath.Text;
  dl := 'en';
  Case DocsLang.ItemIndex of
    0 : dl := 'en';
    1 : dl := 'pt_BR';
    2 : dl := 'zh';
    3 : dl := 'cs';
    4 : dl := 'nl';
    5 : dl := 'fi';
    6 : dl := 'fr';
    7 : dl := 'de';
    8 : dl := 'hu';
    9 : dl := 'it';
    10 : dl := 'ja';
    11 : dl := 'kr';
    12 : dl := 'pl';
    13 : dl := 'ro';
    14 : dl := 'sk';
    15 : dl := 'sl';
    16 : dl := 'es';
    17 : dl := 'sv';
    18 : dl := 'tr';
  end;
  gsettings.dl:=dl;
  Close;
//  if MainFrm.ShellTreeView1.Root<>LocalPath.Text then begin
//    MainFrm.ShellTreeView1.root:=LocalPath.text;
//  end;
  if settings.FTPHostText='' then begin
    MainFrm.tabsheet4.TabVisible:=false;
  end else begin
    MainFrm.tabsheet4.TabVisible:=true;
  end;
  self.ModalResult:=mrok;
  gsettings.SynPHPSyn1Filter:=edit8.Text;
  mainfrm.SynPHPSyn.DefaultFilter:=edit8.Text;
  gsettings.SynHTMLSyn1Filter:=edit11.Text;
  mainfrm.SynHTMLSyn1.DefaultFilter:=edit11.Text;
  gsettings.SynXMLSyn1Filter:=edit14.Text;
  mainfrm.SynXMLSyn1.DefaultFilter:=edit14.Text;
  gsettings.SynJSSyn1Filter:=edit10.Text;
  mainfrm.SynJScriptSyn1.DefaultFilter:=edit10.text;
  gsettings.SynSQLSyn1Filter:=edit12.Text;
  mainfrm.SynSQLSyn1.DefaultFilter:=edit12.Text;
  gsettings.SynCSSSyn1Filter:=edit9.Text;
  mainfrm.SynCssSyn1.DefaultFilter:=edit9.Text;
  gsettings.SynMultiSyn1Filter:=edit13.Text;
  mainfrm.SynMultiSyn1.DefaultFilter:=edit13.Text;
  gsettings.Assoc:=edit15.Text;
  settings.Externals.Assign(valuelisteditor1.Strings);
  settings.writeExternals;
  if RadioButton2.Checked then settings.InternBrowser:='InternetExplorer' else
  settings.InternBrowser:='Mozilla';
  settings.DefaultDoc:=edit19.Text;
  gsettings.activeLineColor:=graphics.ColorToString(ColorPickerButton4.SelectionColor);
  settings.ServerTimeout:=spinedit4.Value;
  mainfrm.DebugClient1.Active:=false;
  mainfrm.idCGIRunner1.Server.Active:=false;
  mainfrm.DebugClient1.TerminateWaitTime:=settings.ServerTimeout;
  mainfrm.idCGIRunner1.TimeOut:=settings.ServerTimeout;
  mainfrm.DebugClient1.Active:=true;
  mainfrm.idCGIRunner1.Server.Active:=true;
end;

procedure TOptionForm.Image1Click(Sender: TObject);
begin
  ShellExecute(0, 'open', 'http://www.php.net', nil, nil, 0);
end;

procedure TOptionForm.Translate(Sender: TObject);
begin
  Edit3.Text := ulang.LangFile.ReadString('Lang','Lang','<ERR: 666>');
  Caption := Lang(700);
  General.Caption := Lang(701);
  Interprete.Caption := Lang(702);
  Opciones.Caption := Lang(704);
  Borde.Caption := Lang(705);
  Ancho.Caption := Lang(706);
  Tamano.Caption := Lang(707);
  Color.Caption := Lang(708);
  EditFont.Caption := Lang(710);
  Sintaxis.Caption := Lang(711);
  Propiedades.Caption := Lang(712);
  Foreground.Caption := Lang(713);
  Background.Caption := Lang(714);
  Parser.Caption := Lang(716);
  Archivo.Caption := Lang(727);
  Actual.Caption := Lang(728);
  Extra.Caption := Lang(729);
  accept.Caption := Lang(900);
  cancel.Caption := Lang(901);
  checkbox1.Caption:=Lang(730);
  panel10.Caption:=Lang(731);
  panel18.Caption:=Lang(732);
  checkbox2.Caption:=lang(733);
  braces.Caption:=lang(734);
  panel4.Caption:=lang(735);
  panel15.Caption:=lang(736);
  panel6.Caption:=lang(737);
  label12.Caption:=lang(738);
  label13.Caption:=lang(739);
  label14.Caption:=lang(740);
  groupbox1.Caption:=lang(1700);
  label1.Caption:=lang(1701);
  label2.Caption:=lang(1702);
  groupbox3.Caption:=lang(1703);
  label9.Caption:=lang(1704);
  groupbox2.Caption:=lang(1705);
  label11.Caption:=lang(1706);
  label3.Caption:=lang(1707);
  label5.Caption:=lang(1708);
  ftppassive.Caption:=lang(1709);
  label4.Caption:=lang(1710);
  label6.Caption:=lang(1711);
  label10.Caption:=lang(1712);
  label8.Caption:=lang(1713);
  groupbox4.Caption:=lang(1714);
  TestFtp.Caption:=lang(1716);
  ExtHighlighter.Caption:=lang(1717);
  fileext.Caption:=lang(1718);
  label16.Caption:=lang(1719);
  label17.Caption:=lang(1720);
  label18.Caption:=lang(1721);
  label19.Caption:=lang(1722);
  label20.Caption:=lang(1723);
  label21.Caption:=lang(1724);
  panel11.Caption:=lang(1725);
  label15.Caption:=lang(1726);
  label31.Caption:=lang(1729);
  devpage1.Caption:=lang(1727);
  ftp.Caption:=lang(1728);
  panel20.Caption:=lang(1730);
  panel22.Caption:=lang(1750);
  ValueListEditor1.TitleCaptions[0]:=lang(1751);
  ValueListEditor1.TitleCaptions[1]:=lang(1752);
  label23.Caption:=lang(1753);
  devpage2.Caption:=lang(1754);
  bold.Caption:=lang(1760);
  italic.Caption:=lang(1761);
  install.Caption:=lang(1762);
  label27.Caption:=lang(1763)+#13+'http://www.iol.ie/~locka/mozilla/control.htm'+#13+lang(1764);
  label25.Caption:=lang(1765);
  radiobutton1.Caption:=lang(1766);
  radiobutton2.Caption:=lang(1767);
  label26.Caption:=lang(1768);
end;

procedure TOptionForm.FormShow(Sender: TObject);
begin
  translate(sender);
  Self.Font.Name := settings.DialogFontText;
  Servers.ActivePageIndex:=0;
  valuelisteditor1.Strings.Assign(settings.Externals);
end;

procedure TOptionForm.SelectLanguageClick(Sender: TObject);
begin
  OpenDialog1.Filter := 'Language File|*.lng';
  OpenDialog1.FileName:=replPath(Idioma.text);
  if OpenDialog1.Execute then begin
    Idioma.Text := OpenDialog1.FileName;
    uinifile.clearToolbars;
  end;
end;

procedure TOptionForm.SpinEdit2Change(Sender: TObject);
begin
  EditFont.Font.Size := UpDown2.Position;
end;

procedure TOptionForm.BoldClick(Sender: TObject);
var t:TListObj;
begin
  if assigned(mainfrm.GetEditor()) then begin
    t:=elementlist.Items.Objects[ElementList.ItemIndex] as TListObj;
    StyleBold(t.highlighter.Attribute[t.index]);
  end;
end;

procedure TOptionForm.StyleBold(Attri: TSynHighlighterAttributes);
begin
  if Bold.Checked = True then begin
    Attri.Style := Attri.Style + [fsBold];
  end else begin
    Attri.Style := Attri.Style - [fsBold];
  end;
end;

procedure TOptionForm.StyleItalic(Attri: TSynHighlighterAttributes);
begin
  if Italic.Checked = True then begin
    Attri.Style := Attri.Style + [fsItalic];
  end else begin
    Attri.Style := Attri.Style - [fsItalic];
  end;
end;

procedure TOptionForm.ItalicClick(Sender: TObject);
var t:TListObj;
begin
  if assigned(mainfrm.GetEditor()) then begin
    t:=elementlist.Items.Objects[ElementList.ItemIndex] as TListObj;
    StyleItalic(t.highlighter.Attribute[t.index]);
  end;
end;

procedure TOptionForm.ColorPickerButton1Change(Sender: TObject);
var t:TListObj;
begin
  if assigned(mainfrm.GetEditor()) then begin
    t:=elementlist.Items.Objects[ElementList.ItemIndex] as TListObj;
    t.highlighter.Attribute[t.index].Background:=ColorPickerButton1.SelectionColor;
  end;
end;

procedure TOptionForm.ColorPickerButton1DefaultSelect(Sender: TObject);
begin
  if assigned(mainfrm.GetEditor()) then
    ColorPickerButton1.SelectionColor:=MainFrm.getEditor().SynEdit.color;
end;

procedure TOptionForm.ColorPickerButton2Change(Sender: TObject);
var t:TListObj;
begin
  if assigned(mainfrm.GetEditor()) then begin
    t:=elementlist.Items.Objects[ElementList.ItemIndex] as TListObj;
    t.Highlighter.Attribute[t.index].Foreground:=ColorPickerButton2.SelectionColor;
  end;
end;

procedure TOptionForm.ColorPickerButton2DefaultSelect(Sender: TObject);
begin
  ColorPickerButton2.SelectionColor:=Graphics.clNone;
end;


procedure TOptionForm.ColorPickerButton3Change(Sender: TObject);
begin
  if assigned(mainfrm.GetEditor()) then
    mainfrm.geteditor.SynEdit.Color := ColorPickerButton3.SelectionColor;
end;

procedure TOptionForm.ColorPickerButton3DefaultSelect(Sender: TObject);
begin
  if assigned(mainfrm.GetEditor()) then
    mainfrm.geteditor.SynEdit.Color := Graphics.clNone;
end;

procedure TOptionForm.Image2Click(Sender: TObject);
begin
  ShellExecute(0, 'open', 'http://gtk.php.net', nil, nil, 0);
end;

procedure TOptionForm.SearchDocsClick(Sender: TObject);
begin
  OpenDialog1.Filter := 'Help Files (*.chm)|*.chm';
  OpenDialog1.FileName:=replPath(DocsPath.Text);
  if OpenDialog1.Execute then begin
    DocsPath.Text := OpenDialog1.FileName;
  end;
end;

procedure TOptionForm.DialogFontChange(Sender: TObject);
begin
  Panel11.Font.Name := DialogFont.Text;
end;

procedure TOptionForm.LocalServerPathchoiceClick(Sender: TObject);
var s1:string;
begin
  s1:=replPath(localpath.Text);
  if SelectDirectory('Bitte whlen','',s1) then
  localPath.text:=s1;
end;

function TOptionForm.ChangeFTPPath():boolean;
var command,sftp:string;
    lauf:integer;
begin
  result:=true;
  if not mainfrm.idftp1.connected then mainfrm.idftp1.connect;
  sftp:=mainfrm.idftp1.RetrieveCurrentDir;
  command:=FtpServerPath.Text;
  lauf:=3;
  while (lauf<>0) and (length(command)>0) do begin
    if command[1]='/' then begin
      dec(lauf);
      if lauf=0 then break;
    end;
    delete(command,1,1);
  end;
  try
    mainfrm.idftp1.ChangeDir(command);
  except
  end;
  sftp:=mainfrm.idftp1.RetrieveCurrentDir;
end;

procedure TOptionForm.TestFTPClick(Sender: TObject);
var i:integer;
    s:string;
begin
  if strtointdef(ftpport.Text,-1)=-1 then begin
    showmessage('Please set port to a number');
    exit;
  end;
  mainfrm.ftpdisconnect();
  mainfrm.IdFTP1.Host:=FtpHost.Text;
  mainfrm.idftp1.Passive:=ftppassive.Checked;
  mainfrm.idftp1.Username:=FtpUser.Text;
  mainfrm.idftp1.Password:=ftpPassword.Text;
  mainfrm.idftp1.port:=strtoint(ftpport.Text);
  try
    mainfrm.idftp1.Connect();
  except
  end;
  if mainfrm.idftp1.Connected then begin
    changeFtpPath();
    try
      mainfrm.idftp1.List(listbox1.Items);
    except
    end;
    for i:=0 to listbox1.items.Count-1 do begin
      s:=listbox1.Items[i];
      listbox1.Items[i]:=s;
    end;
    try
      mainfrm.idftp1.Disconnect;
    except
    end;
  end else begin
    showmessage(lang(3004));
  end;
end;

procedure TOptionForm.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key=VK_ESCAPE then begin
    Close; Key:=0;
  end;
//  showmessage(inttostr(key));
end;

procedure TOptionForm.FontchoiceClick(Sender: TObject);
begin
  if assigned(mainfrm.getEditor()) then begin
    fontDialog1.Font:=mainfrm.getEditor().SynEdit.Font;
  end;
  if fontDialog1.Execute then begin
    if assigned(mainfrm.getEditor()) then begin
      mainfrm.GetEditor().SynEdit.Font:=FontDialog1.Font;
      mainfrm.GetEditor().SynEdit.Font.Charset:=fontdialog1.Font.Charset;
  //    mainfrm.GetEditor().SynEdit.Font.Name:=EditorFont.Text;
      mainfrm.GetEditor().SynEdit.Gutter.Width:=20;
    end;
    gsettings.EditorFontText:=fontDialog1.Font.Name;
    showFont.Caption:=fontdialog1.Font.Name;
    showFont.Font:=fontDialog1.Font;
    updown2.Position:=fontDialog1.Font.Size;
  end;
end;

procedure TOptionForm.SpeedButton2Click(Sender: TObject);
begin
  OpenDialog1.Filter := 'Ini-Files|*.ini';
  OpenDialog1.FileName:=replPath(Edit4.Text);
  if OpenDialog1.Execute then begin
    Edit4.Text := OpenDialog1.FileName;
  end;
end;

procedure TOptionForm.ColorPickerButton4DefaultSelect(Sender: TObject);
begin
  ColorPickerButton4.SelectionColor:=Graphics.clNone;
end;

procedure TOptionForm.InstallClick(Sender: TObject);
var s:string;
begin
  OpenDialog1.FileName:='mozctlx.dll';
  OpenDialog1.Filter := 'dll-Files|*.dll';
  if OpenDialog1.Execute then  begin
     s:=ExtractFilePath(OpenDialog1.FileName)+'mozctlx.dll';
     frmMain.ExecNewProcess('regsvr32 "'+s+'"',true);
  end;
end;

procedure TOptionForm.Label27Click(Sender: TObject);
begin
  ShellExecute(0, 'open', PChar('http://www.iol.ie/~locka/mozilla/control.htm#download'), nil, nil, 0);
end;

procedure TOptionForm.FormClose(Sender: TObject; var Action: TCloseAction);
var i:integer;
begin
  for i:=0 to elementlist.Items.Count-1 do elementlist.Items.Objects[i].Free;
end;

procedure TOptionForm.Button1Click(Sender: TObject);
var phpini:TIniFile;
    str,str2:TStringList;
    i,i2:integer;
    node:TTreeNode;
begin
  phpini:=TIniFile.Create(gsettings.PHPIniFile);
  str:=TStringList.Create;
  str2:=TStringList.Create;
  phpini.ReadSections(str);
  TreeView1.Items.Clear;
  treeview1.SortType:=stNone;
  for i:=0 to str.Count-1 do begin
    node:=TreeView1.Items.AddChild(nil,str[i]);
    phpini.ReadSection(str[i],str2);
    for i2:=0 to str2.Count-1 do begin
      Treeview1.Items.AddChild(node,str2[i2]);
    end;
  end;
  treeview1.SortType:=stText;
  phpini.Free;
  str2.Free;
  str.Free;
end;

procedure TOptionForm.TreeView1Change(Sender: TObject; Node: TTreeNode);
var phpini:TIniFile;
begin
  if node.Parent=nil then exit;
  phpini:=TIniFile.Create(gsettings.PHPIniFile);
  label28.Caption:=Node.Text;
  edit16.Text:=phpini.ReadString(node.Parent.Text,node.Text,'');
  phpini.Free;
end;

procedure TOptionForm.ServersChange(Sender: TObject);
begin
  if (sender as TDevPages).ActivePage=devPage3 then begin
    Button1Click(nil);
  end;
end;

procedure TOptionForm.Button2Click(Sender: TObject);
var phpini:TIniFile;
    node:TTreeNode;
begin
  node:=treeview1.Selected;
  if node=nil then exit;
  phpini:=TIniFile.Create(gsettings.PHPIniFile);
  phpini.WriteString(node.Parent.Text,node.text,edit16.Text);
  phpini.Free;
end;

procedure TOptionForm.SpeedButton1Click(Sender: TObject);
var dir:string;
begin
  dir:=extractFilepath(edit17.Text);
  SelectDirectory('select log dir','',dir);
  if dir<>'' then begin
    if dir[length(dir)]<>'\' then edit17.Text:=dir+'\devphp.log' else
    edit17.Text:=dir+'devphp.log';
  end;
  mainfrm.DebugClient1.logFile:=edit17.Text;
end;

procedure TOptionForm.SpeedButton3Click(Sender: TObject);
var dir:string;
begin
  OpenDialog1.Filter := 'All Files|*.*';
  OpenDialog1.FileName:=replPath(Edit19.Text);
  if OpenDialog1.Execute then begin
    Edit19.Text := OpenDialog1.FileName;
    settings.DefaultDoc:=Edit19.Text;
  end;
end;

procedure TOptionForm.Button3Click(Sender: TObject);
var pieces :TStrings;
    i:integer;
    s:string;
begin
  s:=edit15.Text;
  if s='' then exit;
  pieces:=TStringlist.Create;
  version.split(s,';',pieces);
  for i:=0 to pieces.Count-1 do begin
    RegisterExt(pieces[i],application.ExeName)
  end;
  pieces.Free;
end;

procedure TOptionForm.Button4Click(Sender: TObject);
var pieces :TStrings;
    i:integer;
    s:string;
begin
  s:=edit15.Text;
  if s='' then exit;
  pieces:=TStringlist.Create;
  version.split(s,';',pieces);
  for i:=0 to pieces.Count-1 do begin
    UnRegisterExt(pieces[i]);
  end;
  pieces.Free;
end;

procedure TOptionForm.SpeedButton4Click(Sender: TObject);
var dir:string;
begin
  dir:=extractFilepath(edit22.Text);
  SelectDirectory('select output dir','',dir);
  if dir<>'' then begin
    if dir[length(dir)]<>'\' then edit22.Text:=dir+'\' else
    edit22.Text:=dir;
  end;
end;

procedure TOptionForm.Button5Click(Sender: TObject);
var phpini:TIniFile;
begin
  phpini:=TIniFile.Create(gsettings.PHPIniFile);
  if checkbox6.Checked then
    phpini.WriteString('xdebug','xdebug.remote_enable','On')
  else phpini.WriteString('xdebug','xdebug.remote_enable','Off');
  if checkbox3.Checked then
    phpini.WriteString('xdebug','xdebug.default_enable','On')
  else phpini.WriteString('xdebug','xdebug.default_enable','Off');
  phpini.WriteString('xdebug','xdebug.remote_mode',combobox2.Text);
  phpini.WriteString('xdebug','xdebug.remote_handler',combobox3.Text);
  phpini.WriteString('xdebug','xdebug.remote_host',edit18.Text);
  phpini.WriteString('xdebug','xdebug.remote_port',edit20.Text);
  phpini.WriteString('xdebug','xdebug.idekey',edit21.Text);
  phpini.Free;
end;

procedure TOptionForm.Label40Click(Sender: TObject);
begin
  ShellExecute(0, 'open', PChar('http://www.php.net/download-docs.php'), nil, nil, 0);
end;

end.
