//
// +----------------------------------------------------------------------+
// | Dev-PHP - Integrated Development Environment                         |
// +----------------------------------------------------------------------+
// | Copyright (C) 2002-2003, http://devphp.sourceforge.net               |
// +----------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify |
// | it under the terms of the GNU General Public License as published by |
// | the Free Software Foundation; either version 2 of the License, or    |
// | (at your option) any later version.                                  |
// | This program is distributed in the hope that it will be useful       |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of       |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         |
// | GNU General Public License for more details.                         |
// +----------------------------------------------------------------------+
// | Author: Leonardo Garca <simbiotik@users.sourceforge.net>            |
// | Author: Urs Mder       <ursmaeder@users.sourceforge.net>            |
// +----------------------------------------------------------------------+
//
unit frmTable;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls,uIniFile,ulang;

type
  TTableForm = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    Panel4: TPanel;
    Panel5: TPanel;
    Panel6: TPanel;
    Panel7: TPanel;
    cmdWidth: TEdit;
    cmdBorder: TEdit;
    cmdRows: TEdit;
    cmdColumns: TEdit;
    Panel8: TPanel;
    cmdCellSpacing: TEdit;
    Panel9: TPanel;
    cmdCellPadding: TEdit;
    accept: TSpeedButton;
    cancel: TSpeedButton;
    Label1: TLabel;
    procedure acceptClick(Sender: TObject);
    procedure cancelClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  TableForm: TTableForm;

implementation

uses frmMain;

{$R *.dfm}

procedure TTableForm.acceptClick(Sender: TObject);
var
  szTable : string;
  i, j : integer;
begin
  szTable := '<table width="' + cmdWidth.Text + '" border="' + cmdBorder.Text + '" cellspacing="' + cmdCellSpacing.Text + '" cellpadding="' + cmdCellPadding.Text + '">'#13#10;
  for i := 0 to StrToInt(cmdRows.Text)-1 do begin
    szTable := szTable + '  <tr>'#13#10;
    for j := 0 to StrToInt(cmdColumns.Text)-1 do begin
      szTable := szTable + '    <td>  </td>'#13#10;
    end;
    szTable := szTable + '  </tr>'#13#10;
  end;
  szTable := szTable + '</table>'#13#10;
  with MainFrm.GetEditor.SynEdit do begin
    SelText := szTable;
    CaretX := 10;
    CaretY := CaretY - 3;
  end;
  Close;
end;

procedure TTableForm.cancelClick(Sender: TObject);
begin
  Close;
end;

procedure TTableForm.FormShow(Sender: TObject);
begin
  Self.Font.Name := settings.DialogFontText;
  label1.Caption:=lang(3400);
  panel6.Caption:=lang(3401);
  panel7.Caption:=lang(3402);
  panel4.Caption:=lang(3403);
  panel5.Caption:=lang(3404);
  panel8.Caption:=lang(3405);
  panel9.Caption:=lang(3406);
  accept.Caption:=lang(3407);
  cancel.Caption:=lang(3408);
  caption:=lang(3409);
end;

procedure TTableForm.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key=VK_ESCAPE then begin
    Close; Key:=0;
  end;
end;

end.
