//
// +----------------------------------------------------------------------+
// | Dev-PHP - Integrated Development Environment                         |
// +----------------------------------------------------------------------+
// | Copyright (C) 2002-2003, http://devphp.sourceforge.net               |
// +----------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify |
// | it under the terms of the GNU General Public License as published by |
// | the Free Software Foundation; either version 2 of the License, or    |
// | (at your option) any later version.                                  |
// | This program is distributed in the hope that it will be useful       |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of       |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         |
// | GNU General Public License for more details.                         |
// +----------------------------------------------------------------------+
// | Author: Leonardo Garca <simbiotik@users.sourceforge.net>            |
// | Author: Urs Mder       <ursmaeder@users.sourceforge.net>            |
// +----------------------------------------------------------------------+
//
unit uEditor;

interface

uses Windows, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, consts,
  Menus, ImgList, ComCtrls, StdCtrls, ExtCtrls, SynEdit, SynEditKeyCmds, Grids,
  SynCompletionProposal, StrUtils, SynEditTypes, SynEditHighlighter, devTabs,
  uHighlighterProcs, uLang, uIniFile,version,SynEditSearch,Synunicode,
  taginspector,valedit,IdTCPServer,IdThread;

type
  TEditor = class
    procedure Init(FileName : string; LoadFile : boolean);
    procedure SaveFile(focus: boolean);
    procedure SaveAs;
    procedure NameHighlighters;
    procedure LoadEditorSettings;
    procedure Close(t: TTabSheet);
    constructor create;
    destructor destroy; override;
  protected
    procedure SynEditClick(Sender: TObject);
    procedure SynEditStatusChange(Sender: TObject;
      Changes: TSynStatusChanges);
    procedure SynEditPaintTransient(Sender: TObject; Canvas: TCanvas;
      TransientType: TTransientType);
    procedure SynEditKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FindMetas;
  private
    Fmodifed: boolean;
    encoding:TSynEncoding;
    fcheckbraces: boolean;
    { Nothing }
    procedure Setmodifed(const Value: boolean);
    procedure SynEditChange(Sender: TObject);
    procedure makefShowname;
    procedure wcheckbraces(const Value: boolean);
  public
    fTabSheet : TTabSheet;
    fFileName : string;
    fShowName : string;
    SynEdit : TSynEdit;
    MSynEditSearch:TSynEditSearch;
    szInsert : string;
    LB:string;
    creation,lastAccess,lastWrite: TDateTime;
    function checkChangedFile:boolean;
  published
    property ismodified:boolean read Fmodifed write Setmodifed;
    property checkbraces:boolean read fcheckbraces write wcheckbraces;
  end;

const TTimeStamp='TIMExxSTAMP';

implementation

uses frmMain;

function getEncoding(var encoding:TSynEncoding):boolean;
begin
  result:=false;
  encoding:=seAnsi;
  if gsettings.Encoding='Ansi' then encoding:=seAnsi;
  if gsettings.Encoding='UTF8' then encoding:=seUTF8;
  if gsettings.Encoding='UTF16LE' then encoding:=seUTF16LE;
  if gsettings.Encoding='UTF16BE' then encoding:=seUTF16BE;
  if gsettings.Encoding='Ascii' then result:=true;
end;

function ChangeFileDate(const path: string; const Creation, LastAccess,
  LastWrite: TDateTime): Boolean;
var
  hFile: THandle;
  ftCreationUTC, ftLastAccessUTC, ftLastWriteUTC: TFileTime;
  ftCreationLocal, ftLastAccessLocal, ftLastWriteLocal: TFileTime;
  stCreationLocal, stLastAccessLocal, stLastWriteLocal: TSystemTime;
begin
  result := false;
  hFile := CreateFile(PChar(path), GENERIC_READ or GENERIC_WRITE, 0, nil,
  OPEN_EXISTING, FILE_FLAG_BACKUP_SEMANTICS, 0);
  if (hFile <> INVALID_HANDLE_VALUE) then
    try
      //Umwandlung von TDateTime in Systemzeitformat
      DateTimeToSystemTime(Creation, stCreationLocal);
      DateTimeToSystemTime(LastAccess, stLastAccessLocal);
      DateTimeToSystemTime(LastWrite, stLastWriteLocal);
      //Umwandlung von Systemzeitformat in lokales Dateizeitformat
      if (SystemTimeToFileTime(stCreationLocal, ftCreationLocal)) and
      (SystemTimeToFileTime(stLastAccessLocal, ftLastAccessLocal)) and
      (SystemTimeToFileTime(stLastWriteLocal, ftLastWriteLocal)) then begin
        //Umwandlung von lokalem Dateizeitformat in Weltzeit
        if (LocalFileTimeToFileTime(ftCreationLocal, ftCreationUTC)) and
        (LocalFileTimeToFileTime(ftLastAccessLocal, ftLastAccessUTC)) and
        (LocalFileTimeToFileTime(ftLastWriteLocal, ftLastWriteUTC)) then begin
          result:=SetFileTime(hFile, @ftCreationUTC, @ftLastAccessUTC, @ftLastWriteUTC);
        end;
      end;
    finally
      CloseHandle(hFile);
    end;
end;

function GetFileDate(const FileName: string; out Creation, LastAccess,
  LastWrite: TDateTime): Boolean;
var
  hFile: THandle;
  ftCreationUTC, ftLastAccessUTC, ftLastWriteUTC: TFileTime;
  ftCreationLocal, ftLastAccessLocal, ftLastWriteLocal: TFileTime;
  stCreationLocal, stLastAccessLocal, stLastWriteLocal: TSystemTime;
begin
  result:=false;
  hFile := CreateFile(PChar(FileName), GENERIC_READ, 0, nil,
  OPEN_EXISTING, FILE_FLAG_BACKUP_SEMANTICS, 0);
  if (hFile <> INVALID_HANDLE_VALUE) then begin
    try
      //Ermittlung des Dateidatums in UTC (Weltzeit)
      if GetFileTime(hFile, @ftCreationUTC, @ftLastAccessUTC, @ftLastWriteUTC) then begin
        //Umrechnung in Ortszeit
        if FileTimeToLocalFileTime(ftCreationUTC, ftCreationLocal)
        and FileTimeToLocalFileTime(ftLastAccessUTC, ftLastAccessLocal)
        and FileTimeToLocalFileTime(ftLastWriteUTC, ftLastWriteLocal) then begin
          //Umwandlung in Systemdatumformat
          if FileTimeToSystemTime(ftCreationLocal, stCreationLocal)
          and FileTimeToSystemTime(ftLastAccessLocal, stLastAccessLocal)
          and FileTimeToSystemTime(ftLastWriteLocal, stLastWriteLocal) then begin
            //Zuweisung der Rckgabewerte
            Creation := SystemTimeToDateTime(stCreationLocal);
            LastAccess := SystemTimeToDateTime(stLastAccessLocal);
            LastWrite := SystemTimeToDateTime(stLastWriteLocal);
            result:=true;
          end;
        end;
      end;
    finally
      CloseHandle(hFile);
    end;
  end;
end;

function TEditor.checkChangedFile:boolean;
var creation1,lastAccess1,lastwrite1:TDateTime;
begin
  GetFileDate(fFilename,creation1,lastAccess1,lastwrite1);
  if lastWrite<>lastwrite1 then result:=true else result:= false;
end;

procedure TEditor.NameHighlighters;
begin
  with MainFrm do begin
  if PageControl.PageCount > 0 then begin
    if Assigned(SynEdit.Highlighter) then begin
      if SynEdit.Highlighter = SynMultiSyn1 then begin
        StatusBar1.Panels[3].Text := 'HTML - JScript - CSS';
      end else
      if SynEdit.Highlighter = SynSQLSyn1 then begin
        StatusBar1.Panels[3].Text := 'mySQL';
      end else
      if SynEdit.Highlighter = SynHTMLSyn1 then begin
        StatusBar1.Panels[3].Text := 'HTML';
      end else
      if SynEdit.Highlighter = SynXMLSyn1 then begin
        StatusBar1.Panels[3].Text := 'XML';
      end else begin
        StatusBar1.Panels[3].Text := SynEdit.Highlighter.LanguageName;
      end;
    end else begin
      StatusBar1.Panels[3].Text := Texto1.Caption;
    end;
  end;
  end;
end;

procedure TEditor.SynEditKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  try
    case Key of
      vk_Insert :
        if (not (ssCtrl in Shift)) and (not (ssShift in Shift)) then  begin
          if szInsert = Lang(1252) then szInsert := Lang(1251)
            else szInsert := Lang(1252);
          MainFrm.StatusBar1.Panels[2].Text := szInsert;
        end;
      vk_Space: if Shift=[ssCtrl] then begin
        mainFrm.AutoComplete.CurrentString:=synedit.WordAtCursor;
        mainFrm.AutoComplete.Editor:=mainFrm.GetEditor.SynEdit;
        mainFrm.AutoComplete.ActivateCompletion;
        key:=0;
      end;
      vk_Tab: begin
        if (Shift=[ssCtrl]) then begin MainFrm.Siguiente2Click(sender); exit; end;
        if synedit.SelLength=0 then exit;
        ismodified:=true;
        if (Shift=[ssShift]) then MainFrm.DeIndent1Click(sender)
          else MainFrm.Indent1Click(sender);
        Key:=0;
      end;
      // Zoom Ctrl +
      VK_ADD: if (Shift=[ssCtrl]) then MainFrm.AZoomInExecute(Self);
      // Zoom Ctrl -
      VK_SUBTRACT: if (Shift=[ssCtrl]) then MainFrm.AZoomOutExecute(Self);
    end;
  except
  end;
end;

procedure TEditor.SynEditStatusChange(Sender: TObject;
  Changes: TSynStatusChanges);
begin
  if Changes * [scAll, scCaretX, scCaretY] <> [] then begin
    MainFrm.StatusBar1.Panels[0].Text := Format('%12d:%4d',
      [SynEdit.CaretY, SynEdit.CaretX]);
  end;
end;

procedure TEditor.SaveAs;
var oldlb:string;
begin
  oldlb:=LB;
  if mainfrm.VirtualExplorerTreeview1.SelectedPath<>'' then
      MainFrm.SaveDialog.InitialDir:=Mainfrm.VirtualExplorerTreeview1.SelectedPath;
//  MainFrm.SaveDialog.InitialDir:=ExtractFilePath(fFilename);
  MainFrm.SaveDialog.FilterIndex:=gsettings.SaveType+1;
  MainFrm.SaveDialog.FileName := fTabSheet.Caption;
  if fFilename<>'' then MainFrm.SaveDialog.FileName:=fFilename;
  if MainFrm.SaveDialog.Execute then begin
    case MainFrm.SaveDialog.FilterIndex of
    1: LB:=#13#10;
    2: LB:=#10;
    3: LB:=#13;
    end;
    if FileExists(MainFrm.SaveDialog.FileName) then begin
      case MessageDlg(Lang(950) + #13#10 + Lang(951), mtConfirmation, [mbYes, mbNo], 0) of
        mrYes : begin
                  fFileName := MainFrm.SaveDialog.FileName;
                  SaveFile(false);
                end;
        mrNo : Exit;
      end;
    end else begin
      fFileName := MainFrm.SaveDialog.FileName;
      SaveFile(false);
    end;
    ismodified := TRUE;
    MainFrm.ASave.Enabled := FALSE;
    fTabSheet.Caption := ExtractFileName(fFileName);
    Application.ProcessMessages;
  end;
  SynEdit.SetFocus;
  LB:=oldLB;
end;

procedure TEditor.Close(t:TTabSheet);
begin
  MainFrm.EnableSaveAll;
  t.destroy;
  MainFrm.ActivateButtons(FALSE);
end;

procedure TEditor.SynEditChange(Sender: TObject);
begin
  ismodified := true;
end;

procedure TEditor.SaveFile(focus:boolean);
var
  WasSaved : boolean;
  s,dat:string;
  po:TBufferCoord;
  oldselstart,oldselend:integer;
  enc:TSynEncoding;
  str:TStringList;

  function GetTextStr(str:TWideStrings;LB:string): string;
  var
    I, L, Size, Count: Integer;
    P: PChar;
    S: string;
  begin
    Count := str.Count;
    Size := 0;
    for I := 0 to Count - 1 do Inc(Size, Length(str[I]) + Length(LB));
    SetString(Result, nil, Size);
    P := Pointer(Result);
    for I := 0 to Count - 1 do
    begin
      S := str[I];
      L := Length(S);
      if L <> 0 then
      begin
        System.Move(Pointer(S)^, P^, L);
        Inc(P, L);
      end;
      L := Length(LB);
      if L <> 0 then
      begin
        System.Move(Pointer(LB)^, P^, L);
        Inc(P, L);
      end;
    end;
  end;

begin
//  synedit.Text:=mainfrm.geteditor().SynEdit.Text;
  oldselstart:=synedit.SelStart;
  oldselend:=synedit.SelEnd;
  po:=synedit.CaretXY;
  mainfrm.SynEditRegExSearch1.Options:=[];
  mainfrm.SynEditRegExSearch1.Pattern:=TTimeStamp+'.*'+TTimeStamp;
  mainfrm.SynEditRegExSearch1.FindAll(SynEdit.Text);
  DateTimeToString(dat,'dd.mm.yyyy hh:nn',now);
  if mainfrm.SynEditRegExSearch1.ResultCount>0 then begin
    synedit.SelStart:=mainfrm.SynEditRegExSearch1.Results[0]-1;
    SynEdit.SelEnd:=mainfrm.SynEditRegExSearch1.Lengths[0]+mainfrm.SynEditRegExSearch1.Results[0]-1;
    SynEdit.SelText:=TTimeStamp+' '+dat+' '+TTimeStamp;
  end;
  synedit.CaretXY:=po;
  case gsettings.SaveType of
    0: LB:=#13#10;
    1: LB:=#10;
    2: LB:=#13;
  end;
  if fFilename='' then begin
    MainFrm.SaveDialog.FileName := '';
    if mainfrm.VirtualExplorerTreeview1.SelectedPath<>'' then
      MainFrm.SaveDialog.InitialDir:=Mainfrm.VirtualExplorerTreeview1.SelectedPath;
    if MainFrm.SaveDialog.Execute then begin
      fFileName := MainFrm.SaveDialog.FileName;
    end else begin
      exit;
    end;
  end;
  s:=fTabSheet.Caption;
  if s[length(s)]='*' then delete(s,length(s),1);
  if (getEncoding(enc)) or (synedit.Lines.Text='') then begin
    try
      str:=TStringList.Create;
      str.Text:=Synedit.Text;
      str.SaveToFile(fFilename);
      str.Free;
    except
    end;
  end else begin
    try
      Synedit.Lines.SaveToFile(fFilename);
    except
    end;
  end;
  WasSaved := TRUE;
  if WasSaved = TRUE then begin
    ismodified := false;
    MainFrm.ASave.Enabled := FALSE;
    fTabSheet.Caption := ExtractFileName(fFileName);
  end;
  SynEdit.Highlighter := GetHighlighterFromFileExt(MainFrm.fHighlighters, ExtractFileExt(fFileName));
  mainfrm.CheckHighlighter;
  MainFrm.EnableSaveAll;
  Application.ProcessMessages;
  if focus then begin
    mainfrm.PageControl1.ActivePageIndex:=pEdit;
    SynEdit.SetFocus;
  end;
  synedit.SelStart:=oldselstart;
  synedit.SelEnd:=oldselend;
end;

procedure TEditor.makefShowname();
const l=30;
begin
  if length(fFilename)>l then begin
    fShowName := copy(fFilename,length(fFilename)-l,l+1);
    while (pos('\',fshowname)<>0) and (pos('\',fshowname)<>1) do
      delete(fshowname,1,1);
    if pos('\',fshowname)=1 then fshowname:='..'+fshowname;
  end else
    fShowName :=fFileName;
end;

function GetFileSize(const FileName: String): Integer;
var SRec: TSearchRec;
begin
  Result := -1;
  if FindFirst(FileName, faAnyFile, SRec) = 0 then
  try Result := SRec.Size finally FindClose(SRec) end;
end;

procedure TEditor.Init(FileName : string; LoadFile : boolean);
var i:integer;
begin
  if LoadFile = TRUE then begin
    fFileName := FileName;
    makefShowname();
  end else begin
    fFileName := '';
  end;

  fTabSheet := TTabSheet.Create(MainFrm.PageControl);
  fTabSheet.Caption := ExtractFileName(FileName);
  fTabSheet.PageControl := MainFrm.PageControl;
  fTabSheet.TabVisible:= FALSE;
  fTabSheet.Tag := integer(self);

  SynEdit := TSynEdit.Create(MainFrm);
  SynEdit.PopupMenu:=mainfrm.TBPopupMenu1;
  SynEdit.Align := alClient;
  SynEdit.Parent := fTabSheet;
  SynEdit.Visible := TRUE;
  SynEdit.Gutter.UseFontStyle := FALSE;
  SynEdit.Gutter.ShowLineNumbers := TRUE;
  SynEdit.Gutter.DigitCount:=0;
  SynEdit.Options := [
                        // eoAutoIndent,
                        // eoScrollPastEol,
                        // eoSmartTabDelete,
                        // eoTabIndent,
                        // eoTabsToSpaces,
                        // eoTrimTrailingSpaces
                        eoAutoSizeMaxScrollWidth,
                        eoDragDropEditing,
                        eoDropFiles,
                        eoGroupUndo,
                        eoKeepCaretX,
                        eoScrollByOneLess,
                        eoShowScrollHint,
                        eoEnhanceHomeKey
                       ];
  LoadEditorSettings;
  encoding:=seAnsi;
  if (fFileName <> '') and (FileExists(fFileName)) then
    if getFileSize(fFilename)>0 then begin
//    SynEdit.Lines.LoadFromFile(FileName);
      encoding:=synunicode.LoadFromFile(SynEdit.Lines,Filename);
    end else begin

    end;

  GetFileDate(FileName,creation,lastAccess,lastWrite);
  SynEdit.OnChange := SynEditChange;
  SynEdit.OnDropFiles := MainFrm.SynEditDropFiles;
  SynEdit.OnKeyDown := SynEditKeyDown;
  SynEdit.OnStatusChange := SynEditStatusChange;
  SynEdit.OnClick:=SynEditClick;
  SynEdit.OnGutterClick:=Mainfrm.SynEditGutterClick;
  synEdit.OnGutterPaint:=Mainfrm.SynEdit1GutterPaint;
  SynEdit.Repaint;
  SynEdit.ClearUndo;
  Synedit.Hint:='';

//  showmessage(ExtractFileExt(fFileName));
  SynEdit.Highlighter := GetHighlighterFromFileExt(MainFrm.fHighlighters, ExtractFileExt(fFileName));
//  if synedit.highlighter<>nil then showmessage(synedit.Highlighter.GetLanguageName);
  SynEdit.SearchEngine:=MainFrm.SynEditSearch1;
  synEdit.ActiveLineColor:=graphics.StringToColor(gsettings.activeLineColor);
  NameHighlighters;
  MainFrm.ASave.Enabled := FALSE;
  FindMetas;

  MainFrm.scpParams.Editor := SynEdit;
  MainFrm.AutoComplete.Editor := SynEdit;
  MainFrm.Caption := 'Dev-PHP ' + DevPHPVer + ' - [ ' + fshowname + ' ]';
  MainFrm.StatusBar1.Panels[0].Text := Format('%12d:%4d', [SynEdit.CaretY, SynEdit.CaretX]);
  with SynEdit do
    if MainFrm.S1.checked then
      Options:=Options + [eoShowSpecialChars] else Options:=Options - [eoShowSpecialChars];

  fTabSheet.PageControl.ActivePage := fTabSheet;
  fTabSheet.TabVisible := TRUE;
  fTabSheet.PageControl.Visible := TRUE;
  MainFrm.CheckHighlighter;
  i:=synedit.Keystrokes.FindKeycode(vk_F4,[ssCtrl]);
  if i<>-1 then synedit.Keystrokes.Delete(i);
  ismodified := FALSE;
end;

procedure TEditor.LoadEditorSettings;
begin
  checkbraces:=settings.BracesChecked;
  SynEdit.Gutter.Visible := gsettings.LineNumbers;
  SynEdit.Color := gsettings.DemoEditColor;
  SynEdit.RightEdge := settings.UpDown1Position;
  SynEdit.Font.Size := gsettings.UpDown2Position;
  SynEdit.TabWidth := gsettings.UpDown3Position;
  SynEdit.Font.Name := gsettings.EditorFontText;
  if gsettings.AutoIndent then synedit.Options:=SynEdit.Options+[eoAutoIndent];
  if gsettings.TabsToSpaces then synedit.Options:=SynEdit.Options+[eoTabsToSpaces];
  SynEdit.WantTabs := TRUE;
  SynEdit.WordWrap:=gsettings.WordWrap;
  SynEdit.SearchEngine:=MainFrm.SynEditRegexSearch1;
end;

procedure TEditor.SynEditPaintTransient(Sender: TObject; Canvas: TCanvas;
  TransientType: TTransientType);
const
  BracketSet = ['{','[','(','}',']',')'];
  OpenChars:array[0..2] of Char=('{','[','(');
  CloseChars:array[0..2] of Char=('}',']',')');

  function CharToPixels(P: TBufferCoord): TPoint;
  begin
//    Result:=P;
    Result:=SynEdit.RowColumnToPixels(Synedit.BufferToDisplayPos(P));
    //Result.Y:=Result.Y-1;
  end;

var P:  TbufferCoord;
    Pix: TPoint;
    S: WideString;
    I: Integer;
    Attri: TSynHighlighterAttributes;

begin
  if not Assigned(SynEdit.Highlighter) then Exit;
  P := SynEdit.CaretXY;
  SynEdit.GetHighlighterAttriAtRowCol(P, S, Attri);
  if (SynEdit.CaretX<=length(SynEdit.LineText) + 1) and
     (SynEdit.Highlighter.SymbolAttribute = Attri) then begin
    for i := 0 to 2 do begin
      if (S = OpenChars[i]) or (S = CloseChars[i]) then begin
        Pix := CharToPixels(P);
        SynEdit.Canvas.Brush.Style := bsSolid;
        SynEdit.Canvas.Font.Assign(SynEdit.Font);
        SynEdit.Canvas.Font.Style := Attri.Style;

        if (TransientType = ttAfter) then begin
          if SynEdit.Highlighter.SymbolAttribute.Background <> clNone then
            SynEdit.Canvas.Font.Color := SynEdit.Highlighter.SymbolAttribute.Background
          else
            SynEdit.Canvas.Font.Color := SynEdit.Brush.Color;
          SynEdit.Canvas.Brush.Color := SynEdit.Highlighter.SymbolAttribute.Foreground;
        end
        else begin
          if SynEdit.Highlighter.SymbolAttribute.Foreground <> clNone then
            SynEdit.Canvas.Font.Color:= SynEdit.Highlighter.SymbolAttribute.Foreground
          else
            SynEdit.Canvas.Font.Color:= SynEdit.Font.Color;
          if SynEdit.Highlighter.SymbolAttribute.Background <> clNone then
            SynEdit.Canvas.Brush.Color:= SynEdit.Highlighter.SymbolAttribute.Background
          else
            SynEdit.Canvas.Brush.Color:= SynEdit.Brush.Color;
        end;

        SynEdit.Canvas.TextOut(Pix.X, Pix.Y, S);
        P := SynEdit.GetMatchingBracketEx(P);
        if (P.Char > 0) and (P.Line > 0) and (p.char>=SynEdit.LeftChar) then begin
          Pix := CharToPixels(P);
          if S = OpenChars[i] then
            SynEdit.Canvas.TextOut(Pix.X, Pix.Y, CloseChars[i])
          else
            SynEdit.Canvas.TextOut(Pix.X, Pix.Y, OpenChars[i]);
        end;
      end;
    end;
    SynEdit.Canvas.Brush.Style := bsSolid;
  end;
end;

procedure TEditor.FindMetas;
var
  p1,p2,i,c : integer;
  s : string;
begin
{
  This procedure looks for FrontPage's "Generator" and "ProgId" METAs and
  replaces them with the Dev-PHP ones (if the META is "Generator"), or deletes
  them (if the META is "ProgId").
  Hey, don't bother me.. FrontPage does the same (test by yourself if you don't
  belive me!).
}
  for i := 0 to SynEdit.Lines.Count-1 do begin
    s := LowerCase(SynEdit.Lines[i]);
    if (pos('<meta',s) <> 0) and (pos('content="',s) <> 0) then begin
      if (pos('name="generator"',s) <> 0) or (pos('name=''generator''',s) <> 0) or (pos('name=generator',s) <> 0) then begin
        p1 := pos('content="',s);
        p2 := pos('"',s);
        while p1 > p2 do begin
          Delete(s,p2,1);
          p2 := pos('"',s);
        end;
        Delete(s,p2,1);
        p2 := pos('"',s) + 1;
        s := SynEdit.Lines[i];
        if pos('name=',s) > pos('content=',s) then begin
          c := 1;
        end else begin
          c := 3;
        end;
        Delete(s,p1,(p2-p1)+c);
        Insert('content="Dev-PHP ' + DevPHPVer + '"',s,p1);
        SynEdit.Lines[i] := s;
      end;
      s := LowerCase(SynEdit.Lines[i]);
      if (pos('name="progid"',s) <> 0) or (pos('name=progid',s) <> 0) then begin
        p1 := pos('<meta',s);
        p2 := pos('>',s);
        while p1 > p2 do begin
          Delete(s,p2,1);
          p2 := pos('>',s);
        end;
        s := SynEdit.Lines[i];
        Delete(s,p1,(p2-p1+1));
        if trim(s) = '' then begin
          SynEdit.Lines.Delete(i);
        end else begin
          SynEdit.Lines[i] := s;
        end;
      end;
    end;
  end;
end;

constructor TEditor.create;
begin
  inherited create;
  LB:=#13#10;
end;

destructor TEditor.destroy;
begin
  inherited destroy;
end;

procedure TEditor.Setmodifed(const Value: boolean);
begin
  Fmodifed := Value;
  if Value then begin
    SynEdit.Modified:=Value;
    MainFrm.ASave.Enabled := TRUE;
    MainFrm.ASaveAll.Enabled := TRUE;
    MainFrm.Deshacer1.Enabled:=true;
    MainFrm.StatusBar1.Panels[1].Text := Lang(1250);
    MainFrm.EditMenuClick(self);
    if MainFrm.pagecontrol.ActivePage=nil then exit;
    with MainFrm.pagecontrol.ActivePage do begin
      if caption[length(caption)]<>'*' then begin
        Caption:=Caption+'*';
      end;
    end;
  end;
end;

procedure TEditor.SynEditClick(Sender: TObject);
var r:TGridRect;
    p,i:integer;
    txt,s:string;
    tagfound:boolean;
begin
  if not(mainfrm.PageControl2.ActivePage=mainfrm.TabSheet11) then exit;
  tagfound:=false;
  if assigned(mainfrm.editval) then
    mainfrm.editval.Free;
  mainfrm.editval:=TEditVal.Create(mainfrm.TabSheet11);
  mainfrm.editval.ColorDialog:=mainfrm.ColorDialog1;
  mainfrm.editval.OpenDialog:=mainfrm.OpenDialog;
  mainFrm.editval.OnTagReplace:=mainfrm.ReplaceTag;
  mainfrm.editval.Parent:=mainfrm.TabSheet11;
  mainfrm.editval.Align:=alClient;
  mainfrm.editval.DisplayOptions:=[];
  mainfrm.editval.DefaultColWidth:=85;
  mainfrm.editval.Color:=clBtnFace;
//  mainfrm.editval.OnEditButtonClick:=EditButtonClick;
  mainfrm.editval.ColWidths[0]:=(mainfrm.TabSheet11.Width div 2) -3;
  mainfrm.editval.ColWidths[1]:=(mainfrm.TabSheet11.Width div 2) -3;
  mainfrm.Panel13.Caption:='<>';
  r.Left:=1;
  r.Top:=0;
  r.Right:=1;
  r.Bottom:=0;
  mainfrm.editval.Selection:=r;
  mainfrm.editval.TgType:=noTag;
  for i:=1 to high(tagstrings) do begin
    if not tagfound then begin
      if self.SynEdit.WordAtCursor=tagstrings[i] then begin
        mainfrm.Panel13.Caption:='<'+tagstrings[i]+'>';
        mainfrm.editval.TgType:=tagtype(i);
        tagfound:=true;
      end;
    end;
  end;
  if tagfound then begin
    p:=synedit.RowColToCharIndex(synedit.CaretXY);
    txt:=synedit.Text;
    while (txt[p]<>'<') and (p>1) do dec(p);
    if txt[p+1]<>'/' then begin
      synedit.SelStart:=p-1;
      while (txt[p]<>'>') and (p<length(txt)) do begin
       s:=s+txt[p];inc(p);
      end;
      s:=s+txt[p];
      synedit.SelEnd:=p;
      mainfrm.editval.FullTag:=s;
    end else mainfrm.editval.TgType:=noTag;
    mainfrm.editval.selStart:=Synedit.SelStart;
    mainfrm.editval.selEnd:=Synedit.SelEnd;
  end;
end;

procedure TEditor.wcheckbraces(const Value: boolean);
begin
  fcheckbraces := Value;
  if fcheckbraces then begin
    if not Assigned(SynEdit.OnPaintTransient) then begin
      SynEdit.OnPaintTransient := SynEditPaintTransient;
    end;
  end else begin
    SynEdit.OnPaintTransient := nil;
  end;
end;

end.
