//
// +----------------------------------------------------------------------+
// | Dev-PHP - Integrated Development Environment                         |
// +----------------------------------------------------------------------+
// | Copyright (C) 2002-2005, http://devphp.sourceforge.net               |
// +----------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify |
// | it under the terms of the GNU General Public License as published by |
// | the Free Software Foundation; either version 2 of the License, or    |
// | (at your option) any later version.                                  |
// | This program is distributed in the hope that it will be useful       |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of       |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         |
// | GNU General Public License for more details.                         |
// +----------------------------------------------------------------------+
// | Author: Leonardo Garca <simbiotik@users.sourceforge.net>            |
// | Author: Urs Maeder <umaeder@users.sourceforge.net>                   |
// +----------------------------------------------------------------------+
//
unit uLang;

interface

uses Forms,SysUtils,IniFiles,uIniFile;

function Lang(id: integer):string;

var
  langFileName:string;
  LangFile : TIniFile;

implementation
{-----------------------------------------------------------------------------
  Procedure: geterr
  Author:    urmade
  Date:      30-Mai-2005
  Arguments: id: integer;msg:string
  Result:    string
-----------------------------------------------------------------------------}
function geterr(id: integer;msg:string):string;
begin
  if assigned(LangFile) then
    result:=langFile.ReadString('Lang',IntToStr(id),msg)
  else result:=msg;
end;
{-----------------------------------------------------------------------------
  Procedure: Lang
  Author:    urmade
  Date:      30-Mai-2005
  Arguments: id: integer
  Result:    string
-----------------------------------------------------------------------------}
function Lang(id: integer): string;
var
  msg, IDx : string;
  res:string;
begin
  IDx := IntToStr(id);
  msg := '<ERR: ' + IDx + '>';
  if not assigned(LangFile) then
    LangFile:=TIniFile.Create(ExtractFilePath(application.exename)+'\lang\english.lng');
  res := LangFile.ReadString('Lang',IDx,msg);
  if res=msg then res:='! '+geterr(id,msg);
  result:=''+res;
end;

end.
