//
// +----------------------------------------------------------------------+
// | Dev-PHP - Integrated Development Environment                         |
// +----------------------------------------------------------------------+
// | Copyright (C) 2002-2003, http://devphp.sourceforge.net               |
// +----------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify |
// | it under the terms of the GNU General Public License as published by |
// | the Free Software Foundation; either version 2 of the License, or    |
// | (at your option) any later version.                                  |
// | This program is distributed in the hope that it will be useful       |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of       |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         |
// | GNU General Public License for more details.                         |
// +----------------------------------------------------------------------+
// | Author: Leonardo Garca <simbiotik@users.sourceforge.net>            |
// | Author: Urs Mder <ursmaeder@users.sourceforge.net>                  |
// +----------------------------------------------------------------------+
//

unit version;

interface

uses Classes,SysUtils,dialogs,forms,WideStrUtils;
{**********************************}
Var DevPHPVer : string = '2.0.13 test';
    SynEditVer: string = 'synedit unicode from 19.12.2004';
    UsedComponents: string = 'TBX2_1_beta, Toolbar2000, openxml,'+
                          #13'Indy9, DelphiWebScript,VirtualShellTools'+
                          #13'VirtualTreeView, XP Theme Manager';
{**********************************}
const
  autofilename='autotext.xml';
  cursorstr='<<|>>';

procedure split(s:string;c:char;pieces:TStrings);
procedure split2(s:string;c:char;pieces:TStrings);
function replPath(path:string):string;
function escapeString(const S: wideString): wideString;

implementation

function escapeString(const S: wideString): wideString;
var
  content: TUtilsCustomWideStr;
  i: integer;
begin
  content:= TUtilsCustomWideStr.create;
  try
    for i:= 1 to length(S) do
      case ord(S[i]) of
        10: content.addWideString('&#010;');
        13: content.addWideString('&#013;');
        34: content.addWideString('&quot;');
        38: content.addWideString('&amp;');
        39: content.addWideString('&apos;');
        60: content.addWideString('&lt;');
        62: content.addWideString('&gt;');
      else
        content.addWideChar(S[i]);
      end;
    result:= content.value;
  finally
    content.free;
  end;
end;

function replPath(path:string):string;
var s:string;
begin
  s:=ExtractFilePath(application.ExeName);
  delete(s,length(s),1);
  result:=stringreplace(path,'%DEVPHP%',s,[]);
end;

procedure split(s:string;c:char;pieces:TStrings);

 var Pos : integer;
     s2:string;

 function readuntilchar():string;
 var s1:string;
 begin
   s1:='';
   while (Pos<=length(s)) and (s[Pos]<>c) do begin
     if (s[pos]<>'*') AND (s[pos]<>'.') then begin
       s1:=s1+s[pos];
     end;
     inc(Pos);
   end;
   inc(pos);
   result:=s1;
 end;

 begin
  Pos := 1;
   REPEAT
    s2:=readuntilchar();
    if s2<>'' then Pieces.Add(s2);
   UNTIL s2='';
 end;

procedure split2(s:string;c:char;pieces:TStrings);

 var Pos : integer;
     s2:string;

 function readuntilchar():string;
 var s1:string;
 begin
   s1:='';
   while (Pos<=length(s)) and (s[Pos]<>c) do begin
     s1:=s1+s[pos];
     inc(Pos);
   end;
   inc(pos);
   result:=s1;
 end;

 begin
  Pos := 1;
   REPEAT
    s2:=readuntilchar();
    if s2<>'' then Pieces.Add(s2);
   UNTIL s2='';
 end;



end.

