unit del_cvs;

interface

uses forms,Classes,Windows,dialogs,SysUtils;

type
  TResProc=function (debugStr:string):string of object;

  TCVS = class(TComponent)
  private
    Fconnstr: string;
    FWriteRes: TResProc;
    FcvsExe: string;
    FworkPath: string;
    procedure PFconnstr(const Value: string);
    function call(Cmd, WorkDir: String): string;
    procedure befehl(befehl: string);
  public
    procedure login;
    procedure logout;
    procedure checkout(module:string);
    procedure import(beschreibung, module, codewort, branch: string);
    procedure commit(beschreibung, module: string);
    procedure init(repos:string);
    procedure edit(f:string);
  published
    property workPath:string read FworkPath write FworkPath;
    property connStr:string read Fconnstr write PFconnstr;
    property cvsExe:string read FcvsExe write FcvsExe;
    property writeResult:TResProc read FWriteRes write FWriteRes;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Beispiele', [TCVS]);
end;


{ TCVS }

procedure TCVS.PFconnstr(const Value: string);
begin
  Fconnstr := Value;
end;

function TCVS.call(Cmd, WorkDir: String): string;
var
  tsi: TStartupInfo;
  tpi: TProcessInformation;
  nRead: DWORD;
  aBuf: Array[0..101] of char;
  sa: TSecurityAttributes;
  hOutputReadTmp, hOutputRead, hOutputWrite, hInputWriteTmp, hInputRead,
  hInputWrite, hErrorWrite: THandle;
  FOutput: String;

begin
  FOutput := '';

  sa.nLength              := SizeOf(TSecurityAttributes);
  sa.lpSecurityDescriptor := nil;
  sa.bInheritHandle       := True;

  CreatePipe(hOutputReadTmp, hOutputWrite, @sa, 0);
  DuplicateHandle(GetCurrentProcess(), hOutputWrite, GetCurrentProcess(),
    @hErrorWrite, 0, true, DUPLICATE_SAME_ACCESS);
  CreatePipe(hInputRead, hInputWriteTmp, @sa, 0);

  DuplicateHandle(GetCurrentProcess(), hOutputReadTmp,  GetCurrentProcess(),
    @hOutputRead,  0, false, DUPLICATE_SAME_ACCESS);
  DuplicateHandle(GetCurrentProcess(), hInputWriteTmp, GetCurrentProcess(),
    @hInputWrite, 0, false, DUPLICATE_SAME_ACCESS);
  CloseHandle(hOutputReadTmp);
  CloseHandle(hInputWriteTmp);

  FillChar(tsi, SizeOf(TStartupInfo), 0);
  tsi.cb         := SizeOf(TStartupInfo);
  tsi.dwFlags    := STARTF_USESTDHANDLES or STARTF_USESHOWWINDOW;
  tsi.hStdInput  := hInputRead;
  tsi.hStdOutput := hOutputWrite;
  tsi.hStdError  := hErrorWrite;
  CreateProcess(nil, PChar(Cmd), @sa, @sa, true, 0, nil, PChar(WorkDir),
    tsi, tpi);
  CloseHandle(hOutputWrite);
  CloseHandle(hInputRead );
  CloseHandle(hErrorWrite);
  Application.ProcessMessages;

  repeat
     if (not ReadFile(hOutputRead, aBuf, 16, nRead, nil)) or (nRead = 0) then
     begin
        if GetLastError = ERROR_BROKEN_PIPE then Break
        else MessageDlg('Pipe read error, could not execute file', mtError, [mbOK], 0);
     end;
     aBuf[nRead] := #0;
     FOutput := FOutput + PChar(@aBuf[0]);
     Application.ProcessMessages;
  until False;

  Result := FOutput;
end;

procedure TCVS.login;
begin
  befehl('login');
end;

procedure TCVS.logout;
begin
  befehl('logout');
end;

procedure TCVS.checkout(module: string);
begin
  befehl('checkout '+module);
end;

procedure TCVS.import(beschreibung,module,codewort,branch:string);
begin
  befehl('import -m"'+beschreibung+'" '+module+' '+codewort+' '+branch);
end;

procedure TCVS.commit(beschreibung,module:string);
begin
  befehl('commit -m"'+beschreibung+'" '+module);
end;

procedure TCVS.befehl(befehl:string);
var s:string;
begin
  if not FileExists(cvsExe) then begin
    if assigned(FWriteRes) then FWriteRes('CVS-exe not found');
    exit;
  end;
  if assigned(FWriteREs) then FWriteRes('****'+ fcvsexe+' '+fconnstr+' '+befehl);
  s:=Call(fcvsexe+' '+fconnstr+' '+befehl,fWorkpath);
  if assigned(FWriteRes) then FWriteRes(s);
end;

procedure TCVS.init(repos: string);
begin
  befehl('init '+repos);
end;

procedure TCVS.edit(f: string);
begin
  befehl('edit '+f);
end;

end.
