unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,ActiveX,
  Dialogs, StdCtrls, ExtCtrls, ToolWin, ComCtrls, Grids, ValEdit,StrUtils,IniFiles,
  ImgList,shlObj;

type
  TForm1 = class(TForm)
    Panel2: TPanel;
    Panel3: TPanel;
    Splitter1: TSplitter;
    Panel4: TPanel;
    ValueListEditor1: TValueListEditor;
    ValueListEditor2: TValueListEditor;
    OpenDialog1: TOpenDialog;
    Defecto: TImageList;
    ToolBar1: TToolBar;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolBar2: TToolBar;
    ToolButton1: TToolButton;
    ToolButton6: TToolButton;
    ToolButton4: TToolButton;
    SaveDialog1: TSaveDialog;
    ToolButton5: TToolButton;
    FontDialog1: TFontDialog;
    procedure ToolButton1Click(Sender: TObject);
    procedure ToolButton2Click(Sender: TObject);
    procedure ValueListEditor1SelectCell(Sender: TObject; ACol,
      ARow: Integer; var CanSelect: Boolean);
    procedure ValueListEditor1DrawCell(Sender: TObject; ACol,
      ARow: Integer; Rect: TRect; State: TGridDrawState);
    procedure FormShow(Sender: TObject);
    procedure ToolButton3Click(Sender: TObject);
    procedure ToolButton6Click(Sender: TObject);
    procedure ToolButton4Click(Sender: TObject);
    procedure ValueListEditor1Validate(Sender: TObject; ACol,
      ARow: Integer; const KeyName, KeyValue: String);
    procedure ToolButton5Click(Sender: TObject);
  private
    selLang:string;
    elLang:string;
    procedure read2fromFile(datei: string; edit: TValueListEditor);
    procedure saveEntrys(list:TValueListeditor;filename:string);
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure split(arr:TStrings;s:string;separator:string);
var ls:string;
    i:integer;
begin
  if not assigned(arr) then exit;
  if pos(separator,s)=0 then exit;
  ls:=s;
  while pos(separator,ls)<>0 do begin
    i:=pos(separator,s);
    arr.Add(copy(ls,1,i-1));
    delete(ls,1,i-1+length(separator));
  end;
  arr.Add(ls);
end;

procedure readfromFile(datei:string; edit:TValueListEditor);
var s:TStringList;
    l:TStringList;
    i:integer;
begin
  s:=TStringList.Create;
  l:=TStringList.Create;
  try
    s.LoadFromFile(datei);
    for i:=1 to s.Count-1 do begin
      if s[i]<>'' then split(l,s[i],'=');
      if l.count=2 then begin
        edit.InsertRow(l[0],l[1],true);
      end;
      l.Clear;
    end;
  finally
    s.Free;
    l.free;
  end;
end;

procedure TForm1.saveEntrys(list:TValueListeditor;filename:string);
var ini:TIniFile;
    i:integer;
//    s:string;
begin
  DeleteFile(filename);
  ini:=TIniFile.Create(filename);
  if assigned(ini) then begin
    for i:=1 to list.rowcount-1 do begin
      ini.WriteString('Lang',list.Cells[0,i],list.Cells[1,i]);
    end;
  end;
end;

procedure TForm1.read2fromFile(datei:string; edit:TValueListEditor);
var s:TStringList;
    l:TStringList;
    i,i2,i3:integer;
begin
  s:=TStringList.Create;
  l:=TStringList.Create;
  try
    s.LoadFromFile(datei);
    for i3:=1 to valueListeditor1.rowcount-1 do edit.insertRow(valueListeditor1.Cells[0,i3],' ',true);
    for i:=0 to s.Count-1 do begin
      if s[i]<>'' then split(l,s[i],'=');
      if l.count=2 then begin
        i2:=-1;
        for i3:=0 to valueListeditor1.rowcount-1 do begin
          if valueListEditor1.Keys[i3]=l[0] then i2:=i3;
        end;
        if i2<>-1 then begin
          edit.Values[l[0]]:=l[1];
        end;
      end;
      l.Clear;
    end;
  finally
    s.Free;
    l.free;
  end;
end;

procedure TForm1.ToolButton1Click(Sender: TObject);
begin
   openDialog1.FileName:=ExtractFilePath(application.ExeName)+'lang\*.lng';
   if openDialog1.execute then begin
      while valueListEditor1.Strings.text<>'' do begin
         valueListEditor1.DeleteRow(1);
      end;
      readfromFile(opendialog1.Filename,valueListEditor1);
   end;
end;

procedure TForm1.ToolButton2Click(Sender: TObject);
begin
   openDialog1.FileName:=ExtractFilePath(application.ExeName)+'lang\*.lng';
   if openDialog1.execute then begin
      while valueListEditor2.Strings.text<>'' do begin
         valueListEditor2.DeleteRow(1);
      end;
      read2fromFile(opendialog1.Filename,valueListEditor2);
      selLang:=opendialog1.FileName;
   end;
end;

procedure TForm1.ValueListEditor1SelectCell(Sender: TObject; ACol,
  ARow: Integer; var CanSelect: Boolean);
begin
//  valuelisteditor2.TopRow:=valueListeditor1.TopRow;
end;

procedure TForm1.ValueListEditor1DrawCell(Sender: TObject; ACol,
  ARow: Integer; Rect: TRect; State: TGridDrawState);
begin
  valuelisteditor2.TopRow:=valueListeditor1.TopRow;
end;

function getAppFolder():string;
var
  Allocator: IMalloc;
  SpecialDir: PItemIdList;
  FBuf: array[0..MAX_PATH] of Char;
begin
  if SHGetMalloc(Allocator) = NOERROR then
  begin
    SHGetSpecialFolderLocation(application.Handle, CSIDL_APPDATA, SpecialDir);
    SHGetPathFromIDList(SpecialDir, @FBuf[0]);
    Allocator.Free(SpecialDir);
    result:=(string(FBuf));
  end;
end;

procedure TForm1.FormShow(Sender: TObject);
var ini:TIniFile;
    path:string;
begin
  ini:=TIniFile.Create(getAppFolder()+'\devphp\'+'devphp.ini');
  if assigned(ini) then begin
    selLang:=extractFileName(ini.ReadString('Options','LangFile',''));
    path:=ExtractFilePath(application.exename)+'lang\';
    if fileExists(path+'english.lng') then begin
      readfromFile(path+'english.lng',valueListEditor1);
      elLang:=path+'english.lng';
//      (ValueListEditor1.Strings as TStringList).Sorted:=true;
    end;
    if fileExists(path+selLang) then begin
      read2fromFile(path+selLang,valueListEditor2);
    end;
  end;
end;

procedure TForm1.ToolButton3Click(Sender: TObject);
begin
  valueListEditor2.Enabled:=false;
  if fileExists(selLang) then SaveEntrys(valueListEditor2,selLang);
  valueListEditor2.Enabled:=true;
end;

procedure TForm1.ToolButton6Click(Sender: TObject);
begin
  valueListEditor1.Enabled:=false;
  if fileExists(elLang) then SaveEntrys(valueListEditor1,elLang);
  valueListEditor1.Enabled:=true;
end;

procedure TForm1.ToolButton4Click(Sender: TObject);
var s:string;
    i:integer;
begin
//  valueListEditor1.KeyOptions:=[keyEdit, keyAdd, keyDelete, keyUnique];
//  i:=IntTostr(StrToInt(valueListEditor1.Keys[valueListEditor1.Row])+1);
//  valueListEditor1.InsertRow(i,'new',true);
  saveDialog1.FileName:=ExtractFilePath(Application.exename)+'lang\untitled.lng';
  if SaveDialog1.Execute() then begin
    while valueListEditor2.Strings.text<>'' do begin
       valueListEditor2.DeleteRow(1);
    end;
    s:=ExtractFileName(ChangeFileExt(savedialog1.FileName,''));
    for i:=1 to valuelisteditor1.RowCount-1 do begin
      if i=1 then
        valuelisteditor2.InsertRow(valuelisteditor1.Keys[i],s,true)
      else
        valuelisteditor2.InsertRow(valuelisteditor1.Keys[i],'',true);
    end;
    valuelisteditor2.Strings.SaveToFile(savedialog1.FileName);
//    valuelisteditor2.InsertRow('lang',s,true);
  end;
end;

procedure TForm1.ValueListEditor1Validate(Sender: TObject; ACol,
  ARow: Integer; const KeyName, KeyValue: String);
var r:integer;
  myRect: TGridRect;
begin
  myRect.Left := 0;
  myRect.Top := valueListEditor1.Row;
  myRect.Right := 1;
  myRect.Bottom := valueListEditor1.Row;
  if valueListEditor2.RowCount=2 then exit;
  if not valueListEditor2.FindRow(valueListEditor1.Keys[valueListEditor1.Row],r) then begin
  valueListEditor2.Selection:=myRect;
  valueListEditor2.InsertRow(valueListEditor1.Keys[valueListEditor1.Row],'',false);
//    showmessage(valueListEditor1.Keys[valueListEditor1.Row]);
  end
end;

procedure TForm1.ToolButton5Click(Sender: TObject);
var i:integer;
begin
  fontdialog1.Execute;
  valuelisteditor2.Font:=FontDialog1.Font;
  valuelisteditor2.Invalidate;
  application.ProcessMessages;
  for i:=0 to valuelisteditor2.RowCount-1 do begin
    valuelisteditor2.RowHeights[i]:=valuelisteditor2.Canvas.TextHeight('test');
  end;
end;

end.



