unit OnceOnly;

interface

uses
  Windows, Messages, SysUtils, Classes, Controls, Forms,dialogs;

const
  wm_SecondStart=wm_User+$1;
  wm_SecondParameter=wm_User+$2;
  wm_HandleParameters=wm_User+$3;

type
  TStringEvent=procedure (const Value:String);

var OnParameter:TStringEvent;
    Mapping,WindowHandle:THandle;
    firstAppHandle:THandle;
    all_loaded:boolean;

procedure create;
procedure destroy;
procedure IWndProc2(var ms:TMsg; var Handled:boolean);

implementation

uses frmMain;
type
  PInstInfo=^TInstInfo;
  TInstInfo=record
     AppHandle:THandle;
     Parameter:ShortString;
  end;

{*******************************************************}
{* TOnceOnly                                           *}
{*******************************************************}

function GetLongPathName(APath:String):String;
var
  i : Integer;
  h : THandle;
  Data : TWin32FindData;
  IsBackSlash : Boolean;
begin
  APath:=ExpandFileName(APath);
  i:=Pos('\',APath);
  Result:=Copy(APath,1,i);
  Delete(APath,1,i);
  repeat
    i:=Pos('\',APath);
    IsBackSlash:=i>0;
    if Not IsBackSlash then
      i:=Length(APath)+1;
    h:=FindFirstFile(PChar(Result+Copy(APath,1,i-1)),Data);
    if h<>INVALID_HANDLE_VALUE then begin
      try
        Result:=Result+Data.cFileName;
        if IsBackSlash then
          Result:=Result+'\';
      finally
        Windows.FindClose(h);
      end;
    end
    else begin
      Result:=Result+APath;
      Exit;
    end;
    Delete(APath,1,i);
  until Length(APath)=0;
end;

function ForceForegroundWindow(hWnd: THandle): BOOL;
var 
  hCurWnd: THandle; 
begin
//  showmessage('ForceForegroundWindow');
  hCurWnd := GetForegroundWindow;
  AttachThreadInput(
    GetWindowThreadProcessId(hCurWnd, nil),
    GetCurrentThreadId, True);
  Result := SetForegroundWindow(hWnd);
  AttachThreadInput(
    GetWindowThreadProcessId(hCurWnd, nil),
    GetCurrentThreadId, False);
end;

procedure CheckMapping;
var I:Integer;
    MapView:PInstInfo;
begin
   Mapping:=CreateFileMapping ($FFFFFFFF,nil,Page_ReadWrite,0,SizeOf (TInstInfo),
        //PChar (ExtractFileName (ParamStr (0))));
        'test');
   if GetLastError=Error_Already_Exists then
   begin
      MapView:=MapViewOfFile (Mapping,File_Map_Write,0,0,0);
      if ParamCount>0 then
        for I:=1 to ParamCount do
        begin
           MapView^.Parameter:=GetLongPathName(ParamStr(I));
            PostMessage(MapView^.AppHandle,wm_HandleParameters,0,0);
        end;
      UnmapViewOfFile(MapView);
      all_loaded:=true;
      application.Terminate;
   end else begin
      all_loaded:=false;
      MapView:=MapViewOfFile (Mapping,File_Map_Write,0,0,0);
      MapView^.AppHandle:=Application.Handle;
      if paramCount>0 then
        for I:=1 to ParamCount do
        begin
           MapView^.Parameter:=GetLongPathName(ParamStr(I));
           PostMessage(MapView^.AppHandle,wm_HandleParameters,0,0);
        end;
      UnmapViewOfFile (MapView);
      all_loaded:=true;
   end;
end;

procedure IWndProc2 (var ms:TMsg; var Handled:boolean);

   procedure HandleParameters;
   var MapView:PInstInfo;
   begin
    MapView:=MapViewOfFile (Mapping,File_Map_Read,0,0,0);
    if MapView.Parameter<>'' then begin
       if Assigned (OnParameter) then
         OnParameter (MapView.Parameter);
    end;
    UnmapViewOfFile (MapView);
   end;

begin {TOnceOnly.WndProc}
   with ms do
      case Ms.message of
         wm_HandleParameters : begin
            HandleParameters;
            handled:=true;
         end;
//         else Result:=DefWindowProc (WindowHandle,Msg,wParam,lParam);
         else handled:=false;
      end;
end;

procedure Create;
begin
   CheckMapping;
   PostMessage (WindowHandle,wm_HandleParameters,0,0);
end;

procedure Destroy;
begin
   if Mapping<>0 then CloseHandle (Mapping);
end;

initialization
  Create;
finalization
  Destroy;
end.

