//
// +----------------------------------------------------------------------+
// | Dev-PHP - Integrated Development Environment                         |
// +----------------------------------------------------------------------+
// | Copyright (C) 2002-2003, http://devphp.sourceforge.net               |
// +----------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify |
// | it under the terms of the GNU General Public License as published by |
// | the Free Software Foundation; either version 2 of the License, or    |
// | (at your option) any later version.                                  |
// | This program is distributed in the hope that it will be useful       |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of       |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         |
// | GNU General Public License for more details.                         |
// +----------------------------------------------------------------------+
// | Author: Leonardo Garca <simbiotik@users.sourceforge.net>            |
// | Author: Urs Mder       <ursmaeder@users.sourceforge.net>            |
// +----------------------------------------------------------------------+
//
unit frmGoTo;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, Spin, uLang,uIniFile,
//  XPMenu,
  ExtCtrls;

type
  TGoToLine = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Line: TSpinEdit;
    Label1: TLabel;
    accept: TSpeedButton;
    cancel: TSpeedButton;
    procedure acceptClick(Sender: TObject);
    procedure cancelClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  GoToLine: TGoToLine;

implementation

uses frmMain;

{$R *.dfm}

procedure TGoToLine.acceptClick(Sender: TObject);
begin
  with MainFrm.GetEditor do begin
    SynEdit.CaretY := Line.Value;
    SynEdit.TopLine := Line.Value;
    SynEdit.EnsureCursorPosVisible;
    SynEdit.SetFocus;
  end;
  Close;
end;

procedure TGoToLine.cancelClick(Sender: TObject);
begin
  Close;
end;

procedure TGoToLine.FormShow(Sender: TObject);
begin
  Self.Font.Name := settings.DialogFontText;
  Line.MaxValue := MainFrm.GetEditor.SynEdit.Lines.Count;
  Line.MinValue := 1;
  Caption := Lang(550);
  Label1.Caption := Lang(551);
  accept.Caption := Lang(900);
  Cancel.Caption := Lang(901);
end;

procedure TGoToLine.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key=VK_ESCAPE then begin
    Close; Key:=0;
  end;
end;

end.
