//
// +----------------------------------------------------------------------+
// | Dev-PHP - Integrated Development Environment                         |
// +----------------------------------------------------------------------+
// | Copyright (C) 2002-2003, http://devphp.sourceforge.net               |
// +----------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify |
// | it under the terms of the GNU General Public License as published by |
// | the Free Software Foundation; either version 2 of the License, or    |
// | (at your option) any later version.                                  |
// | This program is distributed in the hope that it will be useful       |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of       |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         |
// | GNU General Public License for more details.                         |
// +----------------------------------------------------------------------+
// | Author: Leonardo Garca <simbiotik@users.sourceforge.net>            |
// +----------------------------------------------------------------------+
//
unit frmMail;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls,uIniFile,ulang;

type
  TMailForm = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Panel3: TPanel;
    Panel4: TPanel;
    Panel5: TPanel;
    Panel6: TPanel;
    MessageContent: TMemo;
    cancel: TSpeedButton;
    accept: TSpeedButton;
    Panel7: TPanel;
    Label1: TLabel;
    Panel8: TPanel;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    procedure acceptClick(Sender: TObject);
    procedure cancelClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MailForm: TMailForm;

implementation

uses frmMain;

{$R *.dfm}

procedure TMailForm.acceptClick(Sender: TObject);
var
  i : integer;
  Buffer, InsertString : string;
begin
  InsertString := '';
  for i := 0 to MessageContent.lines.Count - 1 do begin
    Buffer := Buffer + MessageContent.Lines[i];
  end;
  if CheckBox1.Checked = True then begin
    InsertString := '$headers .= "Content-Type: text/html; charset=iso-8859-1\n";'#13#10;
  end;
  if CheckBox2.Checked = True then begin
    InsertString := InsertString + '$headers .= "X-Priority: 1\n";'#13#10;
  end;
  InsertString := InsertString + 'mail("' + Self.Edit2.Text + '", "' + Self.Edit3.Text + '", "' + Buffer + '", "From: ' + Self.Edit1.Text + '\nReply-To: ' + Self.Edit1.Text + '"';
  if (CheckBox1.Checked = True) or (CheckBox2.Checked = True) then begin
    InsertString := InsertString + ', $headers';
  end;
  InsertString := InsertString + ');'#13#10;
  MainFrm.GetEditor.SynEdit.SelText := InsertString;
  Close;
end;

procedure TMailForm.cancelClick(Sender: TObject);
begin
  Close;
end;

procedure TMailForm.FormShow(Sender: TObject);
begin
  Self.Font.Name := settings.DialogFontText;
  Panel7.Font.Name := Self.Font.Name;
  Panel6.Font.Name := Self.Font.Name;
  Panel2.Font.Name := Self.Font.Name;
  accept.Font.Name := Self.Font.Name;
  cancel.Font.Name := Self.Font.Name;
  label1.Caption:=lang(3300);
  panel3.Caption:=lang(3301);
  panel4.Caption:=lang(3302);
  panel5.Caption:=lang(3303);
  checkbox2.Caption:=lang(3304);
  checkbox1.Caption:=lang(3305);
  accept.Caption:=lang(3306);
  cancel.Caption:=lang(3307);
  caption:=lang(3308);
end;

procedure TMailForm.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key=VK_ESCAPE then begin
    Close; Key:=0;
  end;
end;

end.
