//
// +----------------------------------------------------------------------+
// | Dev-PHP - Integrated Development Environment                         |
// +----------------------------------------------------------------------+
// | Copyright (C) 2002-2003, http://devphp.sourceforge.net               |
// +----------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify |
// | it under the terms of the GNU General Public License as published by |
// | the Free Software Foundation; either version 2 of the License, or    |
// | (at your option) any later version.                                  |
// | This program is distributed in the hope that it will be useful       |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of       |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         |
// | GNU General Public License for more details.                         |
// +----------------------------------------------------------------------+
// | Author: Leonardo Garca <simbiotik@users.sourceforge.net>            |
// | Author: Urs Mder <ursmaeder@users.sourceforge.net>                  |
// +----------------------------------------------------------------------+
//

unit frmMain;

interface

uses Forms, Windows, Dialogs,  ExtCtrls, SynRegExpr,
  SynHighlighterXML, SynCompletionProposal, SynHighlighterMulti,
  SynExportRTF, SynEditExport, SynExportHTML, SynHighlighterSQL,SynEditTypes,
  SynHighlighterPHP, SynHighlighterJScript, SynHighlighterHtml,SynEditSearch,
  SynEdit,uEditor,uIniFile, IniFiles, D6OnHelpFix,hh, hh_funcs,SysUtils,uLang,
  SynEditHighlighter, SynHighlighterCss, SynEditPrint, Menus, ImgList,Graphics,
  Registry, uHighlighterProcs, Clipbrd,StrUtils,shellAPI,
  Controls, Classes, ActnList, StdCtrls, ComCtrls, OleCtrls, DateUtils,
  SHDocVw, ToolWin, SynMemo,Messages,version,
  cltreeview,uParser, SynEditMiscClasses, ActnMan, ActnCtrls,
  CustomizeDlg, BandActn, SynEditRegexSearch, TB2Item, TB2Dock, TB2Toolbar,
  TB2MDI, TB2ExtItems, TB2ToolWindow,Tb2kedit,Consts, SynEditOptionsDialog,
  StdActns, Buttons,
  OleServer, synunicode, SyncObjs,
  OnceOnly, ValEdit,ActiveX,ShlObj,
  SynEditPrintPreview, Spin,taginspector,XDOM_3_1,TypInfo,
  Grids, DB, FileCtrl, php4delphi, PHPCustomLibrary,
  phpLibrary, TBXSwitcher, dws2Comp, dws2VCLGUIFunctions,
  dws2FileFunctions, dws2ComConnector,TBX,
  dws2Exprs, dws2Symbols, dws2Errors,  dws2Debugger,
  dws2Compiler, dws2HtmlFilter,
  dws2ClassesLibModule,dws2EditorFunctions,
  TBXOfficeXPTheme, TBXStripesTheme, TBXToolPals,
  IdException, IdAntiFreezeBase, IdAntiFreeze, IdGlobal,
  IdHTTPServer, WebServ, IdBaseComponent,
  IdComponent, IdTCPConnection, IdTCPClient, IdFTP,
  idISAPIRunner, idCGIRunner, IdTCPServer, IdCustomHTTPServer, idPHPRunner,
  VirtualTrees, VirtualExplorerTree,VirtualShellUtilities,
  VirtualShellToolBar, ThemeMgr, GIFImage, AutoStrCtrls,InitStuff,
  MOZILLACONTROLLib_TLB;

type
  TftpInfo=record
    name:string;
    isdir:boolean;
    month:string;
    day:string;
    timeoryear:string;
    owner:string;
    group:string;
    size:integer;
    permission:string;
    unknown:string;
  end;
  TPosInfo=record
    line:integer;
    char:integer;
    isfilename:boolean;
    filename:string;
    pos:integer;
    length:integer;
  end;

  PTPosInfo = ^TPosInfo;

  EStringInvalid = class(Exception);

  TWalkProc=Procedure (tp:TftpInfo) of object;
  TWalkFolderProc=Procedure (folder:string) of object;

  TStrProc = Function(const S: string;searchstr:string):boolean;
  TMainFrm = class(TForm)
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    PrinterSetupDialog1: TPrinterSetupDialog;
    Defecto: TImageList;
    ExportDialog: TSaveDialog;
    PrintDialog1: TPrintDialog;
    SynEditPrint1: TSynEditPrint;
    ColorDialog1: TColorDialog;
    SynCssSyn1: TSynCssSyn;
    SynHTMLSyn1: TSynHTMLSyn;
    SynJScriptSyn1: TSynJScriptSyn;
    SynPHPSyn: TSynPHPSyn;
    SynSQLSyn1: TSynSQLSyn;
    SynExporterHTML1: TSynExporterHTML;
    SynExporterRTF1: TSynExporterRTF;
    SynMultiSyn1: TSynMultiSyn;
    StatusBar1: TStatusBar;
    AutoComplete: TSynCompletionProposal;
    SynXMLSyn1: TSynXMLSyn;
    FindDialog1: TFindDialog;
    scpParams: TSynCompletionProposal;
    Panel5: TPanel;
    PopupMenu3: TPopupMenu;
    Timer1: TTimer;
    DataSource1: TDataSource;
    SynEditSearch1: TSynEditSearch;
    StandardM: TActionManager;
    ANew: TAction;
    AOpen: TAction;
    ASave: TAction;
    APrint: TAction;
    AExit: TAction;
    AUndo: TAction;
    ARedo: TAction;
    ASaveAs: TAction;
    ASaveAll: TAction;
    ASearch: TAction;
    AReplace: TAction;
    ANextSearch: TAction;
    AClose: TAction;
    AOpenProject: TAction;
    ASaveProject: TAction;
    ASelectAll: TAction;
    AGotoLine: TAction;
    ASaveAndSend: TAction;
    AExecute: TAction;
    ARunGTK: TAction;
    ACheck: TAction;
    ASaveAndSendFtp: TAction;
    ASend: TAction;
    ANextWindow: TAction;
    APreviousWindow: TAction;
    ASearchDocs: TAction;
    AInsText: TAction;
    AInsButton: TAction;
    AInsCheck: TAction;
    AInsRadio: TAction;
    AInsList: TAction;
    AInsFile: TAction;
    AInsImage: TAction;
    AInsHidden: TAction;
    AInsImagen: TAction;
    AInsTable: TAction;
    AInsLayer: TAction;
    AInsForm: TAction;
    AInsInc: TAction;
    AInsMail: TAction;
    AInsHR: TAction;
    AInsBR: TAction;
    AInsDate: TAction;
    Trenner: TAction;
    SynEditRegexSearch1: TSynEditRegexSearch;
    ASearchRegEx: TAction;
    ASearchRegDir: TAction;
    AEditTool: TAction;
    ACloseAll: TAction;
    TBDock1: TTBXDock;
    TBToolbar1: TTBXToolbar;
    FileMenu: TTBXSubmenuItem;
    Nuevo1: TTBXSubmenuItem;
    NuevoTexto: TTBXItem;
    N17: TTBXSeparatorItem;
    NuevoHTML: TTBXItem;
    NuevoPHP: TTBXItem;
    N1: TTBXSeparatorItem;
    Open: TTBXItem;
    OpenProject1: TTBXItem;
    Reabrir: TTBXSubmenuItem;
    N16: TTBXSeparatorItem;
    ReloadCurrentFile1: TTBXItem;
    N15: TTBXSeparatorItem;
    GuardarComo2: TTBXItem;
    FileFormat1: TTBXSubmenuItem;
    Savewithcrlf1: TTBXItem;
    SaveUnix1: TTBXItem;
    Savewithcr1: TTBXItem;
    SaveProject1: TTBXItem;
    GuardarComo1: TTBXItem;
    GuardarTodo1: TTBXItem;
    N10: TTBXSeparatorItem;
    Cerrar1: TTBXItem;
    N4: TTBXSeparatorItem;
    Exportar: TTBXSubmenuItem;
    HTML2: TTBXItem;
    RTF1: TTBXItem;
    Imprimir2: TTBXItem;
    ConfigurarImpresin1: TTBXItem;
    N5: TTBXSeparatorItem;
    Salir1: TTBXItem;
    EditMenu: TTBXSubmenuItem;
    Deshacer1: TTBXItem;
    Rehacer1: TTBXItem;
    N2: TTBXSeparatorItem;
    N3: TTBXSeparatorItem;
    Indent1: TTBXItem;
    DeIndent1: TTBXItem;
    N23: TTBXSeparatorItem;
    DeleteLine1: TTBXItem;
    DeletetoEndLine1: TTBXItem;
    DeleteWord1: TTBXItem;
    DeletePreviousWord1: TTBXItem;
    SeleccionarTodo1: TTBXItem;
    UCaseLCase1: TTBXSubmenuItem;
    UpperCase1: TTBXItem;
    LowerCase1: TTBXItem;
    C3: TTBXItem;
    OptimizarComprimircdigo1: TTBXItem;
    SearchMenu: TTBXSubmenuItem;
    Buscar2: TTBXItem;
    Reemplazar1: TTBXItem;
    NextSearch1: TTBXItem;
    Re1: TTBXItem;
    SearchRegExDir: TTBXItem;
    N11: TTBXSeparatorItem;
    Iralnea1: TTBXItem;
    ViewMenu: TTBXSubmenuItem;
    N19: TTBXSeparatorItem;
    LineNumbers: TTBXItem;
    S1: TTBXItem;
    AnpassenFile: TTBXItem;
    RunMenu: TTBXSubmenuItem;
    EjecutarPHP1: TTBXItem;
    N13: TTBXSeparatorItem;
    Gtk2: TTBXItem;
    N14: TTBXSeparatorItem;
    Comprobarsintaxis1: TTBXItem;
    OptionsMenu: TTBXSubmenuItem;
    Formato1: TTBXSubmenuItem;
    CSS1: TTBXItem;
    HTML3: TTBXItem;
    JavaScript1: TTBXItem;
    MySQL1: TTBXItem;
    PHP1: TTBXItem;
    HtmlPHP1: TTBXItem;
    XML1: TTBXItem;
    Texto1: TTBXItem;
    N9: TTBXSeparatorItem;
    OpcionesGenerales1: TTBXItem;
    CheckforUpdate1: TTBXItem;
    test1: TTBXItem;
    ToolsMenu: TTBXSubmenuItem;
    EMailWizard1: TTBXItem;
    InsertFunction: TTBXItem;
    InsertTable1: TTBXItem;
    N20: TTBXSeparatorItem;
    PRINTselected1: TTBXItem;
    ECHOselectedtext1: TTBXItem;
    N21: TTBXSeparatorItem;
    Replacewith1: TTBXItem;
    N22: TTBXSeparatorItem;
    InsertColor1: TTBXItem;
    DateTime1: TTBXSubmenuItem;
    InsertDate1: TTBXItem;
    InsertTime1: TTBXItem;
    InsertDateTime1: TTBXItem;
    DocumentSpecials1: TTBXSubmenuItem;
    InsertDocPath1: TTBXItem;
    InsertDocFilename1: TTBXItem;
    Insert1: TTBXItem;
    WindowMenu: TTBXSubmenuItem;
    CerrarTodo: TTBXItem;
    N7: TTBXSeparatorItem;
    Siguiente2: TTBXItem;
    Anterior1: TTBXItem;
    N12: TTBXSeparatorItem;
    HelpMenu: TTBXSubmenuItem;
    SearchDocumentation: TTBXItem;
    Website: TTBXItem;
    N6: TTBXSeparatorItem;
    News: TTBXItem;
    ReadGPL: TTBXItem;
    N8: TTBXSeparatorItem;
    Acercade1: TTBXItem;
    test2: TTBXItem;
    TBToolbar2: TTBXToolbar;
    SideBarToggleItem: TTBXVisibilityToggleItem;
    TBSubmenuItem1: TTBXSubmenuItem;
    TBItem4: TTBXItem;
    TBItem1: TTBXItem;
    TBItem5: TTBXItem;
    TBItem2: TTBXItem;
    TBItem3: TTBXItem;
    TBItem6: TTBXItem;
    TBItem7: TTBXItem;
    TBItem8: TTBXItem;
    TBItem9: TTBXItem;
    TBItem10: TTBXItem;
    TBToolbar3: TTBXToolbar;
    TBItem11: TTBXItem;
    TBItem12: TTBXItem;
    TBItem13: TTBXItem;
    TBItem14: TTBXItem;
    TBItem15: TTBXItem;
    TBItem16: TTBXItem;
    TBItem17: TTBXItem;
    TBItem18: TTBXItem;
    TBToolbar4: TTBXToolbar;
    TBItem19: TTBXItem;
    TBItem20: TTBXItem;
    TBItem21: TTBXItem;
    TBItem22: TTBXItem;
    TBItem23: TTBXItem;
    TBItem24: TTBXItem;
    TBItem25: TTBXItem;
    TBItem26: TTBXItem;
    TBItem27: TTBXItem;
    TBItem28: TTBXItem;
    TBItem29: TTBXItem;
    TBItem30: TTBXItem;
    TBItem31: TTBXItem;
    TBItem32: TTBXItem;
    TBItem33: TTBXItem;
    TBItem34: TTBXItem;
    TBItem35: TTBXItem;
    TBDock2: TTBXDock;
    TBToolWindow1: TTBXToolWindow;
    Panel2: TPanel;
    PageControl2: TPageControl;
    TabSheet7: TTabSheet;
    TabSheet8: TTabSheet;
    TabSheet10: TTabSheet;
    Panel6: TPanel;
    TreeView11: TTreeView1;
    TBItem36: TTBXItem;
    TBItem37: TTBXItem;
    TBSeparatorItem1: TTBXSeparatorItem;
    TBSeparatorItem2: TTBXSeparatorItem;
    TBSeparatorItem3: TTBXSeparatorItem;
    TBSeparatorItem4: TTBXSeparatorItem;
    TBSeparatorItem6: TTBXSeparatorItem;
    Splitter2: TSplitter;
    TBSubmenuItem2: TTBXSubmenuItem;
    AnpassenEdit: TTBXItem;
    AEditEdit: TAction;
    AEditIns: TAction;
    AnpassenHtml: TTBXItem;
    FileToolbarVisible: TTBXVisibilityToggleItem;
    HtmlToolbarVisible: TTBXVisibilityToggleItem;
    StatusBarVisible: TTBXVisibilityToggleItem;
    SideBarVisible: TTBXVisibilityToggleItem;
    NewHTMLFile: TAction;
    AInsShellFilename: TAction;
    TBItem40: TTBXItem;
    AInsShellPath: TAction;
    TBItem41: TTBXItem;
    Send: TTBXItem;
    SearchRegExOFiles: TTBXItem;
    ASearchOFiles: TAction;
    SendFile: TTBXItem;
    EditToolbarVisible: TTBXVisibilityToggleItem;
    EditCut1: TEditCut;
    EditCopy1: TEditCopy;
    EditPaste1: TEditPaste;
    TBItem42: TTBXItem;
    TBItem43: TTBXItem;
    TBItem44: TTBXItem;
    ClearHistory: TTBXItem;
    TBDock3: TTBXDock;
    Splitter4: TSplitter;
    Indent: TAction;
    Ahref: TAction;
    TBHref: TTBXItem;
    Panel10: TPanel;
    SpeedButton1: TSpeedButton;
    AComment: TAction;
    TBItem45: TTBXItem;
    Externals: TTBXSubmenuItem;
    TBXItem46: TTBXItem;
    Reopenproject: TTBXSubmenuItem;
    clearprojhist: TTBXItem;
    TBSeparatorItem5: TTBXSeparatorItem;
    classimages: TImageList;
    TabsToSpaces: TTBXItem;
    SpacesToTabs: TTBXItem;
    SynEditPrint2: TSynEditPrint;
    TabSheet11: TTabSheet;
    Panel13: TPanel;
    DomImplementation1: TDomImplementation;
    XmlToDomParser1: TXmlToDomParser;
    DomToXmlParser1: TDomToXmlParser;
    ListBox1: TListBox;
    PopupMenu4: TPopupMenu;
    snedit: TMenuItem;
    snnew: TMenuItem;
    sndelete: TMenuItem;
    Script1: TDelphiWebScriptII;
    dws2ComConnector1: Tdws2ComConnector;
    dws2FileFunctions1: Tdws2FileFunctions;
    dws2GUIFunctions1: Tdws2GUIFunctions;
    dws2Unit1: Tdws2Unit;
    TabSheet12: TTabSheet;
    StringGrid1: TStringGrid;
    TBXSwitcher1: TTBXSwitcher;
    TBXDock1: TTBXDock;
    TBXToolbar1: TTBXToolbar;
    TBItem47: TTBXItem;
    TBItem49: TTBXItem;
    TBItem48: TTBXItem;
    ScriptMenu: TTBXSubmenuItem;
    AZoomIn: TAction;
    AZoomOut: TAction;
    AZoomreset: TAction;
    TBXItem2: TTBXItem;
    TBXSwitcher2: TTBXSwitcher;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    Splitter3: TSplitter;
    PageControl: TPageControl;
    Panel7: TPanel;
    Panel9: TPanel;
    Button3: TButton;
    TreeView1: TTreeView;
    TabSheet2: TTabSheet;
    Splitter1: TSplitter;
    Panel11: TPanel;
    TabSheet3: TTabSheet;
    WebBrowser1: TWebBrowser;
    TabSheet4: TTabSheet;
    ListView: TListView;
    Memo1: TMemo;
    Panel1: TPanel;
    Label1: TLabel;
    SpeedButton9: TSpeedButton;
    Panel4: TPanel;
    Button1: TButton;
    TabSheet5: TTabSheet;
    WebBrowser2: TWebBrowser;
    TabSheet6: TTabSheet;
    Panel3: TPanel;
    BrowserPath: TEdit;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    WebBrowser3: TWebBrowser;
    TabSheet9: TTabSheet;
    SynEditPrintPreview1: TSynEditPrintPreview;
    Panel12: TPanel;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    Label2: TLabel;
    Label3: TLabel;
    SpeedButton7: TSpeedButton;
    SpeedButton8: TSpeedButton;
    Label4: TLabel;
    CheckBox1: TCheckBox;
    SpinEdit1: TSpinEdit;
    SpinEdit2: TSpinEdit;
    Scripts: TTabSheet;
    Memo2: TMemo;
    TestScript: TButton;
    IdAntiFreeze1: TIdAntiFreeze;
    IdFTP1: TIdFTP;
    IdHTTPServer1: TIdHTTPServer;
    CGIRunner: TidCGIRunner;
    EditPHPIni1: TTBXItem;
    EditPHPini: TAction;
    PageControl3: TPageControl;
    Messages: TTabSheet;
    ValueListEditor1: TValueListEditor;
    Source: TTabSheet;
    SynMemo1: TSynMemo;
    VirtualExplorerTreeview1: TVirtualExplorerTreeview;
    VirtualExplorerListview1: TVirtualExplorerListview;
    FtpItems: TImageList;
    Image1: TImage;
    Panel8: TPanel;
    ToggleBookmarks: TTBXSubmenuItem;
    tbm9: TTBXItem;
    tbm7: TTBXItem;
    tbm6: TTBXItem;
    tbm5: TTBXItem;
    tbm4: TTBXItem;
    tbm3: TTBXItem;
    tbm2: TTBXItem;
    tbm1: TTBXItem;
    tbm8: TTBXItem;
    tbm0: TTBXItem;
    TBPopupMenu1: TTBPopupMenu;
    JumpBookmarks: TTBXSubmenuItem;
    jbm0: TTBXItem;
    jbm9: TTBXItem;
    jbm8: TTBXItem;
    jbm7: TTBXItem;
    jbm6: TTBXItem;
    jbm5: TTBXItem;
    jbm4: TTBXItem;
    jbm3: TTBXItem;
    jbm2: TTBXItem;
    jbm1: TTBXItem;
    EditSubmenu: TTBXSubmenuItem;
    Zoom: TTBXSubmenuItem;
    TBXItem1: TTBXItem;
    TBXItem3: TTBXItem;
    TBXItem4: TTBXItem;
    ADeindent: TAction;
    TBPopupMenu2: TTBPopupMenu;
    TBXItem5: TTBXItem;
    TBXItem6: TTBXItem;
    PopupMenu1: TPopupMenu;
    ASend1: TMenuItem;
    InsertselectedFilename1: TMenuItem;
    InsertselectedFilePath1: TMenuItem;
    jumpsubmenu: TTBXSubmenuItem;
    toggleSubmenu: TTBXSubmenuItem;
    ThemeManager1: TThemeManager;
    zoom2: TTBXSubmenuItem;
    AFindFirst: TAction;
    procedure Acercade1Click(Sender: TObject);
    procedure HTML1Click(Sender: TObject);
    procedure PHP1Click(Sender: TObject);
    procedure Texto1Click(Sender: TObject);
    procedure SeleccionarTodo1Click(Sender: TObject);
    procedure StatusBarVisibleClick(Sender: TObject);
    procedure NuevoExecute(Sender: TObject);
    procedure AOpenExecute(Sender: TObject);
    procedure GuardarExecute(Sender: TObject);
    procedure SalirExecute(Sender: TObject);
    procedure DeshacerExecute(Sender: TObject);
    procedure RehacerExecute(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CSS1Click(Sender: TObject);
    procedure JavaScript1Click(Sender: TObject);
    procedure LineNumbersClick(Sender: TObject);
    procedure EjecutarExecute(Sender: TObject);
    procedure ConfigurarImpresin1Click(Sender: TObject);
    procedure HTML3Click(Sender: TObject);
    procedure MySQL1Click(Sender: TObject);
    procedure ImprimirExecute(Sender: TObject);
    procedure GuardarComoExecute(Sender: TObject);
    procedure HTML2Click(Sender: TObject);
    procedure RTF1Click(Sender: TObject);
    procedure FileToolbarVisibleClick(Sender: TObject);
    procedure BuscarExecute(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure EditMenuClick(Sender: TObject);
    procedure OpcionesGenerales1Click(Sender: TObject);
    procedure ReadGPLClick(Sender: TObject);
    procedure ClearHistoryClick(Sender: TObject);
    procedure OpenHistory;
    procedure GuardarHistorial(const Filename:string);
    procedure AgregarHistorial(Filename : string);
    procedure OpenHistoryFile(Sender: TObject);
    procedure NuevoHTMLClick(Sender: TObject);
    procedure Siguiente2Click(Sender: TObject);
    procedure CerrarTodoClick(Sender: TObject);
    procedure NuevoPHPClick(Sender: TObject);
    procedure GuardarTodoExecute(Sender: TObject);
    procedure CloseExecute(Sender: TObject);
    procedure NewsClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ActivateButtons(Activar: boolean);
    procedure CheckExecute(Sender: TObject);
    procedure Iralnea1Click(Sender: TObject);
    procedure OptimizarComprimircdigo1Click(Sender: TObject);
    procedure insTablaExecute(Sender: TObject);
    procedure Gtk2Click(Sender: TObject);
    procedure Translate;
    procedure Anterior1Click(Sender: TObject);
    procedure GuardarSesion;
    procedure OnceOnlyParameter(Sender: TObject; const Value: String);
    procedure HtmlToolbarVisibleClick(Sender: TObject);
    procedure PRINTselected1Click(Sender: TObject);
    procedure Replacewith1Click(Sender: TObject);
    procedure ECHOselectedtext1Click(Sender: TObject);
    procedure EMailWizard1Click(Sender: TObject);
    procedure InsertFunctionClick(Sender: TObject);
    procedure ReloadCurrentFile1Click(Sender: TObject);
    procedure EnableSaveAll;
    procedure CallPrint(doPrint : boolean);
    procedure InsertColor1Click(Sender: TObject);
    procedure CheckforUpdate1Click(Sender: TObject);
    procedure LoadAutoComplete;
    procedure GetFunctions;
    procedure SearchDocumentationClick(Sender: TObject);
    procedure XML1Click(Sender: TObject);
    procedure Commentselectedtext1Click(Sender: TObject);
    procedure scpParamsExecute(Kind: SynCompletionType; Sender: TObject;
      var AString: String; var x, y: Integer; var CanExecute: Boolean);
    procedure FormDestroy(Sender: TObject);
    procedure FindDialog1Find(Sender: TObject);
    function CloseAll : boolean;
    procedure WebsiteClick(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    function GetSearchString : string;
    function GetFindOptions(dial:TFindDialog): TSynSearchOptions;
    function GetEditor(const index: integer = -1): TEditor;
    procedure SynEditDropFiles(Sender: TObject; X, Y: Integer;
      AFiles: TWideStrings);
    procedure PageControlChange(Sender: TObject);
    function AskBeforeClose(e: TEditor): integer;
    function CloseEditor(id: integer): integer;
    procedure Insert(Text: string);
    procedure LoadEditorSettings;
    function RunAndGetOutput(Cmd, WorkDir: string): string;
    procedure AnalizeOutput(List: TStringList);
    procedure ProcessLine(s, l: string);
    procedure FastFTPExecute(Sender: TObject);
    procedure ToolButton49Click(Sender: TObject);
    procedure insImagenExecute(Sender: TObject);
    procedure insCapaExecute(Sender: TObject);
    procedure insFormExecute(Sender: TObject);
    procedure insTextExecute(Sender: TObject);
    procedure insButtonExecute(Sender: TObject);
    procedure insCheckExecute(Sender: TObject);
    procedure insRadioExecute(Sender: TObject);
    procedure insListExecute(Sender: TObject);
    procedure InsImageExecute(Sender: TObject);
    procedure insImgExecute(Sender: TObject);
    procedure insHiddenExecute(Sender: TObject);
    procedure insIncExecute(Sender: TObject);
    procedure insMailExecute(Sender: TObject);
    procedure insHRExecute(Sender: TObject);
    procedure insBRExecute(Sender: TObject);
    procedure insDateExecute(Sender: TObject);
    procedure Indent1Click(Sender: TObject);
    procedure DeIndent1Click(Sender: TObject);
    procedure ShellListView1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure PageControl1Change(Sender: TObject);
    procedure MenuItem2Click(Sender: TObject);
    procedure Send1Click(Sender: TObject);
    procedure MenuItem1Click(Sender: TObject);
    procedure MenuItem3Click(Sender: TObject);
    procedure ListViewDblClick(Sender: TObject);
    procedure Explorer1Click(Sender: TObject);
    procedure Refresch1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Send2Click(Sender: TObject);
    procedure WebBrowser1NavigateComplete2(Sender: TObject;
      const pDisp: IDispatch; var URL: OleVariant);
    procedure ToolButton50Click(Sender: TObject);
    procedure ToolButton51Click(Sender: TObject);
    procedure Close1Click(Sender: TObject);
    procedure BrowserPathKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Button1Click(Sender: TObject);
    procedure IdFTP1Connected(Sender: TObject);
    procedure IdFTP1Disconnected(Sender: TObject);
    procedure WebBrowser2DocumentComplete(Sender: TObject;
      const pDisp: IDispatch; var URL: OleVariant);
    procedure FormDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure S1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure UpperCase1Click(Sender: TObject);
    procedure LowerCase1Click(Sender: TObject);
    procedure C3Click(Sender: TObject);
    procedure InsertDocPath1Click(Sender: TObject);
    procedure InsertDocFilename1Click(Sender: TObject);
    procedure Insert1Click(Sender: TObject);
    procedure InsertDate1Click(Sender: TObject);
    procedure InsertTime1Click(Sender: TObject);
    procedure InsertDateTime1Click(Sender: TObject);
    procedure InsertFilename1Click(Sender: TObject);
    procedure DeleteLine1Click(Sender: TObject);
    procedure DeleteWord1Click(Sender: TObject);
    procedure DeletetoEndLine1Click(Sender: TObject);
    procedure DeletePreviousWord1Click(Sender: TObject);
    procedure InsertFilePath1Click(Sender: TObject);
    procedure SaveUnix1Click(Sender: TObject);
    procedure Savewithcrlf1Click(Sender: TObject);
    procedure Savewithcr1Click(Sender: TObject);
    procedure SideBarVisibleClick(Sender: TObject);
    procedure Re1Click(Sender: TObject);
    procedure HtmlPHP1Click(Sender: TObject);
    procedure ListViewChange(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure ControlBar1DockOver(Sender: TObject; Source: TDragDockObject;
      X, Y: Integer; State: TDragState; var Accept: Boolean);
    procedure TreeView1Deletion(Sender: TObject; Node: TTreeNode);
    procedure TreeView1Click(Sender: TObject);
    procedure TreeView1CustomDrawItem(Sender: TCustomTreeView;
      Node: TTreeNode; State: TCustomDrawState; var DefaultDraw: Boolean);
    procedure Button3Click(Sender: TObject);
    procedure ASearchRegDirExecute(Sender: TObject);
    procedure AEditToolExecute(Sender: TObject);
    procedure AutoCompleteExecute(Kind: SynCompletionType; Sender: TObject;
      var CurrentInput: String; var x, y: Integer;
      var CanExecute: Boolean);
    procedure Splitter2CanResize(Sender: TObject; var NewSize: Integer;
      var Accept: Boolean);
    procedure AEditEditExecute(Sender: TObject);
    procedure AEditInsExecute(Sender: TObject);
    procedure SideBarToggleItemClick(Sender: TObject);
    procedure ASearchOFilesExecute(Sender: TObject);
    procedure EditToolbarVisibleClick(Sender: TObject);
    procedure DHTMLEdit1ShowContextMenu(Sender: TObject; xPos,
      yPos: Integer);
    procedure FindDialog1Show(Sender: TObject);
    procedure FindDialog1Close(Sender: TObject);
    procedure test2Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure AhrefExecute(Sender: TObject);
    procedure CheckHighlighter;
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure PageControl2Change(Sender: TObject);
    procedure ReplaceExecute(Sender: TObject);
    procedure ANextSearchExecute(Sender: TObject);
    procedure TBXItem46Click(Sender: TObject);
    procedure clearprojhistClick(Sender: TObject);
    procedure TBItem48Click(Sender: TObject);
    procedure TBItem49Click(Sender: TObject);
    procedure TreeView11Click(Sender: TObject);
    procedure TabsToSpacesClick(Sender: TObject);
    procedure SpacesToTabsClick(Sender: TObject);
    procedure PopupMenu5Popup(Sender: TObject);
    procedure ValueListEditor1DblClick(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure SpeedButton5Click(Sender: TObject);
    procedure SpeedButton6Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);
    procedure SpinEdit2Change(Sender: TObject);
    procedure SpeedButton7Click(Sender: TObject);
    procedure SpeedButton8Click(Sender: TObject);
    procedure SynEditPrintPreview1PreviewPage(Sender: TObject;
      PageNumber: Integer);
    procedure TabSheet11Resize(Sender: TObject);
    function ReplaceTag(new: string;sStart,sEnd:integer):string;
    procedure ListBox1DblClick(Sender: TObject);
    procedure sneditClick(Sender: TObject);
    procedure snnewClick(Sender: TObject);
    procedure sndeleteClick(Sender: TObject);
    procedure ListBox1ContextPopup(Sender: TObject; MousePos: TPoint;
      var Handled: Boolean);
    procedure AZoomInExecute(Sender: TObject);
    procedure AZoomOutExecute(Sender: TObject);
    procedure TestScriptClick(Sender: TObject);
    procedure dws2Unit1FunctionsShowmessageEval(Info: TProgramInfo);
    procedure dws2Unit1Classes0ConstructorsCreateAssignExternalObject(
      Info: TProgramInfo; var ExtObject: TObject);
    procedure dws2Unit1ClassesEditorMethodsgetSelectionEval(
      Info: TProgramInfo; ExtObject: TObject);
    procedure TBToolWindow1DockChanged(Sender: TObject);
    procedure dws2Unit1VariablesTextReadVar(var Value: Variant);
    procedure dws2Unit1VariablesTextWriteVar(Value: Variant);
    function WebServ1ServEnd(debugStr: String): String;
    procedure dws2Unit1FunctionstestEval(Info: TProgramInfo);
    procedure dws2Unit1ClassesApplicationMethodsAddMenuEval(
      Info: TProgramInfo; ExtObject: TObject);
    procedure SpeedButton9Click(Sender: TObject);
    procedure AZoomresetExecute(Sender: TObject);
    procedure WebServ1GetVariable(modus, name, value: String);
    procedure WebBrowserBeforeNavigate2(Sender: TObject;
      const pDisp: IDispatch; var URL, Flags, TargetFrameName, PostData,
      Headers: OleVariant; var Cancel: WordBool);
    procedure WebBrowserNavigateComplete2(Sender: TObject;
      const pDisp: IDispatch; var URL: OleVariant);
    procedure TBXItem2Click(Sender: TObject);
    function WebServ1File(debugStr: String): String;
    procedure psvPHP1ScriptError(Sender: TObject; AText: String;
      AType: TPHPErrorType; AFileName: String; ALineNo: Integer);
    procedure IdHTTPServer1CommandGet(AThread: TIdPeerThread;
      ARequestInfo: TIdHTTPRequestInfo;
      AResponseInfo: TIdHTTPResponseInfo);
    procedure EditPHPIni1Click(Sender: TObject);
    procedure webbrowserStatusTextChange(Sender: TObject;
      const Text: WideString);
    procedure WebBrowser1StatusTextChange(Sender: TObject;
      const Text: WideString);
    procedure VirtualExplorerListview1ShellExecute(
      Sender: TCustomVirtualExplorerTree; Namespace: TNamespace;
      var WorkingDir, CmdLineArgument: WideString; var Allow: Boolean);
    procedure VirtualExplorerTreeview1Change(Sender: TBaseVirtualTree;
      Node: PVirtualNode);
    procedure TreeView11Deletion(Sender: TObject; Node: TTreeNode);
    procedure TreeView11Changing(Sender: TObject; Node: TTreeNode;
      var AllowChange: Boolean);
    procedure webbrowserDocumentComplete(Sender: TObject;
      const pDisp: IDispatch; var URL: OleVariant);
    procedure Panel8Resize(Sender: TObject);
    procedure sbm1Click(Sender: TObject);
    procedure jbm1Click(Sender: TObject);
   private
    currclass: TTreeNode;
    classes:TTreeNode;
    functions:TTreeNode;
    includes:TTreeNode;
    vars:TTreeNode;
    FPrg:TProgram;
    ftpList:TStringList;
    LookupList : TStringList;
    ParamList : TStringList;
    FunctionNames : TStringList;
    FunctionNumbers : TStringList;
    SearchString : string;
    currPath:string;
    currFtpPath:string;
    FolderIcon:integer;
    findactive:boolean;
    fOnReplaceText:TReplaceTextEvent;
    askreload:boolean;
    UILock: TCriticalSection;
    procedure Insertar(Texto: string);
    procedure showFTP;
    procedure splitFTPMessage(st: string; var t: TFTPInfo);
    procedure walkTree(OnWalk: TWalkProc; OnDirChange,
      OnDirUp: TWalkFolderProc);
    procedure delWalk(tp: tftpinfo);
    procedure delDirUp(folder: string);
    procedure FileLook(Filespec: string);
    procedure getDir(folder: string);
    procedure getWalk(tp: tftpinfo);
    procedure getDirUp(folder: string);
    function ChangeFTPPath: boolean;
    procedure syncEditorWithPath;
    procedure LoadProject(filename: String);
    procedure WMDropFiles(var Msg: TMessage); message WM_DROPFILES;
    procedure visibleBar(barCaption: string; value: boolean);
    procedure searchReg(filename: string;searchstr:string);
    procedure OnMessage(var Msg: TMsg; var Handled: Boolean);
    procedure OpenFile(Sender: TObject; filename: string);
    procedure searchRe(e:TEditor;searchstr:string);
    procedure settreepath(path: string);
    procedure addExternals;
    procedure ExternalClick(Sender: TObject);
    procedure executeExternal(s: string);
    procedure doonReplaceText(Sender: TObject; const ASearch, AReplace:
    widestring; Line, Column: integer; var Action: TSynReplaceAction);
    procedure freeExternals;
    procedure AddProjHistory(Filename: string);
    procedure OpenProjHistoryFile(Sender: TObject);
    procedure OpenProjHistory;
    procedure loadAutoText;
    procedure UpdateSnippetsList(const doc: TdomDocument);
    procedure saveAutoText;
    procedure ScriptClick(Sender: TObject);
    procedure delDir(folder:string);
    procedure DisplayMessage(const Msg: WideString);
    function GetMIMEType(sFile: TFileName): String;
    procedure ServeVirtualFolder(AThread: TIdPeerThread;
      RequestInfo: TIdHTTPRequestInfo; ResponseInfo: TIdHTTPResponseInfo);
    procedure AddInfo(const Action,Msg: String);
    procedure OnToken(t: TToken);
  public
    fHighlighters : TStringList;
    toOpen:TStringList;
    openingallowed:boolean;
    Parser : string;
    NewCount : integer;
    InternalPreview : boolean;
    BrowserActiveFlag:boolean;
    oldx,oldy:integer;
    firstSearch:boolean;
    pars:TParse;
    last:TBufferCoord;
    opt:TSynSearchOptions;
    editval:TEditVal;
    complete:boolean;
    so2:OleVariant;
    timer2counter:integer;
    webbrowser:TWebBrowser;
    mozillabrowser:TMozillaBrowser;
    MIMEMap: TIdMIMETable;
    procedure FTPConnect;
    procedure FTPDisConnect;
    procedure acActivateExecute(Sender: TObject);
  end;

const
  pEdit = 0;
  pIPreview = 1;
  pEPreview = 2;
  pFtp = 3;
  pDoc = 4;
  pBrowser = 5;
  pHtmlEdit = 6;
  pPrintPreview = 6;
  
const
  sauthenticationrealm = 'Dev-PHP2 internal server';

procedure ExecNewProcess(ProgramName : String; Wait: Boolean);

var
  MainFrm: TMainFrm;
  mHHelp: THookHelpSystem;

implementation

uses
  frmOptions, frmAbout, frmCheck,
  frmGoTo, frmOptimize, frmGTK, frmMail, frmFunction, frmUpdate, frmTable,
  frmAutoText, FrmSearch, frmSearchReplace, frmReplaceAsk, frmSearching;

{$R *.dfm}
{$R winxp.res}

var doc_complete:boolean;

function resolveInternalRefs(st:Widestring):widestring;
var s:wideString;
begin
  s:=st;
  s:=stringreplace(s,'&lt;','<',[rfReplaceAll]);
  s:=stringreplace(s,'&gt;','>',[rfReplaceAll]);
  s:=stringreplace(s,'&amp;','&',[rfReplaceAll]);
  s:=stringreplace(s,'&apos;','''',[rfReplaceAll]);
  s:=stringreplace(s,'&quot;','"',[rfReplaceAll]);
  result:=s;
end;

Procedure searchdir2(path:string;searchstr:string;proc:TStrProc);
var sr:tsearchrec;
   n:word;
begin
  if path='' then exit;
 if path[length(path)]<>'\' then path:=path+'\';
 n:=findfirst(path+'*.*',faAnyFile,sr);
 while n=0 do begin
   if sr.name[1]<>'.' then begin
     if sr.attr and fadirectory = fadirectory then begin
       searchdir2(path+sr.name+'\',searchstr,proc);
     end else begin
       proc(path+sr.name,searchstr);
     end;
   end;
   n:=findnext(sr);
 end;
 if path[length(path)]='\' then delete(path,length(path),1);
end;


Procedure searchdir(path:string;searchstr:string;proc:TStrProc);
var sr:tsearchrec;
   n:word;
begin
 if path[length(path)]<>'\' then path:=path+'\';
 n:=findfirst(path+'*.*',faAnyFile,sr);
 while n=0 do begin
   if sr.name[1]<>'.' then begin
     if sr.attr and fadirectory = fadirectory then begin
       searchdir(path+sr.name+'\',searchstr,proc);
     end else begin
       proc(path+sr.name,searchstr);
     end;
   end;
   n:=findnext(sr);
 end;
 if path[length(path)]='\' then delete(path,length(path),1);
 if not SysUtils.RemoveDir(path) then
    showmessage(Format(lang(3001),[path]));
end;


procedure TMainFrm.FTPConnect;
begin
  if idftp1.Connected then exit;
  idftp1.Passive:=settings.FTPPassive;
  idftp1.Username:=settings.FTPUserText;
  idftp1.Password:=settings.FTPPasswordSave;
  try
    idftp1.Connect();
  except
  end;
end;

procedure TMainFrm.FTPDisConnect;
begin
  if not idftp1.connected then exit;
  try
    idftp1.abort;
    idftp1.Quit;
    idftp1.disconnect;
  except
  end;
  listview.Items.Clear;
end;

function TMainFrm.GetFindOptions(dial:TFindDialog): TSynSearchOptions;
begin
  Result := [];
  if frWholeWord in dial.Options then Result := Result + [ssoWholeWord];
  if frMatchCase in dial.Options then Result := Result + [ssoMatchCase];
  if not (frDown in dial.Options) then Result := Result + [ssoBackwards];
end;

procedure TMainFrm.GetFunctions;
var
  j, i, c, c1, c2, p, q, v, q2, s1, s2 : integer;
  s, t : string;
  isComment, isScript, isString : boolean;
  e : TEditor;
begin
  IsScript:=false;
  FunctionNumbers.Clear;
  e := GetEditor;
  for i := 0 to e.SynEdit.Lines.Count-1 do begin
    s := Trim(e.SynEdit.Lines[i]);
    isString := FALSE;
    isComment := FALSE;
    for j := 0 to Length(s) - 1 do begin
      if (isString = True) then begin
        if ((s[j] = '\' ) and (s[j + 1] = '"')) or (s[j] <> '"') then begin
          s[j] := ' ';
        end;
      end;
      if (s[j] = '"') then begin
        isString := not isString;
      end;
    end;
    c := Pos('//',s);
    if (c > 0) then begin
      Delete(s, c, Length(s) - c);
    end;
    c1 := Pos('/*',s);
    if (c1 > 0) then begin
      c2 := Pos('*/',s);
      Delete(s, c1, Length(s) - c1 - c2);
      if (c2 > c1) then begin
        isComment := FALSE;
      end else begin
        isComment := TRUE;
      end;
    end;
    c2 := Pos('*/', s);
    if (c1 > 0) then begin
      Delete(s, c1, c2 + 2);
      isComment := FALSE;
    end;
    if (isString = False) and (isComment = False) then begin
      s1 := Pos('<?', s);
      if (s1 > 0) then begin
        s2 := Pos('?>', s);
        if (s2 > s1) then begin
          isScript := FALSE;
        end else begin
          isScript := TRUE;
        end;
      end;
      s2 := Pos('?>', s);
      if (s2 > 0) then begin
        isScript := FALSE;
      end;
      if (isScript = True) then begin
        t := LowerCase(s);
        if (isComment = True) then begin
          p := 0;
          q := 0;
          q2 := 0;
          v := 0;
        end else begin
          p := Pos('function ', t);
          q := Pos('(', s);
          if (q > p) then begin
            q2 := q + 2; (* JFH *)
            v  := q + 1; (* JFH *)
          end else begin
            q2 := 0;
            v := 0;
          end;
        end;
        if (p <> 0) and (q <> 0) and (q > p) and (q < q2) and (((v > q) and (v < q2)) or (v = 0)) then begin
          Delete(s, 1, p);
          Delete(s, 1, StrLen('function'));
          q := Pos('(', s);
          Delete(s, q, Length(s) - q + 1);
          s := Trim(s);
          p := Pos(' ', s);
          if p = 0 then begin
            if s <> '' then begin
              FunctionNames.Add(s + '()>>>' + IntToStr(i + 1));
            end;
          end;
        end;
      end;
    end;
  end;
end;

procedure TMainFrm.Acercade1Click(Sender: TObject);
begin
  AboutForm := TAboutForm.Create(Self);
  with AboutForm do
  try
     ShowModal;
  finally
    Free;
  end;
end;

procedure TMainFrm.HTML1Click(Sender: TObject);
begin
  GetEditor.SynEdit.Highlighter := SynMultiSyn1;
  StatusBar1.Panels[3].Text := (Sender as TTBXItem).Caption;
end;

procedure TMainFrm.HtmlPHP1Click(Sender: TObject);
begin
  GetEditor.SynEdit.Highlighter := SynMultiSyn1;
  StatusBar1.Panels[3].Text := (Sender as TTBXItem).Caption;
  CheckHighlighter;
end;

procedure TMainFrm.PHP1Click(Sender: TObject);
begin
  GetEditor.Synedit.Highlighter := SynPHPSyn;
  StatusBar1.Panels[3].Text := (Sender as TTBXItem).Caption;
  CheckHighlighter;
end;

procedure TMainFrm.HTML3Click(Sender: TObject);
begin
  GetEditor.SynEdit.Highlighter := SynHTMLSyn1;
  StatusBar1.Panels[3].Text := (Sender as TTBXItem).Caption;
  CheckHighlighter;
end;

procedure TMainFrm.CSS1Click(Sender: TObject);
begin
  GetEditor.SynEdit.Highlighter := SynCSSSyn1;
  StatusBar1.Panels[3].Text := (Sender as TTBXItem).Caption;
  CheckHighlighter;
end;

procedure TMainFrm.XML1Click(Sender: TObject);
begin
  GetEditor.Synedit.Highlighter := SynXMLSyn1;
  StatusBar1.Panels[3].Text := (Sender as TTBXItem).Caption;
  CheckHighlighter;
end;

procedure TMainFrm.JavaScript1Click(Sender: TObject);
begin
  GetEditor.SynEdit.Highlighter := SynJScriptSyn1;
  StatusBar1.Panels[3].Text := (Sender as TTBXItem).Caption;
  CheckHighlighter;
end;

procedure TMainFrm.MySQL1Click(Sender: TObject);
begin
  GetEditor.SynEdit.Highlighter := SynSQLSyn1;
  StatusBar1.Panels[3].Text := (Sender as TTBXItem).Caption;
  CheckHighlighter;
end;

procedure TMainFrm.Texto1Click(Sender: TObject);
begin
  if GetEditor.SynEdit.Highlighter <> nil then
    GetEditor.SynEdit.Highlighter := nil;
  StatusBar1.Panels[3].Text := (Sender as TTBXItem).Caption;
  CheckHighlighter;
end;

procedure TMainFrm.CheckHighlighter;
begin
  if GetEditor.SynEdit.Highlighter=SynphpSyn then php1.Checked:=true;
  if GetEditor.SynEdit.Highlighter=SynMultiSyn1 then HtmlPHP1.Checked:=true;
  if GetEditor.SynEdit.Highlighter=SynHtmlSyn1 then HTML3.Checked:=true;
  if GetEditor.SynEdit.Highlighter=SynCSSSyn1 then CSS1.Checked:=true;
  if GetEditor.SynEdit.Highlighter=SynXMLSyn1 then XML1.Checked:=true;
  if GetEditor.SynEdit.Highlighter=SynJScriptSyn1 then JavaScript1.Checked:=true;
  if GetEditor.SynEdit.Highlighter=SynSQLSyn1 then MySQL1.Checked:=true;
  if GetEditor.SynEdit.Highlighter=nil then Texto1.Checked:=true;
end;

procedure TMainFrm.EnableSaveAll;
var
  i : integer;
  e : TEditor;
begin
  ASaveAll.Enabled := FALSE;
  if PageControl.PageCount > 0 then begin
    for i := 0 to (PageControl.PageCount - 1) do begin
      e := GetEditor(i);
      if e.ismodified = False then begin
        ASaveAll.Enabled := TRUE;
        Exit;
      end;
    end;
  end;
end;

procedure TMainFrm.SeleccionarTodo1Click(Sender: TObject);
begin
  if PageControl.PageCount > 0 then begin
    GetEditor.SynEdit.SelectAll;
  end;
end;

procedure TMainFrm.StatusBarVisibleClick(Sender: TObject);
begin
  gsettings.StatusBar1visible:=StatusBar1.Visible;
end;

procedure TMainFrm.NuevoExecute(Sender: TObject);
var
  e : TEditor;
begin
  Inc(NewCount);
  e := TEditor.Create;
  e.Init('Untitled' + IntToStr(NewCount) + '.php', FALSE);
  ActivateButtons(TRUE);
end;

procedure TMainFrm.SynEditDropFiles(Sender: TObject; X, Y: Integer;
  AFiles: TWideStrings);
var
  i, j : integer;
  Exists : boolean;
  e : TEditor;
begin
  for i := 0 to AFiles.Count-1 do begin
    Exists := FALSE;
    for j := 0 to PageControl.PageCount - 1 do begin
      if AFiles[i] = GetEditor(j).fFileName then begin
        Exists := TRUE;
        Break;
      end;
    end;
    if Exists = False then begin
      e := TEditor.Create;
      e.Init(AFiles[i], TRUE);
      AgregarHistorial(AFiles[i]);
      GuardarHistorial(AFiles[i]);
    end else begin
      Application.ProcessMessages;
      MessageDlg(Format(lang(3005),[AFiles[i]]), mtError, [mbOk], 0);
    end;
  end;
end;

procedure TMainFrm.OpenFile(Sender:TObject;filename:string);
var x:integer;
  Exists : boolean;
  e : TEditor;
begin
  if FileExists(filename) then begin
    Exists := FALSE;
    for x := 0 to PageControl.PageCount - 1 do begin
      if filename = GetEditor(x).fFileName then begin
        pagecontrol.ActivePageIndex:=x;
        if GetEditor(x).ismodified then
            MessageDlg(Format(lang(3005),[filename]), mtError, [mbOk], 0);
        exit;
      end;
    end;
    pageControl.ActivePageIndex:=PageControl.PageCount;
    if Exists = False then begin
      e := TEditor.Create;
      e.Init(filename, TRUE);
      AgregarHistorial(filename);
      GuardarHistorial(filename);
    end else begin
    end;
  end else begin
    MessageDlg(Lang(952) + ' "' + filename + '" ' + Lang(955), mtError, [mbOk], 0);
  end;
  ActivateButtons(TRUE);
end;

procedure TMainFrm.AOpenExecute(Sender: TObject);
var
  i  : integer;
  e:TEditor;
begin
  e:=getEditor();
  if assigned(e) then
    OpenDialog.InitialDir:=virtualExplorerTreeview1.SelectedPath;
  if OpenDialog.Execute then begin
//    Loaded := 0;
    for i := 0 to OpenDialog.Files.Count - 1 do begin
      OpenFile(Sender,OpenDialog.Files[i]);
    end;
    if pagecontrol2.ActivePage=TabSheet10 then begin
      button2click(sender);
    end;
  end;
end;

procedure TMainFrm.AgregarHistorial(Filename : string);
var
   NewMenuItem : TTBCustomItem;
   i : integer;
begin
  for i := 2 to ReAbrir.Count-1 do begin
    if lowercase(ReAbrir.Items[i].Caption) = lowercase(Filename) then exit;
  end;
  if Length(Filename) > 0 then begin
    NewMenuItem := TTBCustomItem.Create(Self);
    NewMenuItem.Caption := Filename;
    NewMenuItem.OnClick := OpenHistoryFile;
    ReAbrir.Insert(2, NewMenuItem);
  end;
end;

procedure TMainFrm.AddProjHistory(Filename : string);
var
   NewMenuItem : TTBCustomItem;
   i : integer;
begin
  for i := 2 to reopenproject.Count-1 do begin
    if lowercase(reopenproject.Items[i].Caption) = lowercase(Filename) then exit;
  end;
  if Length(Filename) > 0 then begin
    NewMenuItem := TTBCustomItem.Create(Self);
    NewMenuItem.Caption := Filename;
    NewMenuItem.OnClick := OpenProjHistoryFile;
    reopenproject.Insert(2, NewMenuItem);
  end;
end;


procedure TMainFrm.OpenHistoryFile(Sender: TObject);
var
  FileName : string;
  x : integer;
  Exists : boolean;
  e : TEditor;
begin
  FileName := (Sender as TTBCustomItem).Caption;
  if FileExists(FileName) then begin
    Exists := FALSE;
    for x := 0 to PageControl.PageCount - 1 do begin
      if FileName = GetEditor(x).fFileName then begin
        Exists := TRUE;
        Break;
      end;
    end;
    if Exists = False then begin
      e := TEditor.Create;
      e.Init(FileName, TRUE);
    end else begin
      Application.ProcessMessages;
      MessageDlg(Format(lang(3005),[filename]), mtError, [mbOk], 0);
    end;
  end else begin
    MessageDlg(Lang(952) + ' "' + FileName + '" ' + Lang(955),mtError,[mbOk],0)
  end;
  ActivateButtons(TRUE);
end;

procedure TMainFrm.OpenProjHistoryFile(Sender: TObject);
var
  FileName : string;
begin
  FileName := (Sender as TTBCustomItem).Caption;
  if FileExists(FileName) then begin
    if FileName <> gSettings.LastProject then begin
      uinifile.SaveIniFile(uinifile.IniFileName);
      loadProject(Filename);
    end else begin
      Application.ProcessMessages;
      statusbar1.Panels[3].Text:= Format(lang(3005),[filename]);
    end;
  end else begin
    statusbar1.Panels[3].Text:=Lang(952) + ' "' + FileName + '" ' + Lang(955);
  end;
  ActivateButtons(TRUE);
  freeExternals();
  addExternals();
  if geteditor=nil then pagecontrol.ActivePageIndex:=0;
end;

procedure TMainFrm.GuardarHistorial(const Filename:string);
var
   i : integer;
   List : TStringList;
begin
  List:=TStringList.Create;
  List.Text:=settings.History.Text;
  for I:=0 to List.Count - 1 do
    if List.Values[IntToStr(I)]= Filename then begin
      List.Free;
      Exit;
    end;
  if settings.History.IndexOf(Filename)=-1 then settings.History.Add(Filename);
  settings.writeHistory;
end;

procedure TMainFrm.OpenHistory;
var
   i       : integer;
   fName : string;
begin
  i := ReAbrir.Count-1;

  if ReAbrir.Count <> 2 then
    repeat
      ReAbrir.Remove(ReAbrir.Items[i]);
      dec(i);
    until ReAbrir.Count = 2;

  for i := 0 to settings.History.Count-1 do begin
    fName := settings.History[I];
    if (fName <> '') and (FileExists(fName)) then begin
      AgregarHistorial(fName);
    end;
  end;
end;

procedure TMainFrm.OpenProjHistory;
var
   i       : integer;
   fName : string;
begin
  i := reopenproject.Count-1;

  if reopenproject.Count <> 2 then
    repeat
      reopenproject.Remove(reopenproject.Items[i]);
      dec(i);
    until reopenproject.Count = 2;

  for i := 0 to gsettings.ProjHistory.Count-1 do begin
    fName := gsettings.ProjHistory[I];
    if (fName <> '') and (FileExists(fName)) then begin
      AddProjHistory(fName);
    end;
  end;
end;

procedure TMainFrm.GuardarExecute(Sender: TObject);
var
  e : TEditor;
begin
  e := GetEditor;
  if Assigned(e) then begin
    e.SaveFile(false);
    VirtualExplorerTreeview1.Refresh;
    statusbar1.Panels[1].Text:='';
  end;
end;

procedure TMainFrm.SalirExecute(Sender: TObject);
begin
  GuardarSesion;
  uIniFile.Settings.writeHistory();
  close;
end;

procedure TMainFrm.DeshacerExecute(Sender: TObject);
var
  e : TEditor;
begin
  e := GetEditor;
  if Assigned(e) then begin
    e.SynEdit.SetFocus;
    e.SynEdit.Undo;
  end;
end;

procedure TMainFrm.RehacerExecute(Sender: TObject);
var
  e : TEditor;
begin
  e := GetEditor;
  if Assigned(e) then begin
    e.SynEdit.SetFocus;
    e.SynEdit.Redo;
  end;
end;

procedure TMainFrm.LoadAutoComplete;
var
  acItems, acInsert : TStringList;
  i : integer;
  DataFile1, DataFile2, s : string;
begin
  DataFile1 := ExtractFilePath(Application.Exename)+ 'data\functions_lite.dat';
  DataFile2 := ExtractFilePath(Application.Exename)+ 'data\functions_full.dat';
  if (FileExists(DataFile1)) and (FileExists(DataFile2)) then begin
    AutoComplete.InsertList.LoadFromFile(DataFile1);
    AutoComplete.ItemList.LoadFromFile(DataFile2);
  end;
  for i := 0 to AutoComplete.InsertList.Count-1 do begin
//    AutoComplete.ItemList[i] := StringReplace(AutoComplete.ItemList[i], #9, #9' ', []);
//    AutoComplete.ItemList[i] := 'function'#9 + AutoComplete.ItemList[i];
    AutoComplete.ItemList[i] := StringReplace(AutoComplete.ItemList[i], #9, ' ', []);
//    AutoComplete.InsertList[i] := AutoComplete.ItemList[i];
    AutoComplete.ItemList[i] := 'function   ' + AutoComplete.ItemList[i];
    AutoComplete.InsertList[i] := AutoComplete.InsertList[i] + '()';
  end;
  DataFile1 := ExtractFilePath(Application.Exename)+ 'data/variables.dat';
  if FileExists(DataFile1) then begin
    acItems := TStringList.Create;
    acInsert := TStringList.Create;
    acInsert.LoadFromFile(DataFile1);
    for i := 0 to acInsert.Count -1 do begin
      acItems.Add('variable   ' + acInsert.Strings[i]);
    end;
    AutoComplete.ItemList.AddStrings(acItems);
    AutoComplete.InsertList.AddStrings(acInsert);
    acItems.Free;
    acInsert.Free;
  end;

  LookupList := TStringList.Create;
  DataFile1 := ExtractFilePath(Application.Exename)+ 'data/functions_lite.dat';
  if FileExists(DataFile1) then begin
    LookupList.LoadFromFile(DataFile1);
  end;
  ParamList := TStringList.Create;
  DataFile1 := ExtractFilePath(Application.Exename)+ 'data/functions_full.dat';
  if FileExists(DataFile1) then begin
    ParamList.LoadFromFile(DataFile1)
  end;
  for i := 0 to ParamList.Count - 1 do begin
    s := Trim(ParamList.Strings[i]);
    Delete(s, 1, Pos('(', s) - 1);
    s := StringReplace(s, '(', '"', []);
    s := StringReplace(s, ', ', '", "', [rfReplaceAll]);
    s[Length(s)] := '"';
    ParamList.Strings[i] := s;
  end;
  scpParams.EndOfTokenChr := '';

  if AutoComplete.ItemList.Count > 0 then begin
    { Nothing }
  end else begin
    AutoComplete.Editor := nil;
  end;
end;

procedure TMainFrm.OnMessage(var Msg: TMsg; var Handled: Boolean);
begin
  OnceOnly.IWndProc2(Msg,Handled);
end;

Procedure OnParam(const value:String);
begin
  if mainfrm.openingallowed then begin
    mainfrm.OpenFile(nil,value);
  end else begin
    mainfrm.toOpen.Add(value);
  end;
end;

procedure TMainFrm.FormCreate(Sender: TObject);
var
  chmFile: string;
  iFilename:string;
  s1:string;
begin
  UILock := TCriticalSection.Create;
  MIMEMap := TIdMIMETable.Create(true);
  askreload:=true;
  pars:=TParse.create();
  toOpen:=TStringList.Create;
  application.OnMessage:=OnMessage;
  OnceOnly.OnParameter:=OnParam;
  openingallowed:=false;
  firstSearch:=true;
  if not (csDesigning in ComponentState) then DragAcceptFiles(Handle, TRUE);
  ForceDirectories(getAppFolder()+'\devphp');
  iFilename:=getAppFolder() +'\devphp\'+
        ChangeFileExt(lowercase(ExtractFileName(Application.Exename)), '.ini');
  uIniFile.OldIniFileName:=iFilename;
  if not FileExists(iFilename) then begin
    MessageDlg(lang(3006)+#13#10+lang(3007)+#13#10
             + lang(3008),mtInformation,[mbOk],0);
    CreateNewIniFile(True);
  end;
  loadGIniFile();
  uinifile.IniFileName:=gsettings.LastProject;
  if not FileExists(uinifile.IniFileName) then begin
    MessageDlg(lang(3009)+#13#10
             + lang(3010)+#13#10
             + lang(3008),mtInformation,[mbOk],0);
    s1:=getPersonalFolder;
    if FileCtrl.SelectDirectory(lang(3011),'rfMyComputer',s1) then begin
      uinifile.IniFileName:=s1+'\project.prd';
      if not FileExists(uinifile.IniFileName) then begin
        ForceDirectories(ExtractFilePath(uinifile.IniFileName));
        CreateIniFile(uinifile.IniFileName);
      end;
    end else begin
      uinifile.IniFileName:=getAppFolder() +'\devphp\'+'project.prd';
      if not FileExists(uinifile.IniFileName) then begin
        ForceDirectories(ExtractFilePath(uinifile.IniFileName));
        CreateIniFile(uinifile.IniFileName);
      end;
    end;
    loadIniFile();
    Settings.localpathText:=extractFilePath(uinifile.IniFileName);
    gsettings.LastProject:=uinifile.IniFileName;
  end else loadIniFile();
  idftp1.Password:=settings.FTPPasswordSave;
  idftp1.Username:=settings.FTPUserText;
  idftp1.Host:=settings.FTPHostText;
  if settings.FTPPortText<>'' then idftp1.port:=strtoint(settings.FTPPortText) else idftp1.Port:=0;
  if settings.FTPHostText='' then begin
    tabsheet4.Visible:=false;
    tabsheet4.TabVisible:=false;
  end;
  LineNumbers.Checked := gsettings.LineNumbers;
  Parser := gsettings.phpexefile;
  news.visible:=FileExists(ExtractFilePath(Application.Exename)+ 'news.txt');
  ReadGPL.Visible:=FileExists(ExtractFilePath(Application.Exename)+ 'docs\copying.txt');

  SynPHPSyn.DefaultFilter:=gsettings.SynPHPSyn1Filter;
  SynHTMLSyn1.DefaultFilter:=gsettings.SynHTMLSyn1Filter;
  SynXMLSyn1.DefaultFilter:=gsettings.SynXMLSyn1Filter;
  SynJScriptSyn1.DefaultFilter:=gsettings.SynJSSyn1Filter;
  SynSQLSyn1.DefaultFilter:=gsettings.SynSQLSyn1Filter;
  SynCssSyn1.DefaultFilter:=gsettings.SynCSSSyn1Filter;
  SynMultiSyn1.DefaultFilter:=gsettings.SynMultiSyn1Filter;

  OpenHistory;
  OpenProjHistory;
  fHighlighters := TStringList.Create;
  fHighlighters.Sorted := TRUE;
  GetHighlighters(Self, fHighlighters, FALSE);
  OpenDialog.Filter :=  'All Files Windows(crlf)|*.*|All Files Unix(lf)|*.*|All Files Mac(cr)|*.*|Text Files|*.txt|' + GetHighlightersFilter(fHighlighters);
  SaveDialog.Filter := OpenDialog.Filter;
  FunctionNames := TStringList.Create;
  FunctionNumbers := TStringList.Create;
  LoadAutoComplete;
  chmFile := gsettings.DocsPathText;
  mHHelp := nil;
  {HH 1.2 oder hher Versionskontrolle}
  if (hh.HHCtrlHandle = 0)
    or (hh_funcs._hhMajVer < 4)
    or ((hh_funcs._hhMajVer = 4) and (hh_funcs._hhMinVer < 73)) then
      ShowMessage(lang(3002));
  {Hook - verwendet HH_FUNCS.pas}
  mHHelp := hh_funcs.THookHelpSystem.Create(chmFile, '', htHHAPI);
//  controll:=TController.create();
  MainFrm.Left := gsettings.MainFormLeft;
  MainFrm.Top := gsettings.MainFormTop;
  MainFrm.width := gsettings.MainFormwidth;
  MainFrm.Height := gsettings.MainFormHeight;
  MainFrm.WindowState := TWindowState(gsettings.MainFormWindowState);
  panel7.Visible:=false;
  splitter3.Visible:=false;
  panel2.Width:=gsettings.SideBarWidth;
  if gsettings.DockSideBar='TBDock2' then TBToolWindow1.CurrentDock:=TBDock2;
  if gsettings.DockSideBar='TBDock3' then TBToolWindow1.CurrentDock:=TBDock3;
//  LoadSynEditFromFile(SynPHPSyn);
  SynPHPSyn.DefaultFilter:=gsettings.SynPHPSyn1Filter;
  SynHTMLSyn1.DefaultFilter:=gsettings.SynHTMLSyn1Filter;
  TBXItem1.ShortCut:=ShortCut(VK_ADD,[ssCtrl]);
  TBXItem3.ShortCut:=ShortCut(VK_SUBTRACT,[ssCtrl]);
  TBXItem4.ShortCut:=ShortCut(VK_MULTIPLY,[ssCtrl]);
  TBXItem46.ShortCut:=ShortCut(VK_F3,[ssCtrl]);
end;

procedure TMainFrm.LineNumbersClick(Sender: TObject);
var
  e : TEditor;
begin
  e := GetEditor;
  if Assigned(e) then begin
    e.SynEdit.Gutter.Visible := not e.SynEdit.Gutter.Visible;
    gsettings.LineNumbers:=e.SynEdit.Gutter.Visible;
    LineNumbers.checked:=e.SynEdit.Gutter.Visible;
  end;
end;

procedure TMainFrm.EjecutarExecute(Sender: TObject);
//var
//  e: TEditor;
//  IFile, OutputFile, CommandLine, OutputString, IniPath: string;
//  Output: TStringList;
begin
{  compileroutput.Clear;
  e := GetEditor;
  if (Assigned(e)) and (FileExists(Parser)) then begin
    if FileExists(e.fFileName) then begin
      IFile := ExtractFilePath(e.fFileName) + '~out.php';
      OutputFile := ExtractFilePath(e.fFileName) + '~out.html';
    end else begin
      IFile := ExtractFilePath(Application.ExeName) + '~out.php';
      OutputFile := ExtractFilePath(Application.ExeName) + '~out.html';
    end;
    e.SynEdit.Lines.SaveToFile(IFile);
    IniPath := ExtractFilePath(Parser);
    Delete(IniPath, Length(IniPath), 1);
    CommandLine := '"' + Parser + '" -c "' + IniPath + '" -f "' + IFile + '"';
    Application.ProcessMessages;
    OutputString := RunAndGetOutput(CommandLine, ExtractFilePath(e.fFileName));
    if FileExists(IFile) then SysUtils.DeleteFile(IFile);
    Application.ProcessMessages;
    if Length(OutputString) > 0 then begin
      Output := TStringList.Create;
      Output.Add(OutputString);
      Output.SaveToFile(OutputFile);
      Output.LoadFromFile(OutputFile);
      AnalizeOutput(Output);
      Output.Free;
      Application.ProcessMessages;
    end;
    if FileExists(OutputFile) then begin
      WebBrowser.Navigate(OutputFile);
      PageControl1.ActivePageIndex := plPreview;
    end;
  end else begin
    showmessage('Parser not found');
  end;      }

  case pagecontrol1.ActivePageIndex of
  pEdit:  begin
        pagecontrol1.ActivePageIndex:=pIPreview;
        PageControl1Change(sender);
      end;
  pIPreview:  begin
        pagecontrol1.ActivePageIndex:=pEdit;
        PageControl1Change(sender);
      end;
  end;
end;

procedure TMainFrm.ConfigurarImpresin1Click(Sender: TObject);
begin
  PrinterSetupDialog1.Execute;
end;

procedure TMainFrm.ImprimirExecute(Sender: TObject);
begin
  if PageControl.PageCount > 0 then begin
    if PrintDialog1.Execute then begin
      CallPrint(True);
    end;
  end;
end;

procedure TMainFrm.GuardarComoExecute(Sender: TObject);
var
  e : TEditor;
begin
  e := GetEditor;
  if Assigned(e) then begin
    e.SaveAs;
  end;
end;

procedure TMainFrm.HTML2Click(Sender: TObject);
var
  e : TEditor;
begin
  e := GetEditor;
  if Assigned(e) then begin
    ExportDialog.Filter := SynExporterHTML1.DefaultFilter;
    ExportDialog.DefaultExt := '.html';
    if ExportDialog.Execute then begin
      SynExporterHTML1.Highlighter := e.SynEdit.Highlighter;
      SynExporterHTML1.ExportAll(e.SynEdit.Lines);
      if fileExists(ExportDialog.FileName) then begin
        case MessageDlg(Lang(950) + #13#10 + Lang(951), mtConfirmation, [mbYes, mbNo], 0) of
          mrYes : begin
                    SynExporterHTML1.SaveToFile(ExportDialog.FileName);
                  end;
          mrNo : Exit;
        end;
      end else begin
        SynExporterHTML1.SaveToFile(ExportDialog.FileName);
      end;
    end;
  end;
end;

procedure TMainFrm.RTF1Click(Sender: TObject);
var
  e : TEditor;
begin
  e := GetEditor;
  if Assigned(e) then begin
    ExportDialog.Filter := SynExporterRTF1.DefaultFilter;
    ExportDialog.DefaultExt := '.rtf';
    if ExportDialog.Execute then begin
      SynExporterRTF1.Highlighter := e.SynEdit.Highlighter;
      SynExporterRTF1.ExportAll(e.SynEdit.Lines);
      if fileExists(ExportDialog.FileName) then begin
        case MessageDlg(Lang(950) + #13#10 + Lang(951), mtConfirmation, [mbYes, mbNo], 0) of
          mrYes : begin
                    SynExporterRTF1.SaveToFile(ExportDialog.FileName);
                  end;
          mrNo : Exit;
        end;
      end else begin
        SynExporterRTF1.SaveToFile(ExportDialog.FileName);
      end;
    end;
  end;
end;

Procedure TMainFrm.visibleBar(barCaption:string;value:boolean);
var i:integer;
begin
  for i:=0 to StandardM.ActionBars.Count-1 do begin
    if StandardM.ActionBars[i].ActionBar.Caption=barCaption then begin
      StandardM.ActionBars[i].Visible:=value;
    end;
  end;
end;

procedure TMainFrm.FileToolbarVisibleClick(Sender: TObject);
begin
  gsettings.toolbar1visible:=not FileToolbarVisible.checked;
end;

procedure TMainFrm.LoadEditorSettings;
var
  e : TEditor;
  i : integer;
begin
  for i := PageControl.PageCount - 1 downto 0 do begin
    e := GetEditor(i);
    if Assigned(e) then begin
      e.SynEdit.Color := gsettings.DemoEditColor;
      e.SynEdit.RightEdge := settings.UpDown1Position;
      e.SynEdit.Font.Size := gsettings.UpDown2Position;
      e.SynEdit.TabWidth := gsettings.UpDown3Position;
      e.SynEdit.Font.Name := gsettings.EditorFontText;
    end;
  end;
end;

procedure TMainFrm.BuscarExecute(Sender: TObject);
var e:TEditor;
begin
{  if PageControl.PageCount > 0 then begin
    with GetEditor do begin
      if (SynEdit.SelText <> '') then begin
        FindDialog1.FindText := SynEdit.SelText;
      end else begin
        FindDialog1.FindText := settings.FindDialog1FindText;
      end;
    end;
    FindDialog1.Execute;
  end;    }
  e:=getEditor;
  e.SynEdit.OnReplaceText:=fOnReplaceText;
  Searching := TSearching.Create(Self);
  with Searching do
    try
       Searching.Edit1.Text:=e.SynEdit.WordAtCursor;
       ShowModal;
       settings.FindDialog1FindText:=Searching.Edit1.Text;
       if Searching.fromtop.Checked then e.SynEdit.CaretXY:=BufferCoord(0,0) else
         e.SynEdit.CaretXY:=e.SynEdit.BlockBegin;
    finally
      case Searching.ModalResult of
      mrok: begin
              opt:=[];
              if Assigned(e) then begin
                e.SynEdit.SearchReplace(Searching.Edit1.Text, '', opt);
              end;
            end;
      mrcancel:;
      end;
      Free;
    end;
end;

procedure TMainFrm.doonReplaceText(Sender: TObject; const ASearch, AReplace:
    widestring; Line, Column: integer; var Action: TSynReplaceAction);
var res:integer;
begin
  //  TSynReplaceAction = (raCancel, raSkip, raReplace, raReplaceAll);
  action:= synedit.raCancel;
  Form3 := TForm3.Create(Self);
  res:=form3.Showmodal;
  form3.Free;
  case  res of
  mrAll: action:=synedit.raReplaceAll;
  mrOK: action:=synedit.raReplace;
  mrCancel: action:=synedit.raSkip;
  mrAbort: action:=synedit.raCancel;
  end;
end;

procedure TMainFrm.ReplaceExecute(Sender: TObject);
var findtext,replacetext:string;
    e:TEditor;

  procedure doreplace();
  var i:integer;
  begin
    replacetext:=Form2.Edit2.Text;
    if Form2.back.Checked then opt:=opt+[ssoBackwards];
    if Form2.fromtop.Checked then opt:=opt+[ssoEntireScope];
    if Form2.WholeWord.Checked then opt:=opt+[ssoWholeWord];
    if Form2.MatchCase.Checked then opt:=opt+[ssoMatchCase];
    if Form2.selectedRange.Checked then opt:=opt+[ssoSelectedOnly];
    if Form2.prompt.checked then opt:=opt+[ssoPrompt];
    if form2.allopen.Checked then begin
      for i:=0 to pagecontrol.PageCount-1 do begin
        e:=getEditor(i);
        pagecontrol.ActivePageIndex:=i;
        e.SynEdit.SetFocus;
        e.SynEdit.SearchReplace(form2.Edit1.Text, form2.Edit2.Text, opt);
      end;
    end else begin
      if Assigned(e) then begin
        e.SynEdit.SearchReplace(form2.Edit1.Text, form2.Edit2.Text, opt);
      end;
    end;
  end;

begin
  e := GetEditor;
  if PageControl.PageCount > 0 then begin
  findtext:=GetEditor.SynEdit.WordAtCursor;
  fOnReplaceText:=doOnReplaceText;
  e.SynEdit.OnReplaceText:=fOnReplaceText;
  Form2 := TForm2.Create(Self);
  with Form2 do
    try
       form2.Edit1.Text:=findtext;
       ShowModal;
       if form2.fromtop.Checked then e.SynEdit.CaretXY:=BufferCoord(0,0) else
         e.SynEdit.CaretXY:=e.SynEdit.BlockBegin;
    finally
      case Form2.ModalResult of
      mrok: begin opt:=[ssoReplace];    doreplace(); end;
      mrall:begin opt:=[ssoReplaceAll]; doreplace(); end;
      mrcancel:;
      end;
      Free;
    end;
  end;
end;

procedure TMainFrm.FormClose(Sender: TObject; var Action: TCloseAction);
var s2:string;
begin
  AExit.Enabled := FALSE;
  try
    settings.SessionActive:=PageControl.ActivePageIndex;
  except
    s2:=getPersonalFolder;
    if FileCtrl.SelectDirectory(lang(3011),'rfMyComputer',s2) then begin
      uinifile.IniFileName:=s2+'\project.prd';
      if not FileExists(uinifile.IniFileName) then begin
        ForceDirectories(ExtractFilePath(uinifile.IniFileName));
        CreateIniFile(uinifile.IniFileName);
      end;
    end else begin
      uinifile.IniFileName:=getAppFolder() +'\devphp\'+'project.prd';
      if not FileExists(uinifile.IniFileName) then begin
        ForceDirectories(ExtractFilePath(uinifile.IniFileName));
        CreateIniFile(uinifile.IniFileName);
      end;
    end;
  end;
  if settings.SaveSessionChecked then begin
    GuardarSesion;
  end;
  gsettings.writeProjHistory;
  if WindowState <> wsMaximized then begin
    gsettings.MainFormLeft:=MainFrm.Left;
    gsettings.MainFormTop:=MainFrm.Top;
    gsettings.MainFormwidth:=MainFrm.Width;
    gsettings.MainFormHeight:=MainFrm.Height;
  end;
  gsettings.MainFormWindowState:=ord(MainFrm.WindowState);
  gsettings.SideBarWidth:=panel2.Width;
  if TBToolWindow1.CurrentDock=TBDock2 then gsettings.DockSideBar:='TBDock2';
  if TBToolWindow1.CurrentDock=TBDock3 then gsettings.DockSideBar:='TBDock3';
  TB2KSaveToolbarButtons(TBToolbar2);
  TB2KSaveToolbarButtons(TBToolbar3);
  TB2KSaveToolbarButtons(TBToolbar4);
  uinifile.SaveHighlighters(SynPHPSyn,SynCSSSyn1,SynJScriptSyn1,SynSQLSyn1,SynMultiSyn1,SynHTMLSyn1,SynXMLSyn1);
  settings.SessionActive:=pagecontrol.ActivePageIndex;
  settings.BrowserPath:=BrowserPath.Text;
  if CloseAll then begin
    FtpDisconnect;
    ftplist.Free;
    freeIniFile();
    Action := caFree;
  end else begin
    Action := caNone;
  end;
end;

procedure TMainFrm.EditMenuClick(Sender: TObject);
var
  e : TEditor;
begin
  e := GetEditor;
  if Assigned(e) then begin
    AUndo.Enabled := e.SynEdit.CanUndo;
    ARedo.Enabled := e.SynEdit.CanRedo;
    EditCut1.Enabled := TRUE;
    EditCopy1.Enabled := TRUE;
    EditPaste1.Enabled := Clipboard.HasFormat(CF_TEXT);
    SeleccionarTodo1.Enabled := TRUE;
  end
  else begin
     AUndo.Enabled := FALSE;
     ARedo.Enabled := FALSE;
     EditCut1.Enabled := FALSE;
     EditCopy1.Enabled := FALSE;
     EditPaste1.Enabled := FALSE;
     SeleccionarTodo1.Enabled := FALSE;
   end;
end;

procedure TMainFrm.ActivateButtons(Activar: boolean);
var pgtz:boolean;
        p:integer;
begin
  P:=PageControl.ActivePageIndex;
  if P=-1 then pagecontrol.ActivePageIndex:=0;
  ASave.Enabled := (GetEditor<>nil) and (GetEditor.ismodified);
  pgtz:= PageControl.PageCount > 0;
  ASaveAs.Enabled := pgtz;
  EnableSaveAll;
  AClose.Enabled := pgtz;
  APrint.Enabled := pgtz;
  EditMenuClick(self);
  ASearch.Enabled := pgtz;
  AReplace.Enabled := pgtz;
  AExecute.Enabled := pgtz;
  Exportar.Enabled := pgtz;
  Formato1.Enabled := pgtz;
  AinsImagen.Enabled := pgtz;
  AinsTable.Enabled := pgtz;
  AinsLayer.Enabled := pgtz;
  AinsForm.Enabled := pgtz;
  AinsText.Enabled := pgtz;
  AinsButton.Enabled := pgtz;
  AinsCheck.Enabled := pgtz;
  AinsRadio.Enabled := pgtz;
  AinsList.Enabled := pgtz;
  AinsFile.Enabled := pgtz;
  AinsImage.Enabled := pgtz;
  AinsHidden.Enabled := pgtz;
  AinsInc.Enabled := pgtz;
  AinsMail.Enabled := pgtz;
  AinsHR.Enabled := pgtz;
  AinsBR.Enabled := pgtz;
  AinsDate.Enabled := pgtz;
  Gtk2.Enabled := pgtz;
  Comprobarsintaxis1.Enabled := pgtz;
  OptimizarComprimircdigo1.Enabled := pgtz;
  IraLnea1.Enabled := pgtz;
  CerrarTodo.Enabled := pgtz;
  EMailWizard1.Enabled := pgtz;
  InsertFunction.Enabled := pgtz;
  PrintSelected1.Enabled := pgtz;
  EchoSelectedtext1.Enabled := pgtz;
  Replacewith1.Enabled := pgtz;
  InsertColor1.Enabled := pgtz;
  ReloadCurrentFile1.Enabled := pgtz;
  Siguiente2.Enabled := pgtz;
  Anterior1.Enabled := pgtz;
  InsertTable1.Enabled := pgtz;
  //Commentselectedtext1.Enabled := pgtz;
  StatusBar1.Panels[0].Text := '';
  StatusBar1.Panels[1].Text := '';
  StatusBar1.Panels[2].Text := '';
  StatusBar1.Panels[3].Text := '';
  //Commentselectedtext1.Enabled := FALSE;
  pagecontrol.ActivePageIndex:=p;
end;

procedure TMainFrm.OpcionesGenerales1Click(Sender: TObject);
var i:integer;
    doi:boolean;
begin
  i:=pageControl.activePageIndex;
  OptionForm := TOptionForm.Create(Self);
  with OptionForm do
  try
     ShowModal;
  finally
    doi:=OptionForm.ModalResult=mrok;
    Free;
  end;
  pageControl.activePageindex:=i;
  if doi then begin
    if gsettings.HideSideBar then panel2.Visible:=false else panel2.Visible:=true;
    Translate;
    pagecontrol2.ActivePage:=tabsheet7;
    if settings.localpathText<>VirtualExplorerTreeview1.RootFolderCustomPath
      then settreepath(settings.localpathText);
    mainfrm.Refresh;
    application.ProcessMessages;
    IdFTP1.Passive:=settings.ftppassive;
  end;
  freeExternals();
  addExternals();
end;


procedure TMainFrm.ExternalClick(Sender: TObject);
var s:string;
    st:TStringList;
    i:integer;
    e:TEditor;
begin
  st:=TStringList.Create;
  s:=((sender as TTBCustomItem).Caption);
  e:=GetEditor;
  for i:=0 to settings.Externals.Count-1 do begin
    st.Clear;
    split2(settings.Externals.Strings[i],'=',st);
    if assigned(e) then st[1]:=stringreplace(st[1],'%CURRFILE%',e.fFileName,[]);
//    showmessage(st[1]);
    if s=st[0] then executeExternal(st[1]);
    application.ProcessMessages;
  end;
  st.Free;
  askreload:=false;
  if assigned(e) then
    if e.checkChangedFile then ReloadCurrentFile1Click(sender);
  askreload:=true;
end;

procedure TMainFrm.addExternals();
var i:integer;
    item:TTBCustomItem;
    st:TStringList;

    function exists(s:string):boolean;
    var i2:integer;
        r:boolean;
    begin
      r:=false;
      for i2:=0 to externals.Count-1 do begin
        if externals[i2].Caption=s then r:=true;
      end;
      result:=r;
    end;

begin
  st:=TStringList.Create;
  if settings.Externals.Count=0 then Externals.Visible:=false else Externals.Visible:=true;
  for i:=0 to settings.Externals.Count-1 do begin
    st.Clear;
    split2(settings.Externals.Strings[i],'=',st);
    if not exists(st[0]) then begin
      item:=TTBCustomItem.Create(nil);
      item.Caption:=st[0];
      item.OnClick:=ExternalClick;
      item.ShortCut:=ShortCut(Word(inttostr(i+1)[1]),[ssAlt,ssShift]);
      externals.Add(item);
    end;
  end;
  st.Free;
end;

procedure TMainFrm.freeExternals();
begin
    Externals.Clear;
end;


procedure TMainFrm.ReadGPLClick(Sender: TObject);
begin
  TEditor.Create.Init(ExtractFilePath(Application.ExeName) + 'docs\copying.txt', TRUE);
  ActivateButtons(TRUE);
end;

procedure TMainFrm.ClearHistoryClick(Sender: TObject);
var
  i : integer;
begin
  settings.clearHistory;
  settings.writeHistory;
  i := Reabrir.Count-1;
  if Reabrir.Count <> 2 then
    repeat
       Reabrir.Remove(ReAbrir.Items[i]);
       dec(i);
    until Reabrir.Count = 2;
end;

procedure TMainFrm.NuevoHTMLClick(Sender: TObject);
var
  e : TEditor;
  i:integer;
  DomNode,a: TDomNode;
  p:integer;
  s:string;
begin
  Inc(NewCount);
  e := TEditor.Create;
  e.Init('Untitled' + IntToStr(NewCount) + '.htm*', FALSE);
  i:=listbox1.Items.IndexOf('HTMLTemplate');
  DomNode:=TDomNode(listbox1.Items.Objects[i]);
  if assigned(DomNode.attributes) then begin
    a:=DomNode.attributes.item(2);
    s:=(resolveInternalRefs(ResolveCharRefs(a.nodeValue)));
  end;
  p:=e.SynEdit.SelStart;
  inc(p,pos(cursorstr,s));
  s:=stringreplace(s,cursorstr,'',[rfReplaceAll]);
  insertar(s);
  e.SynEdit.SelStart:=p;
  ActivateButtons(TRUE);
  e.ismodified:=true;
end;

procedure TMainFrm.Siguiente2Click(Sender: TObject);
var e:TEditor;
begin
  if PageControl1.ActivePageIndex=pEdit then begin
    PageControl.SelectNextPage(TRUE);
    e:=GetEditor();
    if assigned(e) then e.SynEdit.SetFocus;
  end;
end;

function TMainFrm.CloseEditor(id: integer): integer;
var
  e : TEditor;
begin
  Result := mrCancel;
  e := GetEditor(id);
  if not Assigned(e) then Exit;
  Result := AskBeforeClose(e);
  if Result=mrCancel then Exit;
  e.Close(pagecontrol.ActivePage);
end;

function TMainFrm.AskBeforeClose(e: TEditor): integer;
var
  nRes : integer;
  fn:string;
begin
  nRes:=0;
  if e.ismodified = true then begin
    fn:=e.fFileName;
    if fn='' then fn:=GetEditor.fTabSheet.Caption;
    nRes := Application.MessageBox(PChar(Lang(952) + ' ' +fn +
                                   ' ' + Lang(953) + #13#10 + Lang(954)),
                                   'Dev-PHP IDE', MB_YESNOCANCEL);
    if nRes = IDYES then e.SaveFile(true);
  end;
  Result := nres;
end;

function TMainFrm.CloseAll;
var
  i : integer;
  res:integer;
begin
  Result := TRUE;
  if PageControl.PageCount > 0 then begin
    for i := PageControl.PageCount - 1 downto 0 do begin
      pagecontrol.activepageIndex:=pagecontrol.pagecount-1;
      res:=CloseEditor(i);
      if res=mrCancel then begin
        Result := FALSE;
        AExit.Enabled := TRUE;
        Break;
      end;
      if res=mrNo then begin
      end;
    end;
  end;
  if not(PageControl.PageCount > 0) then begin
    PageControl.Visible := FALSE;
  end;
end;

procedure TMainFrm.CerrarTodoClick(Sender: TObject);
begin
  CloseAll;
  treeview11.Items.Clear;
end;

procedure TMainFrm.NuevoPHPClick(Sender: TObject);
var
  e : TEditor;
  i:integer;
  DomNode,a: TDomNode;
  p:integer;
  s:string;
begin
  Inc(NewCount);
  e := TEditor.Create;
  e.Init('Untitled' + IntToStr(NewCount) + '.php*', FALSE);
  i:=listbox1.Items.IndexOf('PHPTemplate');
  DomNode:=TDomNode(listbox1.Items.Objects[i]);
  if assigned(DomNode.attributes) then begin
    a:=DomNode.attributes.item(2);
    s:=(resolveInternalRefs(ResolveCharRefs(a.nodeValue)));
  end;
  p:=e.SynEdit.SelStart;
  inc(p,pos(cursorstr,s));
  s:=stringreplace(s,cursorstr,'',[rfReplaceAll]);
  insertar(s);
  e.SynEdit.SelStart:=p;
  e.SynEdit.Highlighter:=SynMultiSyn1;
  e.ismodified:=true;
end;

procedure TMainFrm.GuardarTodoExecute(Sender: TObject);
var
  i : integer;
  e : TEditor;
begin
  if PageControl.PageCount > 0 then begin
    for i := PageControl.PageCount - 1 downto 0 do begin
      PageControl.ActivePage := PageControl.Pages[i];
      e := GetEditor(i);
      e.SaveFile(true);
    end;
  end;
end;

procedure TMainFrm.CloseExecute(Sender: TObject);
var
  e : TEditor;
  t : TTabSheet;
begin
  e := GetEditor;
  t:=pagecontrol.ActivePage;
  if Assigned(e) then begin
//    pagecontrol.SelectNextPage(false);
    if AskBeforeClose(e)<>mrCancel then begin
      e.Close(t);
      if PageControl2.ActivePage=TabSheet10 then button2click(sender);
    end;
  end;
  if not(PageControl.PageCount > 0) then begin
    PageControl.Visible := FALSE;
  end;
end;

procedure TMainFrm.CallPrint(doPrint : boolean);
var
  e : TEditor;
begin
  e := GetEditor;
  SynEditPrint1.Lines := e.SynEdit.Lines;
  SynEditPrint1.Font.Name := gsettings.EditorFontText;
  SynEditPrint1.Font.Size := gsettings.UpDown2Position;
  SynEditPrint1.Highlighter := e.SynEdit.Highlighter;
  if doPrint = TRUE then begin
    SynEditPrint1.Title := 'Dev-PHP IDE - ' + e.fFileName;
    SynEditPrint1.Header.Clear;
    SynEditPrint1.Header.Add(ExtractFileName(e.fFileName), nil, taLeftJustify, 1);
    SynEditPrint1.Header.Add('$DATE$ $TIME$', nil, taRightJustify, 1);
    SynEditPrint1.Footer.Clear;
    SynEditPrint1.Footer.Add('Page $PAGENUM$ of $PAGECOUNT$', nil, taRightJustify, 1);
    SynEditPrint1.Copies := Self.PrintDialog1.Copies;
    SynEditPrint1.Print;
  end;
end;

procedure TMainFrm.NewsClick(Sender: TObject);
begin
  TEditor.Create.Init(ExtractFilePath(Application.ExeName) + 'news.txt', TRUE);
  ActivateButtons(TRUE);
end;

procedure TMainFrm.Translate;
var i:integer;
begin
  LangFileName := gsettings.IdiomaText;
  LangFile := TIniFile.Create(replPath(LangFilename));
  FileMenu.Caption := Lang(0);
  EditMenu.Caption := Lang(1);
  EditSubmenu.Caption:=lang(1);
  SearchMenu.Caption := Lang(2);
  ViewMenu.Caption := Lang(3);
  RunMenu.Caption := Lang(4);
  OptionsMenu.Caption := Lang(5);
  WindowMenu.Caption := Lang(6);
  HelpMenu.Caption := Lang(7);
  ToolsMenu.Caption:=lang(8);
  TabSheet1.Caption:=lang(30);
  TabSheet2.Caption:=lang(31);
  TabSheet3.Caption:=lang(32);
  TabSheet4.Caption:=lang(33);
  TabSheet5.Caption:=lang(34);
  TabSheet6.Caption:=lang(35);
  Messages.Caption:=lang(36);
  Source.Caption:=lang(37);
  TabSheet7.Caption:=lang(40);
  TabSheet8.Caption:=lang(41);
  TabSheet10.Caption:=lang(42);
  ANew.Caption := Lang(50);
  ANew.Hint := ANew.Caption;
  Nuevo1.Caption:=ANew.Caption;
  NuevoTexto.Caption := Lang(51);
  NuevoHTML.Caption := Lang(52);
  NuevoPHP.Caption := Lang(53);
  AOpen.Caption := Lang(54);
  AOpen.Hint := AOpen.Caption;
  Reabrir.Caption := Lang(55);
  ClearHistory.Caption := Lang(56);
  ASave.Caption := Lang(57);
  ASave.Hint := ASave.Caption;
  ASaveAs.Caption := Lang(58);
  ASaveAs.Hint := ASaveAs.Caption;
  ASaveAll.Caption := Lang(59);
  ASaveAll.Hint := ASaveAll.Caption;
  AClose.Caption := Lang(60);
  AClose.Hint := Lang(68);
  Exportar.Caption := Lang(61);
  HTML2.Caption := Lang(62);
  RTF1.Caption := Lang(63);
  APrint.Caption := Lang(64);
  APrint.Hint := APrint.Caption;
  ConfigurarImpresin1.Caption := Lang(66);
  AExit.Caption := Lang(67);
  AExit.Hint := AExit.Caption;
  FileFormat1.Caption:=lang(69);
  ReloadCurrentFile1.Caption:=lang(70);
  reopenproject.Caption:=lang(71);
  clearprojhist.Caption:=lang(72);
  AUndo.Caption := Lang(100);
  AUndo.Hint := AUndo.Caption;
  ARedo.Caption := Lang(101);
  ARedo.Hint := ARedo.Caption;
  EditCut1.Caption := Lang(102);
  EditCut1.Hint := EditCut1.Caption;
  EditCopy1.Caption := Lang(103);
  EditCopy1.Hint := EditCopy1.Caption;
  EditPaste1.Caption := Lang(104);
  EditPaste1.Hint := EditPaste1.Caption;
  SeleccionarTodo1.Caption := Lang(105);
  OptimizarComprimircdigo1.Caption := Lang(106);
  DeleteLine1.Caption:=lang(107);
  DeleteToEndLine1.Caption:=lang(108);
  DeleteWord1.Caption:=lang(109);
  DeletePreviousWord1.Caption:=lang(110);
  UCaseLCase1.Caption:=lang(111);
  UpperCase1.Caption:=lang(112);
  LowerCase1.Caption:=lang(113);
  C3.Caption:=lang(114);
  ASearch.Caption := Lang(150);
  ASearch.Hint := ASearch.Caption;
  AReplace.Caption := Lang(151);
  AReplace.Hint := AReplace.Caption;
  ANextSearch.Caption := Lang(152);
  ANextSearch.Hint := ANextSearch.Caption;
  Iralnea1.Caption := Lang(153);
  Re1.Caption:=Lang(154);
  Re1.Hint:=Re1.Caption;
  SearchRegExOFiles.Caption:=Lang(155);
  SearchRegExOFiles.Hint:=SearchRegExOFiles.Caption;
  SearchRegExDir.Caption:=Lang(156);
  SearchRegExDir.Hint:=SearchRegExDir.Caption;
  FileToolbarVisible.Caption := Lang(200);
  StatusBarVisible.Caption := Lang(202);
  LineNumbers.Caption := Lang(203);
  TBSubmenuItem2.Caption:=Lang(205);
  TBSubmenuItem2.Hint:=TBSubmenuItem2.Caption;
  AnpassenFile.Caption:=lang(210);
  FileToolbarVisible.Caption:=lang(210);
  AnpassenEdit.Caption:=lang(211);
  EditToolbarVisible.Caption:=lang(211);
  AnpassenHtml.Caption:=lang(212);
  HtmlToolbarVisible.Caption:=lang(212);
  AFindFirst.Caption:=lang(213);
  SideBarVisible.Caption:=lang(214);
  SideBarToggleItem.Caption:=lang(214);
  SideBarToggleItem.Hint:=lang(214);
  zoom.Caption:=lang(215);
  zoom2.Caption:=zoom.Caption;
  AZoomin.Caption:=lang(216);
  Azoomout.Caption:=lang(217);
  Azoomreset.Caption:=lang(218);
  AExecute.Caption := Lang(250);
  AExecute.Hint := AExecute.Caption;
  ComprobarSintaxis1.Caption := Lang(251);
  Gtk2.Caption := Lang(254);
  Formato1.Caption := Lang(300);
  Texto1.Caption := Lang(301);
  OpcionesGenerales1.Caption := Lang(303);
  S1.Caption:=Lang(304);
  ACloseAll.Caption := Lang(350);
  ACloseAll.Hint:=ACloseAll.Caption;
  ANextWindow.Caption:=lang(351);
  ANextWindow.Hint:=ANextWindow.Caption;
  APreviousWindow.Caption := Lang(352);
  APreviousWindow.Hint:=APreviousWindow.Caption;
//  extSnippets1.Caption:=lang(353);
  EMailWizard1.Caption:=lang(354);
  InsertFunction.Caption:=lang(355);
  InsertTable1.Caption:=lang(356);
  PRINTselected1.Caption:=lang(357);
  ECHOselectedtext1.Caption:=lang(358);
  Replacewith1.Caption:=lang(359);
  InsertColor1.Caption:=lang(360);
  DateTime1.Caption:=lang(361);
  InsertDate1.Caption:=lang(362);
  InsertTime1.Caption:=lang(363);
  InsertDateTime1.Caption:=lang(364);
  Indent1.caption:=Lang(365);
  deindent1.Caption:=lang(366);
  Indent1.ShortCut:=ShortCut(Word('I'), [ssCtrl,ssShift]);
  DeIndent1.ShortCut:=ShortCut(Word('U'), [ssCtrl,ssShift]);
  DocumentSpecials1.Caption:=lang(367);
  InsertDocPath1.Caption:=lang(368);
  InsertDocFilename1.Caption:=lang(369);
  Insert1.Caption:=lang(370);
  
  Acercade1.Caption := Lang(400);
  ASearchDocs.Caption:=Lang(401);
  ASearchDocs.Hint:=ASearchDocs.Caption;
  AinsImagen.Caption := Lang(1050);
  AinsImagen.Hint := AinsImagen.Caption;
  AinsTable.Caption := Lang(1051);
  AinsTable.Hint := AinsTable.Caption;
  AinsLayer.Caption := Lang(1052);
  AinsLayer.Hint := AinsLayer.Caption;
  AinsForm.Caption := Lang(1053);
  AinsForm.Hint := AinsForm.Caption;
  AinsMail.Caption := Lang(1058);
  AinsMail.Hint := AinsMail.Caption;
  AinsInc.Caption := Lang(1055);
  AinsInc.Hint := AinsInc.Caption;
  AinsHR.Caption := Lang(1061);
  AinsHR.Hint := AinsHR.Caption;
  AinsBR.Caption := Lang(1062);
  AinsBR.Hint := AinsBR.Caption;
  AinsDate.Caption := Lang(1071);
  AinsDate.Hint := AinsDate.Caption;
  AinsText.Caption := Lang(1100);
  AinsText.Hint := AinsText.Caption;
  AinsButton.Caption := Lang(1101);
  AinsButton.Hint := AinsButton.Caption;
  AinsCheck.Caption := Lang(1102);
  AinsCheck.Hint := AinsCheck.Caption;
  AinsRadio.Caption := Lang(1103);
  AinsRadio.Hint := AinsRadio.Caption;
  AinsList.Caption := Lang(1104);
  AinsList.Hint := AinsList.Caption;
  AinsFile.Caption := Lang(1105);
  AinsFile.Hint := AinsFile.Caption;
  AinsImage.Caption := Lang(1106);
  AinsImage.Hint := AinsImage.Caption;
  AinsHidden.Caption := Lang(1107);
  AinsHidden.Hint := AinsHidden.Caption;
  Ahref.Caption := Lang(1108);
  Ahref.Hint := Ahref.Caption;
  AOpenProject.Caption:=Lang(2025);
  AOpenProject.Hint:=AOpenproject.Caption;
  ASaveProject.Caption:=Lang(2026);
  ASaveProject.Hint:=ASaveProject.Caption;
  ASend.Caption:=Lang(255);
  ASend.Hint:=ASend.Caption;
  ASaveAndSendFTP.Caption:=lang(256);
  ASaveAndSendFTP.Hint:=ASaveAndSendFTP.Caption;
  website.Caption:=lang(402);
  AComment.Caption:=lang(371);
  AInsShellfilename.Caption:=lang(372);
  AInsShellPath.Caption:=lang(373);
  Label1.Caption:=lang(2100);
  button1.Caption:=lang(2103);
//  button2.Caption:=lang(902);
  news.Caption:=lang(403);
  speedbutton1.Hint:=lang(1701);
  externals.Caption:=lang(1755);
  TabsToSpaces.Caption:=lang(115);
  SpacesToTabs.Caption:=lang(116);
  editphpini1.Caption:=lang(305);
  toggleBookmarks.Caption:=lang(117);
  toggleSubmenu.Caption:=toggleBookmarks.Caption;
  jumpbookmarks.Caption:=lang(118);
  jumpsubmenu.Caption:=jumpbookmarks.Caption;
  for i:=0 to togglebookmarks.Count-1 do begin
    togglebookmarks.Items[i].Caption:=lang(119)+' '+inttostr(i);
  end;
  for i:=0 to jumpbookmarks.Count-1 do begin
    jumpbookmarks.Items[i].Caption:=lang(119)+' '+inttostr(i);
  end;
end;

function GetLongPathName(APath:String):String;
var
  i : Integer;
  h : THandle;
  Data : TWin32FindData;
  IsBackSlash : Boolean;
begin
  APath:=ExpandFileName(APath);
  i:=Pos('\',APath);
  Result:=Copy(APath,1,i);
  Delete(APath,1,i);
  repeat
    i:=Pos('\',APath);
    IsBackSlash:=i>0;
    if Not IsBackSlash then
      i:=Length(APath)+1;
    h:=FindFirstFile(PChar(Result+Copy(APath,1,i-1)),Data);
    if h<>INVALID_HANDLE_VALUE then begin
      try
        Result:=Result+Data.cFileName;
        if IsBackSlash then
          Result:=Result+'\';
      finally
        Windows.FindClose(h);
      end;
    end
    else begin
      Result:=Result+APath;
      Exit;
    end;
    Delete(APath,1,i);
  until Length(APath)=0;
end;

procedure TMainFrm.FormShow(Sender: TObject);
var
  FileName : string;
  e : TEditor;
  i:integer;
  info:TShFileInfo;
begin
//  scripts.TabVisible:=false;
  while not onceonly.all_loaded do begin application.ProcessMessages end;
  loadAutoText();
  ftplist:=TStringList.Create;
  pagecontrol1.ActivePageIndex:=pEdit;
  pagecontrol2.activePageIndex:=0;
  Self.Caption := 'Dev-PHP ' + DevPHPVer;
  if ParamCount > 0 then begin
    FileName := getLongPathName(ParamStr(1));
    if FileExists(FileName) then begin
      e := TEditor.Create;
      e.Init(FileName, True);
    end;
  end;
  Translate;
  ActivateButtons(TRUE);
  settreepath(settings.localpathText);
  BrowserPath.Text:=settings.BrowserPath;
  LoadProject(gsettings.LastProject);
  case gsettings.SaveType of
  0: savewithcrlf1.Checked:=true;
  1: saveunix1.Checked:=true;
  2: savewithcr1.Checked:=true;
  else savewithcrlf1.Checked:=true;
  end;
  TB2kInitializeToolbar(TBToolbar2, EmptyStr, uIniFile.OldIniFilename, 0);
  TB2kInitializeToolbar(TBToolbar3, EmptyStr, uIniFile.OldIniFilename, 0);
  TB2kInitializeToolbar(TBToolbar4, EmptyStr, uIniFile.OldIniFilename, 0);
  TBToolWindow1.Visible:=not gsettings.HideSideBar;
  TBToolbar2.Visible := gsettings.toolbar1visible;
  TBToolbar4.Visible := gsettings.htmlbar1visible;
  TBToolbar3.Visible := gsettings.editbar1visible;
  StatusBar1.Visible := gsettings.StatusBar1visible;
  for i:=0 to toOpen.Count-1 do begin
    OpenFile(self,toOpen.Strings[i]);
  end;
  toOpen.Clear;
  openingallowed:=true;
  if GetEditor<>nil then
    Caption := 'Dev-PHP ' + DevPHPVer + ' - [ ' + GetEditor.fShowName + ' ]';
  addExternals;
  TBXSwitcher1.EnableXPStyles:=true;
  TBXSwitcher1.Theme:='Athen';
  ftpitems.handle:=SHGetFileInfo('',
        0,
        info,
        Sizeof(SHFileinfo),
        SHGFI_SYSICONINDEX OR SHGFI_SMALLICON );
  virtualExplorerTreeview1.Refresh();
end;

procedure TMainFrm.GuardarSesion;
var
  i : integer;
  CurrentFile : string;
  e:TEditor;
begin
  settings.Session.Clear;
  if PageControl.PageCount > 0 then begin
    for i := 0 to PageControl.PageCount - 1 do begin
      e:=GetEditor(i);
      CurrentFile:=e.fFilename;
      if (e<>nil) and (Length(e.fFileName) > 0) then begin
        settings.Session.Add(GetEditor(i).fFileName);
      end;
    end;
    settings.SessionActive:=PageControl.ActivePageIndex;
  end;
  settings.writeSession;
end;

procedure TMainFrm.Iralnea1Click(Sender: TObject);
begin
  if PageControl.PageCount > 0 then begin
    GoToLine := TGoToLine.Create(Self);
    with GoToLine do
    try
      ShowModal;
    finally
      Free;
    end;
  end;
end;

procedure TMainFrm.OptimizarComprimircdigo1Click(Sender: TObject);
begin
  if PageControl.PageCount > 0 then begin
    OptimizeForm := TOptimizeForm.Create(Self);
    with OptimizeForm do
    try
      ShowModal;
    finally
      Free;
    end;
  end;
end;

function TMainFrm.GetEditor(const index: integer): TEditor;
var
 i: integer;
begin
  if index = -1 then
    i:= PageControl.ActivePageIndex
  else
    i:= index;

  if (PageControl.PageCount <= 0) or (i=-1) then begin
    result := nil;
  end else begin
    result := TEditor(PageControl.Pages[i].Tag);
  end;
end;

procedure TMainFrm.Insert(Text: string);
var
  e : TEditor;
begin
  e := GetEditor;
  if Assigned(e) then begin
    e.SynEdit.SelText := Text;
    e.SynEdit.SetFocus;
    e.SynEdit.EnsureCursorPosVisible;
    MainFrm.ASave.Enabled := TRUE;
  end;
end;

procedure TMainFrm.insTablaExecute(Sender: TObject);
begin
  if PageControl.PageCount > 0 then begin
    TableForm := TTableForm.Create(Self);
    try
      tableform.Visible:=false;
      TableForm.ShowModal;
    finally
      Tableform.Free;
    end;
  end;
end;

procedure TMainFrm.Anterior1Click(Sender: TObject);
begin
  if virtualExplorerTreeview1.Focused then begin
    virtualExplorerTreeview1.Refresh();
    exit;
  end;
  if PageControl1.ActivePageIndex=pEdit then PageControl.SelectNextPage(FALSE);
  if PageControl1.ActivePageIndex=pIPreview then webbrowser.Refresh2;
end;

procedure TMainFrm.Gtk2Click(Sender: TObject);
begin
  if PageControl.PageCount > 0 then begin
    GtkRun := TGtkRun.Create(Self);
    with GtkRun do
    try
      ShowModal;
    finally
      Free;
    end;
  end;
end;

procedure TMainFrm.CheckExecute(Sender: TObject);
begin
  if PageControl.PageCount > 0 then begin
    SyntaxCheck := TSyntaxCheck.Create(Self);
    with SyntaxCheck do
    try
      ShowModal;
    finally
      Free;
    end;
  end;
end;

procedure TMainFrm.OnceOnlyParameter(Sender: TObject; const Value: String);
var
  x : integer;
  Exists : boolean;
begin
  application.ProcessMessages;
  if FileExists(Value) then begin
    Exists := FALSE;
    for x := 0 to PageControl.PageCount - 1 do begin
      if Value = GetEditor(x).fFileName then begin
        Exists := TRUE;
        Break;
      end;
    end;
    if Exists = False then begin
      application.ProcessMessages;
      TEditor.Create.Init(Value, TRUE);
      AgregarHistorial(Value);
      GuardarHistorial(Value);
    end else begin
      MessageDlg(Format(lang(3005),[Value]), mtError, [mbOk], 0);
    end;
  end;
  ActivateButtons(TRUE);
end;

procedure TMainFrm.HtmlToolbarVisibleClick(Sender: TObject);
begin
  gsettings.htmlbar1visible:=not HtmlToolbarVisible.Checked;
end;

procedure TMainFrm.PRINTselected1Click(Sender: TObject);
var s:string;
begin
  if PageControl.PageCount > 0 then begin
    with GetEditor do begin
      s:=StringReplace(SynEdit.SelText, '''', '\''', [rfReplaceAll]);
      s:=StringReplace(s, '"', '\"', [rfReplaceAll]);
      SynEdit.SelText := 'PRINT "' + s + '";';
    end;
  end;
end;

procedure TMainFrm.Replacewith1Click(Sender: TObject);
begin
  if PageControl.PageCount > 0 then begin
    with GetEditor do begin
      SynEdit.SelText := StringReplace(SynEdit.SelText, '\', '/', [rfReplaceAll]);
    end;
  end;
end;

procedure TMainFrm.ECHOselectedtext1Click(Sender: TObject);
var s:string;
begin
  if PageControl.PageCount > 0 then begin
    with GetEditor do begin
      s:=StringReplace(SynEdit.SelText, '''', '\''', [rfReplaceAll]);
      s:=StringReplace(s, '"', '\"', [rfReplaceAll]);
      SynEdit.SelText := 'ECHO "' + s + '";';
    end;
  end;
end;

procedure TMainFrm.EMailWizard1Click(Sender: TObject);
begin
  if PageControl.PageCount > 0 then begin
    MailForm := TMailForm.Create(Self);
    with MailForm do
    try
       ShowModal;
    finally
      Free;
    end;
  end;
end;

procedure TMainFrm.InsertFunctionClick(Sender: TObject);
begin
  if PageControl.PageCount > 0 then begin
    FunctionForm := TFunctionForm.Create(Self);
    with FunctionForm do
    try
       ShowModal;
    finally
      Free;
    end;
  end;
end;

procedure TMainFrm.ReloadCurrentFile1Click(Sender: TObject);
var
  e : TEditor;
  r : integer;
begin
  if PageControl.PageCount > 0 then begin
    e := GetEditor;
    if askreload then
        r:= MessageDlg(Format(lang(3013),[e.fFileName]), mtConfirmation, [mbYes, mbNo], 0)
    else r:=mrYes;
    case r of
      mrYes : begin
        if FileExists(e.fFileName) then begin
          e.SynEdit.Lines.LoadFromFile(e.fFileName);
          e.ismodified := TRUE;
          ASave.Enabled := FALSE;
          e.SynEdit.Modified:=false;
          pagecontrol.ActivePage.Caption:=ExtractFileName(e.fFileName);
//          MessageDlg('File "' + e.fFileName + '" has been reloaded.', mtInformation, [mbOk], 0);
        end else begin
          MessageDlg(Format(lang(3014),[e.fFileName]), mtError, [mbOk], 0);
        end;
      end;
    end;
  end;
end;

procedure TMainFrm.InsertColor1Click(Sender: TObject);
var
  InsertStr : string;
begin
  if PageControl.PageCount > 0 then begin
    if ColorDialog1.Execute then begin
      InsertStr := IntToHex(ColorDialog1.Color, 6);
      GetEditor.SynEdit.SelText := '#'
        +InsertStr[5]+InsertStr[6]
        +InsertStr[3]+InsertStr[4]
        +InsertStr[1]+InsertStr[2];
    end;
  end;
end;

procedure TMainFrm.CheckforUpdate1Click(Sender: TObject);
begin
  UpdateForm := TUpdateForm.Create(Self);
  with UpdateForm do
  try
     ShowModal;
  finally
    Free;
  end;
end;

procedure TMainFrm.SearchDocumentationClick(Sender: TObject);
var
  Doc_Filename, Doc_Lang,  Section,s : string;
  Command         :OleVariant;
  e:TEditor;
begin
  PageControl1.ActivePageIndex:=pDoc;
  if not firstSearch then pagecontrol1.OnChange(sender) else firstSearch:=false;
  e:=GetEditor;
  if assigned(e) then begin
    s:=e.SynEdit.GetWordAtRowCol(e.synedit.CaretXY);
  end else s:='';
  command:='about:blank';
  webbrowser2.Navigate2(command);
  application.ProcessMessages;
  Doc_Filename := replPath(gsettings.DocsPathText);
  if FileExists(Doc_Filename) then begin
    Doc_Lang := gsettings.dl;
    Section := 'function';
    SearchString := StringReplace(s, '_', '-', [rfReplaceAll]);
    SearchString := LowerCase(SearchString);
    Command := 'mk:@MSITStore:' + Doc_Filename + '::/' + Doc_Lang + '/' + Section + '.' + SearchString + '.html';
    ValueListEditor1.Visible := FALSE;
    Splitter1.Visible := FALSE;
    PageControl1.ActivePageIndex := pDoc;
    doc_complete:=false;
    WebBrowser2.Navigate2(Command);
    while doc_complete=false do application.processmessages;
    if pos('res://',Webbrowser2.OleObject.Document.Url)=1 then begin
      Command := 'mk:@MSITStore:' + Doc_Filename + '::/' + Doc_Lang + '/index.html';
      WebBrowser2.Navigate2(Command);
    end;
  end else begin
    MessageDlg(lang(3015), mtError, [mbOk], 0);
  end;
  MainFrm.StatusBar1.SetFocus;
end;


function TMainFrm.GetSearchString : string;
var locline, lookup: String;
    TmpX,
    ParenCounter   : Integer;
    FoundMatch     : Boolean;
    CanExecute     : Boolean;
    e              : TEditor;
begin
  if PageControl.PageCount > 0 then begin
  e := GetEditor;
  if not(Assigned(e)) then begin
    Exit;
  end;
  with e.SynEdit do
  begin
    locLine := LineText;

    //go back from the cursor and find the first open paren
    TmpX := CaretX;
    if TmpX > length(locLine) then
      TmpX := length(locLine)
    else dec(TmpX);
    FoundMatch := FALSE;
    while (TmpX > 0) and not(FoundMatch) do
    begin
      if LocLine[TmpX] = ',' then
      begin
        dec(TmpX);
      end else if LocLine[TmpX] = ')' then
      begin
        //We found a close, go till it's opening paren
        ParenCounter := 1;
        dec(TmpX);
        while (TmpX > 0) and (ParenCounter > 0) do
        begin
          if LocLine[TmpX] = ')' then inc(ParenCounter)
          else if LocLine[TmpX] = '(' then dec(ParenCounter);
          dec(TmpX);
        end;
        if TmpX > 0 then dec(TmpX);  //eat the open paren
      end else if locLine[TmpX] = '(' then
      begin
        //we have a valid open paren, lets see what the word before it is
{        StartX := TmpX;
        while (TmpX > 0) and not(locLine[TmpX] in TSynValidStringChars) do
          Dec(TmpX);
        if TmpX > 0 then
        begin
          SavePos := TmpX;
          While (TmpX > 0) and (locLine[TmpX] in TSynValidStringChars) do
            dec(TmpX);
          inc(TmpX);
          lookup := lowercase(Copy(LocLine, TmpX, SavePos - TmpX + 1));
          FoundMatch := LookupList.IndexOf(Lookup) > -1;
          if not(FoundMatch) then
          begin
            TmpX := StartX;
            dec(TmpX);
          end;
        end;}
      end else dec(TmpX)
    end;
  end;

  CanExecute := FoundMatch;
  if CanExecute then begin
    Result := Lookup;
  end;
  end;
end;

procedure TMainFrm.Commentselectedtext1Click(Sender: TObject);
var
  e : TEditor;
begin
  e := GetEditor;
  if Assigned(e) then begin
    e.SynEdit.SelText := '/* ' + e.SynEdit.SelText + ' */';
  end;
end;

procedure TMainFrm.scpParamsExecute(Kind: SynCompletionType;
  Sender: TObject; var AString: String; var x, y: Integer;
  var CanExecute: Boolean);
var locline, lookup: String;
    TmpX,
    ParenCounter,
    TmpLocation    : Integer;
    FoundMatch     : Boolean;
    i : integer;
begin
  with TSynCompletionProposal(Sender).Editor do
  begin
    locLine := LineText;

    //go back from the cursor and find the first open paren
    TmpX := CaretX;
    if TmpX > length(locLine) then
      TmpX := length(locLine)
    else dec(TmpX);
    FoundMatch := FALSE;
    TmpLocation := 0;
    while (TmpX > 0) and not(FoundMatch) do
    begin
      if LocLine[TmpX] = ',' then
      begin
        inc(TmpLocation);
        dec(TmpX);
      end else if LocLine[TmpX] = ')' then
      begin
        //We found a close, go till it's opening paren
        ParenCounter := 1;
        dec(TmpX);
        while (TmpX > 0) and (ParenCounter > 0) do
        begin
          if LocLine[TmpX] = ')' then inc(ParenCounter)
          else if LocLine[TmpX] = '(' then dec(ParenCounter);
          dec(TmpX);
        end;
        if TmpX > 0 then dec(TmpX);  //eat the open paren
      end else if locLine[TmpX] = '(' then
      begin
        //we have a valid open paren, lets see what the word before it is
{        StartX := TmpX;
        while (TmpX > 0) and not(locLine[TmpX] in TSynValidStringChars) do
          Dec(TmpX);
        if TmpX > 0 then
        begin
          SavePos := TmpX;
          While (TmpX > 0) and (locLine[TmpX] in TSynValidStringChars) do
            dec(TmpX);
          inc(TmpX);
          lookup := Uppercase(Copy(LocLine, TmpX, SavePos - TmpX + 1));
          FoundMatch := LookupList.IndexOf(Lookup) > -1;
          if not(FoundMatch) then
          begin
            TmpX := StartX;
            dec(TmpX);
          end;
        end;   }
      end else dec(TmpX)
    end;
  end;

  CanExecute := FoundMatch;

  if CanExecute then
  begin
    TSynCompletionProposal(Sender).Form.CurrentIndex := TmpLocation;
    if Lookup <> TSynCompletionProposal(Sender).PreviousToken then
    begin
      TSynCompletionProposal(Sender).ItemList.Clear;

      for i := 0 to LookupList.Count - 1 do begin
        if Lookup = UpperCase(LookupList.Strings[i]) then begin
          TSynCompletionProposal(Sender).ItemList.Add(ParamList.Strings[i]);
          Break;
        end;
      end;
    end;
  end else TSynCompletionProposal(Sender).ItemList.Clear;
end;

procedure TMainFrm.FormDestroy(Sender: TObject);
begin
//  OnceOnly.destroy;
  pars.free;
  TB2KShutdownToolbar;
  if not (csDesigning in ComponentState) then DragAcceptFiles(Handle, FALSE);
  HHCloseAll; // Schliet alle Hilfe-Fenster
  if Assigned(mHHelp) then
    mHHelp.Free;
  if LookupList <> nil then LookupList.Free;
  if ParamList <> nil then ParamList.Free;
  if FunctionNames <> nil then FunctionNames.Free;
  if FunctionNumbers <> nil then FunctionNumbers.Free;
  ftpitems.Handle:=0;
  toOpen.Free;
  IdHTTPServer1.Active := false;
  MIMEMap.Free;
  UILock.Free;
end;

procedure TMainFrm.FindDialog1Find(Sender: TObject);
var
  FindStr : string;
begin
  settings.FindDialog1FindText:=FindDialog1.FindText;
  FindDialog1.CloseDialog;
  FindStr := FindDialog1.FindText;
  if GetEditor.SynEdit.SearchReplace(FindStr, '', GetFindOptions(FindDialog1)) = 0 then begin
    MessageBeep($7000);
//    MessageDlg(Lang(956) + ' "' + FindStr + '" ' + Lang(957), MtInformation, [mbOK],0);
    statusbar1.Panels[3].Text:=Lang(956) + ' "' + FindStr + '" ' + Lang(957);
//    ANextSearch.Enabled := FALSE;
  end else
//    ANextSearch.Enabled := TRUE;
end;

procedure TMainFrm.WebsiteClick(Sender: TObject);
begin
  WebBrowser3.Navigate('http://devphp.sourceforge.net');
  PageControl1.ActivePageIndex := pBrowser;
end;

procedure TMainFrm.FormPaint(Sender: TObject);
begin
  Self.Font.Name := settings.DialogFontText;
end;

procedure TMainFrm.syncEditorWithPath;
var e:TEditor;
begin
  e:=GetEditor();
  if not assigned(e) then exit;
  if not SideBarToggleItem.Checked then exit;
  if pageControl2.ActivePage=TabSheet7 then begin
    virtualExplorerTreeview1.BrowseTo(ExtractFilePath(e.fFileName),true,true,true,false);
    virtualExplorerListview1.BrowseTo(e.fFileName,true,true,true,true);
  end;
end;

procedure TMainFrm.PageControlChange(Sender: TObject);
var
  e : TEditor;

begin
//  showmessage(inttostr(pagecontrol.ActivePageIndex));

  e := GetEditor(PageControl.ActivePageIndex);
  if Assigned(e) then begin
    e.SynEdit.SetFocus;
    if assigned(editval) then editval.Free;
    editval:=nil;
    ASave.Enabled := e.ismodified;
    scpParams.Editor := e.SynEdit;
    EditMenuClick(Self);
    e.NameHighlighters;
    e.LoadEditorSettings;
    StatusBar1.Panels[2].Text := e.szInsert;
//    StatusBar1.Panels[4].Text := Format('%12d:%4d',
//      [e.SynEdit.CaretY, e.SynEdit.CaretX]);
    Self.Caption := 'Dev-PHP ' + DevPHPVer + ' - [ ' + e.fShowName + ' ]';
    if e.SynEdit.Highlighter<>nil then StatusBar1.Panels[3].Text:=e.SynEdit.Highlighter.LanguageName;
    SyncEditorWithPath;
    with e.SynEdit do begin
      if S1.checked then
        Options:=Options + [eoShowSpecialChars] else Options:=Options - [eoShowSpecialChars]
    end;
    if pagecontrol2.ActivePage=TabSheet10 then begin
      button2Click(sender);
    end;
  end;
  CheckHighlighter;
end;

function TMainFrm.RunAndGetOutput(Cmd, WorkDir: string): string;
var
  tsi: TStartupInfo;
  tpi: TProcessInformation;
  nRead: DWORD;
  aBuf: Array[0..101] of char;
  sa: TSecurityAttributes;
  hOutputReadTmp, hOutputRead, hOutputWrite, hInputWriteTmp, hInputRead,
  hInputWrite, hErrorWrite: THandle;
  FOutput: String;
begin
  FOutput := '';

  sa.nLength              := SizeOf(TSecurityAttributes);
  sa.lpSecurityDescriptor := nil;
  sa.bInheritHandle       := True;

  CreatePipe(hOutputReadTmp, hOutputWrite, @sa, 0);
  DuplicateHandle(GetCurrentProcess(), hOutputWrite, GetCurrentProcess(),
    @hErrorWrite, 0, true, DUPLICATE_SAME_ACCESS);
  CreatePipe(hInputRead, hInputWriteTmp, @sa, 0);

  DuplicateHandle(GetCurrentProcess(), hOutputReadTmp,  GetCurrentProcess(),
    @hOutputRead,  0, false, DUPLICATE_SAME_ACCESS);
  DuplicateHandle(GetCurrentProcess(), hInputWriteTmp, GetCurrentProcess(),
    @hInputWrite, 0, false, DUPLICATE_SAME_ACCESS);
  CloseHandle(hOutputReadTmp);
  CloseHandle(hInputWriteTmp);

  FillChar(tsi, SizeOf(TStartupInfo), 0);
  tsi.cb         := SizeOf(TStartupInfo);
  tsi.dwFlags    := STARTF_USESTDHANDLES or STARTF_USESHOWWINDOW;
  tsi.hStdInput  := hInputRead;
  tsi.hStdOutput := hOutputWrite;
  tsi.hStdError  := hErrorWrite;

  CreateProcess(nil, PChar(Cmd), @sa, @sa, true, 0, nil, PChar(WorkDir),
    tsi, tpi);
  CloseHandle(hOutputWrite);
  CloseHandle(hInputRead );
  CloseHandle(hErrorWrite);
  Application.ProcessMessages;

  repeat
     if (not ReadFile(hOutputRead, aBuf, 16, nRead, nil)) or (nRead = 0) then
     begin
        if GetLastError = ERROR_BROKEN_PIPE then Break
        else MessageDlg(lang(3016), mtError, [mbOK], 0);
     end;
     aBuf[nRead] := #0;
     FOutput := FOutput + PChar(@aBuf[0]);
     Application.ProcessMessages;
  until False;

  Result := FOutput;
end;

procedure TMainFrm.AnalizeOutput(List: TStringList);
var
  i, p, w, e, f : integer;
  s, t : string;
begin
  w := 0;
  e := 0;
  f := 0;
  for i := 0 to List.Count - 1 do begin
    s := List.Strings[i];
    s := Trim(s);
    p := Pos('on line <b>', s);
    t := '';
    if p <> 0 then begin
      t := s;
      Delete(t, 1, p + Length('on line <b>') - 1);
      Delete(t, pos('</b>', t), Length(t));
    end;
    p := Pos('<b>Warning</b>:  ',s);
    if p <> 0 then begin
      Inc(w);
      ProcessLine(s, t);
    end;
    p := Pos('<b>Parse error</b>:  ',s);
    if p <> 0 then begin
      Inc(e);
      ProcessLine(s, t);
    end;
    p := Pos('<b>Fatal error</b>:  ',s);
    if p <> 0 then begin
      Inc(f);
      ProcessLine(s, t);
    end;
  end;
  if (e > 0) or (f > 0) or (w > 0) then begin
    Splitter1.Visible := TRUE;
    ValueListEditor1.Visible := TRUE;
  end else begin
    Splitter1.Visible := FALSE;
    ValueListEditor1.Visible := FALSE;
  end;
end;

procedure TMainFrm.ProcessLine(s, l: string);
var
  p : integer;
begin
  p := pos('<b>',s);
  while p <> 0 do begin
    Delete(s,p,3);
    p := pos('<b>',s);
  end;
  p := pos('</b>',s);
  while p <> 0 do begin
    Delete(s,p,4);
    p := pos('</b>',s);
  end;
  Delete(s,pos('<br />',s),6);
end;

procedure TMainFrm.FastFTPExecute(Sender: TObject);
var path,CurrFile:string;
begin
  if pagecontrol1.ActivePageIndex=pePreview then begin
    pagecontrol1.ActivePageIndex:=pEdit;
    pagecontrol1.OnChange(sender);
  end else begin
    StatusBar1.Panels[3].Text:='save File.. ';
    GuardarExecute(sender);
    StatusBar1.Panels[3].Text:='sending.. ';
    Path:=settings.localpathText;
    idftp1.Port:=strtoint(settings.FTPPortText);
    idftp1.Host:=settings.FTPHostText;
    idftp1.Username:=settings.FTPUserText;
  //  idftp1.Password:=settings.FTPPasswordText;
    idftp1.Password:=settings.FTPPasswordSave;
    try
      try
        FtpConnect();
      except
        exit;
      end;
      changeFTPPath();
      CurrFile := GetEditor.fFileName;
      StatusBar1.Panels[3].Text:='sending '+currfile;
//      showmessage(CurrFile+' '+ExtractFilename(CurrFile));
      idftp1.Put(CurrFile,ExtractFilename(CurrFile),false);
    except
      StatusBar1.Panels[3].Text:='error sending '+currfile;
      exit;
    end;
    StatusBar1.Panels[3].Text:='end sending '+currfile;
    pagecontrol1.ActivePageIndex:=pePreview;
    pagecontrol1.OnChange(sender);
  end;
end;

procedure TMainFrm.ToolButton49Click(Sender: TObject);
begin
   PageControl1.ActivePageIndex := pDoc;
   pagecontrol1.OnChange(sender);
end;

procedure TMainFrm.Insertar(Texto: string);
var c:TEdit;
begin
  c:=TEdit.Create(self);
  c.Visible:=false;
  c.Text:=Texto;
  c.Parent:=self;
  c.SelectAll;
  c.CopyToClipboard;
  c.Free;
  getEditor.SynEdit.PasteFromClipboard;
  getEditor.SynEdit.EnsureCursorPosVisible;
  getEditor.isModified := true;
  ASave.Enabled := true;
end;

procedure TMainFrm.insImagenExecute(Sender: TObject);
begin
  Insertar('<img src="image_url">');
end;

procedure TMainFrm.insCapaExecute(Sender: TObject);
begin
  Insertar('<div id="Layer1" style="position:absolute; width:200px; height:115px; z-index:1"></div>');
end;

procedure TMainFrm.insFormExecute(Sender: TObject);
begin
  Insertar('<form name="form1" method="post" action="">'#13#10 + ''#13#10 + '</form>');
end;

procedure TMainFrm.insTextExecute(Sender: TObject);
begin
  Insertar('<input type="text" name="text_field">');
end;

procedure TMainFrm.insButtonExecute(Sender: TObject);
begin
  Insertar('<input type="submit" name="Submit" value="Send Form">');
end;

procedure TMainFrm.insCheckExecute(Sender: TObject);
begin
  Insertar('<input type="checkbox" name="checkbox" value="checkbox">');
end;

procedure TMainFrm.insRadioExecute(Sender: TObject);
begin
  if pagecontrol1.ActivePageIndex=pHTMLEdit then begin
    //form1.InsertRadioActionExecute(sender);
  end else begin
    Insertar('<input type="radio" name="radiobutton" value="radiobutton">');
  end;
end;

procedure TMainFrm.insListExecute(Sender: TObject);
begin
  Insertar('<select name="select">'#13#10 + ''#13#10 + '</select>');
end;

procedure TMainFrm.InsImageExecute(Sender: TObject);
begin
  Insertar('<input type="file" name="file">');
end;

procedure TMainFrm.insImgExecute(Sender: TObject);
begin
  Insertar('<input type="image" border="0" name="image_field" src="image_url">');
end;

procedure TMainFrm.insHiddenExecute(Sender: TObject);
begin
  Insertar('<input type="hidden" name="hidden_field">');
end;

procedure TMainFrm.insIncExecute(Sender: TObject);
begin
  Insertar('<!--#include virtual="file_url" -->');
end;

procedure TMainFrm.insMailExecute(Sender: TObject);
begin
  Insertar('<a href="mailto:mail@domain.com">Write Email</a>');
end;

procedure TMainFrm.insHRExecute(Sender: TObject);
begin
  Insertar('<hr />');
end;

procedure TMainFrm.insBRExecute(Sender: TObject);
begin
  Insertar('<br />');
end;

procedure TMainFrm.insDateExecute(Sender: TObject);
var s:string;
begin
  DateTimeToString(s,'DD.MM.YYYY t',now());
  Insertar(s);
end;

procedure TMainFrm.Indent1Click(Sender: TObject);
var e:TSynEdit;
    s:string;
    linestart,lineend,i2,i:integer;
    bb,be:TBufferCoord;
begin
  e:=getEditor().SynEdit;
  bb:=e.BlockBegin; be:=e.BlockEnd;
  linestart:=e.BlockBegin.Line-1;
  if e.BlockEnd.Char=1 then i:=2 else i:=1;
  lineend:=e.BlockEnd.Line-i;
  if lineend<linestart then lineend:=linestart;
  s:=''; for i2:=1 to e.TabWidth do s:=s+' ';
  for i2:=linestart to lineend do begin
    e.Lines[i2]:=s+e.Lines[i2];
  end;
  e.BlockBegin:=bb; e.BlockEnd:=be;
  geteditor().isModified:=true;
end;

procedure TMainFrm.DeIndent1Click(Sender: TObject);
var e:TSynEdit;
    linestart,lineend,lauf,lauf2,i:integer;
    s:string;
    bb,be:TBufferCoord;
begin
  e:=getEditor.SynEdit;
  bb:=e.BlockBegin; be:=e.BlockEnd;
  linestart:=e.BlockBegin.Line-1;
  if e.BlockEnd.Char=1 then i:=2 else i:=1;
  lineend:=e.BlockEnd.line-i;
  if lineend<linestart then lineend:=linestart;
  for lauf:=linestart to lineend do begin
    s:=e.Lines[lauf];
    for lauf2:=1 to e.TabWidth do begin
      if (ord(s[1])=ord(' ')) then begin
        delete(s,1,1);
      end;
      if (s[1]=#9) then delete(s,1,1);
    end;
    e.Lines[Lauf]:=s;
  end;
  geteditor.isModified:=true;
  e.BlockBegin:=bb; e.BlockEnd:=be;
end;

procedure TMainFrm.ShellListView1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if key=VK_F5 then virtualExplorerTreeview1.Refresh;
end;

procedure TMainFrm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin

  if Key=VK_ESCAPE then begin
    PageControl1.ActivePageIndex:=pEdit;
  end;
  if Key=VK_F5 then begin
    if pagecontrol2.ActivePage=TabSheet10 then Button2Click(sender);
    if pagecontrol2.ActivePage=TabSheet7 then virtualExplorerTreeview1.Refresh;
  end;
end;

function TMainFrm.ChangeFTPPath():boolean;
var command,s,sftp:string;
    lauf:integer;
begin
  result:=true;
  if not idftp1.connected then idftp1.connect;
  sftp:=idftp1.RetrieveCurrentDir;
  if sftp<>'/' then sftp:=sftp+'/';
  command:=settings.FTPServerPathText;
  lauf:=4;
  s:=command;
  while lauf>1 do begin
    if s[1]='/' then dec(lauf);
    delete(s,1,1);
  end;
  command:=s;
  s:=virtualExplorerTreeview1.SelectedPath;
  delete(s,1,length(virtualExplorerTreeview1.RootFolderCustomPath));
  s:=stringreplace(s,'\','/',[rfReplaceAll]);
  if (length(s)>0) then begin
    if (s[1]='/') then delete(s,1,1);
    if (s[length(s)]<>'/') then s:=s+'/';
  end;
  currFTPPath:='/'+Command+s;
  try
    idftp1.ChangeDir(currFTPPath);
  except
    on e:EIdProtocolReplyError do begin
      if e.ReplyErrorCode=550 then begin
        delete(currFTPPath,length(currFTPPath),1);
        while currFTPPath[length(currFTPPath)]<>'/' do begin
          delete(currFTPPath,length(currFTPPath),1);
        end;
        idftp1.ChangeDir(currFTPPath);
        if (virtualExplorerTreeview1.SelectedFile<>'') then begin
          if MessageDlg(format(lang(3017),[s]),
            mtConfirmation, [mbOK,mbCancel], 0) = mrOk then begin
            idftp1.MakeDir(virtualExplorerTreeview1.SelectedFile);
            idftp1.ChangeDir(virtualExplorerTreeview1.SelectedFile);
          end else begin
            result:=false;
          end;
        end;
      end;
    end;
  end;
  sftp:=idftp1.RetrieveCurrentDir;
end;

procedure TMainFrm.PageControl1Change(Sender: TObject);
var
  s,s1,hp                       : string;
  NewTab                    :integer;
  e                               :TEditor;
  Command,so,level         :OleVariant;
  refreshBrowser                  :boolean;

  begin
  NewTab:=pagecontrol1.activePageIndex;
  editval.Free;
  editval:=nil;
  case NewTab of
  pPrintPreview: begin
        e := GetEditor();
        if not assigned(e) then exit;
        syneditprint2.TabWidth:=e.SynEdit.TabWidth;
        SynEditPrint2.Font.Name := e.SynEdit.Font.Name;
        SynEditPrint2.Font.Size := e.SynEdit.Font.Size;
        SynEditPrint2.Highlighter := e.SynEdit.Highlighter;
        SynEditPrint2.Title := 'Dev-PHP IDE - ' + e.fFileName;
        SynEditPrint2.Header.Clear;
        SynEditPrint2.Header.Add(ExtractFileName(e.fFileName), nil, taLeftJustify, 1);
        SynEditPrint2.Header.Add('$DATE$ $TIME$', nil, taRightJustify, 1);
        SynEditPrint2.Footer.Clear;
        SynEditPrint2.Footer.Add('Page $PAGENUM$ of $PAGECOUNT$', nil, taRightJustify, 1);
        SynEditPrintPreview1.SynEditPrint.Lines.Clear;
        SynEditPrintPreview1.SynEditPrint.Lines:=e.SynEdit.Lines;
        SynEditPrintPreview1.FirstPage;
        spinedit1.Value:=1;
        spinedit2.Value:=SynEditPrintPreview1.PageCount;
        synEditPrintPreview1.UpdatePreview;
  end;
  pBrowser:  begin
        if webbrowser3.LocationURL<>browserpath.Text then begin
          command:=browserpath.Text;
          webbrowser3.Navigate2(command);
        end;
      end;
  pDoc:  begin // view documentation
        if firstSearch then SearchDocumentationClick(sender);
      end;   
  pFtp:  begin
        listview.Clear;
        application.ProcessMessages;
        if not idftp1.Connected then ftpconnect();
        if idftp1.Connected then begin
          changeFTPPath();
          showFTP;
        end;
        MainFrm.StatusBar1.SetFocus;
        panel4.caption:='0';
      end;
  pEPreview:  begin
        e:=getEditor();
        if not assigned(e) then exit;
        s:=getEditor.fFileName;
        command:=virtualExplorerTreeview1.RootFolderCustomPath;
        delete(s,1,length(command));
        if s[1]='\' then delete(s,1,1);
        InternalPreview := TRUE;
        if settings.ExternPath='' then begin
          hp:='http://www.';
          InputQuery('Setting external path','Please set your homepage:',hp);
          settings.ExternPath:=hp;
        end;
        Command := settings.ExternPath;
        Command:=Command+s;
        refreshBrowser:=webbrowser1.LocationURL=command;
        BrowserActiveFlag:=true;
        if refreshBrowser then begin
          statusbar1.Panels[3].Text:='retrieve: '+command;
          webbrowser1.Refresh
        end else WebBrowser1.Navigate2(Command);
        StatusBar1.SetFocus;
      end;
  pIPreview:  begin
        if not FileExists(replPath(gsettings.phpExeFile)) then begin
          showmessage(lang(3003)); exit;
        end;
        e:=getEditor();
        if not assigned(e) then exit;
        getEditor.SaveFile(false);
        ValueListEditor1.Visible := true;
        s:=getEditor.fFileName;
        delete(s,1,length(settings.localpathText));
        s:=stringreplace(s,'\','/',[rfReplaceAll]);
        InternalPreview := TRUE;
        acActivateExecute(self);
        valuelisteditor1.strings.Clear;
        synMemo1.Text:='';
        if s[1]='/' then
          s1:='http://localhost:'+settings.localPortText+s
        else
          s1:='http://localhost:'+settings.localPortText+'/'+s;
        so:=s1;
        if not assigned(e) then showmessage('Editor not assigned');
        mozillabrowser.free;
        mozillabrowser:=nil;
        webbrowser.Free;
        webbrowser:=nil;
        if settings.InternBrowser='InternetExplorer' then begin
          webbrowser:=TWebbrowser.Create(panel8);
          webbrowser.ParentWindow:=panel8.Handle;
          webbrowser.Align:=alClient;
          webbrowser.Width:=panel8.Width;
          webbrowser.Height:=panel8.Height;
          webbrowser.OnBeforeNavigate2:=WebBrowserBeforeNavigate2;
          webbrowser.OnDocumentComplete:=WebbrowserDocumentComplete;
          webbrowser.OnStatusTextChange:=WebbrowserStatusTextChange;
          level:=3;
          so2:=webbrowser.LocationURL;
          if so2<>so then webbrowser.Navigate2(so)
          else webbrowser.Refresh2(level);
        end else begin
          //mozillabrowser1.Width:=pagecontrol1.Width div 2;
          try
            mozillabrowser:=TMozillaBrowser.Create(panel8);
            mozillabrowser.ParentWindow:=panel8.Handle;
            mozillabrowser.Align:=alClient;
            mozillabrowser.Width:=panel8.Width;
            mozillabrowser.Height:=panel8.Height;
            mozillabrowser.Navigate2(so);
            mozillabrowser.OnBeforeNavigate2:=WebBrowserBeforeNavigate2;
            mozillabrowser.OnDocumentComplete:=WebbrowserDocumentComplete;
            mozillabrowser.OnStatusTextChange:=WebbrowserStatusTextChange;
          except
            showmessage('Mozilla Browser not found');
          end;
        end;
      end;
  pEdit:  begin
        e:=getEditor();
        if not assigned(e) then exit;
        InternalPreview := FALSE;
        if PageControl.PageCount > 0 then begin
          GetEditor.SynEdit.SetFocus;
        end;
      end;
  else
  end;
end;

//const cfname=55;

function CustomSortProc(Item1, Item2: TListItem; ParamSort: integer): integer; stdcall;
var r:integer;
begin
  r:=0;
//  showmessage(Item1.SubItems.Text);
  if (item1.ImageIndex=mainfrm.FolderIcon) and not(item2.ImageIndex=mainfrm.FolderIcon)then r:=-1;
  if (item2.ImageIndex=mainfrm.FolderIcon) and not(item1.ImageIndex=mainfrm.FolderIcon)then r:=1;
  if (item1.ImageIndex=mainfrm.FolderIcon) and (item2.ImageIndex=mainfrm.FolderIcon) then begin
    r := CompareText(Item1.Caption,Item2.Caption);
  end;
  if not(item1.ImageIndex=mainfrm.FolderIcon) and not(item2.ImageIndex=mainfrm.FolderIcon) then begin
    r := CompareText(Item1.Caption,Item2.Caption);
  end;
//  showmessage(inttostr(item1.imageindex)+' '+item1.Caption+'  '+inttostr(r)+'  '+item2.Caption+' '+inttostr(item2.imageindex));
  result:=r;
end;

procedure TMainFrm.showFTP;
var s,sftp:string;
    i:integer;
    ListItem: TListItem;
    info:TShFileInfo;
    t:TFtpInfo;
begin
  listview.Clear;
  try
    idftp1.List(ftplist);
  except
  end;
  for i:=0 to ftplist.Count-1 do begin
    splitFTPMessage(ftplist[i],t);
    if (t.name[1]='.') then begin
    end else begin
      ListItem := ListView.Items.Add;
      listItem.Data:=pchar(ftplist[i]);
      listItem.SubItems.Add(t.permission);
      listItem.SubItems.Add(t.owner);
      listItem.SubItems.Add(t.group);
      listItem.SubItems.Add(inttostr(t.size));
      listItem.SubItems.Add(t.month);
      listItem.SubItems.Add(t.day);
      listItem.SubItems.Add(t.timeoryear);
      listItem.Caption:=t.name;

      if ftplist[i][1]='d' then begin
        ShGetFileInfo(PAnsiChar(listitem.caption),FILE_ATTRIBUTE_DIRECTORY,
          info,SizeOf(info),
          SHGFI_SYSICONINDEX +
          SHGFI_USEFILEATTRIBUTES +
          SHGFI_ATTRIBUTES +
          0
          );
          FolderIcon:=info.iicon;
      end else begin
        ShGetFileInfo(PAnsiChar(listitem.caption),FILE_ATTRIBUTE_NORMAL,
          info,SizeOf(info),
          SHGFI_SYSICONINDEX +
          SHGFI_USEFILEATTRIBUTES +
          SHGFI_EXETYPE +
          SHGFI_ATTRIBUTES +
          SHGFI_TYPENAME +
//          SHGFI_ICON +
          0
          );
      end;
      listitem.imageIndex:=info.iIcon;
    end;
  end;
  Listview.CustomSort(@CustomSortProc,0);
  Listview.ViewStyle:=vsIcon;
  listview.ViewStyle:=vsList;
  listview.Invalidate;
  listview.Update;
  s:=settings.FTPServerPathText;
  sftp:=idftp1.RetrieveCurrentDir;
  delete(s,length(s),1);
  label1.Caption:='ftp://'+settings.FTPHostText+sftp;
  panel4.Color:=clgreen;
end;

procedure TMainFrm.splitFTPMessage(st:string;var t:TFTPInfo);
var s:TStringList;
    i:integer;
begin
  s:=TStringList.Create;
  s.Delimiter:=' ';
  s.DelimitedText:=st;
  if st='' then raise EStringInvalid.create('String fault');
  t.isdir:=st[1]='d';
  t.name:=s[8];
  if s.Count>9 then
    for i:=9 to s.Count-1 do
      t.name:=t.name+' '+s[i];
  t.month:=s[5];
  t.day:=s[6];
  t.timeoryear:=s[7];
  t.owner:=s[2];
  t.group:=s[3];
  t.size:=strtoint(s[4]);
  t.permission:=s[0];
//  t.name:=trim(copy(st,strtoint(settings.ftpcfname)+1,length(st)-strtoint(settings.ftpcfname)+1));
  s.Free;
end;

procedure TMainFrm.walkTree(OnWalk:TWalkProc;
    OnDirChange:TWalkFolderProc;OnDirUp:TWalkFolderProc);
var i:integer;
    tp:TFTPInfo;
    ls:TStringList;
begin
  ls:=TstringList.Create;
  idftp1.List(ls);
  ls.Sort;
  for i:=ls.Count-1 downto 0 do begin
    splitFTPMessage(ls[i],tp);
    if tp.isdir then begin
      if tp.name[1]<>'.' then begin
        idftp1.ChangeDir(tp.name);
        if assigned(OnDirChange) then OnDirChange(tp.name);
        walktree(OnWalk,OnDirChange,OnDirUp);
        idftp1.ChangeDir('..');
        if assigned(OnDirUp) then OndirUp(tp.name);
      end;
    end else begin
      if assigned(OnWalk) then OnWalk(tp);
    end;
  end;
  ls.Free;
end;

procedure TMainFrm.delDir(folder:string);
begin
end;

procedure TMainFrm.delWalk(tp:tftpinfo);
begin
  memo1.Lines.Add(lang(2005)+tp.name);
  try
    idftp1.delete(tp.name);
  except
  end;
end;

procedure TMainFrm.delDirUp(folder:string);
begin
    memo1.Lines.Add(lang(2016)+folder );
    try
      idftp1.RemoveDir(folder);
    except
    end;
end;

procedure TMainFrm.MenuItem2Click(Sender: TObject);
var t:TListItem;
    ti:TFtpInfo;
    oldname,ftppath:string;
    sp:Pchar;
begin
  panel4.Color:=clred;
  memo1.Clear;
  if not idftp1.Connected then exit;
  if MessageDlg(lang(2009), mtConfirmation, [mbOK,mbCancel], 0) = mrCancel then exit;
  if listview.SelCount>0 then
  begin
    oldname:=virtualExplorerTreeview1.SelectedPath;
    ftppath:=idftp1.RetrieveCurrentDir;
    t:=listview.Selected;
    while t<>nil do begin
      sp:=t.data;
      splitFTPMessage(sp,ti);
      t:=listview.GetNextItem(t,sdAll, [isSelected]);
      if ti.isdir then begin
        try
          memo1.Lines.Add(lang(2015)+ftppath);
          idftp1.ChangeDir(ti.name);
          try
            walktree(delWalk,delDir,delDirUp);
          except
          end;
          idftp1.ChangeDir('..');
          memo1.Lines.Add(lang(2014)+' '+ti.name);
          try
            idftp1.RemoveDir(ti.name);
          except
          end;
          memo1.Lines.Add(lang(2006));
        except
          memo1.Lines.Add(lang(2007));
        end;
      end else begin
        memo1.Lines.Add(lang(2013)+ti.name);
        try
          idftp1.Delete(ti.name);
        except
          memo1.Lines.Add(lang(2008));
        end;
      end;
    end;
    idftp1.ChangeDir(ftppath);
    showftp;
  end;
  panel4.Color:=clgreen;
end;

procedure TMainFrm.FileLook(Filespec:string);
//filespec must contain the full path ie. c:\folder\*.* or c:\folder\this.txt
var validres:integer;
    res:boolean;
    SearchRec : TSearchRec;
    DirPath, FullName, Flname : string;
begin
  DirPath:=ExtractFilePath(FileSpec);
  res:= DirectoryExists(DirPath);
  If not res then exit;
  Flname:=ExtractFileName(FileSpec);
  validres := FindFirst(FileSpec, faAnyFile, SearchRec);
  while validres=0 do begin
    If (SearchRec.Name[1] <> '.') then begin
      FullName:=DirPath + LowerCase(SearchRec.Name);
      If (SearchRec.Attr and faDirectory > 0) then begin
        memo1.Lines.Add(lang(2019)+FullName);
        idftp1.MakeDir(SearchRec.Name);
        idftp1.ChangeDir(searchRec.Name);
        FileLook(FullName+'\'+ Flname);
        idftp1.ChangeDir('..');
        memo1.Lines.Add(lang(2018));
      end else begin
        memo1.Lines.Add(lang(2020)+fullname);
//        showmessage(Fullname+' '+searchRec.Name);
        idftp1.Put(Fullname,searchRec.Name);
      end;
    end;
    validres:=FindNext(SearchRec);
  end;
end;

procedure TMainFrm.Send1Click(Sender: TObject);
var i:integer;
begin
  panel4.Color:=clred;
  pagecontrol1.ActivePageIndex:=pftp;
  if not idftp1.Connected then idftp1.Connect;
  changeFTPPath();
  memo1.Clear;
  for I :=0 to virtualExplorerListview1.SelectedPaths.Count -1 do begin
    memo1.Lines.Add(lang(2017)+virtualExplorerListview1.SelectedPaths[i]);
    panel4.caption:='0';
    idftp1.Put(virtualExplorerListview1.SelectedPaths[i],
      virtualExplorerListview1.selectedFiles[i]);
  end;
  showftp;
  panel4.Color:=clgreen;
  panel4.caption:='0';
end;


procedure TMainFrm.Send2Click(Sender: TObject);
var i:integer;
begin
  FtpConnect();
  changeFTPPath();
  memo1.Clear;
  for I :=0 to VirtualExplorerTreeView1.SelectedPaths.Count -1 do begin
    memo1.Lines.Add(lang(2019)+VirtualExplorerTreeView1.SelectedPaths[i]);
    idftp1.MakeDir(VirtualExplorerTreeView1.SelectedFiles[i]);
    idftp1.ChangeDir(VirtualExplorerTreeView1.SelectedFiles[i]);
    FileLook(VirtualExplorerTreeView1.SelectedPaths[i]+'\*.*');
    idftp1.ChangeDir('..');
    memo1.Lines.Add(lang(2018));
  end;
  showftp;
  panel4.caption:='0';
end;

procedure TMainFrm.getDir(folder:string);
begin
  if folder[1]='/' then delete(folder,1,1);
  currPath:=currPath+'\'+folder;
  ForceDirectories(currPath);
  memo1.Lines.Add(lang(2019)+idftp1.RetrieveCurrentDir+lang(2023)+currPath);
end;

procedure TMainFrm.getWalk(tp:tftpinfo);
begin
  memo1.Lines.Add(lang(2024)+tp.name);
  try
    panel4.Caption:='0';
    idftp1.Get(tp.name,currPath+'\'+tp.name,true);
  except
  end;
end;

procedure TMainFrm.getDirUp(folder:string);
begin
  while currPath[length(currPath)]<>'\' do delete(currPath,length(currPath),1);
  if length(currPath)>3 then delete(currPath,length(currPath),1);
  memo1.Lines.Add(lang(2019)+idftp1.RetrieveCurrentDir+lang(2023)+currPath);
end;


procedure TMainFrm.MenuItem1Click(Sender: TObject);
var t:TListItem;
    ti:TFtpInfo;
    oldname,ftppath,s:string;
    sp:Pchar;
begin
  panel4.Color:=clred;
  if not idftp1.Connected then exit;
  memo1.Clear;
  if listview.SelCount>0 then
  begin
    currpath:=virtualExplorerTreeview1.SelectedPath;
    oldname:=virtualExplorerTreeview1.SelectedPath;
    ftppath:=idftp1.RetrieveCurrentDir;
    t:=listview.Selected;
    while t<>nil do begin
      sp:=t.data;
      splitFTPMessage(sp,ti);
      if ti.isdir then begin
        try
          memo1.Lines.Add(lang(2015)+ftppath);
          memo1.Lines.Add(lang(2022)+ti.name);
          try
            idftp1.ChangeDir(ftppath+'/'+ti.name);
          except
          end;
          getDir(ti.name);
          walktree(getWalk,getDir,getDirUp);
          idftp1.ChangeDir(ftppath);
          getDirUp(ti.name);
          memo1.Lines.Add(lang(2021));
        except
          memo1.Lines.Add(lang(2008));
        end;
        virtualExplorerTreeview1.Refresh();
      end else begin
        memo1.Lines.Add(lang(2024)+ti.name);
        try
          panel4.caption:='0';
          s:=virtualExplorerTreeview1.SelectedPath+'\'+ti.name;
          idftp1.Get(ti.name,s,true);
        except
          memo1.Lines.Add(lang(2008));
        end;
        memo1.Lines.Add(Format(lang(2105),[ti.name]));
      end;
      // next item
      t:=listview.GetNextItem(t,sdAll, [isSelected]);
    end;
    VirtualExplorerTreeview1.ReinitNode(VirtualExplorerTreeview1.FocusedNode,false);
    VirtualExplorerTreeview1.RefreshNode(VirtualExplorerTreeview1.FocusedNode);
    VirtualExplorerListview1.RebuildTree;
  end;
  panel4.Color:=clgreen;
end;

procedure TMainFrm.MenuItem3Click(Sender: TObject);
var val:string;
begin
  if not idftp1.Connected then exit;
  val:=lang(2012);
  if InputQuery(lang(2010),lang(2011),val)then begin
    idftp1.MakeDir(val);
    showftp;
  end;
end;

procedure TMainFrm.ListViewDblClick(Sender: TObject);
var s:Pchar;
begin
  if listview.SelCount=0 then exit;
  s:=listview.Selected.Data;
  if s[0]='d' then begin
    VirtualExplorerTreeView1.BrowseTo(VirtualExplorerTreeView1.SelectedPath
      +'\'+listview.Selected.Caption,true,true,false,false);
  end;
end;

function delFile(const filename:string;searchstr:string):Boolean;
begin
  result:=SysUtils.DeleteFile(filename);
end;

procedure TMainFrm.Explorer1Click(Sender: TObject);
var s:string;
begin
  s:=virtualExplorerTreeview1.selectedFile;
  shellexecute(0,PChar('open'),Pchar(s),Pchar(''),pchar(s),SW_SHOW);
end;

procedure TMainFrm.Refresch1Click(Sender: TObject);
begin
  virtualExplorerTreeview1.refresh();
end;

procedure TMainFrm.Timer1Timer(Sender: TObject);
var i:integer;
begin
  if panel4.Caption='120' then begin
    panel4.Caption:='0';
    if idftp1.connected then showftp;
  end else begin
    i:=strtoint(panel4.caption);
    panel4.caption:=inttostr(i+1);
  end;
end;

procedure TMainFrm.WebBrowser1NavigateComplete2(Sender: TObject;
  const pDisp: IDispatch; var URL: OleVariant);
begin
  BrowserActiveFlag:=false;
end;

procedure TMainFrm.ToolButton50Click(Sender: TObject);
begin
  SaveDialog.FileName := 'project.prd';
  if SaveDialog.Execute then begin
    uinifile.SaveIniFile(SaveDialog.FileName);
    gsettings.LastProject:=SaveDialog.FileName;
  end;
end;

procedure TMainFrm.LoadProject(filename:String);
var list:TStringList;
    i:integer;
    TempIndex:integer;
begin
  Translate;
  Application.ProcessMessages;
  if not FileExists(Filename) then exit;
  if pagecontrol.PageCount>0 then closeall;
  gsettings.LastProject:=Filename;
  uIniFile.IniFileName:=FileName;
  uIniFile.LoadIniFile;
  if settings.SaveSessionChecked then begin
    List := TStringList.Create;
    List.Text:=settings.session.Text;
    for i := 0 to List.Count-1 do begin
      OpenFile(self,List[i]);
    end;
    List.Free;
    TempIndex := settings.SessionActive;
    if (TempIndex <= PageControl.PageCount) and (TempIndex > -1) then begin
      PageControl.ActivePageIndex := TempIndex;
    end else PageControl.ActivePageIndex:=0;
  end else begin
    PageControl.ActivePageIndex:=0;
  end;
  OpenHistory();
  ActivateButtons(TRUE);
  CreateHighlighters(SynPHPSyn,SynCSSSyn1,SynJScriptSyn1,SynSQLSyn1,SynMultiSyn1,SynHtmlSyn1,SynXMLSyn1);
  settreepath(settings.localpathText);
  VirtualExplorerTreeview1.BrowseTo(settings.localpathText,true,true,false,false);
  StatusBarVisible.Checked := gsettings.StatusBar1visible;
  StatusBar1.Visible:=gsettings.StatusBar1visible;
  FileToolbarVisible.Checked := gsettings.toolbar1visible;
  visibleBar('ToolBar',gsettings.toolbar1visible);
  HtmlToolbarVisible.Checked := gsettings.htmlbar1visible;
  visibleBar('HTMLBar',gsettings.toolbar1visible);
  SyncEditorWithPath;
  AddProjHistory(Filename);
  if gsettings.ProjHistory.IndexOf(Filename)=-1 then gsettings.ProjHistory.Add(Filename);
end;

procedure TMainFrm.ToolButton51Click(Sender: TObject);
begin
  if OpenDialog.Execute then begin
      uinifile.SaveIniFile(uinifile.IniFileName);
    LoadProject(opendialog.FileName);
  end;
end;

procedure TMainFrm.Close1Click(Sender: TObject);
begin
  CloseExecute(Sender);
end;

procedure TMainFrm.BrowserPathKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if key=VK_RETURN then begin
      webbrowser3.Navigate(browserpath.text);
  end;
end;

procedure TMainFrm.Button1Click(Sender: TObject);
begin
  panel4.Color:=clblue;
  panel4.Caption:='0';
  if button1.Caption=lang(2103) then begin
    if idftp1.Connected then begin
      FtpDisconnect;
    end;
    try
      FTPConnect();
      changeFTPPath();
      showftp;
    except
    end;
  end else begin
    try
      ftpDisconnect;
    except
    end;
  end;
end;

procedure TMainFrm.IdFTP1Connected(Sender: TObject);
begin
  panel4.Color:=clBlue;
  button1.Caption:=lang(2104);
  label1.Caption:=lang(2101);
  timer1.enabled:=true;
end;

procedure TMainFrm.IdFTP1Disconnected(Sender: TObject);
begin
  panel4.Color:=clRed;
  button1.Caption:=lang(2103);
  label1.Caption:=lang(2100);
  timer1.enabled:=false;
end;

procedure TMainFrm.WebBrowser2DocumentComplete(Sender: TObject;
  const pDisp: IDispatch; var URL: OleVariant);
begin
  doc_complete:=true;
end;

procedure TMainFrm.FormDragDrop(Sender, Source: TObject; X, Y: Integer);
begin
//  showmessage('drop');
end;

procedure TMainFrm.WMDropFiles(var Msg: TMessage);
var
  i, iNumberDropped: integer;
  szPathName: array[0..260] of char;
  Point: TPoint;
  FilesList: TStringList;
  x:integer;
  exists:boolean;
  e:TEditor;
begin
  try
//    if Assigned(fOnDropFiles) then begin
      FilesList := TStringList.Create;
      try
        iNumberDropped := DragQueryFile(THandle(Msg.wParam), Cardinal(-1),
          nil, 0);
        DragQueryPoint(THandle(Msg.wParam), Point);

        for i := 0 to iNumberDropped - 1 do begin
          DragQueryFile(THandle(Msg.wParam), i, szPathName,
            SizeOf(szPathName));
          FilesList.Add(szPathName);
          Exists:=FALSE;
          for x := 0 to PageControl.PageCount - 1 do begin
            if szPathName = GetEditor(x).fFileName then begin
              Exists := TRUE;
              Break;
            end;
          end;
          if Exists = False then begin
            e := TEditor.Create;
            e.Init(szPathName, TRUE);
            AgregarHistorial(szPathName);
            GuardarHistorial(szPathName);
          end else begin
            MessageDlg(format(lang(3005),[szPathName]) , mtError, [mbOk], 0);
          end;

        end;
//        fOnDropFiles(Self, Point.X, Point.Y, FilesList);
      finally
        FilesList.Free;
      end;
 //   end;
  finally
    Msg.Result := 0;
    DragFinish(THandle(Msg.wParam));
  end;
end;

procedure TMainFrm.S1Click(Sender: TObject);
var e:TEditor;
begin
  if PageControl.Pagecount>0 then begin
    e:=getEditor(pagecontrol.ActivePageIndex);
    with e.SynEdit do begin
      if S1.checked then
        Options:=Options + [eoShowSpecialChars] else Options:=Options - [eoShowSpecialChars]
    end;
  end;
end;

procedure TMainFrm.OnToken(t:TToken);
begin
  if ((TClass in t.state)     and (TFunction in t.state)) or
     ((TInterface in t.state) and (TFunction in t.state)) or
     ((TClass in t.state)     and (TVariable in t.state)) or
     ((TInterface in t.state) and (TVariable in t.state)) or
     ((TClass in t.state)     and (TConst in t.state))    or
     ((TInterface in t.state) and (TConst in t.state))    then begin
    treeview11.Items.AddChildObject(currclass,t.str,t);
  end else begin
    if (TClass in t.State) or (TInterface in t.state) then
      currclass:=treeview11.Items.AddChildObject(classes,t.str,t);
    if (t.state=[TFunction]) then
      treeview11.Items.AddChildObject(functions,t.str,t);
    if (TInclude in t.state) then
      treeview11.Items.AddChildObject(includes,t.str,t);
    if (TVariable in t.state) then
      treeview11.Items.AddChildObject(vars,t.str,t);
  end;
end;

procedure TMainFrm.Button2Click(Sender: TObject);
begin
  if getEditor=nil then begin
    treeview11.Items.Clear;    exit;
  end;
  getEditor.SynEdit.SearchEngine:=SynEditSearch1;
  treeview11.items.clear;
  if assigned(pars) then pars.Free;
  pars:=TParse.create;
  pars.parsedStr:=GetEditor.Synedit.lines;
  pars.Filename:=GetEditor.fFileName;
  treeview11.filename:=GetEditor.fFileName;
  classes:=treeview11.Items.AddNode(nil,nil,'classes',nil,naadd);
  functions:=treeview11.Items.AddNode(nil,nil,'functions',nil,naadd);
  includes:=treeview11.Items.AddNode(nil,nil,'includes',nil,naadd);
  vars:=treeview11.Items.AddNode(nil,nil,'vars',nil,naadd);
  pars.OnToken:=OnToken;
  pars.Parse();
  treeview11.AlphaSort(true);
end;

procedure TMainFrm.UpperCase1Click(Sender: TObject);
begin
  if PageControl.PageCount > 0 then begin
    with GetEditor do begin
      SynEdit.SelText := UpperCase(SynEdit.SelText);
      //StringReplace(SynEdit.SelText, '\', '/', [rfReplaceAll]);
    end;
  end;
end;

procedure TMainFrm.LowerCase1Click(Sender: TObject);
begin
  if PageControl.PageCount > 0 then begin
    with GetEditor do begin
      SynEdit.SelText := LowerCase(SynEdit.SelText);
      //StringReplace(SynEdit.SelText, '\', '/', [rfReplaceAll]);
    end;
  end;
end;

procedure TMainFrm.C3Click(Sender: TObject);
var e:TEditor;
begin
  e:=getEditor();
  if not assigned(e) then exit;
  if e.synedit.selText='' then exit;
  e.synedit.selText:=pars.Capitalize(e.synedit.selText);
end;

procedure TMainFrm.InsertDocPath1Click(Sender: TObject);
begin
  Insertar(ExtractFilePath(getEditor.fFilename));
end;

procedure TMainFrm.InsertDocFilename1Click(Sender: TObject);
begin
  Insertar(ExtractFileName(getEditor.fFilename));
end;

procedure TMainFrm.Insert1Click(Sender: TObject);
begin
  Insertar(getEditor.fFilename);
end;

procedure TMainFrm.InsertDate1Click(Sender: TObject);
var s:string;
begin
  DateTimeToString(s,gsettings.dateFmt,now());
  Insertar(s);
end;

procedure TMainFrm.InsertTime1Click(Sender: TObject);
var s:string;
begin
  DateTimeToString(s,gsettings.TimeFmt,now());
  Insertar(s);
end;

procedure TMainFrm.InsertDateTime1Click(Sender: TObject);
var s:string;
begin
  DateTimeToString(s,gsettings.DateTimeFmt,now());
  Insertar(s);
end;

procedure TMainFrm.InsertFilename1Click(Sender: TObject);
begin
  Insertar(virtualExplorerListview1.SelectedFile);
end;

procedure TMainFrm.DeleteLine1Click(Sender: TObject);
var e:TEditor;
    bb,be:TBufferCoord;
begin
  e:=getEditor();
  bb.char:=0;
  bb.Line:=e.synedit.CaretY;
  e.SynEdit.BlockBegin:=bb;
  if e.SynEdit.lines.Count=e.SynEdit.carety then begin
    be.Char:=high(integer);be.Line:=e.synedit.CaretY;
  end else begin
    be.Char:=0;be.Line:=e.synedit.CaretY+1;
  end;
  e.synedit.blockend:=be;
  e.synedit.selText:='';
  e.ismodified:=true;
end;

procedure TMainFrm.DeleteWord1Click(Sender: TObject);
var e:TEditor;
begin
  e:=getEditor();
  e.synedit.SetSelWord;
  e.SynEdit.SelText:='';
//  e.synedit.lines.delete(e.synedit.carety-1);
  e.ismodified:=true;
end;

procedure TMainFrm.DeletetoEndLine1Click(Sender: TObject);
var e:TEditor;
    be,bb:TBufferCoord;
begin
  e:=getEditor();
  bb.Char:=e.synedit.caretx;bb.Line:=e.synedit.carety;
  e.synedit.blockbegin:=bb;
  be.Char:=high(integer);be.Line:=e.synedit.carety;
  e.synedit.blockend:=be;
  e.synedit.selText:='';
  e.ismodified:=true;
end;

procedure TMainFrm.DeletePreviousWord1Click(Sender: TObject);
var e:TEditor;
begin
  e:=getEditor();
  e.synedit.caretxy:=e.synedit.prevWordPos;
  e.synedit.SetSelWord;
  e.SynEdit.SelText:='';
  e.ismodified:=true;
end;

procedure TMainFrm.InsertFilePath1Click(Sender: TObject);
begin
  if virtualExplorerTreeview1.SelectedCount>0 then
  Insertar(ExtractFilePath(virtualExplorerListview1.selectedPath));
end;

procedure TMainFrm.SaveUnix1Click(Sender: TObject);
var
  e : TEditor;
begin
  e := GetEditor;
  if Assigned(e) then begin
    e.LB:=#10;
  end;
  saveunix1.Checked:=true;
  gsettings.SaveType:=1;
end;

procedure TMainFrm.Savewithcrlf1Click(Sender: TObject);
begin
  savewithcrlf1.Checked:=true;
  gsettings.SaveType:=0;
end;

procedure TMainFrm.Savewithcr1Click(Sender: TObject);
begin
  savewithcr1.Checked:=true;
  gsettings.SaveType:=2;
end;

procedure TMainFrm.SideBarVisibleClick(Sender: TObject);
begin
  gsettings.HideSideBar:=SideBarVisible.Checked;
end;

procedure TMainFrm.ListViewChange(Sender: TObject; Item: TListItem;
  Change: TItemChange);
begin
  if listview.SelCount>0 then
  Listview.Hint:=listview.Selected.Caption;
end;

procedure TMainFrm.ControlBar1DockOver(Sender: TObject;
  Source: TDragDockObject; X, Y: Integer; State: TDragState;
  var Accept: Boolean);
begin
  accept:= Source.Control is TActionToolBar;
end;

procedure TMainFrm.Re1Click(Sender: TObject);
var s:string;
    i:integer;
begin
  treeview1.Items.Clear;
  if PageControl.PageCount > 0 then begin
    with GetEditor do begin
      Application.CreateForm(TSearchForm, SearchForm);
      if (SynEdit.SelText <> '') then begin
          SearchForm.SynEdit1.Lines.Text:=SynEdit.selText;
      end else begin
      end;  
      Searchform.ShowModal;
      s:='';
      for i:=0 to searchform.synedit1.lines.count-1 do begin
        if s<>'' then s:=s+#13#10;
        s:=s+searchForm.SynEdit1.Lines[i];
      end;
      if searchForm.ModalResult=mrok then begin
        panel7.Visible:=true;
        splitter3.Visible:=true;
        splitter3.Top:=panel7.Top-splitter3.Height;
        searchre(getEditor,s);
        treeview1.FullExpand;
      end;
      SearchForm.Free;
    end;
  end;
end;

procedure TMainFrm.TreeView1Deletion(Sender: TObject; Node: TTreeNode);
begin
  if assigned(node.data) then dispose(node.Data);
end;

procedure TMainFrm.TreeView1Click(Sender: TObject);
var bc:TBufferCoord;
    info:PTPosInfo;
    cr:boolean;
    s:string;
    i:integer;
    e:TEditor;
begin
  if not assigned(treeview1.selected) then exit;
  info:=PTPosInfo(treeview1.Selected.Data);
  if not assigned(info) then exit;
  if info^.isfilename then exit;
  PageControl1.ActivePageIndex:=pEdit;
  cr:=true;
  s:=info^.filename;
  if s<>GetEditor().fFileName then begin
    for i := PageControl.PageCount - 1 downto 0 do begin
      if GetEditor(i).fFileName=s then begin
        pageControl.ActivePageIndex:=i; cr:=false;
      end;
    end;
    if cr then begin
      e := TEditor.Create;
      e.Init(s, TRUE);
      AgregarHistorial(s);
      GuardarHistorial(s);
      ActivateButtons(TRUE);
    end;
    SyncEditorwithPath;
  end;
  bc.Line:= info^.line;
  bc.Char:= info^.char;
  GetEditor.SynEdit.GotoLineAndCenter(bc.line);
  GetEditor.SynEdit.SelStart:=info^.pos-1;
  getEditor.SynEdit.SelEnd:=info^.pos+info^.length-1;
end;

procedure TMainFrm.TreeView1CustomDrawItem(Sender: TCustomTreeView;
  Node: TTreeNode; State: TCustomDrawState; var DefaultDraw: Boolean);
var info:PTPosInfo;
begin
  info:=PTPosInfo(node.data);
  if assigned(info) then begin
    if info.isfilename then begin
      Treeview1.Canvas.Brush.Color:=TColor($00BBBB);;
      Treeview1.Canvas.FillRect(node.DisplayRect(false));
      Treeview1.Canvas.TextOut(node.DisplayRect(true).Left,node.displayRect(true).Top,info^.filename);
      DefaultDraw:=false;
    end;
  end;
end;

procedure TMainFrm.Button3Click(Sender: TObject);
begin
  splitter3.Visible:=false;
  panel7.Visible:=false;
end;

procedure TMainFrm.searchRe(e:TEditor;searchstr:string);
var s:string;
    i:integer;
    bc:TBufferCoord;
    info:PTPosInfo;
    ro:TTreeNode;
begin
  s:=searchstr;
  SynEditRegExSearch1.Options:=[ssoMatchCase];
  SynEditRegExSearch1.Pattern:=s;
  SynEditRegExSearch1.FindAll(e.SynEdit.Text);
  ro:=treeview1.Items.Add(nil,e.fFileName);
  if SynEditRegExSearch1.ResultCount>0 then begin
    new(info);
    info^.filename:=e.fFileName;
    info^.isfilename:=true;
    ro.Data:=TObject(info);
    For i:=0 to SynEditRegExSearch1.ResultCount-1 do begin
      new(info);
      bc:=e.SynEdit.CharIndexToRowCol(SynEditRegExSearch1.Results[i]);
      info^.line:=bc.Line;
      info^.char:=bc.Char;
      info^.pos:=SynEditRegExSearch1.Results[i];
      info^.length:=SynEditRegExSearch1.Lengths[i];
      info^.filename:=e.fFileName;
      info^.isfilename:=false;
      treeview1.Items.AddChildObject(ro,inttostr(bc.Line)
        +' : '+trim(e.SynEdit.lines[bc.line-1]),TObject(info));
    end;
  end else begin
    treeview1.Items.AddChildObject(ro,'0 occurances found',nil);
  end;
end;

procedure TMainFrm.searchReg(filename:string;searchstr:string);
var s:string;
    i:integer;
    bc:TBufferCoord;
    info:PTPosInfo;
    ro:TTreeNode;
    synedit1:TSynedit;
begin
  synedit1:=TSynedit.Create(nil);
  synedit1.Lines.LoadFromFile(filename);
  s:=searchstr;
  SynEditRegExSearch1.Options:=[ssoMatchCase];
  SynEditRegExSearch1.Pattern:=s;
  SynEditRegExSearch1.FindAll(synedit1.Text);
  if SynEditRegExSearch1.ResultCount>0 then begin
    ro:=treeview1.Items.Add(nil,FileName);
    new(info);
    info^.filename:=FileName;
    info^.isfilename:=true;
    ro.Data:=TObject(info);
    For i:=0 to SynEditRegExSearch1.ResultCount-1 do begin
      new(info);
      bc:=SynEdit1.CharIndexToRowCol(SynEditRegExSearch1.Results[i]);
      info^.line:=bc.Line;
      info^.char:=bc.Char;
      info^.pos:=SynEditRegExSearch1.Results[i];
      info^.length:=SynEditRegExSearch1.Lengths[i];
      info^.filename:=FileName;
      info^.isfilename:=false;
      treeview1.Items.AddChildObject(ro,inttostr(bc.Line)
        +' : '+trim(synedit1.lines[bc.line-1]),TObject(info));
      application.ProcessMessages;
    end;
  end;
  synedit1.lines.clear;
  synedit1.Free;
end;

function getfname(const s:string;searchstr:string):boolean;
begin
  application.ProcessMessages;
  if mainfrm.panel7.visible then mainfrm.searchReg(s,searchstr);
  result:= true;
end;

procedure TMainFrm.ASearchRegDirExecute(Sender: TObject);
var s:string;
    i:integer;
begin
  treeview1.Items.Clear;
  if PageControl.PageCount > 0 then begin
    with GetEditor do begin
      Application.CreateForm(TSearchForm, SearchForm);
      if (SynEdit.SelText <> '') then begin
          SearchForm.SynEdit1.Lines.Text:=SynEdit.selText;
      end else begin
      end;
      Searchform.ShowModal;
      s:='';
      for i:=0 to searchform.synedit1.lines.count-1 do begin
        if s<>'' then s:=s+#13#10;
        s:=s+searchForm.SynEdit1.Lines[i];
      end;
      SearchForm.Free;
      if searchForm.ModalResult=mrok then begin
        image1.Visible:=true;
        try
          panel7.Visible:=true;
          splitter3.Visible:=true;
          splitter3.Top:=panel7.Top-splitter3.Height;
          if virtualExplorerTreeview1.SelectedCount=0 then
            searchDir2(virtualExplorerTreeview1.RootFolderCustomPath,s,getfname)
          else
            searchdir2(virtualExplorerTreeview1.SelectedPath,s,getfname);
          treeview1.FullExpand;
        finally
          image1.Visible:=false;
        end;
      end;
    end;
  end;
end;

procedure TMainFrm.AutoCompleteExecute(Kind: SynCompletionType;
  Sender: TObject; var CurrentInput: String; var x, y: Integer;
  var CanExecute: Boolean);
begin
  if pagecontrol1.ActivePageIndex=pEdit then begin
    geteditor.SynEdit.SetFocus;
    CurrentInput:=geteditor.SynEdit.WordAtCursor;
    AutoComplete.TriggerChars;
  end;
end;


procedure TMainFrm.Splitter2CanResize(Sender: TObject;
  var NewSize: Integer; var Accept: Boolean);
begin
  TBToolWindow1.Width:=newsize;
end;

procedure TMainFrm.AEditEditExecute(Sender: TObject);
var
  ToolbarEditForm : TToolbarEditForm;
begin
  TB2kInitializeToolbar(TBToolbar3, EmptyStr, ExtractFilePath(Application.EXEName) + 'DEVPHP.INI', 0);
  ToolbarEditForm := TToolbarEditForm.Create(Application);
  With ToolbarEditForm Do
    begin
      ShowModal;
      Release;
    end;
end;

procedure TMainFrm.AEditInsExecute(Sender: TObject);
var
  ToolbarEditForm : TToolbarEditForm;
begin
  TB2kInitializeToolbar(TBToolbar4, EmptyStr, ExtractFilePath(Application.EXEName) + 'DEVPHP.INI', 0);
  ToolbarEditForm := TToolbarEditForm.Create(Application);
  With ToolbarEditForm Do
    begin
      ShowModal;
      Release;
    end;
end;

procedure TMainFrm.AEditToolExecute(Sender: TObject);
var
  ToolbarEditForm : TToolbarEditForm;
begin
  TB2kInitializeToolbar(TBToolbar2, EmptyStr, ExtractFilePath(Application.EXEName) + 'DEVPHP.INI', 0);
  ToolbarEditForm := TToolbarEditForm.Create(Application);
  With ToolbarEditForm Do
    begin
      ShowModal;
      Release;
    end;
end;

procedure TMainFrm.SideBarToggleItemClick(Sender: TObject);
begin
  gsettings.hidesidebar:=SideBarToggleItem.Checked;
end;

procedure TMainFrm.ASearchOFilesExecute(Sender: TObject);
var s:string;
    i:integer;
begin
  treeview1.Items.Clear;
  if PageControl.PageCount > 0 then begin
    with GetEditor do begin
      Application.CreateForm(TSearchForm, SearchForm);
      if (SynEdit.SelText <> '') then begin
          SearchForm.SynEdit1.Lines.Text:=SynEdit.selText;
      end;
      Searchform.ShowModal;
      s:='';
      for i:=0 to searchform.synedit1.lines.count-1 do begin
        if s<>'' then s:=s+#13#10;
        s:=s+searchForm.SynEdit1.Lines[i];
      end;
      SearchForm.Free;
      if searchForm.ModalResult=mrok then begin
        panel7.Visible:=true;
        splitter3.Visible:=true;
        splitter3.Top:=panel7.Top-splitter3.Height;
        for i:=0 to pagecontrol.PageCount-1 do begin
          searchre(getEditor(i),s);
        end;
        treeview1.FullExpand;
      end;
    end;
  end;
end;

procedure TMainFrm.EditToolbarVisibleClick(Sender: TObject);
begin
  gsettings.editbar1visible:=not EditToolbarVisible.Checked;
end;

procedure TMainFrm.DHTMLEdit1ShowContextMenu(Sender: TObject; xPos,
  yPos: Integer);
//var p,p2:TPoint;
begin
//  p.x:=xPOS;p.Y:=yPos;
//  p2:=dhtmledit1.ClientToScreen(p);
//  popupmenu1.Popup(p2.X,p2.Y);
end;

procedure TMainFrm.FindDialog1Show(Sender: TObject);
begin
  findactive:=true;
end;

procedure TMainFrm.FindDialog1Close(Sender: TObject);
begin
  findactive:=false;
end;

procedure TMainFrm.test2Click(Sender: TObject);
var s:TSynEditOptionsDialog;
    t:TSynEditorOptionsContainer;
    e:TEditor;
begin
  exit;
  e:=geteditor;
  t:=TSynEditorOptionsContainer.create(self);
  t.Assign(e.SynEdit);
  s:=TSynEditOptionsDialog.Create(self);
  s.Execute(t);
  s.Free;
  e.SynEdit.Assign(t);
  t.Free;
  exit;
  showmessage(getAppFolder());exit;
end;

procedure TMainFrm.SpeedButton1Click(Sender: TObject);
var s1:string;
begin
  s1:=settings.localpathText;
  if FileCtrl.SelectDirectory('Select','rfMyComputer',s1) then
  settings.localpathText:=s1;
  settreepath(s1);
end;

procedure TMainFrm.AhrefExecute(Sender: TObject);
var s:string;
begin
  s:='<a href=""></a>';
  Insertar(s);
end;

procedure TMainFrm.settreepath(path:string);
begin
  if path='' then exit;
  virtualExplorerTreeview1.RootFolderCustomPath:=path;
end;

procedure TMainFrm.BitBtn1Click(Sender: TObject);
begin
  try
    webbrowser3.GoBack;
  except
  end;
end;

procedure TMainFrm.BitBtn2Click(Sender: TObject);
begin
  try
    webbrowser3.GoForward;
  except
  end;
end;

procedure TMainFrm.BitBtn3Click(Sender: TObject);
begin
  webbrowser3.Stop;
end;

procedure TMainFrm.BitBtn4Click(Sender: TObject);
begin
  try
    webbrowser3.Refresh2;
  except
  end;
end;

procedure TMainFrm.PageControl2Change(Sender: TObject);
begin
  editval.Free;
  editval:=nil;
  if (PageControl2.activePage=TabSheet10) and (pagecontrol1.Activepageindex=pEdit) then begin
    button2Click(sender);
  end;
  if (pageControl2.ActivePage=TabSheet7) then syncEditorwithPath();
end;

procedure ExecNewProcess(ProgramName : String; Wait: Boolean);
var
  StartInfo : TStartupInfo;
  ProcInfo : TProcessInformation;
  CreateOK : Boolean;
begin
  FillChar(StartInfo,SizeOf(TStartupInfo),#0);
  FillChar(ProcInfo,SizeOf(TProcessInformation),#0);
  StartInfo.cb := SizeOf(TStartupInfo);
  CreateOK := CreateProcess(nil, PChar(ProgramName), nil, nil,False,
              CREATE_NEW_PROCESS_GROUP+NORMAL_PRIORITY_CLASS,
              nil, nil, StartInfo, ProcInfo);
  if CreateOK then
    begin
        //may or may not be needed. Usually wait for child processes
      if Wait then
        WaitForSingleObject(ProcInfo.hProcess, INFINITE);
    end
  else
    begin
      ShowMessage('Unable to run '+ProgramName);
     end;
  CloseHandle(ProcInfo.hProcess);
  CloseHandle(ProcInfo.hThread);
end;

procedure TMainFrm.executeExternal(s:string);
begin
  ExecNewProcess(s,true);
end;

procedure TMainFrm.ANextSearchExecute(Sender: TObject);
var searchstr:string;
begin
  if PageControl.PageCount > 0 then begin
    with GetEditor do begin
      searchstr:= settings.FindDialog1FindText;
      if GetEditor.SynEdit.SearchReplace(searchstr, '', GetFindOptions(FindDialog1)) = 0 then begin
        MessageBeep($7000);
//        MessageDlg(Lang(956) + ' "' + searchstr + '" ' + Lang(957), MtInformation, [mbOK],0);
        statusbar1.Panels[3].Text:=Lang(956) + ' "' + searchstr + '" ' + Lang(957);
      end;
    end;
  end;
end;

procedure TMainFrm.TBXItem46Click(Sender: TObject);
var e:TEditor;
    searchstr:string;
begin
  //
  e:=getEditor;
  if assigned(e) then begin
    searchstr:=e.SynEdit.SelText;
    if searchstr<>'' then begin
      e.SynEdit.BlockBegin:=BufferCoord(0,0);
      e.SynEdit.BlockEnd:=BufferCoord(0,0);
      e.SynEdit.SearchReplace(searchstr, '',[ssoEntireScope]);
      settings.FindDialog1FindText:=searchstr;
    end;
  end;
end;

procedure TMainFrm.clearprojhistClick(Sender: TObject);
var i:integer;
begin
  gsettings.clearProjHistory;
  gsettings.writeProjHistory;
  i := reopenproject.Count-1;
  if reopenproject.Count <> 2 then
    repeat
       reopenproject.Remove(reopenproject.Items[i]);
       dec(i);
    until reopenproject.Count = 2;
end;

procedure TMainFrm.TBItem48Click(Sender: TObject);
begin
  treeview11.FullExpand;
end;

procedure TMainFrm.TBItem49Click(Sender: TObject);
begin
  treeview11.FullCollapse;
end;

procedure TMainFrm.TreeView11Click(Sender: TObject);
var e:TEditor;
    i:integer;
    s:string;
    cr:boolean;
    t:TToken;
begin
  e:=GetEditor();
  if e=nil then exit;
  if not assigned(treeview11.selected) then exit;
  t:=treeview11.selected.data;
  if not assigned(t) then exit;
  e.SynEdit.SelStart:=t.pos;
  e.SynEdit.SelEnd:=t.last;
  e.SynEdit.TopLine:=e.SynEdit.BlockBegin.Line;
  if ((pos('include',treeview11.selected.text)=1) or (pos('require',treeview11.selected.text)=1)) then begin
    s:=treeview11.selected.text;
    delete(s,1,pos(' ',s));
    s:=extractFilePath(e.fFileName)+s;
    s:=stringreplace(s,'/','\',[rfReplaceAll]);
    cr:=true;
    for i := PageControl.PageCount - 1 downto 0 do begin
      if GetEditor(i).fFileName=s then begin
        pageControl.ActivePageIndex:=i; cr:=false;
      end;
    end;
    if cr then begin
      if fileExists(s) then begin
        OpenFile(sender,s);
      end;
    end;
    button2click(sender);
  end;
end;

procedure TMainFrm.TabsToSpacesClick(Sender: TObject);
var e:TSynEdit;
    linestart,lineend,lauf,i2,i:integer;
    s,s1:string;
    bb,be:TBufferCoord;
begin
  e:=getEditor.SynEdit;
  if e.SelText='' then exit;
  bb:=e.BlockBegin; be:=e.BlockEnd;
  linestart:=e.BlockBegin.Line-1;
  if e.BlockEnd.Char=1 then i:=2 else i:=1;
  lineend:=e.BlockEnd.line-i;
  if lineend<linestart then lineend:=linestart;
  s1:=''; for i2:=1 to e.TabWidth do s1:=s1+' ';
  for lauf:=linestart to lineend do begin
    s:=e.Lines[lauf];
    s:=stringreplace(s,#9,s1,[rfReplaceAll]);
    e.Lines[Lauf]:=s;
  end;
  e.BlockBegin:=bb; e.BlockEnd:=be;
  getEditor.isModified:=true;
end;

procedure TMainFrm.SpacesToTabsClick(Sender: TObject);
var e:TSynEdit;
    linestart,lineend,lauf,i2,i:integer;
    s,s1:string;
    bb,be:TBufferCoord;
begin
  e:=getEditor.SynEdit;
  if e.SelText='' then exit;
  bb:=e.BlockBegin; be:=e.BlockEnd;
  linestart:=e.BlockBegin.Line-1;
  if e.BlockEnd.Char=1 then i:=2 else i:=1;
  lineend:=e.BlockEnd.line-i;
  if lineend<linestart then lineend:=linestart;
  s1:=''; for i2:=1 to e.TabWidth do s1:=s1+' ';
  for lauf:=linestart to lineend do begin
    s:=e.Lines[lauf];
    s:=stringreplace(s,s1,#9,[rfReplaceAll]);
    e.Lines[Lauf]:=s;
  end;
  e.BlockBegin:=bb; e.BlockEnd:=be;
  geteditor.isModified:=true;
end;

procedure TMainFrm.PopupMenu5Popup(Sender: TObject);
var i:integer;
begin
  i:=pagecontrol.IndexOfTabAt(mouse.CursorPos.X-pagecontrol.ClientOrigin.X,
        mouse.CursorPos.Y-pagecontrol.ClientOrigin.y);
  if i>=0 then pagecontrol.ActivePageIndex:=i;
end;

procedure TMainFrm.ValueListEditor1DblClick(Sender: TObject);
var line,i:integer;
    m,filename:string;
    cr:boolean;
begin
  try
    if Valuelisteditor1.Keys[valuelisteditor1.Selection.Top]='' then exit;
    line:=strtointdef(Valuelisteditor1.Keys[valuelisteditor1.Selection.Top],-1);
    if line=-1 then exit;
    m:=Valuelisteditor1.Values[Valuelisteditor1.Keys[valuelisteditor1.Selection.Top]];
    filename:=copy(m,pos('in ',m)+3,pos(' on line',m)-pos('in ',m)-3);
    pagecontrol1.ActivePageIndex:=pEdit;
    cr:=true;
    for i := PageControl.PageCount - 1 downto 0 do begin
      if GetEditor(i).fFileName=filename then begin
        pageControl.ActivePageIndex:=i; cr:=false;
      end;
    end;
    if cr then begin
      OpenFile(sender,filename);
    end;
    geteditor.SynEdit.SetFocus;
    geteditor.SynEdit.CaretY := Line;
    geteditor.SynEdit.TopLine := Line;
    geteditor.SynEdit.EnsureCursorPosVisible;
  except
  end;
end;

procedure TMainFrm.SpeedButton2Click(Sender: TObject);
begin
  SynEditPrintPreview1.Print;
end;

procedure TMainFrm.SpeedButton3Click(Sender: TObject);
begin
  SynEditPrintPreview1.FirstPage;
end;

procedure TMainFrm.SpeedButton4Click(Sender: TObject);
begin
  SynEditPrintPreview1.PreviousPage;
end;

procedure TMainFrm.SpeedButton5Click(Sender: TObject);
begin
  SynEditPrintPreview1.NextPage;
end;

procedure TMainFrm.SpeedButton6Click(Sender: TObject);
begin
  SynEditPrintPreview1.LastPage;
end;

procedure TMainFrm.CheckBox1Click(Sender: TObject);
begin
    SynEditPrintPreview1.SynEditPrint.LineNumbers:=checkbox1.Checked;
    SynEditPrintPreview1.UpdatePreview;
end;

procedure TMainFrm.SpinEdit1Change(Sender: TObject);
begin
    if spinedit1.Value<1 then spinedit1.Value:=1;
    if spinedit1.Value>SynEditPrintPreview1.SynEditPrint.PageCount then
        spinedit1.Value:=SynEditPrintPreview1.SynEditPrint.PageCount;
end;

procedure TMainFrm.SpinEdit2Change(Sender: TObject);
begin
    if spinedit2.Value<1 then spinedit2.Value:=1;
    if spinedit2.Value>SynEditPrintPreview1.SynEditPrint.PageCount then
        spinedit2.Value:=SynEditPrintPreview1.SynEditPrint.PageCount;
end;

procedure TMainFrm.SpeedButton7Click(Sender: TObject);
begin
  SynEditPrintPreview1.SynEditPrint.PrintRange(spinedit1.Value,spinedit2.Value);
end;

procedure TMainFrm.SpeedButton8Click(Sender: TObject);
begin
  SynEditPrintPreview1.SynEditPrint.Highlight:=
        not SynEditPrintPreview1.SynEditPrint.Highlight;
  SynEditPrintPreview1.UpdatePreview;
end;

procedure TMainFrm.SynEditPrintPreview1PreviewPage(Sender: TObject;
  PageNumber: Integer);
begin
  Label4.Caption:='Page '+inttostr(PageNumber);
end;

procedure TMainFrm.TabSheet11Resize(Sender: TObject);
begin
  if assigned(editval) then begin
    editval.ColWidths[0]:=(TabSheet11.Width div 2)-3;
    editval.ColWidths[1]:=(TabSheet11.Width div 2)-3;
  end;
end;

function TMainFrm.ReplaceTag(new:string;sStart,sEnd:integer):string;
begin
  insertar(new);
  getEditor.SynEdit.SelStart:=sStart;
  getEditor.SynEdit.SelEnd:=sEnd;
  result:=getEditor.SynEdit.SelText;
end;

procedure TMainFrm.loadAutoText();
var
  Doc: TdomDocument;
  str:TStringlist;
  s:string;
begin
  if not fileExists(getAppFolder() +'\devphp\'+autofilename) then begin
    str:=TStringList.Create;
    str.Text:=
      '<?xml version="1.0" standalone="yes"?><DATAPACKET Version="2.0"><METADATA>'+
      '<FIELDS>'+
      '<FIELD attrname="Name" fieldtype="string" WIDTH="20"/>'+
      '<FIELD attrname="Text" fieldtype="bin.hex" SUBTYPE="Text"/>'+
      '<FIELD attrname="CursorPos" fieldtype="i4"/>'+
      '</FIELDS>'+
      '<PARAMS CHANGE_LOG="1 0 4 2 0 4 3 0 4 4 0 4 5 0 4 6 0 4 7 0 4 8 0 4 9 0 4"/>'+
      '</METADATA>'+
      '<ROWDATA>'+
      '<ROW RowState="4" Name="function" Text="function &lt;&lt;|&gt;&gt;&#013;&#010;{&#013;&#010;}"/>'+
      '</ROWDATA></DATAPACKET>';
    str.SaveToFile(getAppFolder() +'\devphp\'+autofilename);
    str.Free;
  end;
  with XmlToDomParser1 do begin
    s:=getAppFolder() +'\devphp\'+autofilename;
    FileToDom(s);
    Doc := (XmlToDomParser1.DOMImpl.Documents.Item(0) as TdomDocument);
    updateSnippetsList(doc);
  end;
end;

procedure TMainFrm.saveAutoText();
var
  doc: TdomDocument;
  s:string;
  lines:TStringList;
begin
  lines:=TStringList.Create;
  doc := (XmlToDomParser1.DOMImpl.documents.Item(0) as TdomDocument);
  if DomToXmlParser1.writeToString(doc,'windows-1252',s) then begin
    Lines.Text:=s;
    //showmessage(s);
    lines.SaveToFile(getAppFolder() +'\devphp\'+autofilename);
  end;
  lines.free;
end;

procedure TMainFrm.UpdateSnippetsList(const doc: TdomDocument);

  procedure HandleNodeList(DomNodeList: TDomNodeList);
  var
    I: integer;
    DomNode: TDomNode;
    nod:TDomNode;
    a:TDomNode;
    Astr: string;
  begin
    for I := 0 to Pred(DomNodeList.Length) do
    begin
      DomNode := DomNodeList.Item(I);
      Astr := DomNode.NodeName;
      if DomNode.NodeValue <> '' then Astr := Astr + ' [' + DomNode.NodeValue + ']';
      Astr := Astr + ' (' + GetEnumName(TypeInfo(TdomNodeType), Integer(DomNode.NodeType)) + ') ';
      if DomNode.NodeType = ntText_Node then
        if TdomText(DomNode).isWhitespaceInElementContent then
          Astr := Astr + '-- Whitespace in element content';
      //Tn := Parent.Owner.AddChildObject(Parent, Astr, DomNode);
      if DomNode.nodeName='ROWDATA' then listbox1.Tag:=integer(DomNode);
      if DomNode.nodeName='ROW' then begin
        nod:=DomNode;
        if assigned(nod.attributes) then begin
          a:=nod.attributes.item(0);
          listbox1.Items.AddObject(resolveInternalRefs(ResolveCharRefs(a.nodeValue)),DomNode);
        end;
      end;
      if assigned(DomNode.ChildNodes) then HandleNodeList(DomNode.ChildNodes);
    end;
  end;

begin
  // Quick and dirty: always build the tree completely.
  // Delphi 5 seems to have problems with this approach,
  // but I could not figure out why.
  listbox1.Items.BeginUpdate;
  try
    listbox1.Items.Clear;
    HandleNodeList(Doc.ChildNodes);
  finally
    listbox1.Items.EndUpdate;
  end;
end;


procedure TMainFrm.ListBox1DblClick(Sender: TObject);
var
  DomNode,a: TDomNode;
  p:integer;
  s:string;
  e:Teditor;
begin
  DomNode:=TDomNode(listbox1.Items.Objects[listbox1.ItemIndex]);
  if assigned(DomNode.attributes) then begin
    a:=DomNode.attributes.item(2);
    s:=(resolveInternalRefs(ResolveCharRefs(a.nodeValue)));
  end;
  e:=getEditor();
  if not assigned(e) then exit;
  p:=e.SynEdit.SelStart;
  inc(p,pos(cursorstr,s));
  s:=stringreplace(s,cursorstr,'',[rfReplaceAll]);
  insertar(s);
  e.SynEdit.SelStart:=p;
end;

procedure TMainFrm.sneditClick(Sender: TObject);
var
  DomNode,a,a2: TDomNode;
  s,s2:string;
begin
  if listbox1.ItemIndex=-1 then exit;
  DomNode:=TDomNode(listbox1.Items.Objects[listbox1.ItemIndex]);
  if assigned(DomNode.attributes) then begin
    a:=DomNode.attributes.item(0);
    s:=(resolveInternalRefs(ResolveCharRefs(a.nodeValue)));
    a2:=DomNode.attributes.item(2);
    s2:=(resolveInternalRefs(ResolveCharRefs(a2.nodeValue)));
    AutoTextFrm := TAutoTextFrm.Create(Self);
    with AutoTextFrm do
    try
       setTitleAndMemo(s,s2);
       ShowModal;
       if ModalResult=mrOK then begin
         a.nodeValue:=escapeString(AutoTextFrm.edit1.Text);
         a2.nodeValue:=escapeString(AutoTextFrm.Memo1.Text);
         saveAutoText;
       end;
    finally
      Free;
    end;
  end;
end;

procedure TMainFrm.snnewClick(Sender: TObject);
var
  doc:TDomDocument;
  DomNode,dn,a,a1,a2: TDomNode;
begin
  doc := (XmlToDomParser1.DOMImpl.documents.Item(0) as TdomDocument);
  DomNode:=TDomNode(listbox1.tag);
  dn:=doc.createElement('ROW');
  a:=doc.createAttribute('RowState');
  a.nodeValue:='4';
  a1:=doc.createAttribute('Name');
  a.nodeValue:='new Item';
  a2:=doc.createAttribute('Text');
  a.nodeValue:='';
  dn.attributes.setNamedItem(a1);
  dn.attributes.setNamedItem(a);
  dn.attributes.setNamedItem(a2);
  DomNode.appendChild(dn);
  AutoTextFrm := TAutoTextFrm.Create(Self);
  with AutoTextFrm do
  try
     setTitleAndMemo('newItem','');
     ShowModal;
     if ModalResult=mrOK then begin
       a1.nodeValue:=escapeString(AutoTextFrm.edit1.Text);
       a.nodeValue:='4';
       a2.nodeValue:=escapeString(AutoTextFrm.Memo1.Text);
       saveAutoText;
     end;
  finally
    Free;
  end;
  loadAutoText;
end;

procedure TMainFrm.sndeleteClick(Sender: TObject);
var
  DomNode: TDomNode;
begin
  if listbox1.ItemIndex=-1 then exit;
  DomNode:=TDomNode(listbox1.Items.Objects[listbox1.ItemIndex]);
  domNode.parentNode.removeChild(DomNode);
  saveAutoText;
  listbox1.Items.Delete(listbox1.ItemIndex);
end;

procedure TMainFrm.ListBox1ContextPopup(Sender: TObject; MousePos: TPoint;
  var Handled: Boolean);
var i:integer;
  exists:boolean;
begin
  exists:=false;
  i:=listbox1.ItemAtPos(MousePos,exists);
  if (i>=0) and (i<listbox1.Count) then
    listbox1.ItemIndex:=i;
//  showmessage(inttostr(i));
end;

procedure TMainFrm.AZoomInExecute(Sender: TObject);
 //        -----------------------
 	var
 		e: TEditor;
 	begin
 		e := GetEditor;
 		if Assigned(e) then
 		begin
 			e.SynEdit.Font.Size := e.SynEdit.Font.Size + 1;
 			e.SynEdit.Gutter.Font.Size :=e.SynEdit.Gutter.Font.Size + 1;
 		end;
 	end;

procedure TMainFrm.AZoomOutExecute(Sender: TObject);
 //        ------------------------
 	var
 		e: TEditor;
 	begin
 		e := GetEditor;
 		if Assigned(e) then
 			if e.SynEdit.Font.Size > 1 then
 			begin
 				e.SynEdit.Font.Size := e.SynEdit.Font.Size - 1;
 				e.SynEdit.Gutter.Font.Size :=e.SynEdit.Gutter.Font.Size - 1;
 			end;
 	end;

procedure TMainFrm.TestScriptClick(Sender: TObject);
var x:integer;
begin
  try
    FPrg.Free;
  finally
    FPrg := nil;
  end;
  editorsynedit:=getEditor().SynEdit;
  FPrg:=script1.Compile(memo2.Text);
  for x := 0 to FPrg.Msgs.Count - 1 do
    showmessage(FPrg.Msgs[x].AsString);
  FPrg.Execute;
  for x := 0 to FPrg.Msgs.Count - 1 do
    showmessage(FPrg.Msgs[x].AsString);
end;

procedure TMainFrm.dws2Unit1FunctionsShowmessageEval(Info: TProgramInfo);
begin
  showmessage(info.Vars['text'].Value);
end;

procedure TMainFrm.dws2Unit1Classes0ConstructorsCreateAssignExternalObject(
  Info: TProgramInfo; var ExtObject: TObject);
begin
  ExtObject:=TEditor.create();
end;

procedure TMainFrm.dws2Unit1ClassesEditorMethodsgetSelectionEval(
  Info: TProgramInfo; ExtObject: TObject);
begin
  info.Result:= getEditor().SynEdit.SelText;
end;

procedure TMainFrm.TBToolWindow1DockChanged(Sender: TObject);
begin
  splitter2.Left:=TBToolWindow1.Left+10;
end;

procedure TMainFrm.dws2Unit1VariablesTextReadVar(var Value: Variant);
begin
  value:=geteditor.SynEdit.Text;
end;

procedure TMainFrm.dws2Unit1VariablesTextWriteVar(Value: Variant);
begin
  geteditor.SynEdit.Text:=value;
end;

function TMainFrm.WebServ1ServEnd(debugStr: String): String;
var i:integer;
    line,m:string;
    s:TStringList;
begin
  s:=TSTringList.Create;
  s.Text:=debugstr;
//  valueListEditor1.InsertRow('test','test',true);
  s.Text:=Stringreplace(s.text,'<b>','',[rfReplaceAll]);
  s.Text:=Stringreplace(s.text,'</b>','',[rfReplaceAll]);
  s.Text:=Stringreplace(s.text,'<br />','',[rfReplaceAll]);
  if (pos('PHP Parse error',s.Text)>0) or
     (pos('PHP Fatal error',s.Text)>0) or
     (pos('PHP Notice',s.Text)>0) or
     (pos('PHP Warning',s.Text)>0) then begin
    for i:=0 to s.Count-1 do begin
      if (pos('PHP Parse error',s.Strings[i])>0) or
         (pos('PHP Fatal error',s.Strings[i])>0) or
         (pos('PHP Notice',s.Strings[i])>0) or
         (pos('PHP Warning',s.Strings[i])>0) then begin
        m:=s.Strings[i];
        if m<>'' then begin
          while m[1]<>':' do delete(m,1,1);
          delete(m,1,1);
          while m[1]=' ' do delete(m,1,1);
          line:=copy(m,pos('line',m),length(m)-pos('line',m)+1);
          delete(line,1,5);
          if pos('~',m)>0 then delete(m,pos('~',m),1);
          valuelistEditor1.InsertRow(line,m,true);
        end;
      end;
    end;
  end;
  s.Free;
end;

procedure TMainFrm.dws2Unit1FunctionstestEval(Info: TProgramInfo);
begin
  showmessage('test');
end;

procedure TMainFrm.dws2Unit1ClassesApplicationMethodsAddMenuEval(
  Info: TProgramInfo; ExtObject: TObject);
var     item:TTBCustomItem;
begin
  item:=TTBCustomItem.Create(nil);
  item.Caption:=info.Value['ItemName'];
  item.OnClick:=ScriptClick;
  //item.ShortCut:=ShortCut(Word(inttostr(i+1)[1]),[ssAlt,ssShift]);
  ScriptMenu.Add(item);
end;

procedure TMainFrm.ScriptClick(Sender: TObject);
var s:string;
//    info:TProgramInfo;
begin
  s:=((sender as TTBCustomItem).Caption);
  showmessage(s);
end;

procedure TMainFrm.SpeedButton9Click(Sender: TObject);
begin
  case listview.ViewStyle of
  vsReport: listview.ViewStyle:=vsList;
  vsList:listview.ViewStyle:=vsReport;
  end;
end;


procedure TMainFrm.AZoomresetExecute(Sender: TObject);
var e: TEditor;
begin
  e := GetEditor;
  if Assigned(e) then
  begin
    e.SynEdit.Font.Size := gsettings.UpDown2Position;
    e.SynEdit.Gutter.Font.Size :=gsettings.UpDown2Position;
  end;
end;

procedure TMainFrm.WebServ1GetVariable(modus, name, value: String);
begin
  valuelistEditor1.InsertRow(modus,name+'='+value,valuelisteditor1.RowCount>0)
end;

procedure TMainFrm.WebBrowserBeforeNavigate2(Sender: TObject;
  const pDisp: IDispatch; var URL, Flags, TargetFrameName, PostData,
  Headers: OleVariant; var Cancel: WordBool);
begin
  valuelisteditor1.strings.Clear;
  synMemo1.Text:='';
end;

procedure TMainFrm.WebBrowserNavigateComplete2(Sender: TObject;
  const pDisp: IDispatch; var URL: OleVariant);
begin
//  synmemo1.Text:=webserv1.OutPutText.Text;
//  synMemo1.TopLine:=0;
  if valuelisteditor1.Strings.Count>0 then begin
    valuelisteditor1.Visible:=true;
  end else begin
    valuelisteditor1.Visible:=false;
  end;
end;

procedure TMainFrm.TBXItem2Click(Sender: TObject);
begin
  if Opendialog.Execute then
//    showmessage(NpsvPHP1.Execute(Opendialog.filename));
end;

function TMainFrm.WebServ1File(debugStr: String): String;
begin
  synmemo1.Text:=result;
  synMemo1.TopLine:=0;
end;

procedure TMainFrm.psvPHP1ScriptError(Sender: TObject; AText: String;
  AType: TPHPErrorType; AFileName: String; ALineNo: Integer);
begin
  showmessage(AText);
end;

procedure TMainFrm.DisplayMessage(const Msg: WideString);
begin
  UILock.Acquire;
  try
    synmemo1.Lines.Text:=synMemo1.Lines.Text+msg;
  finally
  UILock.Release;
  end;
end;

procedure TMainFrm.AddInfo(const Action,Msg: String);
begin
  UILock.Acquire;
  try
    ValueListEditor1.InsertRow(Action,Msg,true);
  finally
  UILock.Release;
  end;
end;

procedure TMainFrm.ServeVirtualFolder(AThread: TIdPeerThread;
  RequestInfo: TIdHTTPRequestInfo; ResponseInfo: TIdHTTPResponseInfo);
begin
  ResponseInfo.ContentType := 'text/HTML';
  ResponseInfo.ContentText := '<html><head><title>Virtual folder</title></head><body>';

  if AnsiSameText(RequestInfo.Params.Values['action'], 'close') then
  begin
  // Closing user session
  RequestInfo.Session.Free;
  ResponseInfo.ContentText :=  ResponseInfo.ContentText + '<h1>Session cleared</h1><p><a href="/sessions">Back</a></p>';
  end
  else
  begin
  if assigned(RequestInfo.Session) then
  begin
  if Length(RequestInfo.Params.Values['ParamName'])>0 then
  begin
  // Add a new parameter to the session
  ResponseInfo.Session.Content.Values[RequestInfo.Params.Values['ParamName']] := RequestInfo.Params.Values['Param'];
  end;
  ResponseInfo.ContentText := ResponseInfo.ContentText + '<h1>Session informations</h1>';
  RequestInfo.Session.Lock;
  try
  ResponseInfo.ContentText := ResponseInfo.ContentText + '<table border=1>';
  ResponseInfo.ContentText := ResponseInfo.ContentText + '<tr><td>SessionID</td><td>' + RequestInfo.Session.SessionID + '</td></tr>';
  ResponseInfo.ContentText := ResponseInfo.ContentText + '<tr><td>Number of page requested during this session</td><td>'+RequestInfo.Session.Content.Values['NumViews']+'</td></tr>';
  ResponseInfo.ContentText := ResponseInfo.ContentText + '<tr><td>Session data (raw)</td><td><pre>' + RequestInfo.Session.Content.Text + '</pre></td></tr>';
  ResponseInfo.ContentText := ResponseInfo.ContentText + '</table>';
  ResponseInfo.ContentText := ResponseInfo.ContentText + '<h1>Tools:</h1>';
  ResponseInfo.ContentText := ResponseInfo.ContentText + '<h2>Add new parameter</h2>';
  ResponseInfo.ContentText := ResponseInfo.ContentText + '<form method="POST">';
  ResponseInfo.ContentText := ResponseInfo.ContentText + '<p>Name: <input type="text" Name="ParamName"></p>';
  ResponseInfo.ContentText := ResponseInfo.ContentText + '<p>value: <input type="text" Name="Param"></p>';
  ResponseInfo.ContentText := ResponseInfo.ContentText + '<p><input type="Submit"><input type="reset"></p>';
  ResponseInfo.ContentText := ResponseInfo.ContentText + '</form>';
  ResponseInfo.ContentText := ResponseInfo.ContentText + '<h2>Other:</h2>';
  ResponseInfo.ContentText := ResponseInfo.ContentText + '<p><a href="' + RequestInfo.Document + '?action=close">Close current session</a></p>';
  finally
  RequestInfo.Session.Unlock;
  end;
  end
  else
  begin
  ResponseInfo.ContentText := ResponseInfo.ContentText + '<p color=#FF000>No session</p>';
  end;
  end;
  ResponseInfo.ContentText := ResponseInfo.ContentText + '</body></html>';
end;

procedure TMainFrm.IdHTTPServer1CommandGet(AThread: TIdPeerThread;
  ARequestInfo: TIdHTTPRequestInfo; AResponseInfo: TIdHTTPResponseInfo);

  procedure AuthFailed;
  begin
  AResponseInfo.ContentText := '<html><head><title>Error</title></head><body><h1>Authentication failed</h1>'#13 +
  'Check the demo source code to discover the password:<br><ul><li>Search for <b>AuthUsername</b> in <b>Main.pas</b>!</ul></body></html>';
  AResponseInfo.AuthRealm := sauthenticationrealm;
  end;

  procedure AccessDenied;
  begin
  AResponseInfo.ContentText := '<html><head><title>Error</title></head><body><h1>Access denied</h1>'#13 +
  'You do not have sufficient priviligies to access this document.</body></html>';
  AResponseInfo.ResponseNo := 403;
  end;

var
  LocalDoc,res: string;
//  ByteSent: Cardinal;
  i:integer;
  ResultFile: TFileStream;
begin
  // Log the request
//  DisplayMessage(Format( 'Command %s %s received from %s:%d',
//    [ARequestInfo.Command, ARequestInfo.Document, AThread.Connection.Socket.Binding.PeerIP,AThread.Connection.Socket.Binding.PeerPort]));
{  if cbAuthentication.Checked and
  ((ARequestInfo.AuthUsername <> 'Indy') or (ARequestInfo.AuthPassword <> 'rocks')) then
  begin
    AuthFailed;
    exit;
  end;    }

  LocalDoc := '';
  if Pos('.php',LowerCase(ARequestInfo.Document)) <> 0 then begin
    LocalDoc := Parser;
  end;

{  if Pos('.exe',LowerCase(ARequestInfo.Document)) <> 0 then
    LocalDoc := ExpandFilename(settings.localpathText + ARequestInfo.Document);     }

  if LocalDoc <> '' then
  begin
    if FileExists(LocalDoc) then
     begin
       for i:=0 to ARequestInfo.Params.Count-1 do
         AddInfo(ARequestInfo.Command,ARequestInfo.Params.Strings[i]);
      if gsettings.PHPIniFile<>'' then begin
        CGIRunner.PHPIniPath:= gsettings.PHPIniFile;
      end;
       CGIRunner.Execute(LocalDoc,AThread,ARequestInfo,AResponseInfo,settings.localpathText);
     end
      else
        begin
          AResponseInfo.ContentText := '<H1><center>php-cgi.exe not found</center></H1>';
          AResponseInfo.ResponseNo := 404; // Not found
        end;
  end else begin
    if (Pos('/session', LowerCase(ARequestInfo.Document)) = 1) then begin
      ServeVirtualFolder(AThread, ARequestInfo, AResponseInfo);
    end else begin
      // Interprete the command to it's final path (avoid sending files in parent folders)
      LocalDoc := ExpandFilename(settings.localpathText + ARequestInfo.Document);

      // Default document (index.html) for folder
      if not FileExists(LocalDoc) and DirectoryExists(LocalDoc)
         and FileExists(ExpandFileName(LocalDoc + '/index.html')) then begin
        LocalDoc := ExpandFileName(LocalDoc + '/index.html');
      end;
      if FileExists(LocalDoc) then begin
        if AnsiSameText(Copy(LocalDoc, 1, Length(settings.localpathText)),
          settings.localpathText) then begin
          if AnsiSameText(ARequestInfo.Command, 'HEAD') then
          begin
          // HEAD request, don't send the document but still send back it's size
          ResultFile := TFileStream.create(LocalDoc, fmOpenRead  or fmShareDenyWrite);
            try
              AResponseInfo.ResponseNo := 200;
              AResponseInfo.ContentType := GetMIMEType(LocalDoc);
              AResponseInfo.ContentLength := ResultFile.Size;
            finally
              ResultFile.Free; // We must free this file since it won't be done by the web server component
            end;
          end else begin
            //ByteSent :=
              IdHTTPServer1.ServeFile(AThread, AResponseInfo, LocalDoc);
//            DisplayMessage(Format('Serving file %s (%d bytes / %d bytes sent) to %s:%d',
//            [LocalDoc, ByteSent, FileSizeByName(LocalDoc),
//            AThread.Connection.Socket.Binding.PeerIP,
//            AThread.Connection.Socket.Binding.PeerPort]));
          end;
        end else AccessDenied;
      end else begin
       AResponseInfo.ResponseNo := 404; // Not found
       AResponseInfo.ContentText := '<html><head><title>Error</title></head><body><h1>' + AResponseInfo.ResponseText + '</h1></body></html>';
      end;
    end;
  end;
  res:=AResponseInfo.ContentText;
  DisplayMessage(res);
end;

function TMainFrm.GetMIMEType(sFile: TFileName): String;
begin
  result := MIMEMap.GetFileMIMEType(sFile);
end;

procedure TMainFrm.acActivateExecute(Sender: TObject);
begin

  if not IdHTTPServer1.Active then begin
    IdHTTPServer1.Bindings.Clear;
    IdHTTPServer1.DefaultPort := StrToIntDef(settings.localPortText, 8080);
    IdHTTPServer1.Bindings.Add;
    try
      IdHTTPServer1.Active := true;
      DisplayMessage(format('Listening for HTTP connections on %s:%d.',
        [IdHTTPServer1.Bindings[0].IP, IdHTTPServer1.Bindings[0].Port]));
    except
      on e: exception do
        begin
        DisplayMessage(format('Exception %s in Activate. Error is:"%s".',
          [e.ClassName, e.Message]));
        end;
    end;
  end;
  if not DirectoryExists(settings.localpathText) then begin
    DisplayMessage(Format('Web root folder (%s) not found.',[settings.localpathText]));
  end;
end;

procedure TMainFrm.EditPHPIni1Click(Sender: TObject);
begin
  PageControl1.ActivePageIndex:=pEdit;
  OpenFile(Sender,extractFilepath(gsettings.phpexeFile)+'php.ini');
end;

procedure TMainFrm.webbrowserStatusTextChange(Sender: TObject;
  const Text: WideString);
begin
  statusbar1.Panels[3].Text:=Text;
end;

procedure TMainFrm.WebBrowser1StatusTextChange(Sender: TObject;
  const Text: WideString);
begin
  statusbar1.Panels[3].Text:=Text;
end;

procedure TMainFrm.VirtualExplorerListview1ShellExecute(
  Sender: TCustomVirtualExplorerTree; Namespace: TNamespace;
  var WorkingDir, CmdLineArgument: WideString; var Allow: Boolean);
var s:string;
    cr:boolean;
    i:integer;
begin
  if (lowercase(ExtractFileExt(sender.SelectedFile))='.jpg')
    or (lowercase(ExtractFileExt(sender.SelectedFile))='.png')
    or (lowercase(ExtractFileExt(sender.SelectedFile))='.gif')
    then begin
      allow:=true;
      exit;
  end;
  if sender.SelectedFile<>'' then begin
    s:=sender.SelectedPath;
    if pagecontrol1.ActivePageIndex=pHtmlEdit then begin
      //form1.loadfile(s);
    end else begin
      PageControl1.ActivePageIndex:=pEdit;
      cr:=true;
      for i := PageControl.PageCount - 1 downto 0 do begin
        if GetEditor(i).fFileName=s then begin
          pageControl.ActivePageIndex:=i; cr:=false;
        end;
      end;
      if cr then begin
        OpenFile(sender,s);
      end;
    end;
  end;
  Allow:=false;
end;

procedure TMainFrm.VirtualExplorerTreeview1Change(Sender: TBaseVirtualTree;
  Node: PVirtualNode);
var val:string;
begin
  if not assigned(Node) then exit;
  if not(vsSelected IN Node.States) then exit;
  if (pagecontrol1.ActivePageIndex=3) and (assigned(settings)) then begin
    if pagecontrol1.ActivePage<>TabSheet4 then exit;
    if idftp1.Connected then begin
      if not changeFTPPath()then begin
        if InputQuery(lang(2010),lang(2011),val)then begin
          idftp1.MakeDir(val);
          showftp;
        end;
      end else showftp;
    end;
  end;
end;

procedure TMainFrm.TreeView11Deletion(Sender: TObject; Node: TTreeNode);
var t:TToken;
begin
  if assigned(node.data) then begin
    t:=node.data;
    t.free;
  end;
end;

procedure TMainFrm.TreeView11Changing(Sender: TObject; Node: TTreeNode;
  var AllowChange: Boolean);
//var t:TToken;
begin
  if assigned(Node.data) then begin
//    t:=node.data;
  end;
  AllowChange:=true;
end;

procedure TMainFrm.webbrowserDocumentComplete(Sender: TObject;
  const pDisp: IDispatch; var URL: OleVariant);
begin
  WebServ1ServEnd(synmemo1.Text);
end;

procedure TMainFrm.Panel8Resize(Sender: TObject);
begin
  if assigned(mozillabrowser) then begin
    mozillabrowser.Height:=panel8.Height;
    mozillabrowser.Width:=panel8.Width;
  end;
  if assigned(webbrowser) then begin
    webbrowser.Height:=panel8.Height;
    webbrowser.Width:=panel8.Width;
  end;
end;

procedure TMainFrm.sbm1Click(Sender: TObject);
var e:TEditor;

  function isBookmarked(n:integer):boolean;
  var i:integer;
  begin
    result:=false;
    for i:=0 to e.SynEdit.Marks.Count-1 do begin
      if e.SynEdit.Marks[i].BookmarkNumber=n then result:=true;
    end;
  end;

  procedure clearBookmark(n:integer);
  var i:integer;
  begin
    for i:=0 to e.SynEdit.Marks.Count-1 do begin
      if e.SynEdit.Marks[i].BookmarkNumber=n then
        e.SynEdit.Marks.Delete(i);
    end;
  end;

begin
  e:=getEditor();
  if not assigned(e) then exit;
  if isBookmarked((sender as TTBXItem).tag) then
    clearBookmark((sender as TTBXItem).tag)
  else
    e.SynEdit.SetBookMark((sender as TTBXItem).tag,e.SynEdit.CaretX,e.SynEdit.CaretY);
end;

procedure TMainFrm.jbm1Click(Sender: TObject);
var e:TEditor;
begin
  e:=GetEditor();
  if not assigned(e) then exit;
  e.SynEdit.GotoBookMark((sender as TTBXItem).Tag);
end;

end.
