{*******************************************************************************
  MSHTMLDemo
  Demo application showing how to use MSHTML editing mode from Delphi.
  Copyright (c) 2001 by Peter Pohmann, dataWeb GmbH, Aicha, Germany
  This file may be distributed and used freely as long as this copyright header
  is not modified or removed. The author is not liable in any way for any harm
  using this file could do.
  E-mail: pohmann@dataweb.de
  Web: http://www.dataweb.de
  More information on MSHTML editing mode:
    http://www.dataweb.de/articles/mshtmlediting.html
*******************************************************************************}
unit frmhtmledit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdActns, ActnList, ActnMenus, ToolWin, ActnMan, ActnCtrls,
  ExtCtrls, OleCtrls, SHDocVw, ActiveX, MSHTML_TLB, StdCtrls, ImgList,
  ComCtrls;

type
  TMSHTMLEvent = procedure(Sender: TObject; Event: IHTMLEventObj) of object;

  TMSHTMLEventConnector = class(TInterfacedObject, IDispatch)
  private
    FOnEvent: TMSHTMLEvent;
  private
    // *** Construction and Destruction ***
    constructor Create(Handler: TMSHTMLEvent);
    // *** Implementation of IDispatch interface ***
    function GetTypeInfoCount(out Count: Integer): HResult; stdcall;
    function GetTypeInfo(Index, LocaleID: Integer; out TypeInfo): HResult; stdcall;
    function GetIDsOfNames(const IID: TGUID; Names: Pointer;
      NameCount, LocaleID: Integer; DispIDs: Pointer): HResult; stdcall;
    function Invoke(DispID: Integer; const IID: TGUID; LocaleID: Integer;
      Flags: Word; var Params; VarResult, ExcepInfo, ArgErr: Pointer): HResult; stdcall;
  public
    property OnEvent: TMSHTMLEvent read FOnEvent write FOnEvent;
  end;


  TForm1 = class(TForm, IHTMLEditDesigner)
    WebBrowser1: TWebBrowser;
    ActionManager1: TActionManager;
    ControlBar1: TControlBar;
    ActionMainMenuBar2: TActionMainMenuBar;
    FileOpen: TFileOpen;
    FileSaveAs: TFileSaveAs;
    FileExit1: TFileExit;
    InsertImageAction: TAction;
    InsertHyperlinkAction: TAction;
    FormatBoldAction: TAction;
    FormatItalicAction: TAction;
    FormatUnderlineAction: TAction;
    Panel1: TPanel;
    TextSizeCombo: TComboBox;
    TextFontCombo: TComboBox;
    TextColorCombo: TColorBox;
    Panel2: TPanel;
    BlockFormatCombo: TComboBox;
    JustifyCombo: TComboBox;
    EditCut2: TEditCut;
    EditCopy2: TEditCopy;
    EditPaste2: TEditPaste;
    EditSelectAll2: TEditSelectAll;
    EditUndo2: TEditUndo;
    EditDelete2: TEditDelete;
    EditDocument: TAction;
    StatusBar1: TStatusBar;
    FileNew: TAction;
    Memo1: TMemo;
    procedure FileOpenAccept(Sender: TObject);
    procedure InsertImageActionExecute(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormatBoldActionExecute(Sender: TObject);
    procedure FormatBoldActionUpdate(Sender: TObject);
    procedure InsertHyperlinkActionExecute(Sender: TObject);
    procedure InsertHyperlinkActionUpdate(Sender: TObject);
    procedure TextSizeComboChange(Sender: TObject);
    procedure FormatItalicActionExecute(Sender: TObject);
    procedure FormatUnderlineActionExecute(Sender: TObject);
    procedure TextFontComboChange(Sender: TObject);
    procedure TextColorComboChange(Sender: TObject);
    procedure BlockFormatComboChange(Sender: TObject);
    procedure JustifyComboChange(Sender: TObject);
    procedure FileSaveAsAccept(Sender: TObject);
    procedure EditDocumentExecute(Sender: TObject);
    procedure FileNewExecute(Sender: TObject);
    procedure WebBrowser1NavigateComplete2(Sender: TObject;
      const pDisp: IDispatch; var URL: OleVariant);

  private
    FDblClickConnector: TMSHTMLEventConnector;
    FClickConnector: TMSHTMLEventConnector;
    FMouseOverConnector: TMSHTMLEventConnector;
    function GetHTMLDocument2Ifc: IHTMLDocument2;

    // *** Scripting events ***
    procedure WebEditorDblClk(Sender: TObject; EventObjIfc: IHTMLEventObj);
    procedure WebEditorClick(Sender: TObject; EventObjIfc: IHTMLEventObj);
    procedure WebMouseOver(Sender: TObject; EventObjIfc: IHTMLEventObj);
    // *** Implementation of IHTMLHost
    function SnapRect(const pIElement: IHTMLElement; var prcNew: tagRECT; eHandle: _ELEMENT_CORNER): HResult; stdcall;

    // *** Implementation of IHTMLEditDesigner ***
    function PreHandleEvent(inEvtDispId: Integer; const pIEventObj: IHTMLEventObj): HResult; stdcall;
    function PostHandleEvent(inEvtDispId: Integer; const pIEventObj: IHTMLEventObj): HResult; stdcall;
    function TranslateAccelerator(inEvtDispId: Integer; const pIEventObj: IHTMLEventObj): HResult; stdcall;
    function PostEditorEventNotify(inEvtDispId: Integer; const pIEventObj: IHTMLEventObj): HResult; stdcall;

  protected
    property HTMLDocument2Ifc: IHTMLDocument2 read GetHTMLDocument2Ifc;
    procedure AfterLoad;
    procedure BeforeLoad;

  public
    { Public declarations }
    filename:string;
    procedure loadFile(s: WideString);
    procedure InsertRadioActionExecute(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation

uses ComObj, frmDocProp, frmTable;

{$R *.dfm}

const
  // Service ID (GUID) for the HTML Edit Services
  SID_SHTMLEditServices: TGUID = (D1: $3050f7f9; D2: $98b5; D3: $11cf; D4: ($bb, $82, $00, $AA, $00, $bd, $ce, $0b));

function RGBToBGR(RGB: TColor): Integer;
begin
  Result := (RGB and $000000ff) shl 16 + (RGB and $0000ff00) + (RGB and $00ff0000) shr 16;
end;


function ColorStr(RGB: TColor): string;
begin
  Result := '#' + IntToHex(RGBToBGR(RGB), 6);
end;

procedure TForm1.loadFile(s:WideString);
begin
//  webbrowser1.Navigate('http://localhost:8080/'+extractFilename(s));
  (HTMLDocument2Ifc as IPersistFile).Load(PWideChar(s), 0);
end;

procedure TForm1.FileOpenAccept(Sender: TObject);
var
  FileName: WideString;
begin
  FileName := FileOpen.Dialog.FileName;
  loadfile(Filename);
end;


function TForm1.GetHTMLDocument2Ifc: IHTMLDocument2;
begin
  Result := WebBrowser1.Document as IHTMLDocument2;
end;


procedure TForm1.InsertImageActionExecute(Sender: TObject);
begin
  HTMLDocument2Ifc.execCommand('InsertImage', True, 0);
end;

procedure TForm1.InsertRadioActionExecute(Sender: TObject);
begin
  HTMLDocument2Ifc.execCommand('InsertInputRadio', True, 0);
end;


procedure TForm1.FormCreate(Sender: TObject);
begin
  FDblClickConnector := TMSHTMLEventConnector.Create(WebEditorDblClk);
  FClickConnector := TMSHTMLEventConnector.Create(WebEditorClick);
  FMouseOverConnector:=TMSHTMLEventConnector.Create(WebMouseOver);
  WebBrowser1.Navigate('about:blank');
  AfterLoad;
end;


procedure TForm1.FormatBoldActionExecute(Sender: TObject);
begin
  HTMLDocument2Ifc.execCommand('Bold', False, 0);
end;


procedure TForm1.FormatBoldActionUpdate(Sender: TObject);
begin
  FormatBoldAction.Checked := HTMLDocument2Ifc.queryCommandValue('Bold');
end;


procedure TForm1.InsertHyperlinkActionExecute(Sender: TObject);
begin
  HTMLDocument2Ifc.execCommand('CreateLink', True, 0);
end;


procedure TForm1.InsertHyperlinkActionUpdate(Sender: TObject);
begin
  InsertHyperlinkAction.Enabled := HTMLDocument2Ifc.queryCommandEnabled('CreateLink');
end;


procedure TForm1.TextSizeComboChange(Sender: TObject);
begin
  HTMLDocument2Ifc.execCommand('FontSize', False, TextSizeCombo.Items[TextSizeCombo.ItemIndex]);
end;


procedure TForm1.FormatItalicActionExecute(Sender: TObject);
begin
  HTMLDocument2Ifc.execCommand('Italic', False, 0);
end;


procedure TForm1.FormatUnderlineActionExecute(Sender: TObject);
begin
  HTMLDocument2Ifc.execCommand('Underline', False, 0);
end;


procedure TForm1.TextFontComboChange(Sender: TObject);
begin
  if TextFontCombo.ItemIndex = 0 then
    HTMLDocument2Ifc.execCommand('FontName', True, '')
  else
    HTMLDocument2Ifc.execCommand('FontName', True, TextFontCombo.Items[TextFontCombo.ItemIndex]);
end;


procedure TForm1.TextColorComboChange(Sender: TObject);
begin
  HTMLDocument2Ifc.execCommand('ForeColor', False, ColorStr(TextColorCombo.Selected));
end;


procedure TForm1.BlockFormatComboChange(Sender: TObject);
begin
  HTMLDocument2Ifc.execCommand('FormatBlock', True, BlockFormatCombo.Text);
end;


procedure TForm1.JustifyComboChange(Sender: TObject);
begin
  HTMLDocument2Ifc.execCommand('Justify' + JustifyCombo.Text, False, 0);
end;


procedure TForm1.FileSaveAsAccept(Sender: TObject);
var
  FileName: WideString;
begin
  FileName := FileSaveAs.Dialog.FileName;
  (HTMLDocument2Ifc as IPersistFile).Save(PWideChar(FileName), True);
end;


procedure TForm1.EditDocumentExecute(Sender: TObject);
begin
  if DocumentPropertiesDialog.ShowModal = mrOk then begin
    if DocumentPropertiesDialog.BgImageEdit.Text = '' then
      (HTMLDocument2Ifc.body as IHTMLBodyElement).bgColor := ColorStr(DocumentPropertiesDialog.BgColorCombo.Selected)
    else
      (HTMLDocument2Ifc.body as IHTMLBodyElement).background := DocumentPropertiesDialog.BgImageEdit.Text;
  end;
end;


{ TMSHTMLEventConnector }

constructor TMSHTMLEventConnector.Create(Handler: TMSHTMLEvent);
begin
  inherited Create;
  _AddRef;
  FOnEvent := Handler;
end;


function TMSHTMLEventConnector.GetIDsOfNames(const IID: TGUID;
  Names: Pointer; NameCount, LocaleID: Integer; DispIDs: Pointer): HResult;
begin
  Result := E_NOTIMPL;
end;


function TMSHTMLEventConnector.GetTypeInfo(Index, LocaleID: Integer;
  out TypeInfo): HResult;
begin
  Result := E_NOTIMPL;
end;


function TMSHTMLEventConnector.GetTypeInfoCount(out Count: Integer): HResult;
begin
  Result := E_NOTIMPL;
end;


function TMSHTMLEventConnector.Invoke(DispID: Integer;
  const IID: TGUID; LocaleID: Integer; Flags: Word; var Params; VarResult,
  ExcepInfo, ArgErr: Pointer): HResult;
var
  HTMLEventObjIfc: IHTMLEventObj;
begin
  Result := S_OK;
  if Assigned(FOnEvent) then FOnEvent(Self, HTMLEventObjIfc);
//  form1.Memo1.Lines.Add('Invoke: Dispid='+inttostr(DispID));
end;


procedure TForm1.WebEditorClick(Sender: TObject; EventObjIfc: IHTMLEventObj);
var
  HTMLImageIfc: IHTMLImgElement;
begin
  HTMLDocument2Ifc.parentWindow.event.cancelBubble := True;
  if Supports(HTMLDocument2Ifc.parentWindow.event.srcElement, IHTMLImgElement, HTMLImageIfc) then
    form1.Memo1.Lines.Add('Its an image');
  exit;
  form1.Memo1.Lines.Add('click: classname='+HTMLDocument2Ifc.parentWindow.event.srcElement.className);
  form1.Memo1.Lines.Add('click: tagname='+HTMLDocument2Ifc.parentWindow.event.srcElement.tagName);
  form1.Memo1.Lines.Add('click: title='+HTMLDocument2Ifc.parentWindow.event.srcElement.title);
  form1.Memo1.Lines.Add('click: stylefont='+HTMLDocument2Ifc.parentWindow.event.srcElement.style.font);
end;


procedure TForm1.WebEditorDblClk(Sender: TObject; EventObjIfc: IHTMLEventObj);
var
  HTMLTableIfc: IHTMLTable;
  w,h,b,r,c:oleVariant;
begin
  if Supports(HTMLDocument2Ifc.parentWindow.event.srcElement, IHTMLTable, HTMLTableIfc) then begin
    HTMLTableIfc:=HTMLDocument2Ifc.parentWindow.event.srcElement as IHTMLTable;
    w:=HTMLTableIfc.width;
    h:=HTMLTableIfc.height;
    b:=HTMLTableIfc.border;
    r:=HTMLTableIfc.rows.length;
    c:=HTMLTableIfc.cols;
    application.createForm(TTableForm,TableForm);
    tableform.cmdWidth.Text:=w;
    tableform.cmdBorder.Text:=b;
    tableform.cmdRows.Text:=r;
    tableform.cmdColumns.Text:=c;
    TableForm.ShowModal;
    TableForm.Free;
  end;
end;


function TForm1.SnapRect(const pIElement: IHTMLElement;
  var prcNew: tagRECT; eHandle: _ELEMENT_CORNER): HResult;
begin
  prcNew.left := 20 * (prcNew.left div 20);
  prcNew.top := 20 * (prcNew.top div 20);
  prcNew.right := 20 * (prcNew.right div 20);
  prcNew.bottom := 20 * (prcNew.bottom div 20);
  Result := S_OK;
end;


function TForm1.PostEditorEventNotify(inEvtDispId: Integer; const pIEventObj: IHTMLEventObj): HResult;
begin
  if inEvtDispId = -606 then begin
    // onmousemove
    StatusBar1.Panels[0].Text := IntToStr(pIEventObj.clientX) + ':' + IntToStr(pIEventObj.clientY);
  end;
  Result := S_FALSE;
end;


function TForm1.PostHandleEvent(inEvtDispId: Integer; const pIEventObj: IHTMLEventObj): HResult;
begin
  Result := S_FALSE;
//  showmessage('PostHandleEvent');
end;


function TForm1.PreHandleEvent(inEvtDispId: Integer; const pIEventObj: IHTMLEventObj): HResult;
begin
  Result := S_FALSE;
//  showmessage('PreHandleEvent');
end;


function TForm1.TranslateAccelerator(inEvtDispId: Integer; const pIEventObj: IHTMLEventObj): HResult;
begin
  Result := S_FALSE;
end;


procedure TForm1.FileNewExecute(Sender: TObject);
begin
  WebBrowser1.Navigate('about:blank');
end;


procedure TForm1.AfterLoad;
var
  HTMLEditServicesIfc: IHTMLEditServices;
begin
  // Set document to design mode
  HTMLDocument2Ifc.designMode := 'On';
  // Register scripting event handlers
  HTMLDocument2Ifc.ondblclick := FDblClickConnector as IDispatch;
  HTMLDocument2Ifc.onclick := FClickConnector as IDispatch;
  HTMLDocument2Ifc.onmouseover:= FMouseOverConnector as IDispatch;
  // Register edit designer
  (HTMLDocument2Ifc as IServiceProvider).QueryService(SID_SHTMLEditServices, IHTMLEditServices, HTMLEditServicesIfc);
  HTMLEditServicesIfc.AddDesigner(Self);
end;


procedure TForm1.BeforeLoad;
var
  HTMLEditServicesIfc: IHTMLEditServices;
begin
  (HTMLDocument2Ifc as IServiceProvider).QueryService(SID_SHTMLEditServices, IHTMLEditServices, HTMLEditServicesIfc);
  HTMLEditServicesIfc.RemoveDesigner(Self);
  HTMLDocument2Ifc.ondblclick := Null;
  HTMLDocument2Ifc.onclick := Null;
  HTMLDocument2Ifc.onmouseover := Null;
end;


procedure TForm1.WebBrowser1NavigateComplete2(Sender: TObject;
  const pDisp: IDispatch; var URL: OleVariant);
begin
  AfterLoad;
end;

procedure TForm1.WebMouseOver(Sender: TObject; EventObjIfc: IHTMLEventObj);
var
  HTMLImageIfc: IHTMLImgElement;
begin
  if Supports(HTMLDocument2Ifc.parentWindow.event.srcElement, IHTMLImgElement, HTMLImageIfc) then
    form1.Memo1.Lines.Add((HTMLImageIfc as IHtmlImgElement).dynsrc+' '+(HTMLImageIfc as IHtmlImgElement).src);
end;

end.
