unit taginspector;

interface

uses graphics,Types,ValEdit,StdCtrls,Controls,Classes,grids,dialogs,SysUtils,
    forms,fileCtrl;

const
  maxTagType=19;
  tagstrings : array [0..maxTagType] of string =(
    'noTag','table','td','tr','img','a',
    'body', 'link','head','html','form','input',
    'p','i','b','li','ol','ul',
    'meta','title');

type
  tagtype = (noTag,tagtable,tagtd,tagtr,tagimg,taga,tagbody,taglink,
    taghead,taghtml,tagform,taginput,tagp,tagi,tagb,tagli,tagol,tagul,
    tagmeta,tagtitle);
  itemtype = (noItem,titAlign,titAlign2,titAlign3,titColor,titInteger,titstring,
    titDirlist,titFrame,titRules,titFile,titDataformatas,titScope,titVAlign,
    titShape,titMethod,titType,titTypeli,titTypeol,titTypeul);
  ReplProc = function (newSelection:string;selstart,selend:integer):string of object;

  TEditVal = class (TValueListEditor)
    procedure wTagType(value:TagType);
  private
    fTagType:tagtype;
    FColorDialog: TColorDialog;
    FOpenDialog:TOpenDialog;
    FFullTag:string;
    FMItemList:TStringList;
    FItemCount:integer;
    FOnTagReplace: ReplProc;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure editButtonClick(sender: TObject);
    procedure MakeType();
    procedure parse();
    procedure WFullTag(value: string);
    function getString(index: integer): string;
    function getType(index: integer): ItemType;
    function getVal(key:string): string;
    procedure MyOnStringChange(sender: TObject);
  public
    selStart:integer;
    selEnd:integer;
    property OnTagReplace:ReplProc read FOnTagReplace write FOnTagReplace;
    property TgType:tagtype read FTagType write WTagType;
    property FullTag:string read FFullTag write WFullTag;
    property ColorDialog:TColorDialog read FColorDialog write FColorDialog;
    property OpenDialog:TOpenDialog read FOpenDialog write FOpenDialog;
    procedure DrawCell(ACol, ARow: Longint; ARect: TRect;
       AState: TGridDrawState); override;
  end;
  
const
  maxTable=20;
  TTable: array [0..maxTable] of string =(
    'align','bgcolor','border','datafld','datasrc','dataformatas','lang',
    'cellpadding','cellspacing','class','dir','frame','height','hspace',
    'id','rules','style','summary','title','vspace','width');
  TTableType: array [0..maxTable] of itemtype =(
    titAlign,titColor,titInteger,titString,titString,titDataformatas,titString,
    titInteger,titInteger,titstring,titDirlist,titFrame,titInteger,titInteger,
    titstring,titRules,titstring,titstring,titstring,titstring,titinteger);

  maxTd=19;
  TTD: Array [0..maxTd] of string=(
    'abbr','align','axis','bgcolor','char','charoff',
    'colspan','headers','height','nowrap','rowspan','scope',
    'valign','width',
    'class','id','style','title','dir','lang');
  TTDType: Array [0..maxTd] of itemtype = (
    titString,titAlign2,titString,titColor,titString,titString,
    titString,titString,titString,titstring,titString,titScope,
    titVAlign,titString,
    titString,titString,titString,titString,titDirlist,titString);

  maxTr=10;
  TTR: Array [0..maxTr] of string=(
    'align','bgcolor','char','charoff','valign',
    'class','id','style','title','dir','lang');
  TTRType: Array [0..maxTr] of itemtype = (
    titAlign2,titColor,titString,titColor,titVAlign,
    titString,titString,titString,titString,titDirlist,titString);

  maxImg=19;
  TIMG: Array [0..maxImg] of string=(
    'align','alt','border','height','hspace','ismap',
    'longdesc','name','src','usemap','vspace','width',
    'valign','width',
    'class','id','style','title','dir','lang');
  TIMGType: Array [0..maxImg] of itemtype = (
    titAlign3,titString,titString,titString,titString,titString,
    titString,titString,titFile,titstring,titString,titString,
    titString,titString,
    titString,titString,titString,titString,titDirlist,titString);

  maxA=17;
  TA: Array [0..maxA] of string=(
    'accesskey','charset','coords','href','hreflang','name',
    'rel','rev','shape','tabindex','target','type',
    'class','id','style','title','dir','lang');
  TAType: Array [0..maxA] of itemtype = (
    titString,titString,titString,titString,titString,titString,
    titString,titString,titShape,titstring,titString,titString,
    titString,titString,titString,titString,titDirlist,titString);

  maxBody=15;
  TBody: Array [0..maxBody] of string=(
    'alink','background','bgcolor','link','onload','onunload',
    'text','vlink','topmargin','leftmargin',
    'class','id','style','title','dir','lang');
  TBodyType: Array [0..maxBody] of itemtype = (
    titColor,titString,titColor,titColor,titString,titString,
    titColor,titColor,titInteger,titinteger,
    titString,titString,titString,titString,titDirlist,titString);

  maxLink=13;
  TLink: Array [0..maxLink] of string=(
    'charset','href','hreflang','media','rel','rev',
    'target','type',
    'class','id','style','title','dir','lang');
  TLinkType: Array [0..maxLink] of itemtype = (
    titString,titFile,titString,titString,titString,titString,
    titString,titString,
    titString,titString,titString,titString,titDirlist,titString);

  maxHead=6;
  THead: Array [0..maxHead] of string=(
    'profile',
    'class','id','style','title','dir','lang');
  THeadType: Array [0..maxHead] of itemtype = (
    titString,
    titString,titString,titString,titString,titDirlist,titString);

  maxHtml=6;
  THtml: Array [0..maxHtml] of string=(
    'version',
    'class','id','style','title','dir','lang');
  THtmlType: Array [0..maxHtml] of itemtype = (
    titString,
    titString,titString,titString,titString,titDirlist,titString);

  maxForm=14;
  TtForm: Array [0..maxForm] of string=(
    'action','accept','accept-charset','enctype','method','name',
    'onreset','onsubmit','target',
    'class','id','style','title','dir','lang');
  TtFormType: Array [0..maxForm] of itemtype = (
    titString,titString,titString,titString,titMethod,titString,
    titString,titString,titString,
    titString,titString,titString,titString,titDirlist,titString);

  maxInput=29;
  TInput: array [0..maxInput] of string =(
    'accept','accesskey','align','alt','checked','datafld',
    'datasrc','dataformatas','disabled','ismap','maxlength','name',
    'onblur','onchange','onfocus','onselect','readonly','size',
    'title','src','tabindex','type','usemap','value',
    'class','id','style','title','dir','lang');
  TInputType: array [0..maxInput] of itemtype =(
    titString,titString,titString,titString,titString,titString,
    titString,titDataformatas,titString,titString,titString,titString,
    titString,titString,titString,titString,titString,titString,
    titString,titString,titString,titType,titString,titString,
    titString,titString,titString,titString,titDirlist,titString);

  maxP=6;
  TP: array [0..maxP] of string =(
    'align','class','id','style','title','dir','lang');
  TPType: array [0..maxP] of itemtype =(
    titString,
    titString,titString,titString,titString,titDirlist,titString);

  maxI=5;
  TI: array [0..maxI] of string =(
    'class','id','style','title','dir','lang');
  TIType: array [0..maxI] of itemtype =(
    titString,titString,titString,titString,titDirlist,titString);

  maxB=5;
  TB: array [0..maxB] of string =(
    'class','id','style','title','dir','lang');
  TBType: array [0..maxB] of itemtype =(
    titString,titString,titString,titString,titDirlist,titString);

  maxli=7;
  Tli: array [0..maxli] of string =(
    'type','value','class','id','style','title','dir','lang');
  TliType: array [0..maxli] of itemtype =(
    titTypeli,titString,titString,titString,titString,titString,titDirlist,titString);

  maxol=8;
  Tol: array [0..maxol] of string =(
    'compact','start','type','class','id','style','title','dir','lang');
  TolType: array [0..maxol] of itemtype =(
    titString,titString,titTypeol,titString,titString,titString,titString,titDirlist,titString);

  maxul=7;
  Tul: array [0..maxul] of string =(
    'compact','type','class','id','style','title','dir','lang');
  TulType: array [0..maxul] of itemtype =(
    titString,titTypeul,titString,titString,titString,titString,titDirlist,titString);

  maxMeta=9;
  TMeta: Array [0..maxMeta] of string=(
    'name','content','http-equiv','scheme',
    'class','id','style','title','dir','lang');
  TMetaType: Array [0..maxMeta] of itemtype = (
    titString,titString,titString,titString,
    titString,titString,titString,titString,titDirlist,titString);

  maxTitle=5;
  TTitle: array [0..maxTitle] of string =(
    'class','id','style','title','dir','lang');
  TTitleType: array [0..maxTitle] of itemtype =(
    titString,titString,titString,titString,titDirlist,titString);

implementation

constructor TEditVal.Create(AOwner: TComponent);
begin
  inherited;
  defaultdrawing:=true;
  OnEditButtonClick:=editButtonClick;
  FMItemList:=TStringList.Create;
end;

destructor TEditVal.Destroy;
begin
  FMItemList.Free;
  inherited;
end;

procedure TEditVal.wTagType(value: TagType);
begin
  fTagType:=value;
  strings.Clear;
  case fTagType of
    taga:     FItemCount:=high(TA);
    tagbody:  FItemCount:=high(TBody);
    tagLink:  FItemCount:=high(TLink);
    tagForm:  FItemCount:=high(TtForm);
    tagHead:  FItemCount:=high(THead);
    tagHtml:  FItemCount:=high(THtml);
    tagInput: FItemCount:=high(TInput);
    tagTable: FItemCount:=high(TTable);
    tagtd:    FItemCount:=high(Ttd);
    tagtr:    FItemCount:=high(Ttr);
    tagimg:   FItemCount:=high(Timg);
    tagp:     FItemCount:=high(TP);
    tagi:     FItemCount:=high(TI);
    tagb:     FItemCount:=high(TB);
    tagli:    FItemCount:=high(Tli);
    tagol:    FItemCount:=high(Tol);
    tagul:    FItemCount:=high(Tul);
    tagmeta:  FItemCount:=high(Tmeta);
    tagTitle: FItemCount:=high(TTitle);
  end;
  if value<>notag then MakeType();
end;


function TEditVal.getString(index:integer):string;
begin
  result:='';
  case fTagType of
    taga:     result:=TA[index];
    tagbody:  result:=TBody[index];
    taglink:  result:=TLink[index];
    tagform:  result:=TtForm[index];
    taghead:  result:=THead[index];
    taghtml:  result:=THtml[index];
    tagInput: result:=TInput[index];
    tagTable: result:=TTable[index];
    tagtd:    result:=Ttd[index];
    tagtr:    result:=Ttr[index];
    tagimg:   result:=Timg[index];
    tagp:     result:=TP[index];
    tagi:     result:=TI[index];
    tagb:     result:=TB[index];
    tagli:    result:=Tli[index];
    tagol:    result:=Tol[index];
    tagul:    result:=Tul[index];
    tagmeta:  result:=TMeta[index];
    tagtitle: result:=TTitle[index];
  end;
end;

function TEditVal.getType(index:integer): ItemType;
begin
  result:=noItem;
  case fTagType of
    taga:     result:=TAType[index];
    tagbody:  result:=TBodyType[index];
    taglink:  result:=TLinkType[index];
    tagform:  result:=TtFormType[index];
    taghead:  result:=THeadType[index];
    taghtml:  result:=THtmlType[index];
    tagInput: result:=TInputType[index];
    tagTable: result:=TTableType[index];
    tagtd:    result:=TtdType[index];
    tagtr:    result:=TtrType[index];
    tagimg:   result:=TimgType[index];
    tagp:     result:=TPType[index];
    tagi:     result:=TIType[index];
    tagb:     result:=TBType[index];
    tagli:    result:=TliType[index];
    tagol:    result:=TolType[index];
    tagul:    result:=TulType[index];
    tagmeta:  result:=TMetaType[index];
    tagTitle: result:=TTitleType[index];
  end;
end;

procedure TEditVal.EditButtonClick(sender:TObject);
var s:string;
    item:ItemType;
begin
  item:=getType(Selection.Top);
  case item of
    titColor:begin
      if Assigned(FColorDialog) then begin
        if FColorDialog.Execute then begin
          s := IntToHex(ColorDialog.Color, 6);
          inplaceEditor.EditText:='#'+s[5]+s[6]+s[3]+s[4]+s[1]+s[2];
          inplaceEditor.Modified:=true;
          inplaceEditor.Update;
          values[keys[selection.Top]]:=inplaceEditor.EditText;
        end;
      end;
    end;
    titFile:begin
      if Assigned(FOpenDialog) then begin
        if FOpenDialog.Execute then begin
          s := FOpenDialog.FileName;
          inplaceEditor.EditText:=s;
          inplaceEditor.Modified:=true;
          inplaceEditor.Update;
          values[keys[selection.Top]]:=s;
        end;
      end;
    end;
  end;
end;

procedure TEditVal.DrawCell(ACol, ARow: Integer; ARect: TRect;
  AState: TGridDrawState);
var s,color:string;
begin
  if (Acol=1) then begin
    if ARow<=FItemCount then begin
      case GetType(ARow) of
          titColor: begin
            if Values[Keys[Arow]]<>'' then begin
              try
                s:=values[keys[ARow]];
                if length(s)=7 then begin
                  color:='$'+s[6]+s[7]+s[4]+s[5]+s[2]+s[3];
                  Canvas.Brush.Color:=stringToColor(color);
                end;
                except
              end;
            end;
          end;
      end;
    end;
  end;
  inherited;
end;

procedure TEditVal.WFullTag(value:string);
begin
  FFullTag:=value;
  parse();
end;

function TEditVal.getVal(key:string):string;
var i:integer;
begin
  result:='';
  i:=FMitemList.IndexOf(key);
  if i>0 then begin
    inc(i,2);
    if (i<=FMItemList.count) then result:=FMItemList[i];
    if result[1]='"' then delete(result,1,1);
    if result[length(result)]='"' then delete(result,length(result),1);
  end;
end;

procedure TEditVal.parse();
var run,i,i2:integer;
    c:char;
    toap,s:string;
    inString:boolean;
begin
  OnStringsChange:=nil;
  if FFulltag='' then exit;
  instring:=false;
  if not(assigned(FMItemList)) then FMItemList:=TStringList.Create;
  FMItemList.Clear;
  run:=1;
  repeat
    c:=FFullTag[run];
    inc(run);
    case c of
      ' ',#09,#11,#13: begin
        if not inString then begin
          if toap<>'' then begin
            FMItemList.Add(toap);
          end;
          toap:='';
        end else toap:=toap+c;
      end;
      '"':begin
        inString:=not inString;
        toap:=toap+c;
      end;
      '=': begin
        if not inString then begin
          FMItemList.Add(toap);
          FMItemList.Add('=');
          toap:='';
        end else toap:=toap+c;;
      end;
    else
      toap:=toap+c;
    end;
  until run>=length(FFulltag);
  FMItemList.Add(toap);
  for i2:=0 to FItemCount do begin
    s:=getString(i2);
    i:=FMitemList.IndexOf(s);
    if i>0 then Cells[1,i2]:=getVal(s);
  end;
  OnStringsChange:=MyOnStringChange;
end;

procedure TEditVal.MakeType();
var i:integer;
begin
  for i:=0 to FItemCount do begin
    InsertRow(GetString(i),'',true);
    case GetType(i) of
      titColor: begin
        ItemProps[i].EditStyle:=esEllipsis;
        if assigned(EditList) then EditList.OnEditButtonClick:=editButtonClick;
      end;
      titFile: begin
        ItemProps[i].EditStyle:=esEllipsis;
        if assigned(EditList) then EditList.OnEditButtonClick:=editButtonClick;
      end;
      titAlign: begin
        ItemProps[i].EditStyle:=esPickList;
        ItemProps[i].PickList.Clear;
        ItemProps[i].PickList.Add('left');
        ItemProps[i].PickList.Add('center');
        ItemProps[i].PickList.Add('right');
      end;
      titAlign2: begin
        ItemProps[i].EditStyle:=esPickList;
        ItemProps[i].PickList.Clear;
        ItemProps[i].PickList.Add('left');
        ItemProps[i].PickList.Add('center');
        ItemProps[i].PickList.Add('right');
        ItemProps[i].PickList.Add('justify');
        ItemProps[i].PickList.Add('char');
      end;
      titAlign3: begin
        ItemProps[i].EditStyle:=esPickList;
        ItemProps[i].PickList.Clear;
        ItemProps[i].PickList.Add('top');
        ItemProps[i].PickList.Add('middle');
        ItemProps[i].PickList.Add('bottom');
        ItemProps[i].PickList.Add('left');
        ItemProps[i].PickList.Add('center');
        ItemProps[i].PickList.Add('right');
      end;
      titVAlign:begin
        ItemProps[i].EditStyle:=esPickList;
        ItemProps[i].PickList.Clear;
        ItemProps[i].PickList.Add('top');
        ItemProps[i].PickList.Add('middle');
        ItemProps[i].PickList.Add('bottom');
        ItemProps[i].PickList.Add('baseline');
      end;
      titDirList: begin
        ItemProps[i].EditStyle:=esPickList;
        ItemProps[i].PickList.Clear;
        ItemProps[i].PickList.Add('ltr');
        ItemProps[i].PickList.Add('rtl');
      end;
      titDataformatas:begin
        ItemProps[i].EditStyle:=esPickList;
        ItemProps[i].PickList.Clear;
        ItemProps[i].PickList.Add('plaintext');
        ItemProps[i].PickList.Add('html');
      end;
      titFrame:begin
        ItemProps[i].EditStyle:=esPickList;
        ItemProps[i].PickList.Clear;
        ItemProps[i].PickList.Add('void');
        ItemProps[i].PickList.Add('above');
        ItemProps[i].PickList.Add('below');
        ItemProps[i].PickList.Add('hsides');
        ItemProps[i].PickList.Add('lhs');
        ItemProps[i].PickList.Add('rhs');
        ItemProps[i].PickList.Add('vsides');
        ItemProps[i].PickList.Add('box');
        ItemProps[i].PickList.Add('border');
      end;
      titType:begin
        ItemProps[i].EditStyle:=esPickList;
        ItemProps[i].PickList.Clear;
        ItemProps[i].PickList.Add('text');
        ItemProps[i].PickList.Add('password');
        ItemProps[i].PickList.Add('checkbox');
        ItemProps[i].PickList.Add('radio');
        ItemProps[i].PickList.Add('submit');
        ItemProps[i].PickList.Add('reset');
        ItemProps[i].PickList.Add('file');
        ItemProps[i].PickList.Add('hidden');
        ItemProps[i].PickList.Add('image');
        ItemProps[i].PickList.Add('button');
      end;
      titRules:begin
        ItemProps[i].EditStyle:=esPickList;
        ItemProps[i].PickList.Clear;
        ItemProps[i].PickList.Add('none');
        ItemProps[i].PickList.Add('groups');
        ItemProps[i].PickList.Add('rows');
        ItemProps[i].PickList.Add('cols');
        ItemProps[i].PickList.Add('all');
      end;
      titScope:begin
        ItemProps[i].EditStyle:=esPickList;
        ItemProps[i].PickList.Clear;
        ItemProps[i].PickList.Add('row');
        ItemProps[i].PickList.Add('col');
        ItemProps[i].PickList.Add('rowgroup');
        ItemProps[i].PickList.Add('colgroup');
      end;
      titShape:begin
        ItemProps[i].EditStyle:=esPickList;
        ItemProps[i].PickList.Clear;
        ItemProps[i].PickList.Add('rect');
        ItemProps[i].PickList.Add('circle');
        ItemProps[i].PickList.Add('poly');
        ItemProps[i].PickList.Add('default');
      end;
      titMethod:begin
        ItemProps[i].EditStyle:=esPickList;
        ItemProps[i].PickList.Clear;
        ItemProps[i].PickList.Add('get');
        ItemProps[i].PickList.Add('post');
      end;
      titTypeli:begin
        ItemProps[i].EditStyle:=esPickList;
        ItemProps[i].PickList.Clear;
        ItemProps[i].PickList.Add('disc');
        ItemProps[i].PickList.Add('square');
        ItemProps[i].PickList.Add('circle');
        ItemProps[i].PickList.Add('1');
        ItemProps[i].PickList.Add('a');
        ItemProps[i].PickList.Add('A');
        ItemProps[i].PickList.Add('i');
        ItemProps[i].PickList.Add('I');
      end;
      titTypeol:begin
        ItemProps[i].EditStyle:=esPickList;
        ItemProps[i].PickList.Clear;
        ItemProps[i].PickList.Add('1');
        ItemProps[i].PickList.Add('a');
        ItemProps[i].PickList.Add('A');
        ItemProps[i].PickList.Add('i');
        ItemProps[i].PickList.Add('I');
      end;
      titTypeul:begin
        ItemProps[i].EditStyle:=esPickList;
        ItemProps[i].PickList.Clear;
        ItemProps[i].PickList.Add('disc');
        ItemProps[i].PickList.Add('square');
        ItemProps[i].PickList.Add('circle');
      end;
    end;
  end;
end;

procedure TEditVal.MyOnStringChange(sender: TObject);
var s,old,new,newfull:string;
    i,first,last:integer;
begin
  last:=0;
  i:=Selection.Top;
//  if Cells[1,i]='' then exit;
  s:=s+Cells[0,i];
  s:=s+'=';
  s:=s+'"'+inplaceEditor.EditText+'"';
//  showmessage(inplaceEditor.EditText);
  if assigned(FOnTagReplace) then begin
    first:=Pos(getString(i),FFulltag);
    old:='';
    if first>0 then begin
        last:=first;
        while FFulltag[last]<>'=' do inc(last);
        while FFulltag[last]<>'"' do inc(last);
        inc(last);
        while FFulltag[last]<>'"' do inc(last);
        inc(last);
        old:=copy(FFullTag,first,last-first);
    end;
//    showmessage('old:'+old);
    new:=s;
    newfull:=FFullTag;
    if inplaceEditor.EditText='' then begin
      if first>0 then begin
//        showmessage(old);
        if newfull[last]=' ' then inc(last);
//        if newfull[first-1]=' ' then dec(first);
        delete(newfull,first,last-first);
        if newfull[length(newfull)-1]=' ' then delete(newfull,length(newfull)-1,1);
      end;
    end else begin
  //    showmessage(getString(i));
      if first>0 then
          newfull:=StringReplace(newfull,old,new,[rfReplaceAll, rfIgnoreCase])
      else
         insert(' '+new,newfull,length(newfull));
    end;
    selEnd:=selStart+length(newfull);
    FFullTag:=FOnTagReplace(newfull,selstart,selend);
    parse();
  end;
end;

end.
