//
// +----------------------------------------------------------------------+
// | Dev-PHP - Integrated Development Environment                         |
// +----------------------------------------------------------------------+
// | Copyright (C) 2002-2003, http://devphp.sourceforge.net               |
// +----------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify |
// | it under the terms of the GNU General Public License as published by |
// | the Free Software Foundation; either version 2 of the License, or    |
// | (at your option) any later version.                                  |
// | This program is distributed in the hope that it will be useful       |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of       |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         |
// | GNU General Public License for more details.                         |
// +----------------------------------------------------------------------+
// | Author: Leonardo Garca <simbiotik@users.sourceforge.net>            |
// | Author: Urs Mder <ursmaeder@users.sourceforge.net>                  |
// +----------------------------------------------------------------------+
//

unit uIniFile;

interface

uses Classes, Dialogs, IniFiles, Forms, graphics, SysUtils,  windows, shlObj,
     SynEditHighlighter,SynHighlighterSQL, SynHighlighterJScript, SynHighlighterMulti,
     SynHighlighterXML,InitStuff,
     SynHighlighterHtml, SynHighlighterCss, SynHighlighterPHP, SynEdit,
     version,DCPrc4,DCPsha1;

type

TGlobSettings=class (TPersistent)
    constructor Create();
    destructor Destroy;override;
  private
    fIdiomaText:string;
    fEdit1Text: string;
    fEditorFontText:string;
    fDemoEditColor:integer;
    fUpDown4Position:integer;
    fUpDown2Position:integer;
    fUpDown3Position:integer;
    fStatusBar1visible:boolean;
    fDocsPathText: string;
    fdl: string;
    fLastProject:string;
    fToolBar1visible:boolean;
    fhtmlbar1visible:boolean;
    feditbar1visible:boolean;
    fLineNumbers:boolean;
    fMainFormWindowState: integer;
    fMainFormLeft : integer;
    fMainFormTop : integer;
    fMainFormwidth : integer;
    fMainFormHeight : integer;
    fDateFmt:string;
    fTimeFmt:string;
    fDateTimeFmt:string;
    fSaveType:integer;
    fHideSideBar:boolean;
    fAutoIndent:boolean;
    fWordWrap:boolean;
    fSideBarWidth:integer;
    fDockSideBar:string;
    fSynHTMLSyn1Filter:string;
    fSynPHPSyn1Filter:string;
    fSynJSSyn1Filter:string;
    fSynXMLSyn1Filter:string;
    fSynCSSSyn1Filter:string;
    fSynSQLSyn1Filter:string;
    fSynMultiSyn1Filter:string;
    fAssoc:string;
    fProjHistory:TStringList;
    fPHPIniFile: string;
    fActiveLineColor: string;
    fTabsToSpaces: boolean;
    fEncoding: String;
    fBOM: boolean;
    procedure wEdit1Text(const Value: string);
    procedure wDemoEditColor(const Value: integer);
    procedure wUpDown4Position(const Value: integer);
    procedure wUpDown2Position(const Value: integer);
    procedure wUpDown3Position(const Value: integer);
    procedure wEditorFontText(const Value: string);
    procedure wStatusBar1visible(const Value: boolean);
    procedure wDocsPathText(const Value: string);
    procedure wdl(const Value: string);
    procedure wIdiomaText(const Value:string);
    procedure wLastProject(const Value:string);
    procedure wToolBar1visible(const Value: boolean);
    procedure whtmlbar1visible(const Value: boolean);
    procedure weditbar1visible(const Value: boolean);
    procedure wLineNumbers(const Value: boolean);
    procedure wMainFormWindowState(const Value: integer);
    procedure wMainFormLeft (const Value: integer);
    procedure wMainFormTop (const Value: integer);
    procedure wMainFormwidth (const Value: integer);
    procedure wMainFormHeight (const Value: integer);
    procedure wDateFmt(const Value:string);
    procedure wTimeFmt(const Value:string);
    procedure wDateTimeFmt(const Value:string);
    procedure wSaveType(const Value:integer);
    procedure wHideSideBar(const Value:boolean);
    procedure wSideBarWidth(const Value:integer);
    procedure wAutoIndent(const Value:boolean);
    procedure wWordWrap(const Value:boolean);
    procedure wDockSideBar(const Value:string);
    procedure wSynHTMLSyn1Filter(const Value:string);
    procedure wSynPHPSyn1Filter(const Value:string);
    procedure wSynXMLSyn1Filter(const Value:string);
    procedure wSynCSSSyn1Filter(const Value:string);
    procedure wSynJSSyn1Filter(const Value:string);
    procedure wSynSQLSyn1Filter(const Value:string);
    procedure wSynMultiSyn1Filter(const Value:string);
    procedure wAssoc(const Value:string);
    procedure writeStrings(list: TStrings; bezeichnung: string);
    procedure wPHPInifile(const Value: string);
    procedure wActiveLineColor(const Value: string);
    procedure wTabsToSpaces(const Value: boolean);
    procedure wEncoding(const Value: String);
    procedure wBOM(const Value: boolean);
  protected
  public
    procedure clearProjHistory;
    procedure writeProjHistory;
  published
    property activeLineColor:string read fActiveLineColor write wActiveLineColor;
    property PHPExeFile:string read fEdit1Text write wEdit1Text;
    property PHPIniFile:string read fPHPIniFile write wPHPInifile;
    property UpDown4Position:integer read fUpDown4Position write wUpDown4Position;
    property UpDown2Position:integer read fUpDown2Position write wUpDown2Position;
    property UpDown3Position:integer read fUpDown3Position write wUpDown3Position;
    property DemoEditColor:integer read fDemoEditColor write wDemoEditColor;
    property EditorFontText:string read fEditorFontText write wEditorFontText;
    property StatusBar1visible:boolean read fStatusBar1visible write wStatusBar1visible;
    property DocsPathText :string read fDocsPathText write wDocsPathText;
    property dl :string read fdl write wdl;
    property IdiomaText:string read fIdiomaText write wIdiomaText;
    property LastProject:string read fLastProject write wLastProject;
    property toolbar1visible:boolean read fToolbar1visible write wToolbar1visible;
    property htmlbar1visible:boolean read fhtmlbar1visible write whtmlbar1visible;
    property editbar1visible:boolean read feditbar1visible write weditbar1visible;
    property LineNumbers:boolean read fLineNumbers write wLineNumbers;
    property MainFormWindowState:Integer read fMainFormWindowState write wMainFormWindowState;
    property MainFormLeft :Integer read fMainFormLeft write wMainFormLeft;
    property MainFormTop :Integer read fMainFormTop write wMainFormTop;
    property MainFormwidth :Integer read fMainFormwidth write wMainFormwidth;
    property MainFormHeight :Integer read fMainFormHeight write wMainFormHeight;
    property DateFmt:string read fDateFmt write wDateFmt;
    property TimeFmt:String read fTimeFmt write wTimeFmt;
    property DateTimeFmt:String read fDateTimeFmt write wDateTimeFmt;
    property SaveType:integer read fSaveType write wSaveType;
    // 0 = DOS - 1 = UNIX - 2 = MAC
    property HideSideBar:boolean read fHideSideBar write wHideSideBar;
    property AutoIndent:boolean read fAutoIndent write wAutoIndent;
    property TabsToSpaces:boolean read fTabsToSpaces write wTabsToSpaces;
    property WordWrap:boolean read fWordWrap write wWordWrap;
    property SideBarWidth:integer read fSideBarWidth write wSideBarWidth;
    property DockSideBar:String read fDockSideBar write wDockSideBar;
    property SynHTMLSyn1Filter:String read fSynHTMLSyn1Filter write wSynHTMLSyn1Filter;
    property SynPHPSyn1Filter:String read fSynPHPSyn1Filter write wSynPHPSyn1Filter;
    property SynXMLSyn1Filter:String read fSynXMLSyn1Filter write wSynXMLSyn1Filter;
    property SynJSSyn1Filter:String read fSynJSSyn1Filter write wSynJSSyn1Filter;
    property SynSQLSyn1Filter:String read fSynSQLSyn1Filter write wSynSQLSyn1Filter;
    property SynCSSSyn1Filter:String read fSynCSSSyn1Filter write wSynCSSSyn1Filter;
    property SynMultiSyn1Filter:String read fSynMultiSyn1Filter write wSynMultiSyn1Filter;
    property Assoc:String read fAssoc write wAssoc;
    property ProjHistory:TStringList read fProjHistory write fProjHistory;
    property Encoding:String read fEncoding write wEncoding;
    property BOM:boolean read fBOM write wBOM;

end;

TSettings = class (TPersistent)
    constructor Create();
    destructor Destroy;override;
  private
    fUpDown1Position:integer;
    fDemoEditFontName: string;
    fBracesChecked: boolean;
    fSaveSessionChecked: boolean;
    fDialogFontText: string;
    fFTPcfname:string;
    fFTPPassive:boolean;
    fFTPPortText: string;
    flocalpathText: string;
    fFTPPasswordSave: string;
    fFTPServerPathText: string;
    fFTPHostText: string;
    fFTPUserText: string;
    flocalPortText: string;
    fregMultiChecked: boolean;
    fParams: string;
    fHistory:TStringList;
    fExternals:TStringList;
    fSession:TStringList;
    fFindDialog1FindText:string;
    fReplaceDialog1FindText:string;
    fSessionActive: integer;
    fExternPath:string;
    fVersion:string;
    fDSiteText:string;
    fDescription:string;
    fBrowserPath:string;
    fInternBrowser: String;
    procedure wDemoEditFontName(const Value: string);
    procedure wBracesChecked(const Value: boolean);
    procedure wDialogFontText(const Value: string);
    procedure wSaveSessionChecked(const Value: boolean);
    procedure wFTPcfname(const value:string);
    procedure wFTPPassive(const Value:boolean);
    procedure wFTPHostText(const Value: string);
    procedure wFTPPasswordSave(const Value: string);
    procedure wFTPPortText(const Value: string);
    procedure wFTPServerPathText(const Value: string);
    procedure wFTPUserText(const Value: string);
    procedure wlocalpathText(const val: string);
    procedure wlocalPortText(const Value: string);
    procedure wUpDown1Position(const Value: integer);
    procedure wregMultiChecked(const Value: boolean);
    procedure wParams(const Value: string);
    procedure wFindDialog1FindText (const Value:string);
    procedure wReplaceDialog1FindText (const Value:string);
    procedure wSessionActive (const Value: integer);
    procedure wExternPath(const Value:string);
    procedure wVersion(const Value:string);
    procedure wDSiteText(const value:string);
    procedure wDescription(const value:string);
    procedure wBrowserPath(const value:string);
    function ReadPw():string;
    procedure writeStrings(list: TStrings; bezeichnung: string);
    procedure wInternBrowser(const Value: String);
  protected
  public
    procedure writeHistory();
    procedure writeSession();
    procedure writeExternals();
    procedure clearHistory;
  published
    property UpDown1Position:integer read fUpDown1Position write wUpDown1Position;
    property DemoEditFontName:string read fDemoEditFontName write wDemoEditFontName;
    property BracesChecked :boolean read fBracesChecked write wBracesChecked;
    property SaveSessionChecked:boolean read fSaveSessionChecked write wSaveSessionChecked;
    property DialogFontText:string read fDialogFontText write wDialogFontText;
    property localpathText:string read flocalpathText write wlocalpathText;
    property localPortText:string read flocalPortText write wlocalPortText;
    property FTPcfname:string read fFTPcfname write wFTPcfname;
    property FTPPassive:boolean read fFTPPassive write wFTPPassive;
    property FTPHostText:string read fFTPHostText write wFTPHostText;
    property FTPPortText:string read fFTPPortText write wFTPPortText;
    property FTPUserText:string read fFTPUserText write wFTPUserText;
    property FTPPasswordSave:string read fFTPPasswordSave write wFTPPasswordSave;
    property FTPServerPathText:string read fFTPServerPathText write wFTPServerPathText;
    property regMultiChecked :boolean read fregMultiChecked write wregMultiChecked;
    property Params :string read fParams write wParams;
    property FindDialog1FindText:string read fFindDialog1FindText write wFindDialog1FindText;
    property ReplaceDialog1FindText:string read fReplaceDialog1FindText write wReplaceDialog1FindText;
    property SessionActive:integer read fSessionActive write wSessionActive;
    property ExternPath:string read fExternPath write wExternPath;
    property Version:string read fVersion write wVersion;
    property DSiteText:string read fDSiteText write wDSiteText;
    property Description:string read fDescription write wDescription;
    property BrowserPath:string read fBrowserPath write wBrowserPath;
    property History:TStringList read fHistory write fHistory;
    property Session:TStringList read fSession write fSession;
    property Externals:TStringList read fExternals write fExternals;
    property InternBrowser:String read fInternBrowser write wInternBrowser;
end;

procedure CreateNewIniFile(CreateIni : boolean);
procedure CreateIniFile(filename:string);
procedure CreateHighlighters( SynPHPSyn:TSynPHPSyn;
                              SynCSSSyn:TSynCssSyn;
                              SynJScriptSyn:TSynJScriptSyn;
                              SynSQLSyn:TSynSQLSyn;
                              SynMulti:TSynMultiSyn;
                              Synhtml:TSynHTMLSyn;
                              SynXMLSyn:TSynXMLSyn);
procedure SaveHighlighters(   SynPHPSyn:TSynPHPSyn;
                              SynCSSSyn1:TSynCssSyn;
                              SynJScriptSyn1:TSynJScriptSyn;
                              SynSQLSyn1:TSynSQLSyn;
                              SynMulti:TSynMultiSyn;
                              SynHTML:TSynHTMLSyn;
                              SynXMLSyn:TSynXMLSyn);
procedure LoadIniFile();
procedure LoadGIniFile();
procedure SaveIniFile(filename:string);
procedure LoadSynEditFromFile(IniFileName:string;DemoSyn:TSynCustomHighlighter);
procedure SaveSynEditToFile(IniFileName:string;DemoSyn:TSynCustomHighlighter);
procedure freeIniFile;
procedure clearToolbars;

const
  keyStr='DEV-PHP is good';
  initphp='php;php4;hphp;php3';
  inithtm='html;shtml';
  initcss='css';
  initxml='xml;xhtm;xhtml';
  initsql='sql';
  initjs='js';
  initmulti='htm;php';
  initassoc='php;htm';

var
    Settings:TSettings;
    GSettings:TGlobSettings;
    IniFile:TIniFile;
    OldIniFile:TIniFile;
    IniFileName:string;
    OldIniFilename:string;

implementation

procedure CreateNewIniFile(CreateIni : boolean);
begin
if FileExists(OldIniFileName) then
  SysUtils.DeleteFile(OldIniFileName);
  OldIniFile:=TIniFile.Create(OldIniFileName);
  if CreateIni = True then begin
    gsettings:=TGlobSettings.Create;
    gsettings.PHPExeFile:=ExtractFilePath(Application.ExeName) + 'php\php-cgi.exe';
    gsettings.PHPIniFile:=ExtractFilePath(Application.ExeName) + 'php\php.ini';
    gsettings.UpDown2Position:=10;
    gsettings.UpDown3Position:=2;
    gsettings.UpDown4Position:=80;
    gsettings.DemoEditColor:=16777215;
    gsettings.EditorFontText:='Courier New';
    gsettings.StatusBar1visible:=true;
    gsettings.toolbar1visible:=true;
    gsettings.htmlbar1visible:=true;
    gsettings.editbar1visible:=true;
    gsettings.LineNumbers:=true;
    gsettings.MainFormWindowState:=integer(wsnormal);
    gsettings.MainFormLeft:=10;
    gsettings.MainFormTop:=10;
    gsettings.MainFormwidth:=600;
    gsettings.MainFormHeight:=400;
    gsettings.DateFmt:='MM.DD.YYYY';
    gsettings.TimeFmt:='t';
    gsettings.DateTimeFmt:='MM.DD.YYYY t';
    gsettings.SaveType:=0;
    gsettings.HideSideBar:=false;
    gsettings.AutoIndent:=true;
    gsettings.TabsToSpaces:=false;
    gsettings.WordWrap:=false;
    gsettings.sideBarWidth:=200;
    gsettings.DockSideBar:='TBDock2';
    gsettings.fSynHTMLSyn1Filter:=inithtm;
    gsettings.fSynPHPSyn1Filter:=initphp;
    gsettings.fSynXMLSyn1Filter:=initxml;
    gsettings.fSynCSSSyn1Filter:=initcss;
    gsettings.fSynSQLSyn1Filter:=initsql;
    gsettings.fSynJSSyn1Filter:=initjs;
    gsettings.fSynMultiSyn1Filter:=initmulti;
    gsettings.fassoc:=initassoc;
    gsettings.activeLineColor:='clblue';
    gsettings.IdiomaText:=ExtractFilePath(Application.ExeName) + 'lang\english.lng';
    gsettings.DocsPathText:=ExtractFilePath(Application.ExeName) + 'doc\php_manual_en.chm';
    gsettings.dl := 'en';
    gsettings.Encoding:='Ansi';
    gsettings.BOM:=false;
  end;
end;

procedure CreateIniFile(filename:string);
begin
  settings:=TSettings.Create();
  IniFileName:=filename;
  if FileExists(IniFileName) then begin
    SysUtils.DeleteFile(IniFileName);
  end;
  IniFile:=TIniFile.Create(IniFileName);
//  IniFile.WriteInteger('Edit','Edge',settings.UpDown1Position);
//  IniFile.WriteString('Options','Font',settings.DemoEditFontName);
  IniFile.WriteBool('Options', 'Highlight', false);
  IniFile.WriteBool('Options', 'SaveSession', true);
  IniFile.WriteString('Options', 'DialogFont', 'Tahoma');
  IniFile.WriteString('Options', 'ExternPath','');
  iniFile.WriteString('Options','LocalPath','');
  iniFile.WriteString('Options','LocalPort','8080');
  iniFile.WriteString('Options','FTPcfname','55');
  iniFile.WriteBool('Options','FTPPassive',false);
  iniFile.WriteString('Options','FTPHost','');
  iniFile.WriteString('Options','FTPPort','');
  iniFile.WriteString('Options','FTPUser','');
  iniFile.WriteString('Options','FTPServerPath','');
  IniFile.WriteBool('Registry', 'css', false);
  IniFile.WriteBool('Registry', 'html', false);
  IniFile.WriteBool('Registry', 'js', false);
  IniFile.WriteBool('Registry', 'sql', false);
  IniFile.WriteBool('Registry', 'php', false);
//  IniFile.WriteString('Options','Parameters',settings.Params);
//  settings.writeHistory();
//  settings.writeSession();
  iniFile.WriteString('Options', 'FindText','');
  iniFile.WriteString('Options', 'ReplaceText', '');
  IniFile.WriteInteger('Session', 'Active', 0);
  IniFile.WriteString('UPDATE', 'Version','');
  IniFile.WriteString('UPDATE', 'Download', '' );
  IniFile.WriteString('UPDATE', 'Description', '');
  IniFile.WriteString('Options', 'BrowserPath','');
  IniFile.WriteString('Options', 'BrowserPath','InternetExplorer');
end;

procedure LoadGIniFile();
var last,i:integer;
begin
  if not assigned(OldIniFile) then OldIniFile:=TIniFile.Create(OldIniFileName);
  if not assigned(gsettings) then gsettings:=TGlobSettings.Create;
  gsettings.DemoEditColor:= OldIniFile.ReadInteger('Edit','Color',ord(clwhite));
  gsettings.UpDown2Position := OldIniFile.ReadInteger('Edit','Size',8);
  gsettings.UpDown3Position := OldIniFile.ReadInteger('Edit','Tab',4);
  gsettings.UpDown4Position := OldIniFile.ReadInteger('Options', 'FunctionBrowser', 185);
  gsettings.PHPExeFile:= OldIniFile.ReadString('Options','Parser','');
  gsettings.PHPIniFile:= OldIniFile.ReadString('Options','IniFile','');
  gsettings.EditorFontText := OldIniFile.ReadString('Options','Font', 'Courier New');
  gsettings.StatusBar1visible:=OldIniFile.ReadBool('ToolBars','StatusBar',true);
  gsettings.DocsPathText := OldIniFile.ReadString('Documentation', 'Filename', '');
  gsettings.dl := OldIniFile.ReadString('Documentation', 'Lang', 'en');
  gsettings.IdiomaText := OldIniFile.ReadString('Options','LangFile',
    ExtractFilePath(Application.ExeName) + 'lang\english.lng');
  gsettings.LastProject:=OldIniFile.ReadString('Projects','Last',
    getAppFolder() +'\devphp\'+'project.prd');
  gsettings.toolbar1visible:=OldIniFile.ReadBool('ToolBars','ToolBar',true);
  gsettings.htmlbar1visible:=OldIniFile.ReadBool('ToolBars','HtmlBar',true);
  gsettings.editbar1visible:=OldIniFile.ReadBool('ToolBars','EditBar',true);
  gsettings.LineNumbers:=OldIniFile.ReadBool('Edit','LineNums',True);
  gsettings.MainFormWindowState:=OldIniFile.ReadInteger('Options','WindowState',0);
  gsettings.MainFormLeft:=  OldIniFile.ReadInteger('Options','windowX',10);
  gsettings.MainFormTop:=  OldIniFile.ReadInteger('Options','windowY',10);
  gsettings.MainFormwidth:=   OldIniFile.ReadInteger('Options','windowW',400);
  gsettings.MainFormHeight:=OldIniFile.ReadInteger('Options','windowH',200);
  gsettings.DateFmt:=OldIniFile.ReadString('Options','DateFmt','MM.DD.YYYY');
  gsettings.TimeFmt:=OldIniFile.ReadString('Options','TimeFmt','t');
  gsettings.DateTimeFmt:=OldIniFile.ReadString('Options','DateTimeFmt','MM.DD.YYYY t');
  gsettings.SaveType:=OldIniFile.ReadInteger('Options','SaveType',0);
  gsettings.HideSideBar:=OldIniFile.ReadBool('Options','HideSideBar',false);
  gsettings.AutoIndent:=OldIniFile.ReadBool('Edit','AutoIndent',True);
  gsettings.TabsToSpaces:=OldIniFile.ReadBool('Edit','TabsToSpaces',false);
  gsettings.WordWrap:=OldIniFile.ReadBool('Edit','WordWrap',False);
  gsettings.SideBarWidth:=OldIniFile.ReadInteger('Options','SideBarWidth',200);
  gsettings.DockSideBar:=OldIniFile.ReadString('Options','DockSideBar','TBDock2');
  gsettings.SynHTMLSyn1Filter:=OldIniFile.ReadString('Options','SynHTMLSynFilter',inithtm);
  gsettings.SynPHPSyn1Filter:=OldIniFile.ReadString('Options','SynPHPSynFilter',initphp);
  gsettings.SynXMLSyn1Filter:=OldIniFile.ReadString('Options','SynXMLSynFilter',initxml);
  gsettings.SynJSSyn1Filter:=OldIniFile.ReadString('Options','SynJSSynFilter',initjs);
  gsettings.SynSQLSyn1Filter:=OldIniFile.ReadString('Options','SynSQLSynFilter',initsql);
  gsettings.SynCSSSyn1Filter:=OldIniFile.ReadString('Options','SynCSSSynFilter',initcss);
  gsettings.SynMultiSyn1Filter:=OldIniFile.ReadString('Options','SynMultiSynFilter',initmulti);
  gsettings.assoc:=OldIniFile.ReadString('Options','Assoc',initassoc);
  gsettings.ProjHistory.Clear;
  last:=oldinifile.ReadInteger('ProjectHistory','Last',0);
  gsettings.activeLineColor:=OldIniFile.ReadString('Options','ActiveLineColor','clnone');
  if last>0 then begin
    for i:=1 to last do begin
      gsettings.ProjHistory.Add(oldinifile.ReadString('ProjectHistory',inttostr(i),''));
    end;
  end;
  gsettings.Encoding:=OldIniFile.ReadString('Options','Encoding','Ansi');
  gsettings.BOM:=OldIniFile.ReadBool('Options','Encoding',false);
end;

procedure LoadIniFile();
var last,i:integer;
    s:string;
begin
  if assigned(IniFile) then IniFile.Free;
  if assigned(Settings) then Settings.free;
  IniFile:=TIniFile.Create(IniFileName);
  settings:=TSettings.Create();
  settings.UpDown1Position := IniFile.ReadInteger('Edit','Edge',80);
  settings.DemoEditFontName := IniFile.ReadString('Options','Font','Courier New');
  settings.BracesChecked := IniFile.ReadBool('Options', 'Highlight', True);
  settings.SaveSessionChecked := IniFile.ReadBool('Options', 'SaveSession', True);
  settings.DialogFontText := IniFile.ReadString('Options', 'DialogFont', 'Tahoma');
  settings.externPath := IniFile.ReadString('Options', 'ExternPath', 'http://sourceforge.org/dev-php/');
  settings.localpathText:=iniFile.ReadString('Options','LocalPath','');
  settings.localPortText:=iniFile.ReadString('Options','LocalPort','8080');
  settings.FTPcfname:=iniFile.readString('Options','FTPcfname','0');
  settings.FTPPassive:=iniFile.ReadBool('Options','FTPPassive',false);
  settings.FTPHostText:=iniFile.ReadString('Options','FTPHost','');
  settings.FTPPortText:=iniFile.ReadString('Options','FTPPort','21');
  settings.FTPUserText:=iniFile.ReadString('Options','FTPUser','anonymous');
  settings.FTPPasswordSave:=settings.ReadPw();
  settings.FTPServerPathText:=iniFile.ReadString('Options','FTPServerPath','');
  settings.regMultiChecked := IniFile.ReadBool('Registry', 'multi', false);
  settings.Params := IniFile.ReadString('Options','Parameters',' -q');
  settings.History.Clear;
  last:=inifile.ReadInteger('History','Last',0);
  if last>0 then begin
    for i:=1 to last do begin
      settings.History.Add(inifile.ReadString('History',inttostr(i),''));
    end;
  end;
  settings.Externals.Clear;
  last:=inifile.ReadInteger('Externals','Last',0);
  if last>0 then begin
    for i:=1 to last do begin
      settings.Externals.Add(inifile.ReadString('Externals','Name'+inttostr(i),'')+'='+
        inifile.ReadString('Externals','Prg'+inttostr(i),''));
    end;
  end;
  settings.Session.Clear;
  last:=inifile.ReadInteger('Session','Last',0);
  if last>0 then begin
    for i:=1 to last do begin
      s:=inifile.ReadString('Session',inttostr(i),'');
      settings.Session.Add(s);
    end;
  end;
  settings.FindDialog1FindText:=  iniFile.ReadString('Options', 'FindText', '');
  settings.ReplaceDialog1FindText:=  iniFile.ReadString('Options', 'ReplaceText', '');
  settings.SessionActive := IniFile.ReadInteger('Session', 'Active', 1);
  settings.version := IniFile.ReadString('UPDATE', 'Version',DevPHPVer);
  settings.DSiteText := IniFile.ReadString('UPDATE', 'Download', '');
  settings.Description := IniFile.ReadString('UPDATE', 'Description', '');
  settings.BrowserPath:= IniFile.ReadString('Options','BrowserPath','http://devphp.sourceforge.net/');
  settings.InternBrowser:= IniFile.ReadString('Options','InternBrowser','Internet Explorer');
end;

procedure SaveGIniFile;
begin
  OldIniFile:=TIniFile.Create(OldIniFileName);
  OldIniFile.WriteInteger('Edit','Color',gsettings.DemoEditColor);
  OldIniFile.WriteInteger('Edit','Size',gsettings.UpDown2Position);
  OldIniFile.WriteInteger('Edit','Tab',gsettings.UpDown3Position);
  OldIniFile.WriteInteger('Options', 'FunctionBrowser', gsettings.UpDown4Position);
  OldIniFile.WriteString('Options','Parser',gsettings.PHPExeFile);
  OldIniFile.WriteString('Options','IniFile',gsettings.PHPIniFile);
  OldIniFile.WriteString('Options','Font', gsettings.EditorFontText);
  OldIniFile.WriteBool('ToolBars','StatusBar',gsettings.StatusBar1visible);
  OldIniFile.WriteString('Documentation', 'Filename', gsettings.DocsPathText);
  OldIniFile.WriteString('Documentation', 'Lang', gsettings.dl);
  OldIniFile.WriteString('Options','LangFile',gsettings.IdiomaText);
  OldiniFile.Writestring('Projects','Last',gsettings.LastProject);
  OldIniFile.WriteBool('ToolBars','ToolBar',gsettings.toolbar1visible);
  OldIniFile.WriteBool('ToolBars','HtmlBar',gsettings.htmlbar1visible);
  OldIniFile.WriteBool('ToolBars','EditBar',gsettings.editbar1visible);
  OldIniFile.WriteBool('Edit','LineNums',gsettings.LineNumbers);
  OldIniFile.WriteInteger('Options','WindowState',gsettings.MainFormWindowState);
  OldIniFile.WriteInteger('Options','windowX',gsettings.MainFormLeft);
  OldIniFile.WriteInteger('Options','windowY',gsettings.MainFormTop);
  OldIniFile.WriteInteger('Options','windowW',gsettings.MainFormwidth);
  OldIniFile.WriteInteger('Options','windowH',gsettings.MainFormHeight);
  OldIniFile.WriteString('Options','DateFmt',gsettings.dateFmt);
  OldIniFile.WriteString('Options','TimeFmt',gsettings.timeFmt);
  OldIniFile.WriteString('Options','DateTimeFmt',gsettings.datetimeFmt);
  OldIniFile.WriteInteger('Options','SaveType',gsettings.SaveType);
  OldIniFile.WriteBool('Options','HideSideBar',gsettings.HideSideBar);
  OldIniFile.WriteBool('Edit','AutoIndent',gsettings.AutoIndent);
  OldIniFile.WriteBool('Edit','TabsToSpaces',gsettings.TabsToSpaces);
  OldIniFile.WriteBool('Edit','WordWrap',gsettings.WordWrap);
  OldIniFile.WriteInteger('Options','SideBarWidth',240);
  OldIniFile.WriteString('Options','SynHTMLSynFilter',gsettings.SynHTMLSyn1Filter);
  OldIniFile.WriteString('Options','SynPHPSynFilter',gsettings.SynPHPSyn1Filter);
  OldIniFile.WriteString('Options','SynXMLSynFilter',gsettings.SynXMLSyn1Filter);
  OldIniFile.WriteString('Options','SynCSSSynFilter',gsettings.SynCSSSyn1Filter);
  OldIniFile.WriteString('Options','SynJSSynFilter',gsettings.SynJSSyn1Filter);
  OldIniFile.WriteString('Options','SynSQLSynFilter',gsettings.SynSQLSyn1Filter);
  OldIniFile.WriteString('Options','SynMultiSynFilter',gsettings.SynMultiSyn1Filter);
  OldIniFile.WriteString('Options','Assoc',gsettings.assoc);
  OldIniFile.WriteString('Options','ActiveLineColor',gsettings.activeLineColor);
  OldIniFile.WriteString('Options','Encoding',gsettings.Encoding);
  gsettings.writeProjHistory;
end;

procedure SaveIniFile(filename:string);
begin
  if not assigned(IniFile) then begin
    iniFilename:=filename;
    IniFile:=TIniFile.Create(IniFileName);
  end;
  IniFile.WriteInteger('Edit','Edge',settings.UpDown1Position);
  IniFile.WriteString('Options','Font',settings.DemoEditFontName);
  IniFile.WriteBool('Options', 'Highlight', settings.BracesChecked);
  IniFile.WriteBool('Options', 'SaveSession', settings.SaveSessionChecked);
  IniFile.WriteString('Options', 'DialogFont', settings.DialogFontText);
  IniFile.WriteString('Options', 'ExternPath', settings.externPath);
  iniFile.WriteString('Options','LocalPath',settings.localpathText);
  iniFile.WriteString('Options','LocalPort',settings.localPortText);
  iniFile.WriteString('Options','FTPcfname',settings.FTPcfname);
  iniFile.WriteBool('Options','FTPPassive',settings.FTPPassive);
  iniFile.WriteString('Options','FTPHost',settings.FTPHostText);
  iniFile.WriteString('Options','FTPPort',settings.FTPPortText);
  iniFile.WriteString('Options','FTPUser',settings.FTPUserText);
  iniFile.WriteString('Options','FTPServerPath',settings.FTPServerPathText);
  IniFile.WriteBool('Registry', 'multi', settings.regMultiChecked);
  IniFile.WriteString('Options','Parameters',settings.Params);
  iniFile.WriteString('Options', 'FindText', settings.FindDialog1FindText);
  iniFile.WriteString('Options', 'ReplaceText', settings.ReplaceDialog1FindText);
  IniFile.WriteInteger('Session', 'Active', settings.SessionActive);
  IniFile.WriteString('UPDATE', 'Version',settings.version);
  IniFile.WriteString('UPDATE', 'Download', settings.DSiteText );
  IniFile.WriteString('UPDATE', 'Description', settings.Description);
  IniFile.WriteString('Options', 'BrowserPath',settings.BrowserPath);
  IniFile.WriteString('Options', 'InternBrowser',settings.InternBrowser);
  settings.writeHistory();
  settings.writeSession();
  settings.writeExternals();
end;

procedure clearToolbars;
begin
  oldinifile.EraseSection('TBToolbar2Options');
  oldinifile.EraseSection('TBToolbar2DefaultOptions');
  oldinifile.EraseSection('TBToolbar2DefaultButtons');
  oldinifile.EraseSection('TBToolbar2Buttons');
  oldinifile.EraseSection('TBToolbar3Options');
  oldinifile.EraseSection('TBToolbar3DefaultOptions');
  oldinifile.EraseSection('TBToolbar3DefaultButtons');
  oldinifile.EraseSection('TBToolbar3Buttons');
  oldinifile.EraseSection('TBToolbar4Options');
  oldinifile.EraseSection('TBToolbar4DefaultOptions');
  oldinifile.EraseSection('TBToolbar4DefaultButtons');
  oldinifile.EraseSection('TBToolbar4Buttons');
end;

procedure CreateHighlighters( SynPHPSyn:TSynPHPSyn;
                              SynCSSSyn:TSynCssSyn;
                              SynJScriptSyn:TSynJScriptSyn;
                              SynSQLSyn:TSynSQLSyn;
                              SynMulti:TSynMultiSyn;
                              SynHTML:TSynHTMLSyn;
                              SynXMLSyn:TSynXMLSyn);
begin
  LoadSynEditFromFile('PHP.ini',SynPHPSyn);
  LoadSynEditFromFile('CSS.ini',SynCSSSyn);
  LoadSynEditFromFile('JS.ini',SynJScriptSyn);
  LoadSynEditFromFile('SQL.ini',SynSQLSyn);
  LoadSynEditFromFile('XML.ini',SynXMLSyn);
  LoadSynEditFromFile('HTML.ini',SynHTML);
  LoadSynEditFromFile('Multi.ini',SynMulti);
end;

procedure SaveHighlighters( SynPHPSyn:TSynPHPSyn;
                              SynCSSSyn1:TSynCssSyn;
                              SynJScriptSyn1:TSynJScriptSyn;
                              SynSQLSyn1:TSynSQLSyn;
                              SynMulti:TSynMultiSyn;
                              SynHTML:TSynHTMLSyn;
                              SynXMLSyn:TSynXMLSyn);
begin
  SaveSynEditToFile('PHP.ini',SynPHPSyn);
  SaveSynEditToFile('CSS.ini',SynCSSSyn1);
  SaveSynEditToFile('JS.ini',SynJScriptSyn1);
  SaveSynEditToFile('SQL.ini',SynSQLSyn1);
  SaveSynEditToFile('XML.ini',SynXMLSyn);
  SaveSynEditToFile('HTML.ini',SynHTML);
  SaveSynEditToFile('Multi.ini',SynMulti);
end;

procedure SaveSynEditToFile(IniFileName:string;DemoSyn:TSynCustomHighlighter);
var i:integer;
    ifile:TIniFile;
    fname:string;
begin
  Fname:=getAppFolder()+'\devphp\'+IniFileName;
  ifile:=TIniFile.Create(Fname);
  if assigned(DemoSyn) then
    for i:=0 to DemoSyn.AttrCount-1 do begin
      DemoSyn.Attribute[i].SaveToFile(ifile);
      ifile.WriteString(DemoSyn.Attribute[i].Name,'nr',inttostr(i));
    end;
  ifile.Free;
end;

procedure LoadSynEditFromFile(IniFileName:string;DemoSyn:TSynCustomHighlighter);
var i,nr:integer;
    ifile:TIniFile;
    fname:string;
begin
  Fname:=getAppFolder()+'\devphp\'+IniFileName;
  ifile:=TIniFile.Create(Fname);
  if assigned(DemoSyn) then
    for i:=0 to DemoSyn.AttrCount-1 do begin
      nr:=strtoint(ifile.ReadString(DemoSyn.Attribute[i].Name,'nr','-1'));
      if i=nr then DemoSyn.Attribute[i].LoadFromFile(ifile);
    end;
  ifile.Free;
end;

procedure freeIniFile;
begin
  if assigned(IniFile) then IniFile.Free;
  if assigned(Settings) then Settings.free;
  if assigned(OldIniFile) then OldInifile.Free;
  if assigned(GSettings) then GSettings.Free;
end;

{ TSettings }

procedure TSettings.wBracesChecked(const Value: boolean);
begin
  fBracesChecked:=Value;
  IniFile.WriteBool('Options', 'Highlight', Value);
end;

procedure TGlobSettings.wDemoEditColor(const Value: integer);
begin
  fDemoEditColor:=Value;
  OldIniFile.WriteInteger('Edit','Color',Value);
end;

procedure TSettings.wDemoEditFontName(const Value: string);
begin
  fDemoEditFontName:=value;
  IniFile.WriteString('Options','Font',value);
end;

procedure TSettings.wDialogFontText(const Value: string);
begin
  fDialogFontText:=value;
  IniFile.WriteString('Options','DialogFont',value);
end;

procedure TGlobSettings.wdl(const Value: string);
begin
  fdl := Value;
  OldIniFile.WriteString('Documentation','Lang',value);
end;

procedure TGlobSettings.wDocsPathText(const Value: string);
begin
  fDocsPathText := Value;
  OldIniFile.WriteString('Documentation','Filename',value);
end;

procedure TGlobSettings.wEdit1Text(const Value: string);
begin
  fEdit1Text:=value;
  OldInifile.WriteString('Options','Parser',value);
end;

procedure TGlobSettings.wEditorFontText(const Value: string);
begin
  fEditorFontText:=value;
  OldInifile.WriteString('Options','Font',value);
end;

procedure TSettings.wFTPcfname(const Value: string);
begin
  fFTPcfname:=value;
  inifile.WriteString('Options','FTPcfname',value);
end;

procedure TSettings.wFTPpassive(const Value: boolean);
begin
  fFTPpassive:=value;
  inifile.WriteBool('Options','FTPPassive',value);
end;

procedure TSettings.wFTPHostText(const Value: string);
begin
  fFTPHosttext:=value;
  inifile.WriteString('Options','FTPHost',value);
end;

procedure TSettings.wFTPPortText(const Value: string);
begin
  fFtpPortText:=value;
  inifile.WriteString('Options','FTPPort',value);
end;

procedure TSettings.wFTPServerPathText(const Value: string);
begin
  fFTPServerPathText:=value;
  iniFile.WriteString('Options','FTPServerPath',value);
end;

procedure TSettings.wFTPUserText(const Value: string);
begin
  fFTPUserText:=value;
  iniFile.WriteString('Options','FTPUser',value);
end;

procedure TGlobSettings.wIdiomaText(const Value: string);
begin
  fIdiomaText:=value;
  OldiniFile.WriteString('Options','LangFile',value);
end;

procedure TSettings.wlocalpathText(const val: string);
begin
  flocalpathText:=val;
  iniFile.WriteString('Options','LocalPath',val);
end;

procedure TSettings.wlocalPortText(const Value: string);
begin
  flocalPortText:=value;
  iniFile.WriteString('Options','LocalPort',value);
end;

procedure TSettings.wParams(const Value: string);
begin
  fParams := Value;
  iniFile.WriteString('Options','Parameters',value);
end;

procedure TSettings.wFindDialog1FindText(const Value: string);
begin
  fFindDialog1FindText := Value;
  iniFile.WriteString('Options', 'FindText', value);
end;

procedure TSettings.wReplaceDialog1FindText(const Value: string);
begin
  fReplaceDialog1FindText := Value;
  iniFile.WriteString('Options', 'ReplaceText', value);
end;

procedure TSettings.wregMultiChecked(const Value: boolean);
begin
  fregMultiChecked := Value;
  iniFile.WriteBool('Registry','multi',value);
end;

procedure TSettings.wSaveSessionChecked(const Value: boolean);
begin
  fSaveSessionChecked:=value;
  iniFile.WriteBool('Options','SaveSession',value);
end;

procedure TSettings.wUpDown1Position(const Value: integer);
begin
  fUpDown1Position:=value;
  inifile.WriteInteger('Edit','Edge',value);
end;

procedure TGlobSettings.wUpDown2Position(const Value: integer);
begin
  fUpDown2Position:=value;
  oldIniFile.WriteInteger('Edit','Size',value);
end;

procedure TGlobSettings.wUpDown3Position(const Value: integer);
begin
  fUpDown3Position:=value;
  OldIniFile.WriteInteger('Edit','Tab',Value);
end;

procedure TGlobSettings.wUpDown4Position(const Value: integer);
begin
  fUpDown4Position := Value;
  OldIniFile.WriteInteger('Options','FunctionBrowser',Value);
end;

procedure TGlobSettings.wMainFormWindowState(const Value: integer);
begin
  fMainFormWindowState := Value;
  OldIniFile.WriteInteger('Options','WindowState',value);
end;

procedure TGlobSettings.wMainFormLeft (const Value: integer);
begin
  fMainFormLeft := Value;
  OldIniFile.WriteInteger('Options','windowX',value);
end;

procedure TGlobSettings.wMainFormTop (const Value: integer);
begin
  fMainFormTop := Value;
  OldIniFile.WriteInteger('Options','windowY',value);
end;

procedure TGlobSettings.wMainFormwidth (const Value: integer);
begin
  fMainFormwidth := Value;
  OldIniFile.WriteInteger('Options','windowW',value);
end;

procedure TGlobSettings.wMainFormHeight (const Value: integer);
begin
  fMainFormHeight := Value;
  OldIniFile.WriteInteger('Options','windowH',value);
end;

procedure TSettings.wVersion(const Value: string);
begin
  fVersion:=value;
  iniFile.WriteString('UPDATE','Version',value);
end;

procedure TSettings.wExternPath(const Value: string);
begin
  fExternPath:=value;
  iniFile.WriteString('Options','ExternPath',value);
end;

procedure TSettings.wDSiteText(const Value: string);
begin
  fDSiteText:=value;
  iniFile.WriteString('UPDATE','Download',value);
end;

procedure TSettings.wDescription(const Value: string);
begin
  fDescription:=value;
  iniFile.WriteString('UPDATE','Description',value);
end;

procedure TGlobSettings.wStatusBar1visible(const Value: boolean);
begin
  fStatusBar1visible:=value;
  OldiniFile.WriteBool('Toolbars','StatusBar',value);
end;

procedure TGlobSettings.wToolBar1visible(const Value: boolean);
begin
  fToolBar1visible:=value;
  OldiniFile.WriteBool('Toolbars','ToolBar',value);
end;

procedure TGlobSettings.whtmlbar1visible(const Value: boolean);
begin
  fhtmlbar1visible:=value;
  OldiniFile.WriteBool('Toolbars','HtmlBar',value);
end;

procedure TGlobSettings.weditbar1visible(const Value: boolean);
begin
  feditbar1visible:=value;
  OldiniFile.WriteBool('Toolbars','EditBar',value);
end;

procedure TGlobSettings.wLineNumbers(const Value: boolean);
begin
  fLineNumbers:=value;
  OldiniFile.WriteBool('Edit','LineNums',value);
end;

procedure TSettings.wSessionActive(const Value: integer);
begin
  fSessionActive:=value;
  iniFile.WriteInteger('Session','Active',value);
end;

procedure TGlobSettings.clearProjHistory;
begin
  fprojhistory.Clear
end;

procedure TSettings.clearHistory;
begin
  fhistory.clear;
end;

procedure TSettings.writeStrings(list:TStrings;bezeichnung:string);
var i:integer;
begin
  inifile.EraseSection(bezeichnung);
  inifile.WriteInteger(bezeichnung,'Last',list.count);
  if list.count=0 then exit;
  for i:=0 to list.count-1 do begin
    inifile.WriteString(bezeichnung,inttostr(i+1),list[i]);
  end;
end;

procedure TGlobSettings.writeStrings(list:TStrings;bezeichnung:string);
var i:integer;
begin
  oldinifile.EraseSection(bezeichnung);
  oldinifile.WriteInteger(bezeichnung,'Last',list.count);
  if list.count=0 then exit;
  for i:=0 to list.count-1 do begin
    oldinifile.WriteString(bezeichnung,inttostr(i+1),list[i]);
  end;
end;

procedure TSettings.writeHistory;
begin
  writeStrings(history,'History');
end;

procedure TGlobSettings.writeProjHistory;
begin
  writeStrings(projhistory,'ProjectHistory');
end;

procedure TSettings.writeExternals;
var i2,i:integer;
    st:TStringList;
begin
  st:=TStringList.Create;
  i:=fexternals.count-1;
  while i>0 do begin
    i2:=fexternals.count-1;
    while i2>0  do begin
      if (i2<>i) and (fexternals[i]=fexternals[i2]) then begin
        fexternals.Delete(i);  dec(i);
      end;
      dec(i2);
    end;
    dec(i);
    if i>fexternals.count-1 then i:=fexternals.count-1;
  end;
  inifile.EraseSection('Externals');
  inifile.WriteInteger('Externals','Last',fexternals.count);
  if fexternals.count=0 then exit;
  for i2:=0 to fexternals.count-1 do begin
    st.Clear;
    split2(fexternals.Strings[i2],'=',st);
    inifile.WriteString('Externals','Name'+inttostr(i2+1), st[0]);
    inifile.WriteString('Externals','Prg'+inttostr(i2+1),st[1]);
  end;
  st.Free;
end;

procedure TSettings.writeSession;
var lauf:integer;
begin
  inifile.EraseSection('Session');
  inifile.WriteInteger('Session','Last',fSession.count);
  if fSession.count=0 then exit;
  for lauf:=1 to fSession.count do begin
    inifile.WriteString('Session',inttostr(lauf),fSession[lauf-1]);
  end;
end;

constructor TSettings.Create();
begin
  inherited create();
  fHistory:=TStringList.Create;
  fHistory.Duplicates:=dupIgnore;
  fSession:=TStringList.Create;
  fExternals:=TStringList.Create;
  fExternals.Duplicates:=dupIgnore;
end;

destructor TSettings.Destroy;
begin
  fHistory.Destroy;
  fSession.Destroy;
  fExternals.Destroy;
  inherited Destroy;
end;

procedure TSettings.wBrowserPath(const value: string);
begin
  fBrowserPath:=value;
  IniFile.WriteString('Options','BrowserPath',value);
end;

procedure TSettings.wFTPPasswordSave(const Value: string);
var Cipher: TDCP_rc4;
    s:string;
begin
  fFTPPasswordSave:=value;
  if Value<>'' then begin
    Cipher:= TDCP_rc4.Create(nil);
    Cipher.InitStr(KeyStr,TDCP_sha1);         // initialize the cipher with a hash of the passphrase
    s:= Cipher.EncryptString(value);
    Cipher.Burn;
    Cipher.Free;
    iniFile.WriteString('Options','FTPPasswordSave',s);
  end;
end;

function TSettings.ReadPw():string;
var
  Cipher: TDCP_rc4;
  s,s1:string;
begin
  s:='';
  s1:=IniFile.ReadString('Options','FTPPasswordSave','');
  if s1<>'' then begin
    Cipher:= TDCP_rc4.Create(nil);
    Cipher.InitStr(KeyStr,TDCP_sha1);         // initialize the cipher with a hash of the passphrase
    s:= Cipher.DecryptString(s1);
    Cipher.Burn;
    Cipher.Free;
  end;
  result:=s;
end;

procedure TSettings.wInternBrowser(const Value: String);
begin
  fInternBrowser := Value;
  IniFile.WriteString('Options','InternBrowser',value);
end;

{ TGlobSettings }

constructor TGlobSettings.Create;
begin
  inherited;
    fProjHistory:=TStringList.Create;
    fProjHistory.Duplicates:=dupIgnore;
end;

destructor TGlobSettings.Destroy;
begin
  inherited;
  fProjHistory.Destroy;
end;

procedure TGlobSettings.wLastProject(const Value: string);
begin
  fLastProject:=value;
  OldiniFile.WriteString('Projects','Last',value);
end;

procedure TGlobSettings.wDateFmt(const Value: string);
begin
  fDateFmt:=value;
  OldiniFile.WriteString('Options','DateFmt',value);
end;

procedure TGlobSettings.wTimeFmt(const Value: string);
begin
  fTimeFmt:=value;
  OldiniFile.WriteString('Options','TimeFmt',value);
end;

procedure TGlobSettings.wDateTimeFmt(const Value: string);
begin
  fDateTimeFmt:=value;
  OldiniFile.WriteString('Options','DateTimeFmt',value);
end;

procedure TGlobSettings.wSaveType(const Value: integer);
begin
  fSaveType:=value;
  OldiniFile.WriteInteger('Options','SaveType',value);
end;

procedure TGlobSettings.wHideSideBar(const Value: boolean);
begin
  fHideSideBar:=value;
  OldiniFile.WriteBool('Options','HideSideBar',value);
end;

procedure TGlobSettings.wAutoIndent(const Value: boolean);
begin
  fAutoIndent:=value;
  OldiniFile.WriteBool('Edit','AutoIndent',value);
end;

procedure TGlobSettings.wWordWrap(const Value: boolean);
begin
  fWordWrap:=value;
  OldiniFile.WriteBool('Edit','WordWrap',value);
end;

procedure TGlobSettings.wSideBarWidth(const Value: integer);
begin
  fSideBarWidth:=value;
  OldiniFile.WriteInteger('Options','SideBarWidth',value);
end;

procedure TGlobSettings.wDockSideBar(const Value: string);
begin
  fDockSideBar:=value;
  OldiniFile.WriteString('Options','DockSideBar',value);
end;

procedure TGlobSettings.wSynHTMLSyn1Filter(const Value: string);
begin
  fSynHTMLSyn1Filter:=value;
  OldiniFile.WriteString('Options','SynHTMLSynFilter',value);
end;

procedure TGlobSettings.wSynPHPSyn1Filter(const Value: string);
begin
  fSynPHPSyn1Filter:=value;
  OldiniFile.WriteString('Options','SynPHPSynFilter',value);
end;

procedure TGlobSettings.wSynXMLSyn1Filter(const Value: string);
begin
  fSynXMLSyn1Filter:=value;
  OldiniFile.WriteString('Options','SynXMLSynFilter',value);
end;

procedure TGlobSettings.wSynCSSSyn1Filter(const Value: string);
begin
  fSynCSSSyn1Filter:=value;
  OldiniFile.WriteString('Options','SynCSSSynFilter',value);
end;

procedure TGlobSettings.wSynJSSyn1Filter(const Value: string);
begin
  fSynJSSyn1Filter:=value;
  OldiniFile.WriteString('Options','SynJSSynFilter',value);
end;

procedure TGlobSettings.wSynSQLSyn1Filter(const Value: string);
begin
  fSynSQLSyn1Filter:=value;
  OldiniFile.WriteString('Options','SynSQLSynFilter',value);
end;

procedure TGlobSettings.wSynMultiSyn1Filter(const Value: string);
begin
  fSynMultiSyn1Filter:=value;
  OldiniFile.WriteString('Options','SynMultiSynFilter',value);
end;

procedure TGlobSettings.wAssoc(const Value: string);
begin
  fassoc:=value;
  OldiniFile.WriteString('Options','Assoc',value);
end;

procedure TGlobSettings.wPHPInifile(const Value: string);
begin
  fPHPIniFile := Value;
  OldiniFile.WriteString('Options','IniFile',value);
end;

procedure TGlobSettings.wActiveLineColor(const Value: string);
begin
  fActiveLineColor := Value;
  OldiniFile.WriteString('Options','ActiveLineColor',value);
end;

procedure TGlobSettings.wTabsToSpaces(const Value: boolean);
begin
  fTabsToSpaces := Value;
  OldiniFile.WriteBool('Edit','TabsToSpaces',value);
end;

procedure TGlobSettings.wEncoding(const Value: String);
begin
  fEncoding := Value;
  OldiniFile.WriteString('Options','Encoding',value);
end;

procedure TGlobSettings.wBOM(const Value: boolean);
begin
  fBOM := Value;
  OldiniFile.WriteBool('Options','BOM',value);
end;

end.
