//
// +----------------------------------------------------------------------+
// | Dev-PHP - Integrated Development Environment                         |
// +----------------------------------------------------------------------+
// | Copyright (C) 2002-2003, http://devphp.sourceforge.net               |
// +----------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify |
// | it under the terms of the GNU General Public License as published by |
// | the Free Software Foundation; either version 2 of the License, or    |
// | (at your option) any later version.                                  |
// | This program is distributed in the hope that it will be useful       |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of       |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         |
// | GNU General Public License for more details.                         |
// +----------------------------------------------------------------------+
// | Author: Leonardo Garca <simbiotik@users.sourceforge.net>            |
// +----------------------------------------------------------------------+
//
unit uLang;

interface

uses SysUtils,IniFiles,uIniFile,Forms;

function Lang(id: integer):string;

var
  langFileName:string;
  LangFile : TIniFile;

implementation

function geterr(id: integer;msg:string):string;
begin
  if assigned(LangFile) then begin
    result:=langFile.ReadString('Lang',IntToStr(id),msg);
  end else begin
    result:=msg;
  end;
end;

function Lang(id: integer): string;
var
  msg, IDx : string;
  res:string;

begin
  IDx := IntToStr(id);
  msg := '<ERR: ' + IDx + '>';
  if not assigned(LangFile) then begin
      LangFile:=TIniFile.Create(ExtractFilePath(application.exename)+'\lang\english.lng');
  end;
  res := LangFile.ReadString('Lang',IDx,msg);
  if res=msg then
    res:='! '+geterr(id,msg);
  result:=res;
end;

end.
