unit WebServ;

interface

uses
  Forms, Windows, Messages, SysUtils, Classes, IdBaseComponent, IdComponent,
  IdCustomHTTPServer,IdHTTPServer, idGlobal, dialogs, SyncObjs,ActiveX,SHDocVw;

type
  TCompileProc=function (debugStr:string):string of object;
  TVarProc=procedure(modus:string;name:string;value:string) of object;

  TStatus=(startup,header,body,shutdown);
  TWebServ = class(TIdHTTPServer)
  private
    Fport: integer;
    FRootPath: string;
    FPHPExe: string;
    FFilename: string;
    Fstatus: TStatus;
    FRequestInfo: TIdHTTPRequestInfo;
    Foutput: String;
    procedure Setport(const Value: integer);
    procedure SetRootPath(const Value: string);
    procedure SetPHPExe(const Value: string);
    procedure SetFilename(const Value: string);
    procedure Setstatus(const Value: TStatus);
    procedure SetRequestInfo(const Value: TIdHTTPRequestInfo);
    procedure Setoutput(const Value: String);
    { Private-Deklarationen }
  protected
    { Protected-Deklarationen }
  public
  published
    property port:integer read Fport write Setport;
    property RootPath:string read FRootPath write SetRootPath;
    property PHPExe:string read FPHPExe write SetPHPExe;
    property Filename:string read FFilename write SetFilename;
    property status:TStatus read Fstatus write Setstatus;
    property output:String read Foutput write Setoutput;
    property RequestInfo:TIdHTTPRequestInfo read FRequestInfo write SetRequestInfo;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Beispiele', [TWebServ]);
end;

function GetShortName(sLongName: string): string;
var
  sShortName:    string;
  nShortNameLen: Integer;
begin
  SetLength(sShortName, MAX_PATH);
  nShortNameLen := GetShortPathName(PChar(sLongName), PChar(sShortName), MAX_PATH - 1);
  if (0 = nShortNameLen) then
  begin
    // handle errors...
  end;
  SetLength(sShortName, nShortNameLen);
  Result := sShortName;
end;

{ TWebServ }

procedure TWebServ.SetFilename(const Value: string);
begin
  FFilename := Value;
end;

procedure TWebServ.Setoutput(const Value: String);
begin
  Foutput := Value;
end;

procedure TWebServ.SetPHPExe(const Value: string);
begin
  FPHPExe := Value;
end;

procedure TWebServ.Setport(const Value: integer);
begin
  Fport := Value;
end;

procedure TWebServ.SetRequestInfo(const Value: TIdHTTPRequestInfo);
begin
  FRequestInfo := Value;
end;

procedure TWebServ.SetRootPath(const Value: string);
begin
  FRootPath := Value;
end;

procedure TWebServ.Setstatus(const Value: TStatus);
begin
  Fstatus := Value;
end;

end.






