;;; dic-lookup-w3m-zh.el --- look up dictionaries on the Internet

;; Copyright (C) 2009, 2010  mcprvmec

;; Author: mcprvmec

;; This file is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This file is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
;; Boston, MA 02110-1301, USA.

;;; Commentary:

;; Look up in dictionaries on the Internet using emacs-w3m.

;;; Code:

;; $AJ5$BNc(B

(mapc
 '(lambda (elem) (add-to-list 'dic-lookup-w3m-search-engine-alist elem))
 '(("cc-baidu"
    "http://baike.baidu.com/w?ct=17&lm=0&tn=baiduWikiSearch&pn=0&rn=10&word=%s&submit=search" gb2312)
   ("cc-5156edu-post" "http://xh.5156edu.com/index.php" gb2312
    "f_key=%s&f_type=zi")
   ("cc-5156edu" "http://xh.5156edu.com/index.php?f_key=%s&f_type=zi" gb2312)
   ("cc-thefreedictionary"
    "http://www.thefreedictionary.com/e/%s" utf-8)
   ;;("cc-thefreedictionary"
   ;; "http://www.thefreedictionary.com/_/search.aspx?tab=-11&charset=utf-8&SearchBy=0&TFDBy=2&Word=%s" utf-8)
   ("ce-ichiba" "http://www.iciba.com/%s" utf-8)
   ("ec-ichiba" "http://www.iciba.com/%s" utf-8)
   ("cc-hanzi-zdic-post" "http://www.zdic.net/zd/search/default.asp" utf-8
    "lb=1&q=%s")
   ("cc-hanzi-zdic"
    "http://www.zdic.net/zd/search/default.asp?lb=1&q=%s" utf-8)
   ))


(defvar dic-lookup-w3m-filter-do-show-candidates-heading " $B8u$A29(B: ")

(defvar dic-lookup-w3m-filter-related-links-heading " $A9XA*(B: ")

(defvar dic-lookup-w3m-favorite-ej-engine "ec-ichiba")

(eval-after-load "w3m-filter"
  '(mapc
    '(lambda (elem)
       (add-to-list 'w3m-filter-rules elem))
    (reverse
     `(
       ("\\`http://baike\\.baidu\\.com/"
	dic-lookup-w3m-filter-related-links "cc-baidu" cc)

       ("\\`http://www\\.thefreedictionary\\.com/"
	dic-lookup-w3m-filter-related-links "cc-thefreedictionary" cc)

       ("\\`http://www\\.iciba\\.com/"
	(w3m-filter-delete-regions "<body[^>]*>" "<div id=\"content\">" t t t)
	(dic-lookup-w3m-filter-related-links "ce-ichiba" cc)
	(dic-lookup-w3m-filter-show-candidates "ec-ichiba")
       	(dic-lookup-w3m-filter-eword-anchor dic-lookup-w3m-favorite-ej-engine)
	(dic-lookup-w3m-filter-convert-phonetic-symbol
	 dic-lookup-w3m-filter-ichiba-symbol-alist
	 "<img src=\"/images/\\([a-z0-9_]+\\)\\.gif\"[^>]*>")
	)
       ))))

(add-to-list
 'dic-lookup-w3m-related-site-list
 '(cc
   (("cc-baidu" . "baidu")
    ("cc-5156edu" . "5156edu")
    ("cc-thefreedictionary" . "thefreedictionary")
    ("ce-ichiba" . "ichiba")
    ("cc-hanzi-zdic" . "zdic"))))

(defvar dic-lookup-w3m-filter-ichiba-symbol-alist
  '(("dict_icon" . "-")
    ("close" . "")
    ("open" . "")
    ("display" . "")
    ("display1" . "")
    ("dot" . "*")))

;; http://baike.baidu.com/ $AOV$BBe$A::So4J$BE5(B $BBh8^HG!#Cf9q<R2q2J3X1!8@8l8&5f=jJT!$>&L30u=q4[=PHG(B
;; http://xh.5156edu.com/
;; http://zh.thefreedictionary.com/
;; http://www.iciba.com/
;; http://www.zdic.net/

(provide 'dic-lookup-w3m-zh)

;;; dic-lookup-w3m-zh.el ends here.
