#include "DicBook.h"
#include "DicHook.h"
#include <eb/error.h>
#include <eb/text.h>
#include <wx/filename.h>

#define MAXLEN_HEADING 127
#define MAXLEN_TEXT 1023

int DicBook::m_count = 0;

/**
 * RXgN^
 */
DicBook::DicBook() :
	m_convEuc(wxT("EUC-JP")),
	m_searchMethod(DicBook::SEARCH_WORD)
{
	m_index = m_count++;
    ::eb_initialize_book(&m_book);
}

/**
 * fXgN^
 */
DicBook::~DicBook()
{
	::eb_finalize_book(&m_book);
}

/**
 * EB_Book̃|C^擾
 */
EB_Book* DicBook::GetEbBook()
{
	return &m_book;
}

/**
 * CfbNX擾
 */
int DicBook::GetIndex() 
{
	return m_index;
}

/**
 * \bhݒ
 */
void DicBook::SetSearchMethod(int method)
{
	m_searchMethod = method;
}

/**
 * {oCh
 */
void DicBook::Bind(const wxString& path)
{
	// pXݒ肷B
	m_path = path;
	
	// {[ݒ肷B
    wxFileName fn(path);
    fn.MakeAbsolute();
    m_vol = fn.GetVolume();
	
	CheckCurVol();
	
	// oChB
    EB_Error_Code ebErr = ::eb_bind(&m_book,
    						fn.GetFullPath(wxPATH_UNIX).mb_str());
    if (ebErr != EB_SUCCESS) {
        return;
    }

    // {̈ꗗ擾B
    ebErr = ::eb_subbook_list(&m_book, m_subbooks, &m_subbookCount);
    if (ebErr != EB_SUCCESS) {
        return;
    }
}

/**
 * {ݒ
 */
void DicBook::SetSubbook(EB_Subbook_Code code)
{
	CheckCurVol();

    EB_Error_Code ebErr = ::eb_set_subbook(&m_book, code);
    if (ebErr != EB_SUCCESS) {
        return;
    }
}

/**
 * {(̃R[h)擾
 */
EB_Subbook_Code DicBook::GetSubbook()
{
	CheckCurVol();
	
	EB_Subbook_Code code;
    ::eb_subbook(&m_book, &code);
    return code;
}

/**
 * {̑薼擾
 */
wxString DicBook::GetSubbookTitle()
{
	CheckCurVol();
	
    EB_Error_Code ebErr;
    
    char title[EB_MAX_TITLE_LENGTH + 1];
	ebErr = ::eb_subbook_title(&m_book, title);
    return wxString(title, m_convEuc);
}

/**
 * 
 */
int DicBook::Search(const wxString& key, DicHits& hits)
{
	CheckCurVol();
	
    EB_Error_Code ebErr;

	EB_Hit ebHits[100];
	int count;
	int total = 0;
	
	for (int i = 0; i < m_subbookCount; ++i) {
		// {ݒ肷B
	    ebErr = ::eb_set_subbook(&m_book, m_subbooks[i]);
	    if (ebErr != EB_SUCCESS) {
	        continue;
	    }
	    
	    // Pꌟ̃NGXg𑗏oB
	    switch (m_searchMethod) {
	    case SEARCH_WORD:
	    	if (!::eb_have_word_search(&m_book)) {
	    		continue;
	    	}
	    	ebErr = ::eb_search_word(&m_book, key.mb_str(m_convEuc));
	    	break;
		case SEARCH_END_WORD:
	    	if (!::eb_have_endword_search(&m_book)) {
	    		continue;
	    	}
	    	ebErr = ::eb_search_endword(&m_book, key.mb_str(m_convEuc));
			break;
		case SEARCH_EXACT_WORD:
	    	if (!::eb_have_exactword_search(&m_book)) {
	    		continue;
	    	}
	    	ebErr = ::eb_search_exactword(&m_book, key.mb_str(m_convEuc));
			break;
		case SEARCH_KEYWORD:
		case SEARCH_CROSS:
		case SEARCH_MULTI:
	    default:
	    	return 0;
	    }
	    if (ebErr != EB_SUCCESS) {
	        continue;
	    }
	
		DicHits tmpHits;
	
	    // qbgGg擾B
	    for (;;) {
			ebErr = ::eb_hit_list(&m_book, 100, ebHits, &count);
		    if (ebErr != EB_SUCCESS || !count) {
		        break;
		    }
		    for (int j = 0; j < count; ++j) {
		    	DicHit* hit = new DicHit(this, m_subbooks[i], ebHits[j]);
		    	if (tmpHits.Exists(hit)) {
		    		delete hit;
		    	} else {
		    		tmpHits.Add(hit);
		    		++total;
		    	}
		    }
	    }
		
    	WX_APPEND_ARRAY(hits, tmpHits)		
	}
    
    return total;
}

/**
 * o擾
 */
wxString DicBook::GetHeading(EB_Position* pos)
{
    EB_Error_Code ebErr;
    char heading[MAXLEN_HEADING + 1];
    ssize_t headingLength;
    
	CheckCurVol();
	
    // öʒuֈړB
    ebErr = ::eb_seek_text(&m_book, pos);
    if (ebErr != EB_SUCCESS) {
        return wxT("");
    }

	wxString str;
	
    // o擾B
    for (;;) {
	    ebErr = ::eb_read_heading(&m_book, NULL, NULL, NULL,
	        MAXLEN_HEADING, heading, &headingLength);
	    if (ebErr != EB_SUCCESS) {
	        return wxT("");
	    }
	    if (headingLength == 0) {
	    	break;
	    }
	    str += wxString(heading, m_convEuc);
    }
    
    return str;
}

/**
 * eLXgf[^擾
 */
wxString DicBook::GetText(EB_Position* pos)
{
    EB_Error_Code ebErr;
    char text[MAXLEN_TEXT + 1];
    ssize_t textLength;
    
	CheckCurVol();
	
    // eLXgf[^̈ʒuֈړB
    ebErr = ::eb_seek_text(&m_book, pos);
    if (ebErr != EB_SUCCESS) {
        return wxT("");
    }

	wxString str;
	
	for (int i = 0; i < 20; ++i) {
	    // eLXgf[^擾B
	    for (;;) {
		    ebErr = ::eb_read_text(&m_book, NULL, m_hook.GetHookset(), this,
		        MAXLEN_TEXT, text, &textLength);
		    if (ebErr != EB_SUCCESS) {
		        break;
		    }
		    if (textLength == 0) {
		    	break;
		    }
		    str += wxString(text, m_convEuc);
	    }
	    
	    // ̒P̐ֈړB
		ebErr = ::eb_forward_text(&m_book, NULL);
		if (ebErr == EB_ERR_END_OF_CONTENT) {
		    break;
		} else if (ebErr != EB_SUCCESS) {
			break;
		}
		
		m_hook.Break(&m_book);
	}
    
    return str;
}

/**
 * ݂̃{[`FbN
 */
void DicBook::CheckCurVol()
{
	// ݂̃fBNgt@Ĉ{[ȊȌꍇA
	// t@ĈfBNgɕύXB
	wxFileName fn;
	fn.SetCwd();
	if (fn.GetVolume() != m_vol) {
		::wxSetWorkingDirectory(m_path);
	}
}


