#ifndef _DICBOOK_H_
#define _DICBOOK_H_

#include <wx/string.h>
#include <wx/strconv.h>
#include <eb/eb.h>

#include "DicHits.h"
#include "DicHook.h"

/**
 * {NX
 */
class DicBook {
public:
	enum {
		SEARCH_WORD,
		SEARCH_END_WORD,
		SEARCH_EXACT_WORD,
		SEARCH_KEYWORD,
		SEARCH_CROSS,
		SEARCH_MULTI
	};
	DicBook();
	~DicBook();
	EB_Book* GetEbBook();
	int GetIndex();
	void SetSearchMethod(int method);
	void Bind(const wxString& path);
	void SetSubbook(EB_Subbook_Code code);
	EB_Subbook_Code GetSubbook();
	wxString GetSubbookTitle();
	int Search(const wxString& key, DicHits& hits);
	wxString GetHeading(EB_Position* pos);
	wxString GetText(EB_Position* pos);

private:
	void CheckCurVol();
	
private:
	static int m_count;
	int m_index;
	wxCSConv m_convEuc;
	wxString m_path;
	wxString m_vol;		// t@Ĉ{[
	int m_searchMethod;
    EB_Book m_book;
    EB_Subbook_Code m_subbooks[EB_MAX_SUBBOOKS];
    int m_subbookCount;
	DicHook m_hook;
};

#endif //_DICBOOK_H_
