#include <wx/html/m_templ.h>
#include <wx/string.h>
#include <wx/statbmp.h>
#include "DicBitmaps.h"

TAG_HANDLER_BEGIN(INDENT, "INDENT")
	TAG_HANDLER_PROC(tag)
	{
		if (!tag.HasParam(wxT("width"))) {
			return false;
		}
		int width;
		tag.GetParamAsInt(wxT("width"), &width);
        m_WParser->GetContainer()->SetIndent(
        	width * m_WParser->GetCharWidth() * 2,
        	wxHTML_INDENT_LEFT);
        return false;
	}
TAG_HANDLER_END(INDENT)

TAG_HANDLER_BEGIN(EXTCHAR, "EXTCHAR")
	TAG_HANDLER_PROC(tag)
	{
		if (!tag.HasParam(wxT("key"))) {
			return false;
		}
		wxString key = tag.GetParam(wxT("key"));
		DicBitmaps& bitmaps = DicBitmaps::Get();
		DicBitmaps::iterator it = bitmaps.find(key);
		if (it == bitmaps.end()) {
			return false;
		}
		wxWindow* wnd = new wxStaticBitmap(
			(wxWindow*)m_WParser->GetWindow(), -1, *it->second);
//		wnd->Show(true);
		m_WParser->GetContainer()->InsertCell(new wxHtmlWidgetCell(wnd));
		return false;
	}
TAG_HANDLER_END(EXTCHAR)

TAG_HANDLER_BEGIN(GRAPH, "GRAPH")
	TAG_HANDLER_PROC(tag)
	{
		if (!tag.HasParam(wxT("key"))) {
			return false;
		}
		wxString key = tag.GetParam(wxT("key"));
		DicBitmaps& bitmaps = DicBitmaps::Get();
		DicBitmaps::iterator it = bitmaps.find(key);
		if (it == bitmaps.end()) {
			return false;
		}
		wxWindow* wnd = new wxStaticBitmap(
			(wxWindow*)m_WParser->GetWindow(), -1, *it->second);
//		wnd->Show(true);
		m_WParser->GetContainer()->InsertCell(new wxHtmlWidgetCell(wnd));
		return false;
	}
TAG_HANDLER_END(GRAPH)

TAGS_MODULE_BEGIN(DicCustomTag)
	TAGS_MODULE_ADD(INDENT)
	TAGS_MODULE_ADD(EXTCHAR)
	TAGS_MODULE_ADD(GRAPH)
TAGS_MODULE_END(DicCustomTag)
