#include "DicEB.h"
#include "DicBook.h"
#include <wx/app.h>

#define MAXLEN_HEADING 127
#define MAXLEN_TEXT 1023

/**
 * RXgN^
 */
DicEB::DicEB() :
	m_searchMethod(DicBook::SEARCH_WORD)
{
}

/**
 * fXgN^
 */
DicEB::~DicEB()
{
    m_books.DeleteAll();
    
    // EB Cu̗pIB
    ::eb_finalize_library();
}

/**
 * 
 */
void DicEB::Initialize()
{
    // EB CuB
    eb_initialize_library();
}

/**
 * \bhݒ
 */
void DicEB::SetSearchMethod(int method)
{
	m_searchMethod = method;
	for (unsigned int i = 0; i < m_books.Count(); ++i) {
		m_books[i]->SetSearchMethod(method);
	}
}

/**
 * {ǉ
 */
void DicEB::AddBook(const wxString& path)
{
	DicBook* book = new DicBook;
	book->SetSearchMethod(m_searchMethod);
	book->Bind(path);
	m_books.Add(book);
}

/**
 * 
 */
int DicEB::Search(const wxString& key, DicHits& hits)
{
	int before = hits.Count();
    for (unsigned int i = 0; i < m_books.Count(); ++i) {
    	m_books[i]->Search(key, hits);
    }
    return hits.Count() - before;
}
