#include "DicBook.h"
#include "DicHit.h"

#define MAXLEN_HEADING 127
#define MAXLEN_TEXT 1023

/**
 * RXgN^
 */
DicHit::DicHit(DicBook* book, EB_Subbook_Code subbook, const EB_Hit& hit) :
	m_book(book),
	m_subbook(subbook),
	m_hit(hit)
{
}

/**
 * {̑薼擾
 */
wxString DicHit::GetSubbookTitle()
{
	m_book->SetSubbook(m_subbook);
	return m_book->GetSubbookTitle(); 
}

/**
 * o擾
 */
wxString DicHit::GetHeading()
{
	m_book->SetSubbook(m_subbook);
	return m_book->GetHeading(&m_hit.heading);
}

/**
 * eLXgf[^擾
 */
wxString DicHit::GetText()
{
	m_book->SetSubbook(m_subbook);
	return m_book->GetText(&m_hit.text);
}
	
/**
 * ==Zq
 */
bool DicHit::operator==(DicHit& hit)
{
	if (m_book == hit.m_book
		&& m_subbook == hit.m_subbook
		&& m_hit.text.page == hit.m_hit.text.page
		&& m_hit.text.offset == hit.m_hit.text.offset
		&& ((m_hit.heading.page == hit.m_hit.heading.page
			&& m_hit.heading.offset == hit.m_hit.heading.offset)
			|| GetHeading() == hit.GetHeading())
		) {
		return true;
	}
	return false;
}
