#include "DicHook.h"
#include "DicBook.h"
#include "DicBitmaps.h"
#include "DicReferences.h"
#include <eb/text.h>
#include <eb/font.h>
#include <eb/binary.h>
#include <wx/string.h>
#include <wx/image.h>
#include <wx/mstream.h>
#include <wx/file.h>

#define HOOK_FUNC(name) \
	EB_Error_Code name(EB_Book* book, EB_Appendix* appendix, void* container, EB_Hook_Code code, int argc, const unsigned int* argv)
	
static HOOK_FUNC(Initialize);
static HOOK_FUNC(BeginNarrow);
static HOOK_FUNC(EndNarrow);
static HOOK_FUNC(BeginSubscript);
static HOOK_FUNC(EndSubscript);
static HOOK_FUNC(SetIndent);
static HOOK_FUNC(Newline);
static HOOK_FUNC(BeginSuperscript);
static HOOK_FUNC(EndSuperscript);
static HOOK_FUNC(BeginNoNewline);
static HOOK_FUNC(EndNoNewline);
static HOOK_FUNC(BeginEmphasis);
static HOOK_FUNC(EndEmphasis);
static HOOK_FUNC(BeginCandidate);
static HOOK_FUNC(EndCandidateLeaf);
static HOOK_FUNC(EndCandidateGroup);
static HOOK_FUNC(BeginReference);
static HOOK_FUNC(EndReference);
static HOOK_FUNC(BeginKeyword);
static HOOK_FUNC(EndKeyword);
static HOOK_FUNC(BeginDecoration);
static HOOK_FUNC(EndDecoration);
static HOOK_FUNC(NarrowFont);
static HOOK_FUNC(WideFont);
static HOOK_FUNC(Iso8859_1);
static HOOK_FUNC(NarrawJisx0208_1);
static HOOK_FUNC(WideJisx0208_1);
static HOOK_FUNC(Gb2312);
static HOOK_FUNC(BeginMonoGraphic);
static HOOK_FUNC(EndMonoGraphic);
//static HOOK_FUNC(BeginGrayGraphic);
//static HOOK_FUNC(EndGrayGraphic);
static HOOK_FUNC(BeginColorBmp);
static HOOK_FUNC(BeginColorJpeg);
static HOOK_FUNC(EndColorGraphic);
static HOOK_FUNC(BeginInColorBmp);
static HOOK_FUNC(BeginInColorJpeg);
static HOOK_FUNC(EndInColorGraphic);
static HOOK_FUNC(BeginGraphicReference);
static HOOK_FUNC(EndGraphicReference);
static HOOK_FUNC(GraphicReference);
static HOOK_FUNC(BeginWave);
static HOOK_FUNC(EndWave);
static HOOK_FUNC(BeginMpeg);
static HOOK_FUNC(EndMpeg);

static void PutIndent(EB_Book* book);
static wxString ReadGraphic(DicBook* b, int page, int offset,
							long type = wxBITMAP_TYPE_ANY);
static char RevChar(char c);

static bool m_firstLine;	// ŏ̍s
static bool m_firstIndent;
static bool m_indent;
static int m_ref;
static int m_width;
static int m_height;
static wxString m_graphKey;

/**
 * RXgN^
 */
DicHook::DicHook()
{
	::eb_initialize_hookset(&m_hookset);
	const EB_Hook hooks[] = {
		{EB_HOOK_INITIALIZE,			Initialize},
		{EB_HOOK_BEGIN_NARROW,			BeginNarrow},
		{EB_HOOK_END_NARROW,			EndNarrow},
		{EB_HOOK_BEGIN_SUBSCRIPT,		BeginSubscript},
		{EB_HOOK_END_SUBSCRIPT,			EndSubscript},
		{EB_HOOK_SET_INDENT,			SetIndent},
		{EB_HOOK_NEWLINE,				Newline},
		{EB_HOOK_BEGIN_SUPERSCRIPT,		BeginSuperscript},
		{EB_HOOK_END_SUPERSCRIPT,		EndSuperscript},
		{EB_HOOK_BEGIN_NO_NEWLINE,		BeginNoNewline},
		{EB_HOOK_END_NO_NEWLINE,		EndNoNewline},
		{EB_HOOK_BEGIN_EMPHASIS,		BeginEmphasis},
		{EB_HOOK_END_EMPHASIS,			EndEmphasis},
		{EB_HOOK_BEGIN_CANDIDATE,		BeginCandidate},
		{EB_HOOK_END_CANDIDATE_LEAF,	EndCandidateLeaf},
		{EB_HOOK_END_CANDIDATE_GROUP,	EndCandidateGroup},
		{EB_HOOK_BEGIN_REFERENCE,		BeginReference},
		{EB_HOOK_END_REFERENCE,			EndReference},
		{EB_HOOK_BEGIN_KEYWORD,			BeginKeyword},
		{EB_HOOK_END_KEYWORD,			EndKeyword},
		{EB_HOOK_BEGIN_DECORATION,		BeginDecoration},
		{EB_HOOK_END_DECORATION,		EndDecoration},
		{EB_HOOK_NARROW_FONT,			NarrowFont},
		{EB_HOOK_WIDE_FONT,				WideFont},
		{EB_HOOK_ISO8859_1,				Iso8859_1},
		{EB_HOOK_NARROW_JISX0208,		NarrawJisx0208_1},
		{EB_HOOK_WIDE_JISX0208,			WideJisx0208_1},
		{EB_HOOK_GB2312,				Gb2312},
		{EB_HOOK_BEGIN_MONO_GRAPHIC,	BeginMonoGraphic},
		{EB_HOOK_END_MONO_GRAPHIC,		EndMonoGraphic},
//		{EB_HOOK_BEGIN_GRAY_GRAPHIC,	BeginGrayGraphic},
//		{EB_HOOK_END_GRAY_GRAPHIC,		EndGrayGraphic},
		{EB_HOOK_BEGIN_COLOR_BMP,		BeginColorBmp},
		{EB_HOOK_BEGIN_COLOR_JPEG,		BeginColorJpeg},
		{EB_HOOK_END_COLOR_GRAPHIC,		EndColorGraphic},
		{EB_HOOK_BEGIN_IN_COLOR_BMP,	BeginInColorBmp},
		{EB_HOOK_BEGIN_IN_COLOR_JPEG,	BeginInColorJpeg},
		{EB_HOOK_END_IN_COLOR_GRAPHIC,	EndInColorGraphic},
		{EB_HOOK_BEGIN_GRAPHIC_REFERENCE, BeginGraphicReference},
		{EB_HOOK_END_GRAPHIC_REFERENCE,	EndGraphicReference},
		{EB_HOOK_GRAPHIC_REFERENCE,		GraphicReference},
		{EB_HOOK_BEGIN_WAVE,			BeginWave},
		{EB_HOOK_END_WAVE,				EndWave},
		{EB_HOOK_BEGIN_MPEG,			BeginMpeg},
		{EB_HOOK_END_MPEG,				EndMpeg},
		{EB_HOOK_NULL,					NULL}
	};
	::eb_set_hooks(&m_hookset, hooks);
}

/**
 * fXgN^
 */
DicHook::~DicHook()
{
	::eb_finalize_hookset(&m_hookset);
}

/**
 * tbNZbg擾
 */
EB_Hookset* DicHook::GetHookset()
{
	return &m_hookset;
}

/**
 * ؂
 */
void DicHook::Break(EB_Book* book)
{
	m_firstLine = true;
	m_indent = 0;
	::eb_write_text_string(book, "\n<font color=blue>");
}

HOOK_FUNC(Initialize)
{
	m_firstLine = true;
	m_indent = 0;
	::eb_write_text_string(book, "<font color=blue>");
	return 0;
}

HOOK_FUNC(BeginNarrow)
{
	return 0;
}

HOOK_FUNC(EndNarrow)
{
	return 0;
}

HOOK_FUNC(BeginSubscript)
{
	::eb_write_text_string(book, "<sub>");
	return 0;
}

HOOK_FUNC(EndSubscript)
{
	::eb_write_text_string(book, "</sub>");
	return 0;
}

HOOK_FUNC(SetIndent)
{
	if (m_firstLine) {
		m_firstIndent = argv[1];
		m_indent = 0;
	} else {
		m_indent = argv[1] - m_firstIndent;
	}
	::PutIndent(book);
	return 0;
}

HOOK_FUNC(Newline)
{
	if (m_firstLine) {
		::eb_write_text_string(book, "</font>\n<br>\n");
		m_firstLine = false;
	} else {
		::eb_write_text_string(book, "<br>\n");
		::PutIndent(book);
	}
	return 0;
}

HOOK_FUNC(BeginSuperscript)
{
	::eb_write_text_string(book, "<sup>");
	return 0;
}
	
HOOK_FUNC(EndSuperscript)
{
	::eb_write_text_string(book, "</sup>");
	return 0;
}

HOOK_FUNC(BeginNoNewline)
{
	::eb_write_text_string(book, "<nobr>");
	return 0;
}

HOOK_FUNC(EndNoNewline)
{
	::eb_write_text_string(book, "</nobr>");
	return 0;
}

HOOK_FUNC(BeginEmphasis)
{
	::eb_write_text_string(book, "<i>");
	return 0;
}

HOOK_FUNC(EndEmphasis)
{
	::eb_write_text_string(book, "</i>");
	return 0;
}

HOOK_FUNC(BeginCandidate)
{
//	::eb_write_text_string(book, "<a href=***>");
	return 0;
}

HOOK_FUNC(EndCandidateLeaf)
{
//	::eb_write_text_string(book, "</a>");
	return 0;
}

HOOK_FUNC(EndCandidateGroup)
{
//	::eb_write_text_string(book, "</a>");
	return 0;
}

HOOK_FUNC(BeginReference)
{
	DicReferences& refs = DicReferences::Get();
	m_ref = refs.Count();
	wxString tag = wxString::Format(wxT("<a href=%u>"), m_ref);
	::eb_write_text_string(book, tag.mb_str());
	return 0;
}

HOOK_FUNC(EndReference)
{
	DicBook* b = (DicBook*)container;
	EB_Position pos;
	pos.page = argv[1];
	pos.offset = argv[2];

	DicReference* ref = new DicReference;
	ref->SetBook(b);
	ref->SetSubbook(b->GetSubbook());
	ref->SetPosition(pos);
	
	DicReferences& refs = DicReferences::Get();
	refs.Add(ref);
	
	::eb_write_text_string(book, "</a>");
	return 0;
}

HOOK_FUNC(BeginKeyword)
{
	::eb_write_text_string(book, "<font color=blue><b>");
	return 0;
}

HOOK_FUNC(EndKeyword)
{
	::eb_write_text_string(book, "</b></font>");
	return 0;
}

HOOK_FUNC(BeginDecoration)
{
	::eb_write_text_string(book, "<b>");
	return 0;
}

HOOK_FUNC(EndDecoration)
{
	::eb_write_text_string(book, "</b>");
	return 0;
}

HOOK_FUNC(NarrowFont)
{
	DicBook* b = (DicBook*)container;
	wxString key = wxString::Format(wxT("%d/%d/narrow/%d"),
		b->GetIndex(), b->GetSubbook(), argv[0]);
	DicBitmaps& bitmaps = DicBitmaps::Get();
	if (bitmaps.find(key) == bitmaps.end()) {
		// rbg}bv쐬B
		char data[16];
		::eb_set_font(book, EB_FONT_16);
		::eb_narrow_font_character_bitmap(book, argv[0], data);
		char xbm[16];
		for (int i = 0; i < 16; ++i) {
			xbm[i] = RevChar(data[i]);
		}
		wxBitmap* bitmap = new wxBitmap(xbm, 8, 16);
		bitmaps[key] = bitmap;
	}
	wxString tag = wxT("<extchar key=") + key + wxT(">");
	::eb_write_text_string(book, tag.mb_str());
	return 0;
}

HOOK_FUNC(WideFont)
{
	DicBook* b = (DicBook*)container;
	wxString key = wxString::Format(wxT("%d/%d/wide/%d"),
		b->GetIndex(), b->GetSubbook(), argv[0]);
	DicBitmaps& bitmaps = DicBitmaps::Get();
	if (bitmaps.find(key) == bitmaps.end()) {
		// rbg}bv쐬B
		char data[2*16];
		::eb_set_font(book, EB_FONT_16);
		::eb_wide_font_character_bitmap(book, argv[0], data);
		char xbm[2*16];
		for (int i = 0; i < 32; ++i) {
			xbm[i] = RevChar(data[i]);
		}
		wxBitmap* bitmap = new wxBitmap(xbm, 16, 16);
		bitmaps[key] = bitmap;
	}
	wxString tag = wxT("<extchar key=") + key + wxT(">");
	::eb_write_text_string(book, tag.mb_str());
	return 0;
}

HOOK_FUNC(Iso8859_1)
{
	::eb_write_text_byte1(book, argv[0]);
	return 0;
}

HOOK_FUNC(NarrawJisx0208_1)
{
	// 󔒂̏ꍇ&nbsp;ɕϊB
	if (argv[0] == 0xa1a1) {
		::eb_write_text_string(book, "&nbsp;");
		return 0;
	} else {
		return ::eb_hook_euc_to_ascii(book, appendix, container, code, argc, argv);
	}
}

HOOK_FUNC(WideJisx0208_1)
{
	int byte1 = (argv[0] >> 8)& 0xFF;
	int byte2 = argv[0] & 0xFF;
	::eb_write_text_byte2(book, byte1, byte2);
	return 0;
}

HOOK_FUNC(Gb2312)
{
	int byte1 = (argv[0] >> 8)& 0xFF;
	int byte2 = argv[0] & 0xFF;
	::eb_write_text_byte2(book, byte1, byte2);
	return 0;
}

HOOK_FUNC(BeginMonoGraphic)
{
	m_height = argv[2];
	m_width = argv[3];
	return 0;
}

HOOK_FUNC(EndMonoGraphic)
{
	DicBook* b = (DicBook*)container;
	wxString key = wxString::Format(wxT("%d/%d/mono/%d/%d"),
		b->GetIndex(), b->GetSubbook(), argv[1], argv[2]);

	DicBitmaps& bitmaps = DicBitmaps::Get();
	if (bitmaps.find(key) == bitmaps.end()) {
		EB_Position pos;
		pos.page = argv[1];
		pos.offset = argv[2];
		::eb_set_binary_mono_graphic(book, &pos, m_width, m_height);

		ssize_t len;
		unsigned char head[6];
		::eb_read_binary(book, 6, (char*)head, &len);
		size_t size = head[5];
		size <<= 8;
		size += head[4];
		size <<= 8;
		size += head[3];
		size <<= 8;
		size += head[2];
		char* data = new char[size];
		for (int i = 0; i < 6; ++i) {
			data[i] = head[i];
		}
		::eb_read_binary(book, size - 6, data + 6, &len);
		
		wxMemoryInputStream stream(data, size);
		wxImage image(stream, wxBITMAP_TYPE_BMP);
		wxBitmap* bitmap = new wxBitmap(image);
		bitmaps[key] = bitmap;
		
		delete[] data;
	}

	::eb_write_text_string(book, "<br>\n");
	::PutIndent(book);
	wxString tag = wxT("<graph key=") + key + wxT(">\n<br>\n");
	::eb_write_text_string(book, tag.mb_str());
	
	return 0;
}

HOOK_FUNC(BeginColorBmp)
{
	m_graphKey = ReadGraphic((DicBook*)container, argv[2], argv[3],
							wxBITMAP_TYPE_BMP);	
	return 0;
}

HOOK_FUNC(BeginColorJpeg)
{
	m_graphKey = ReadGraphic((DicBook*)container, argv[2], argv[3],
							wxBITMAP_TYPE_JPEG);	
	return 0;

}

HOOK_FUNC(EndColorGraphic)
{
	::eb_write_text_string(book, "<br>\n");
	::PutIndent(book);
	wxString tag = wxT("<graph key=") + m_graphKey + wxT(">\n<br>\n");
	::eb_write_text_string(book, tag.mb_str());
	return 0;
}

HOOK_FUNC(BeginInColorBmp)
{
	m_graphKey = ReadGraphic((DicBook*)container, argv[2], argv[3],
							wxBITMAP_TYPE_BMP);	
	return 0;
}

HOOK_FUNC(BeginInColorJpeg)
{
	m_graphKey = ReadGraphic((DicBook*)container, argv[2], argv[3],
							wxBITMAP_TYPE_JPEG);	
	return 0;
}

HOOK_FUNC(EndInColorGraphic)
{
	wxString tag = wxT("<graph key=") + m_graphKey + wxT(">\n");
	::eb_write_text_string(book, tag.mb_str());
	return 0;
}

HOOK_FUNC(BeginGraphicReference)
{
// L-CTɃTvB
	return 0;
}

HOOK_FUNC(EndGraphicReference)
{
	return 0;
}

HOOK_FUNC(GraphicReference)
{
	wxString key = ReadGraphic((DicBook*)container, argv[1], argv[2]);	
	::eb_write_text_string(book, "<br>\n");
	::PutIndent(book);
	wxString tag = wxT("<graph key=") + key + wxT(">\n<br>\n");
	::eb_write_text_string(book, tag.mb_str());
	return 0;
}

HOOK_FUNC(BeginWave)
{
	return 0;
}

HOOK_FUNC(EndWave)
{
	return 0;
}

HOOK_FUNC(BeginMpeg)
{
	return 0;
}

HOOK_FUNC(EndMpeg)
{
	return 0;
}

/**
 * Cfgo
 */
void PutIndent(EB_Book* book)
{
	wxString tag = wxString::Format(wxT("<indent width=%d>"), m_indent);
	::eb_write_text_string(book, tag.mb_str());
}

/**
 * 摜ǂݍ
 * 
 * @param b	{
 * @param page y[W
 * @param offset ItZbg
 * @param type 摜̎
 * @return L[
 */
wxString ReadGraphic(DicBook* b, int page, int offset, long type)
{
	wxString key = wxString::Format(wxT("%d/%d/graph/%d/%d"),
		b->GetIndex(), b->GetSubbook(), page, offset);

	DicBitmaps& bitmaps = DicBitmaps::Get();
	if (bitmaps.find(key) == bitmaps.end()) {
		EB_Position pos;
		pos.page = page;
		pos.offset = offset;
		EB_Book* book = b->GetEbBook();
		::eb_set_binary_color_graphic(book, &pos);
		wxMemoryOutputStream out;
		ssize_t len;
		char data[1024];
		for (;;) {
			::eb_read_binary(book, 1024, data, &len);
			if (len <= 0) {
				break;
			}
			out.Write(data, len);
		}
		wxMemoryInputStream stream(out);
		wxImage image(stream, type);
		wxBitmap* bitmap = new wxBitmap(image);
		bitmaps[key] = bitmap;
	}
	
	return key;
}

/**
 * 0/1ƃrbg𔽓]
 */
char RevChar(char c)
{
	c = ~c;
	char out = 0;
	if (c & 0x80) { out |= 0x01; }
	if (c & 0x40) { out |= 0x02; }
	if (c & 0x20) { out |= 0x04; }
	if (c & 0x10) { out |= 0x08; }
	if (c & 0x08) { out |= 0x10; }
	if (c & 0x04) { out |= 0x20; }
	if (c & 0x02) { out |= 0x40; }
	if (c & 0x01) { out |= 0x80; }
	return out;
}
