#include "DicHtmlWindow.h"
#include "DicBook.h"
#include "DicBitmaps.h"
#include "DicReferences.h"
#include <wx/utils.h>

/**
 * NNbN
 */
void DicHtmlWindow::OnLinkClicked(const wxHtmlLinkInfo& link)
{
	wxString href = link.GetHref();
/*
	DicBook* book;
	EB_Subbook_Code subbook;
	EB_Position pos;

	int idx;
	wxString tmp;
	unsigned long l;
	
	idx = href.Find(wxT(":")) + 1;
	tmp = href.Mid(idx);
	tmp.ToULong(&l);
	book = (DicBook*)l;
	
	idx = tmp.Find(wxT("/")) + 1;
	tmp = tmp.Mid(idx);
	tmp.ToULong(&l);
	subbook = (EB_Subbook_Code)l;
	
	idx = tmp.Find(wxT("/")) + 1;
	tmp = tmp.Mid(idx);
	tmp.ToULong(&l);
	pos.page = l;

	idx = tmp.Find(wxT("/")) + 1;
	tmp = tmp.Mid(idx);
	tmp.ToULong(&l);
	pos.offset = l;
*/	
	DicReferences& refs = DicReferences::Get();
	unsigned long idx;
	href.ToULong(&idx);
	DicReference* ref = refs[idx];
	DicBook* book = ref->GetBook();
	EB_Subbook_Code subbook = ref->GetSubbook();
	EB_Position pos = ref->GetPosition();
	

	wxBusyCursor wait;
	
	DicBitmaps::Get().DeleteAll();
	DicReferences::Get().DeleteAll();
	
	book->SetSubbook(subbook);
	
	wxString html = wxT("<html><body>");
	html += book->GetText(&pos);
	html += wxT("</body></html>");

	Freeze();
	SetPage(html);
	Thaw();
}
